/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.DialogHandler;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.Callback;
import com.teamdev.jxbrowser.chromium.internal.ChromiumEventQueue;
import com.teamdev.jxbrowser.chromium.internal.JavaScriptMessageType;
import com.teamdev.jxbrowser.chromium.internal.WebView;
import com.teamdev.jxbrowser.chromium.internal.av;
import com.teamdev.jxbrowser.chromium.internal.aw;
import com.teamdev.jxbrowser.chromium.internal.ax;
import com.teamdev.jxbrowser.chromium.internal.ay;
import com.teamdev.jxbrowser.chromium.internal.az;
import com.teamdev.jxbrowser.chromium.internal.ba;
import com.teamdev.jxbrowser.chromium.internal.bb;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CancelPendingReloadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CloseClientCertificateMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CloseJavaScriptDialogMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRunFileChooserMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRunJavaScriptDialogMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnSelectClientCertificateMessage;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogHandlerDelegate {
    private static final Logger a = LoggerProvider.getBrowserLogger();
    private DialogHandler b;

    public DialogHandler getDialogHandler() {
        return this.b;
    }

    public void setDialogHandler(DialogHandler dialogHandler) {
        this.b = dialogHandler;
    }

    public void handle(WebView webView, ChromiumEventQueue chromiumEventQueue, OnRunJavaScriptDialogMessage onRunJavaScriptDialogMessage, Callback<Message> callback) {
        if (((DialogHandlerDelegate)((Object)callback2)).b == null) {
            int n2 = onRunJavaScriptDialogMessage.getDialogID();
            Callback<Message> callback2 = callback;
            DialogHandlerDelegate.b(callback2, n2, false);
            return;
        }
        JavaScriptMessageType javaScriptMessageType = JavaScriptMessageType.from(onRunJavaScriptDialogMessage.getMessageType());
        switch (javaScriptMessageType) {
            case ALERT: {
                chromiumEventQueue.invokeLater(new ay((DialogHandlerDelegate)((Object)callback2), onRunJavaScriptDialogMessage, webView, callback));
                return;
            }
            case CONFIRM: {
                chromiumEventQueue.invokeLater(new bb((DialogHandlerDelegate)((Object)callback2), onRunJavaScriptDialogMessage, webView, callback));
                return;
            }
            case PROMPT: {
                chromiumEventQueue.invokeLater(new ba((DialogHandlerDelegate)((Object)callback2), onRunJavaScriptDialogMessage, webView, callback));
                return;
            }
            case BEFORE_UNLOAD: {
                chromiumEventQueue.invokeLater(new az((DialogHandlerDelegate)((Object)callback2), onRunJavaScriptDialogMessage, webView, callback));
                return;
            }
        }
        throw new RuntimeException("Unsupported message type: " + (Object)((Object)javaScriptMessageType));
    }

    public void handle(WebView webView, ChromiumEventQueue chromiumEventQueue, OnRunFileChooserMessage onRunFileChooserMessage, Callback<Message> callback) {
        if (this.b == null) {
            callback.invoke(onRunFileChooserMessage);
            return;
        }
        chromiumEventQueue.invokeLater(new ax(this, onRunFileChooserMessage, webView, callback));
    }

    public void handle(WebView webView, ChromiumEventQueue chromiumEventQueue, OnSelectClientCertificateMessage onSelectClientCertificateMessage, Callback<Message> callback) {
        if (this.b == null) {
            callback.invoke(new CloseClientCertificateMessage(MessageUIDGenerator.generate(), onSelectClientCertificateMessage.getDialogID(), -1));
            return;
        }
        chromiumEventQueue.invokeLater(new av(this, onSelectClientCertificateMessage, webView, callback));
    }

    public void handleReloadPostData(WebView webView, ChromiumEventQueue chromiumEventQueue, Callback<Message> callback) {
        if (this.b == null) {
            callback.invoke(new CancelPendingReloadMessage(MessageUIDGenerator.generate()));
            return;
        }
        chromiumEventQueue.invokeLater(new aw(this, webView, callback));
    }

    private static void b(Callback<Message> callback, int n2, boolean bl) {
        DialogHandlerDelegate.b(callback, n2, bl, "");
    }

    private static void b(Callback<Message> callback, int n2, boolean bl, String string) {
        callback.invoke(new CloseJavaScriptDialogMessage(MessageUIDGenerator.generate(), n2, bl, string));
    }

    static /* synthetic */ DialogHandler a(DialogHandlerDelegate dialogHandlerDelegate) {
        return dialogHandlerDelegate.b;
    }

    static /* synthetic */ Logger a() {
        return a;
    }

    static /* synthetic */ void a(Callback callback, int n2, boolean bl, String string) {
        DialogHandlerDelegate.b(callback, n2, bl, string);
    }

    static /* synthetic */ void a(Callback callback, int n2) {
        DialogHandlerDelegate.b(callback, n2, false);
    }

    static /* synthetic */ void a(Callback callback, int n2, boolean bl) {
        DialogHandlerDelegate.b(callback, n2, bl);
    }
}

