/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.internal.BrowserTransferable;
import com.teamdev.jxbrowser.chromium.internal.DragAndDropData;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.DragTargetMessage;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.net.MalformedURLException;
import java.net.URL;

public class DragAndDropSupport {
    private final DragSourceListener a;
    private final DropTargetListener b;
    private final DragGestureListener c;
    private boolean d = Boolean.valueOf(System.getProperty("jxbrowser.chromium.dnd.enabled", "true"));
    private boolean e;
    private boolean f;
    private boolean g;
    private DragSource h;
    private DropTarget i;
    private DragGestureRecognizer j;
    private DragAndDropData k;

    public DragAndDropSupport(DragSourceListener dragSourceListener, DropTargetListener dropTargetListener) {
        this.a = dragSourceListener;
        this.b = dropTargetListener;
        this.c = new a(this);
    }

    public void registerDragGestureHandler(Component component) {
        if (!GraphicsEnvironment.isHeadless()) {
            this.h = new DragSource();
            this.i = new DropTarget(component, this.b);
            this.j = this.h.createDefaultDragGestureRecognizer(component, 1, this.c);
        }
    }

    public void unregisterDragGestureHandler() {
        if (this.j != null) {
            this.j.removeDragGestureListener(this.c);
            this.j = null;
        }
        if (this.i != null) {
            this.i.removeDropTargetListener(this.b);
        }
        if (this.h != null) {
            this.h.removeDragSourceListener(this.a);
        }
    }

    public void setDraggingFromWebView(boolean bl) {
        this.f = bl;
    }

    public boolean isDraggingFromWebView() {
        return this.f;
    }

    public void setData(DragAndDropData dragAndDropData) {
        this.k = dragAndDropData;
    }

    public DragAndDropData getData() {
        return this.k;
    }

    public void setDragStarted(boolean bl) {
        this.e = bl;
    }

    public boolean isDragStarted() {
        return this.e;
    }

    public void setDragAndDropEnabled(boolean bl) {
        this.d = bl;
    }

    public boolean isDragAndDropEnabled() {
        return this.d;
    }

    public boolean isDragGestureRecognized() {
        return this.g;
    }

    public void setDragGestureRecognized(boolean bl) {
        this.g = bl;
    }

    public DragTargetMessage.WebDragOperation getDragOperation() {
        if (this.k != null && this.isDraggingFromWebView()) {
            if (!this.k.getURL().isEmpty()) {
                return DragTargetMessage.WebDragOperation.WebDragOperationCopy;
            }
            if (!this.k.getText().isEmpty() && !this.k.getHTML().isEmpty()) {
                return DragTargetMessage.WebDragOperation.WebDragOperationCopy;
            }
            if (!this.k.getText().isEmpty() && this.k.getHTML().isEmpty()) {
                return DragTargetMessage.WebDragOperation.WebDragOperationMove;
            }
            if (this.k.getText().isEmpty() && !this.k.getHTML().isEmpty()) {
                return DragTargetMessage.WebDragOperation.WebDragOperationMove;
            }
        }
        return DragTargetMessage.WebDragOperation.WebDragOperationCopy;
    }

    private final class a
    implements DragGestureListener {
        private /* synthetic */ DragAndDropSupport a;

        private a(DragAndDropSupport dragAndDropSupport) {
            this.a = dragAndDropSupport;
        }

        public final void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (this.a.d && this.a.e && this.a.k != null) {
                Transferable transferable = this.a();
                DragSource dragSource = dragGestureEvent.getDragSource();
                dragSource.startDrag(dragGestureEvent, DragSource.DefaultCopyDrop, transferable, this.a.a);
                this.a.setDragGestureRecognized(true);
            }
        }

        private Transferable a() {
            Object object;
            String string = ((a)object).a.k.getURL();
            if (!string.isEmpty()) {
                try {
                    object = new BrowserTransferable(new URL(string));
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException("Drag data cannot be represented as URL.", malformedURLException);
                }
            } else {
                object = new BrowserTransferable(((a)object).a.k.getText());
            }
            return object;
        }
    }
}

