/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.ai;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public final class FileUtil {
    private static final Logger a = LoggerProvider.getBrowserLogger();

    public static void createDirs(File file) {
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("Failed to create directory: " + file.getPath());
        }
    }

    public static void createDirs(String object) {
        if (!((File)(object = new File((String)object))).exists() && !((File)object).mkdirs()) {
            throw new RuntimeException("Failed to create directory: " + ((File)object).getPath());
        }
    }

    public static void deleteDir(File file) {
        if (!file.isDirectory()) {
            if (!file.delete()) {
                file.deleteOnExit();
                return;
            }
        } else {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    FileUtil.deleteDir(file2);
                }
            }
            FileUtil.deleteFile(file);
        }
    }

    public static void deleteFile(File file) {
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    public static boolean allFilesExist(File file, String ... stringArray) {
        for (String string : stringArray) {
            File object = new File(file, string);
            if (object.exists()) continue;
            a.info("The '" + object.getAbsolutePath() + "' file doesn't exist.");
            return false;
        }
        return true;
    }

    public static File createTempDir(String object) {
        try {
            object = File.createTempFile((String)object, Long.toString(System.nanoTime()));
            if (!((File)object).delete()) {
                throw new IllegalStateException("Failed to delete temp file: " + ((File)object).getAbsolutePath());
            }
            if (!((File)object).mkdir()) {
                throw new IllegalStateException("Failed to create temp dir: " + ((File)object).getAbsolutePath());
            }
            return object;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static File findByTemplate(String fileArray, String string) {
        if ((fileArray = new File((String)fileArray)).isDirectory() && (fileArray = fileArray.listFiles(new ai(string))) != null && fileArray.length > 0) {
            return fileArray[0];
        }
        return null;
    }
}

