/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.HttpHeaders;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeadersImpl
implements HttpHeaders {
    private static final Pattern a = Pattern.compile("\r\n");
    private final Map<String, String> b = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    @Override
    public void setHeader(String string, String string2) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Header name cannot be null or empty.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Header value cannot be null");
        }
        this.b.put(string, string2);
    }

    @Override
    public String removeHeader(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Header name cannot be null or empty.");
        }
        return this.b.remove(string);
    }

    @Override
    public void removeAll() {
        this.b.clear();
    }

    @Override
    public Map<String, String> getHeaders() {
        return new HashMap<String, String>(this.b);
    }

    @Override
    public boolean containsHeader(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Header name cannot be null or empty.");
        }
        return this.b.containsKey(string);
    }

    @Override
    public String getHeader(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Header name cannot be null or empty.");
        }
        return this.b.get(string);
    }

    public String getStringRepresentation(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : ((HttpHeadersImpl)this).b.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append(": ");
            stringBuilder.append(entry.getValue());
            stringBuilder.append(string);
        }
        int n2 = stringBuilder.lastIndexOf(string);
        if (n2 != -1) {
            stringBuilder.delete(n2, n2 + string.length());
        }
        return stringBuilder.toString();
    }

    public static HttpHeadersImpl buildFromString(String stringArray) {
        HttpHeadersImpl httpHeadersImpl = new HttpHeadersImpl();
        String[] stringArray2 = a.split((CharSequence)stringArray);
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n2 = stringArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            if (string.isEmpty()) continue;
            int n3 = string.indexOf(": ");
            String string2 = string.substring(0, n3);
            string = string.substring(n3 + 2);
            httpHeadersImpl.setHeader(string2, string);
        }
        return httpHeadersImpl;
    }
}

