/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.JSValue;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ExecuteJavaScriptMessage;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSValueParser {
    private static final Character a = Character.valueOf(';');

    public static List<JSValue> fromString(String string) {
        ArrayList<JSValue> arrayList = new ArrayList<JSValue>();
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            JSValue jSValue;
            Object object;
            Object object2 = string.substring(i2, i2 + 2);
            if ("i:".equals(object2)) {
                object2 = JSValueParser.a(cArray, i2 + 2);
                arrayList.add(JSValue.create(Integer.valueOf((String)object2).intValue()));
                i2 += ((String)object2).length() + 2;
                continue;
            }
            if ("b:".equals(object2)) {
                object2 = JSValueParser.a(cArray, i2 + 2);
                arrayList.add(JSValue.create(Integer.valueOf((String)object2) != 0));
                i2 += ((String)object2).length() + 2;
                continue;
            }
            if ("n:".equals(object2)) {
                object2 = JSValueParser.a(cArray, i2 + 2);
                arrayList.add(JSValue.create(Double.valueOf((String)object2)));
                i2 += ((String)object2).length() + 2;
                continue;
            }
            if ("s:".equals(object2)) {
                object2 = JSValueParser.a(cArray, i2 + 2);
                i2 += ((String)object2).length() + 3;
                object2 = Integer.valueOf((String)object2);
                int n2 = (Integer)object2;
                int n3 = i2;
                object = string.getBytes(Charset.forName("UTF-8"));
                byte[] byArray = new byte[n2];
                System.arraycopy(object, n3, byArray, 0, n2);
                object2 = new String(byArray, Charset.forName("UTF-8"));
                arrayList.add(JSValue.create((String)object2));
                i2 += ((String)object2).length();
                continue;
            }
            if (!"o:".equals(object2)) continue;
            object2 = JSValueParser.a(cArray, i2 + 2);
            object = object2;
            if ("null".equals(object)) {
                jSValue = JSValue.createNull();
            } else if ("object".equals(object)) {
                jSValue = JSValue.createObject();
            } else if ("undefined".equals(object)) {
                jSValue = JSValue.createUndefined();
            } else {
                throw new IllegalArgumentException((String)object);
            }
            arrayList.add(jSValue);
            i2 += ((String)object2).length() + 2;
        }
        return arrayList;
    }

    private static String a(char[] cArray, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        while (n2 < cArray.length && cArray[n2] != a.charValue()) {
            stringBuilder.append(cArray[n2]);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static JSValue create(ExecuteJavaScriptMessage executeJavaScriptMessage) {
        if (executeJavaScriptMessage.isUndefined()) {
            return JSValue.createUndefined();
        }
        if (executeJavaScriptMessage.isObject()) {
            return JSValue.createObject();
        }
        if (executeJavaScriptMessage.isNull()) {
            return JSValue.createNull();
        }
        if (executeJavaScriptMessage.isString()) {
            return JSValue.create(executeJavaScriptMessage.getStringValue());
        }
        if (executeJavaScriptMessage.isBoolean()) {
            return JSValue.create(executeJavaScriptMessage.getBooleanValue());
        }
        if (executeJavaScriptMessage.isNumber()) {
            return JSValue.create(executeJavaScriptMessage.getNumberValue());
        }
        if (executeJavaScriptMessage.isInteger()) {
            return JSValue.create(executeJavaScriptMessage.getIntegerValue());
        }
        if (executeJavaScriptMessage.isTrue()) {
            return JSValue.create(Boolean.TRUE);
        }
        if (executeJavaScriptMessage.isFalse()) {
            return JSValue.create(Boolean.FALSE);
        }
        throw new IllegalArgumentException(executeJavaScriptMessage.toString());
    }

    public static String toString(JSValue object) {
        StringBuilder stringBuilder = new StringBuilder();
        if (((JSValue)object).isUndefined()) {
            stringBuilder.append("o:undefined;");
        } else if (((JSValue)object).isObject()) {
            stringBuilder.append("o:object;");
        } else if (((JSValue)object).isNull()) {
            stringBuilder.append("o:null;");
        } else if (((JSValue)object).isTrue()) {
            stringBuilder.append("b:1;");
        } else if (((JSValue)object).isFalse()) {
            stringBuilder.append("b:0;");
        } else if (((JSValue)object).isBoolean()) {
            stringBuilder.append(((JSValue)object).getBoolean() ? "b:1;" : "b:0;");
        } else if (((JSValue)object).isNumber()) {
            stringBuilder.append("n:").append(((JSValue)object).getNumber()).append(a);
        } else if (((JSValue)object).isString()) {
            object = ((JSValue)object).getString();
            stringBuilder.append("s:").append(((String)object).getBytes(Charset.forName("UTF-8")).length).append(a).append((String)object).append(a);
        }
        return stringBuilder.toString();
    }
}

