/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.internal.MemoryImageListener;
import com.teamdev.jxbrowser.chromium.internal.MemoryImageProducer;
import com.teamdev.jxbrowser.chromium.internal.SharedMemory;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryImage {
    private final Image a;
    private final MemoryImageProducer b = new MemoryImageProducer();
    private final List<MemoryImageListener> c;
    private boolean d;

    public MemoryImage() {
        this.a = Toolkit.getDefaultToolkit().createImage(this.b);
        this.c = new ArrayList<MemoryImageListener>();
    }

    public boolean isVisible() {
        return this.d;
    }

    public void setVisible(boolean bl) {
        this.d = bl;
    }

    public void addMemoryImageListener(MemoryImageListener memoryImageListener) {
        if (!this.c.contains(memoryImageListener)) {
            this.c.add(memoryImageListener);
        }
    }

    public void removeMemoryImageListener(MemoryImageListener memoryImageListener) {
        this.c.remove(memoryImageListener);
    }

    public List<MemoryImageListener> getMemoryImageListeners() {
        return new ArrayList<MemoryImageListener>(this.c);
    }

    public void resetMemory(SharedMemory sharedMemory) {
        this.b.resetMemory(sharedMemory);
    }

    public boolean isInitialized() {
        return this.b.isInitialized();
    }

    public int getWidth() {
        return this.b.getWidth();
    }

    public int getHeight() {
        return this.b.getHeight();
    }

    public double getDeviceScaleFactor() {
        return this.b.getDeviceScaleFactor();
    }

    public void updatePixels(Rectangle rectangle) {
        ((MemoryImage)this).b.updatePixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        rectangle = new Rectangle(rectangle);
        rectangle.x /= (int)((MemoryImage)this).getDeviceScaleFactor();
        rectangle.y /= (int)((MemoryImage)this).getDeviceScaleFactor();
        rectangle.width /= (int)((MemoryImage)this).getDeviceScaleFactor();
        rectangle.height /= (int)((MemoryImage)this).getDeviceScaleFactor();
        for (MemoryImageListener memoryImageListener : ((MemoryImage)this).getMemoryImageListeners()) {
            memoryImageListener.onUpdated(rectangle);
        }
    }

    public Image getImage() {
        return this.a;
    }
}

