/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.BeforeRedirectParams;
import com.teamdev.jxbrowser.chromium.BeforeSendHeadersParams;
import com.teamdev.jxbrowser.chromium.BeforeURLRequestParams;
import com.teamdev.jxbrowser.chromium.Cookie;
import com.teamdev.jxbrowser.chromium.DefaultNetworkDelegate;
import com.teamdev.jxbrowser.chromium.FormData;
import com.teamdev.jxbrowser.chromium.HeadersReceivedParams;
import com.teamdev.jxbrowser.chromium.HttpHeaders;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.MultipartFormData;
import com.teamdev.jxbrowser.chromium.NetworkDelegate;
import com.teamdev.jxbrowser.chromium.PostData;
import com.teamdev.jxbrowser.chromium.RawData;
import com.teamdev.jxbrowser.chromium.RequestCompletedParams;
import com.teamdev.jxbrowser.chromium.RequestParams;
import com.teamdev.jxbrowser.chromium.RequestStatus;
import com.teamdev.jxbrowser.chromium.ResponseStartedParams;
import com.teamdev.jxbrowser.chromium.SendHeadersParams;
import com.teamdev.jxbrowser.chromium.events.NetError;
import com.teamdev.jxbrowser.chromium.internal.ChromiumEventQueue;
import com.teamdev.jxbrowser.chromium.internal.CookieParser;
import com.teamdev.jxbrowser.chromium.internal.HttpHeadersImpl;
import com.teamdev.jxbrowser.chromium.internal.PostDataBuilderCreator;
import com.teamdev.jxbrowser.chromium.internal.PostDataFactory;
import com.teamdev.jxbrowser.chromium.internal.PostDataUtils;
import com.teamdev.jxbrowser.chromium.internal.be;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelAdapter;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CloseAuthDialogMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageType;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnBeforeRedirectMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnBeforeSendHeadersMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnBeforeURLRequestMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnCanGetCookiesMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnCanSetCookiesMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnCompletedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnHeadersReceivedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnResponseStartedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRunAuthDialogMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnSendHeadersMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetNetworkDelegateConfigMessage;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkDelegateImpl {
    private static final Logger a = LoggerProvider.getBrowserLogger();
    private Channel b;
    private NetworkDelegate c;
    private final int d;
    private final ChannelListener e;
    private final ChromiumEventQueue f;
    private final NetworkDelegate g;

    public NetworkDelegateImpl(int n2) {
        this.d = n2;
        this.e = new b();
        this.f = new ChromiumEventQueue();
        this.c = this.g = new DefaultNetworkDelegate();
    }

    public void initialize(Channel channel) {
        this.b = channel;
        this.b.addChannelListener(this.e);
        this.a(this.g.equals(this.c));
    }

    private void a(Message message) {
        this.b.send(message);
    }

    public void setNetworkDelegate(NetworkDelegate networkDelegate) {
        this.c = networkDelegate;
        if (this.b != null) {
            this.a(this.g.equals(this.c));
        }
    }

    private void a(boolean bl) {
        this.a(new SetNetworkDelegateConfigMessage(MessageUIDGenerator.generate(), this.d, bl, bl, bl, bl, bl, bl, bl, false, false));
    }

    public NetworkDelegate getNetworkDelegate() {
        return this.c;
    }

    private final class b
    extends ChannelAdapter {
        private b() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void onMessageReceived(Message message) {
            MessageType messageType = message.getType();
            if (messageType == MessageType.OnBeforeUrlRequest) {
                if (((OnBeforeURLRequestMessage)(message = (OnBeforeURLRequestMessage)message)).getBrowserContextId() != NetworkDelegateImpl.this.d) return;
                if (NetworkDelegateImpl.this.c != null) {
                    try {
                        Object object;
                        String string = ((OnBeforeURLRequestMessage)message).getURL();
                        Object object2 = ((OnBeforeURLRequestMessage)message).getMethod();
                        Object object3 = ((OnBeforeURLRequestMessage)message).getOriginalHeaders();
                        Map<String, List<String>> map = ((OnBeforeURLRequestMessage)message).getPostData();
                        Object object4 = ((OnBeforeURLRequestMessage)message).getFileList();
                        object3 = HttpHeadersImpl.buildFromString((String)object3);
                        String string2 = ((HttpHeadersImpl)object3).getStringRepresentation("\r\n");
                        PostData postData = null;
                        if ("POST".equals(object2)) {
                            object = ((HttpHeadersImpl)object3).getHeader("Content-Type");
                            postData = PostDataFactory.createPostData((String)object, (String)((Object)map), (String)object4);
                        }
                        object = new BeforeURLRequestParams(string, (String)object2, postData);
                        NetworkDelegateImpl.this.c.onBeforeURLRequest((BeforeURLRequestParams)object);
                        if ("POST".equals(object2)) {
                            object2 = ((BeforeURLRequestParams)object).getPostData();
                            if (object2 instanceof RawData) {
                                PostDataBuilderCreator.create(object2.getContentType(), (HttpHeaders)object3);
                                object4 = (RawData)object2;
                                object2 = ((RawData)object4).getData();
                                if (!((String)object2).equals(map)) {
                                    ((OnBeforeURLRequestMessage)message).setPostData((String)object2);
                                }
                            } else if (object2 instanceof MultipartFormData) {
                                if (!object2.equals(postData)) {
                                    object4 = PostDataBuilderCreator.create(object2.getContentType(), (HttpHeaders)object3);
                                    object2 = (MultipartFormData)object2;
                                    map = PostDataUtils.buildKeyValuesMap((FormData)object2);
                                    object2 = PostDataUtils.buildFilesMap((MultipartFormData)object2);
                                    ((OnBeforeURLRequestMessage)message).setPostData(object4.buildKeyValues(map, (Map<String, List<String>>)object2));
                                    ((OnBeforeURLRequestMessage)message).setFileList(object4.buildFileList((Map<String, List<String>>)object2));
                                }
                            } else if (object2 instanceof FormData && !object2.equals(postData)) {
                                object4 = PostDataBuilderCreator.create(object2.getContentType(), (HttpHeaders)object3);
                                object2 = (FormData)object2;
                                map = PostDataUtils.buildKeyValuesMap((FormData)object2);
                                ((OnBeforeURLRequestMessage)message).setPostData(object4.buildKeyValues(map));
                            }
                        }
                        if (!string2.equals(object2 = ((HttpHeadersImpl)object3).getStringRepresentation("\r\n"))) {
                            ((OnBeforeURLRequestMessage)message).setOverrideHeaders((String)object2);
                        }
                        if ((object4 = ((RequestParams)object).getURL()) != null && !string.equals(object4)) {
                            ((OnBeforeURLRequestMessage)message).setNewLocation((String)object4);
                        }
                    }
                    catch (Exception exception) {
                        a.log(Level.SEVERE, "The NetworkDelegate.onBeforeURLRequest() method has thrown exception: ", exception);
                    }
                }
                NetworkDelegateImpl.this.a(message);
                return;
            }
            if (messageType == MessageType.OnBeforeSendHeaders) {
                if (((OnBeforeSendHeadersMessage)(message = (OnBeforeSendHeadersMessage)message)).getBrowserContextId() != NetworkDelegateImpl.this.d) return;
                if (NetworkDelegateImpl.this.c != null) {
                    try {
                        String string = ((OnBeforeSendHeadersMessage)message).getURL();
                        String string3 = ((OnBeforeSendHeadersMessage)message).getMethod();
                        Object object = ((OnBeforeSendHeadersMessage)message).getOriginalHeaders();
                        HttpHeadersImpl httpHeadersImpl = HttpHeadersImpl.buildFromString((String)object);
                        String string4 = httpHeadersImpl.getStringRepresentation("\r\n");
                        object = new BeforeSendHeadersParams(string, string3, httpHeadersImpl);
                        NetworkDelegateImpl.this.c.onBeforeSendHeaders((BeforeSendHeadersParams)object);
                        String string5 = httpHeadersImpl.getStringRepresentation("\r\n");
                        if (!string4.equals(string5)) {
                            ((OnBeforeSendHeadersMessage)message).setOverrideHeaders(string5);
                        }
                    }
                    catch (Exception exception) {
                        a.log(Level.SEVERE, "The NetworkDelegate.onBeforeSendHeaders() method has thrown exception: ", exception);
                    }
                }
                NetworkDelegateImpl.this.a(message);
                return;
            }
            if (messageType == MessageType.OnSendHeaders) {
                if (((OnSendHeadersMessage)(message = (OnSendHeadersMessage)message)).getBrowserContextId() != NetworkDelegateImpl.this.d || NetworkDelegateImpl.this.c == null) return;
                try {
                    String string = ((OnSendHeadersMessage)message).getURL();
                    String string6 = ((OnSendHeadersMessage)message).getMethod();
                    String string7 = ((OnSendHeadersMessage)message).getHeaders();
                    HttpHeadersImpl httpHeadersImpl = HttpHeadersImpl.buildFromString(string7);
                    SendHeadersParams sendHeadersParams = new SendHeadersParams(string, string6, httpHeadersImpl);
                    NetworkDelegateImpl.this.c.onSendHeaders(sendHeadersParams);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onSendHeaders() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnHeadersReceived) {
                if (((OnHeadersReceivedMessage)(message = (OnHeadersReceivedMessage)message)).getBrowserContextId() != NetworkDelegateImpl.this.d) return;
                if (NetworkDelegateImpl.this.c != null) {
                    try {
                        String string = ((OnHeadersReceivedMessage)message).getURL();
                        String string8 = ((OnHeadersReceivedMessage)message).getMethod();
                        Object object = ((OnHeadersReceivedMessage)message).getOriginalHeaders();
                        HttpHeadersImpl httpHeadersImpl = HttpHeadersImpl.buildFromString((String)object);
                        String string9 = httpHeadersImpl.getStringRepresentation("\r\n");
                        object = new HeadersReceivedParams(string, string8, httpHeadersImpl);
                        NetworkDelegateImpl.this.c.onHeadersReceived((HeadersReceivedParams)object);
                        String string10 = httpHeadersImpl.getStringRepresentation("\r\n");
                        if (!string9.equals(string10)) {
                            ((OnHeadersReceivedMessage)message).setOverrideHeaders(string10);
                        }
                    }
                    catch (Exception exception) {
                        a.log(Level.SEVERE, "The NetworkDelegate.onHeadersReceived() method has thrown exception: ", exception);
                    }
                }
                NetworkDelegateImpl.this.a(message);
                return;
            }
            if (messageType == MessageType.OnBeforeRedirect) {
                if (((OnBeforeRedirectMessage)(message = (OnBeforeRedirectMessage)message)).getBrowserContextId() != NetworkDelegateImpl.this.d || NetworkDelegateImpl.this.c == null) return;
                try {
                    String string = ((OnBeforeRedirectMessage)message).getURL();
                    String string11 = ((OnBeforeRedirectMessage)message).getMethod();
                    int n2 = ((OnBeforeRedirectMessage)message).getResponseCode();
                    String string12 = ((OnBeforeRedirectMessage)message).getNewLocation();
                    BeforeRedirectParams beforeRedirectParams = new BeforeRedirectParams(string, string11, n2, string12);
                    NetworkDelegateImpl.this.c.onBeforeRedirect(beforeRedirectParams);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onBeforeRedirect() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnResponseStarted) {
                if (((OnResponseStartedMessage)(message = (OnResponseStartedMessage)message)).getBrowserContextId() != NetworkDelegateImpl.this.d || NetworkDelegateImpl.this.c == null) return;
                try {
                    String string = ((OnResponseStartedMessage)message).getURL();
                    String string13 = ((OnResponseStartedMessage)message).getMethod();
                    int n3 = ((OnResponseStartedMessage)message).getResponseCode();
                    ResponseStartedParams responseStartedParams = new ResponseStartedParams(string, string13, n3);
                    NetworkDelegateImpl.this.c.onResponseStarted(responseStartedParams);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onResponseStarted() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnCompleted) {
                if (((OnCompletedMessage)(message = (OnCompletedMessage)message)).getBrowserContextId() != NetworkDelegateImpl.this.d || NetworkDelegateImpl.this.c == null) return;
                try {
                    RequestStatus requestStatus = RequestStatus.valueOf(((OnCompletedMessage)message).getStatus());
                    NetError netError = NetError.valueOf(((OnCompletedMessage)message).getErrorCode());
                    Object object = ((OnCompletedMessage)message).getURL();
                    String string = ((OnCompletedMessage)message).getMethod();
                    int n4 = ((OnCompletedMessage)message).getResponseCode();
                    object = new RequestCompletedParams((String)object, string, n4, requestStatus, netError);
                    NetworkDelegateImpl.this.c.onCompleted((RequestCompletedParams)object);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onCompleted() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnPACScriptError) return;
            if (messageType == MessageType.OnRunAuthDialog) {
                if (((OnRunAuthDialogMessage)(message = (OnRunAuthDialogMessage)message)).getBrowserContextId() != NetworkDelegateImpl.this.d) return;
                if (NetworkDelegateImpl.this.c == null) {
                    NetworkDelegateImpl.this.a(new CloseAuthDialogMessage(MessageUIDGenerator.generate(), NetworkDelegateImpl.this.d, ((OnRunAuthDialogMessage)message).getDialogID(), false, "", ""));
                    return;
                }
                NetworkDelegateImpl.this.f.invokeLater(new be(this, (OnRunAuthDialogMessage)message));
                return;
            }
            if (messageType == MessageType.OnCanGetCookies) {
                message = (OnCanGetCookiesMessage)message;
                if (NetworkDelegateImpl.this.c != null) {
                    String string = ((OnCanGetCookiesMessage)message).getURL();
                    List<Cookie> list = CookieParser.cookiesFromString(((OnCanGetCookiesMessage)message).getCookies());
                    try {
                        ((OnCanGetCookiesMessage)message).setCanGetCookies(NetworkDelegateImpl.this.c.onCanGetCookies(string, list));
                    }
                    catch (Exception exception) {
                        a.log(Level.SEVERE, "The DialogHandler.onCanGetCookies() method has thrown exception: ", exception);
                    }
                }
                NetworkDelegateImpl.this.a(message);
                return;
            }
            if (messageType != MessageType.OnCanSetCookies) return;
            message = (OnCanSetCookiesMessage)message;
            if (NetworkDelegateImpl.this.c != null) {
                String string = ((OnCanSetCookiesMessage)message).getURL();
                List<Cookie> list = CookieParser.cookiesFromString(((OnCanSetCookiesMessage)message).getCookies());
                try {
                    ((OnCanSetCookiesMessage)message).setCanSetCookies(NetworkDelegateImpl.this.c.onCanSetCookies(string, list));
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The DialogHandler.onCanSetCookies() method has thrown exception: ", exception);
                }
            }
            NetworkDelegateImpl.this.a(message);
        }
    }
}

