/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.PluginInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginInfoParser {
    private static final Logger a = LoggerProvider.getBrowserLogger();
    public static final String PLUGIN_DELIMITER = "|";
    public static final String MIME_TYPE_DELIMITER = "jxb-part";
    public static final String FIELD_DELIMITER = "jxb-field";
    private static final Pattern b = Pattern.compile("jxb-field");
    private static final Pattern c = Pattern.compile("jxb-part");

    public static List<PluginInfo> parsePluginsInfo(String object) {
        ArrayList<PluginInfo> arrayList = new ArrayList<PluginInfo>();
        object = new StringTokenizer((String)object, PLUGIN_DELIMITER);
        while (((StringTokenizer)object).hasMoreTokens()) {
            Object object2 = ((StringTokenizer)object).nextToken();
            if ((object2 = PluginInfoParser.parsePluginInfo((String)object2)) == null) continue;
            arrayList.add((PluginInfo)object2);
        }
        return arrayList;
    }

    public static PluginInfo parsePluginInfo(String string) {
        try {
            String[] stringArray = b.split(string, Integer.MAX_VALUE);
            if (stringArray.length != 5) {
                a.log(Level.SEVERE, "Failed to parse the '" + string + "' plugin representation.");
                return null;
            }
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            String string4 = stringArray[2];
            String string5 = stringArray[3];
            ArrayList<String> arrayList = new ArrayList<String>();
            stringArray = c.split(stringArray[4]);
            Collections.addAll(arrayList, stringArray);
            return new PluginInfo(string2, string3, string4, string5, arrayList);
        }
        catch (Exception exception) {
            a.log(Level.SEVERE, "Failed to parse the '" + string + "' plugin representation", exception);
            return null;
        }
    }
}

