/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.FormData;
import com.teamdev.jxbrowser.chromium.MultipartFormData;
import com.teamdev.jxbrowser.chromium.PostData;
import com.teamdev.jxbrowser.chromium.PostDataContentType;
import com.teamdev.jxbrowser.chromium.RawData;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostDataUtils {
    private static final int[] a = new int[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66};

    public static PostDataContentType getPostDataTypeFromHeader(String string) {
        if (string == null) {
            return null;
        }
        if (string.contains("application/x-www-form-urlencoded")) {
            return PostDataContentType.FORM_URL_ENCODED;
        }
        if (string.contains("multipart/form-data")) {
            return PostDataContentType.MULTIPART_FORM_DATA;
        }
        return PostDataContentType.PLAIN_TEXT;
    }

    public static String getBoundaryFromContentHeader(String string) {
        Object object = PostDataUtils.getPostDataTypeFromHeader(string);
        if (object == PostDataContentType.MULTIPART_FORM_DATA) {
            object = "boundary=";
            int n2 = string.indexOf((String)object) + ((String)object).length();
            return string.substring(n2);
        }
        return null;
    }

    public static boolean isKeyValuePairsEquals(Map<String, List<String>> object, Map<String, List<String>> map) {
        if (object.size() != map.size()) {
            return false;
        }
        for (Map.Entry object2 : object.entrySet()) {
            Object object3 = (String)object2.getKey();
            if (!map.containsKey(object3)) {
                return false;
            }
            List list = (List)object2.getValue();
            object3 = map.get(object3);
            boolean bl = list.containsAll((Collection<?>)object3);
            boolean bl2 = object3.containsAll(list);
            if (bl && bl2) continue;
            return false;
        }
        return true;
    }

    public static String generateUniqueBoundary() {
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("----WebKitFormBoundary");
        for (int i2 = 0; i2 < 16; ++i2) {
            int n2 = secureRandom.nextInt(a.length);
            stringBuilder.append((char)a[n2]);
        }
        return stringBuilder.toString();
    }

    public static void initializeFormData(FormData formData, Map<String, List<String>> object) {
        formData.removeAllPairs();
        for (Map.Entry entry : object.entrySet()) {
            List list = (List)entry.getValue();
            formData.setPair((String)entry.getKey(), list.toArray(new String[list.size()]));
        }
    }

    public static void initializeFormData(MultipartFormData multipartFormData, Map<String, List<String>> object, Map<String, List<String>> object22) {
        multipartFormData.removeAllFilePairs();
        PostDataUtils.initializeFormData(multipartFormData, (Map<String, List<String>>)((Object)object));
        for (Map.Entry entry : object22.entrySet()) {
            List list = (List)entry.getValue();
            multipartFormData.setFilePair((String)entry.getKey(), list.toArray(new String[list.size()]));
        }
    }

    public static Map<String, List<String>> buildKeyValuesMap(FormData formData) {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>();
        Object object = formData.getPairKeys();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            treeMap.put(string, new ArrayList<String>(formData.getPairValues(string)));
        }
        return treeMap;
    }

    public static Map<String, List<String>> buildFilesMap(MultipartFormData multipartFormData) {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>();
        Object object = multipartFormData.getFileKeys();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            treeMap.put(string, new ArrayList<String>(multipartFormData.getFiles(string)));
        }
        return treeMap;
    }

    public static PostData copyPostData(PostData postData) {
        if (postData instanceof MultipartFormData) {
            MultipartFormData multipartFormData = new MultipartFormData();
            PostDataUtils.initializeFormData(multipartFormData, PostDataUtils.buildKeyValuesMap((MultipartFormData)postData), PostDataUtils.buildFilesMap((MultipartFormData)postData));
            return multipartFormData;
        }
        if (postData instanceof FormData) {
            FormData formData = new FormData();
            PostDataUtils.initializeFormData(formData, PostDataUtils.buildKeyValuesMap((FormData)postData));
            return formData;
        }
        return new RawData(((RawData)postData).getData());
    }
}

