/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.BrowserContext;
import com.teamdev.jxbrowser.chromium.BrowserFunction;
import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.BrowserView;
import com.teamdev.jxbrowser.chromium.CacheStorage;
import com.teamdev.jxbrowser.chromium.ContextMenuHandler;
import com.teamdev.jxbrowser.chromium.ContextMenuParams;
import com.teamdev.jxbrowser.chromium.CookieStorage;
import com.teamdev.jxbrowser.chromium.DefaultDialogHandler;
import com.teamdev.jxbrowser.chromium.DefaultDownloadHandler;
import com.teamdev.jxbrowser.chromium.DefaultLoadHandler;
import com.teamdev.jxbrowser.chromium.DefaultPopupHandler;
import com.teamdev.jxbrowser.chromium.DefaultPrintHandler;
import com.teamdev.jxbrowser.chromium.DialogHandler;
import com.teamdev.jxbrowser.chromium.DownloadHandler;
import com.teamdev.jxbrowser.chromium.EditorCommand;
import com.teamdev.jxbrowser.chromium.JSValue;
import com.teamdev.jxbrowser.chromium.LoadDataParams;
import com.teamdev.jxbrowser.chromium.LoadHTMLParams;
import com.teamdev.jxbrowser.chromium.LoadHandler;
import com.teamdev.jxbrowser.chromium.LoadURLParams;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.MediaType;
import com.teamdev.jxbrowser.chromium.NavigationEntry;
import com.teamdev.jxbrowser.chromium.PluginManager;
import com.teamdev.jxbrowser.chromium.PopupContainer;
import com.teamdev.jxbrowser.chromium.PopupHandler;
import com.teamdev.jxbrowser.chromium.PopupParams;
import com.teamdev.jxbrowser.chromium.PrintHandler;
import com.teamdev.jxbrowser.chromium.SavePageType;
import com.teamdev.jxbrowser.chromium.SearchParams;
import com.teamdev.jxbrowser.chromium.SearchResult;
import com.teamdev.jxbrowser.chromium.StopFindAction;
import com.teamdev.jxbrowser.chromium.TerminationStatus;
import com.teamdev.jxbrowser.chromium.dom.DOMDocument;
import com.teamdev.jxbrowser.chromium.dom.DOMNodeAtPoint;
import com.teamdev.jxbrowser.chromium.events.ConsoleEvent;
import com.teamdev.jxbrowser.chromium.events.ConsoleListener;
import com.teamdev.jxbrowser.chromium.events.DisposeEvent;
import com.teamdev.jxbrowser.chromium.events.DisposeListener;
import com.teamdev.jxbrowser.chromium.events.FailLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.FinishLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.FrameLoadEvent;
import com.teamdev.jxbrowser.chromium.events.LoadEvent;
import com.teamdev.jxbrowser.chromium.events.LoadListener;
import com.teamdev.jxbrowser.chromium.events.ProvisionalLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.RenderEvent;
import com.teamdev.jxbrowser.chromium.events.RenderListener;
import com.teamdev.jxbrowser.chromium.events.StartLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.StatusEvent;
import com.teamdev.jxbrowser.chromium.events.StatusListener;
import com.teamdev.jxbrowser.chromium.events.TitleEvent;
import com.teamdev.jxbrowser.chromium.events.TitleListener;
import com.teamdev.jxbrowser.chromium.internal.Callback;
import com.teamdev.jxbrowser.chromium.internal.ChannelCacheStorage;
import com.teamdev.jxbrowser.chromium.internal.ChannelCookieStorage;
import com.teamdev.jxbrowser.chromium.internal.ChromiumEventQueue;
import com.teamdev.jxbrowser.chromium.internal.DialogHandlerDelegate;
import com.teamdev.jxbrowser.chromium.internal.DownloadHandlerDelegate;
import com.teamdev.jxbrowser.chromium.internal.JSValueParser;
import com.teamdev.jxbrowser.chromium.internal.PluginManagerImpl;
import com.teamdev.jxbrowser.chromium.internal.PopupWidget;
import com.teamdev.jxbrowser.chromium.internal.PrintHandlerDelegate;
import com.teamdev.jxbrowser.chromium.internal.RenderProcess;
import com.teamdev.jxbrowser.chromium.internal.SearchCompleteCallback;
import com.teamdev.jxbrowser.chromium.internal.SearchRequestIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.WebViewManager;
import com.teamdev.jxbrowser.chromium.internal.Widget;
import com.teamdev.jxbrowser.chromium.internal.WidgetView;
import com.teamdev.jxbrowser.chromium.internal.d;
import com.teamdev.jxbrowser.chromium.internal.f;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelType;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPCException;
import com.teamdev.jxbrowser.chromium.internal.ipc.LatchUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.AllowCertificateErrorMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CanGoBackMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CanGoForwardMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CanGoToOffsetMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.DisposeBrowserMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ExecuteJavaScriptMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.FindTextMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetCurrentEntryIndexMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetEntryCountMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetEntryMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetHTMLMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetRemoteDebuggingURLMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetTitleMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetURLMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetWebPreferencesMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetZoomLevelMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GoBackMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GoForwardMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GoToIndexMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GoToOffsetMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.IsLoadingMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.LoadDataMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.LoadURLMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnAddNewContentsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnAllowCertificateErrorMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnBeforeDownloadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnCacheClearMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnConsoleMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidCommitProvisionalLoadForFrameMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidFailLoadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidFailProvisionalLoadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidFinishLoadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDidStartProvisionalLoadForFrameMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDocumentAvailableInMainFrameMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDocumentLoadedInFrameMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnFormRepostWarningShowMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnGetParentForWindowlessPluginMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnPrintingDoneMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRenderViewCreatedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRenderViewGoneMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRequestPluginStateMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRequestPrintSettingsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRunFileChooserMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRunJavaScriptDialogMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnSearchCompleteMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnSelectClientCertificateMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnShouldCreateWebContentsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnShowContextMenuMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnShowPopupWidgetMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnStatusChangeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnTitleChangeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnTooltipChangeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnWindowCloseMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.PageZoom;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.PingMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.PrintMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ReloadIgnoringCacheMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ReloadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.RemoveEntryAtIndexMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SaveWebPageMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetZoomLevelMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetZoomMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.StopFindingMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.StopMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.UpdateWebPreferencesMessage;
import com.teamdev.jxbrowser.chromium.internal.m;
import com.teamdev.jxbrowser.chromium.internal.n;
import com.teamdev.jxbrowser.chromium.internal.o;
import com.teamdev.jxbrowser.chromium.internal.p;
import com.teamdev.jxbrowser.chromium.internal.q;
import com.teamdev.jxbrowser.chromium.internal.r;
import com.teamdev.jxbrowser.chromium.internal.s;
import com.teamdev.jxbrowser.chromium.internal.t;
import com.teamdev.jxbrowser.chromium.internal.u;
import com.teamdev.jxbrowser.chromium.internal.v;
import com.teamdev.jxbrowser.chromium.internal.w;
import com.teamdev.jxbrowser.chromium.internal.x;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebView
implements Browser {
    private static final Logger a;
    private final WidgetView b;
    private final CookieStorage c;
    private final BrowserContext d;
    private final ChromiumEventQueue e;
    private final PluginManagerImpl f;
    private final ChannelCacheStorage g;
    private final List<LoadListener> h;
    private final List<TitleListener> i;
    private final List<RenderListener> j;
    private final List<StatusListener> k;
    private final List<ConsoleListener> l;
    private final List<DisposeListener> m;
    private final PrintHandlerDelegate n;
    private final DialogHandlerDelegate o;
    private final DownloadHandlerDelegate p;
    private final Map<String, BrowserFunction> q;
    private final Map<Integer, SearchCompleteCallback> r;
    private LoadHandler s;
    private PopupHandler t;
    private PopupContainer u;
    private ContextMenuHandler v;

    public WebView(WidgetView widgetView, BrowserContext browserContext) {
        this.b = widgetView;
        this.d = browserContext;
        this.q = new HashMap<String, BrowserFunction>();
        this.c = new ChannelCookieStorage(widgetView.getWidget().getChannel());
        this.g = new ChannelCacheStorage(widgetView.getWidget().getChannel());
        this.f = new PluginManagerImpl(widgetView.getWidget().getChannel());
        this.e = new ChromiumEventQueue();
        this.i = new ArrayList<TitleListener>();
        this.h = new ArrayList<LoadListener>();
        this.j = new ArrayList<RenderListener>();
        this.m = new ArrayList<DisposeListener>();
        this.l = new ArrayList<ConsoleListener>();
        this.k = new ArrayList<StatusListener>();
        this.r = new HashMap<Integer, SearchCompleteCallback>();
        this.n = new PrintHandlerDelegate();
        this.o = new DialogHandlerDelegate();
        this.p = new DownloadHandlerDelegate();
        this.b.getWidget().getChannel().addChannelListener(new x(this));
    }

    public Channel getChannel() {
        return this.b.getWidget().getChannel();
    }

    public void initializeDefaultHandlers() {
        this.setDialogHandler(new DefaultDialogHandler());
        this.setDownloadHandler(new DefaultDownloadHandler());
        this.setPopupHandler(new DefaultPopupHandler());
        this.setLoadHandler(new DefaultLoadHandler());
        this.setPrintHandler(new DefaultPrintHandler());
    }

    @Override
    public void addTitleListener(TitleListener titleListener) {
        if (!this.i.contains(titleListener)) {
            this.i.add(titleListener);
        }
    }

    @Override
    public void removeTitleListener(TitleListener titleListener) {
        this.i.remove(titleListener);
    }

    @Override
    public List<TitleListener> getTitleListeners() {
        return new ArrayList<TitleListener>(this.i);
    }

    @Override
    public void addStatusListener(StatusListener statusListener) {
        if (!this.k.contains(statusListener)) {
            this.k.add(statusListener);
        }
    }

    @Override
    public void removeStatusListener(StatusListener statusListener) {
        this.k.remove(statusListener);
    }

    @Override
    public List<StatusListener> getStatusListeners() {
        return new ArrayList<StatusListener>(this.k);
    }

    @Override
    public void addLoadListener(LoadListener loadListener) {
        if (!this.h.contains(loadListener)) {
            this.h.add(loadListener);
        }
    }

    @Override
    public void removeLoadListener(LoadListener loadListener) {
        this.h.remove(loadListener);
    }

    @Override
    public List<LoadListener> getLoadListeners() {
        return new ArrayList<LoadListener>(this.h);
    }

    @Override
    public void addRenderListener(RenderListener renderListener) {
        if (!this.j.contains(renderListener)) {
            this.j.add(renderListener);
        }
    }

    @Override
    public void removeRenderListener(RenderListener renderListener) {
        this.j.remove(renderListener);
    }

    @Override
    public List<RenderListener> getRenderListeners() {
        return new ArrayList<RenderListener>(this.j);
    }

    @Override
    public void addConsoleListener(ConsoleListener consoleListener) {
        if (!this.l.contains(consoleListener)) {
            this.l.add(consoleListener);
        }
    }

    @Override
    public void removeConsoleListener(ConsoleListener consoleListener) {
        this.l.remove(consoleListener);
    }

    @Override
    public List<ConsoleListener> getConsoleListeners() {
        return new ArrayList<ConsoleListener>(this.l);
    }

    @Override
    public void setPopupHandler(PopupHandler popupHandler) {
        this.t = popupHandler;
    }

    @Override
    public PopupHandler getPopupHandler() {
        return this.t;
    }

    @Override
    public void setContextMenuHandler(ContextMenuHandler contextMenuHandler) {
        this.v = contextMenuHandler;
    }

    @Override
    public ContextMenuHandler getContextMenuHandler() {
        return this.v;
    }

    @Override
    public void setDownloadHandler(DownloadHandler downloadHandler) {
        this.p.setDownloadHandler(downloadHandler);
    }

    @Override
    public DownloadHandler getDownloadHandler() {
        return this.p.getDownloadHandler();
    }

    @Override
    public void setDialogHandler(DialogHandler dialogHandler) {
        this.o.setDialogHandler(dialogHandler);
    }

    @Override
    public DialogHandler getDialogHandler() {
        return this.o.getDialogHandler();
    }

    @Override
    public CookieStorage getCookieStorage() {
        return this.c;
    }

    @Override
    public CacheStorage getCacheStorage() {
        return this.g;
    }

    @Override
    public synchronized boolean isCommandEnabled(EditorCommand editorCommand) {
        if (editorCommand == null) {
            throw new IllegalArgumentException("The command parameter cannot be null.");
        }
        return (this = WebViewManager.INSTANCE.getRenderProcess((WebView)this)) != null && ((RenderProcess)this).isCommandEnabled(editorCommand.getCommandText());
    }

    @Override
    public synchronized boolean executeCommand(EditorCommand editorCommand) {
        return this.executeCommand(-2L, editorCommand);
    }

    @Override
    public synchronized boolean executeCommand(long l2, EditorCommand editorCommand) {
        return this.executeCommand(l2, editorCommand, null);
    }

    @Override
    public synchronized boolean executeCommand(EditorCommand editorCommand, String string) {
        return this.executeCommand(-2L, editorCommand, string);
    }

    @Override
    public synchronized boolean executeCommand(long l2, EditorCommand editorCommand, String string) {
        if (editorCommand == null) {
            throw new IllegalArgumentException("The command parameter cannot be null.");
        }
        ((WebView)((Object)renderProcess)).a(l2);
        RenderProcess renderProcess = WebViewManager.INSTANCE.getRenderProcess((WebView)((Object)renderProcess));
        return renderProcess != null && renderProcess.executeCommand(l2, editorCommand.getCommandText(), string);
    }

    @Override
    public void setLoadHandler(LoadHandler loadHandler) {
        this.s = loadHandler;
    }

    @Override
    public LoadHandler getLoadHandler() {
        return this.s;
    }

    @Override
    public synchronized BrowserPreferences getPreferences() {
        GetWebPreferencesMessage getWebPreferencesMessage = ((WebView)((Object)getWebPreferencesMessage)).b(new GetWebPreferencesMessage(MessageUIDGenerator.generate()));
        return getWebPreferencesMessage.getPreferences();
    }

    @Override
    public synchronized String getRemoteDebuggingURL() {
        GetRemoteDebuggingURLMessage getRemoteDebuggingURLMessage = ((WebView)((Object)getRemoteDebuggingURLMessage)).b(new GetRemoteDebuggingURLMessage(MessageUIDGenerator.generate()));
        return getRemoteDebuggingURLMessage.getRemoteDebuggingURL();
    }

    @Override
    public synchronized Set<Long> getFramesIds() {
        if ((this = WebViewManager.INSTANCE.getRenderProcess((WebView)this)) != null) {
            return ((RenderProcess)this).getFramesIds();
        }
        return new HashSet<Long>();
    }

    @Override
    public synchronized SearchResult findText(SearchParams object) {
        if (object == null) {
            throw new IllegalArgumentException("The params parameter cannot be null.");
        }
        int n2 = SearchRequestIDGenerator.generate();
        object = new FindTextMessage(MessageUIDGenerator.generate(), n2, ((SearchParams)object).getSearchText(), ((SearchParams)object).isForward(), ((SearchParams)object).isMatchCase(), false);
        AtomicReference atomicReference = new AtomicReference();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        t t2 = new t(this, atomicReference, countDownLatch);
        this.r.put(n2, t2);
        this.a((Message)object);
        LatchUtil.await(countDownLatch, new IPCException("Response was not received."));
        return (SearchResult)atomicReference.get();
    }

    @Override
    public synchronized void stopFindingText(StopFindAction stopFindAction) {
        if (stopFindAction == null) {
            throw new IllegalArgumentException("The action parameter cannot be null.");
        }
        this.a(new StopFindingMessage(MessageUIDGenerator.generate(), stopFindAction.getValue()));
    }

    @Override
    public String getSelectedText() {
        return this.getSelectedText(-2L);
    }

    @Override
    public String getSelectedText(long l2) {
        ((WebView)((Object)renderProcess)).a(l2);
        RenderProcess renderProcess = WebViewManager.INSTANCE.getRenderProcess((WebView)((Object)renderProcess));
        if (renderProcess != null) {
            return renderProcess.getSelectedText(l2);
        }
        return "";
    }

    @Override
    public PluginManager getPluginManager() {
        return this.f;
    }

    @Override
    public void setPrintHandler(PrintHandler printHandler) {
        this.n.setPrintHandler(printHandler);
    }

    @Override
    public PrintHandler getPrintHandler() {
        return this.n.getPrintHandler();
    }

    @Override
    public void print() {
        this.a(new PrintMessage(MessageUIDGenerator.generate()));
    }

    @Override
    public synchronized void setPreferences(BrowserPreferences browserPreferences) {
        if (browserPreferences == null) {
            throw new IllegalArgumentException("Preferences cannot be null.");
        }
        this.a(new UpdateWebPreferencesMessage(MessageUIDGenerator.generate(), browserPreferences));
    }

    @Override
    public synchronized void saveWebPage(String string, String string2, SavePageType savePageType) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("The filePath parameter cannot be empty or null.");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("The dirPath parameter cannot be empty or null.");
        }
        if (savePageType == null) {
            throw new IllegalArgumentException("The saveType parameter cannot be null.");
        }
        boolean bl = ((SaveWebPageMessage)(this = ((WebView)this).b(new SaveWebPageMessage(MessageUIDGenerator.generate(), string, string2, savePageType.getValue())))).getResult();
        if (!bl) {
            a.log(Level.SEVERE, "Initialization of the saving process failed.");
        }
    }

    @Override
    public BrowserView getView() {
        return this.b;
    }

    @Override
    public BrowserContext getContext() {
        return this.d;
    }

    @Override
    public synchronized DOMDocument getDocument() {
        return this.getDocument(-1L);
    }

    @Override
    public synchronized DOMDocument getDocument(long l2) {
        ((WebView)((Object)renderProcess)).a(l2);
        RenderProcess renderProcess = WebViewManager.INSTANCE.getRenderProcess((WebView)((Object)renderProcess));
        if (renderProcess != null) {
            return renderProcess.getDocument(l2);
        }
        return null;
    }

    @Override
    public synchronized DOMNodeAtPoint getNodeAtPoint(int n2, int n3) {
        if ((this = WebViewManager.INSTANCE.getRenderProcess((WebView)this)) != null) {
            return ((RenderProcess)this).getNodeAtPoint(n2, n3);
        }
        return null;
    }

    @Override
    public synchronized DOMNodeAtPoint getNodeAtPoint(Point point) {
        if (point == null) {
            throw new IllegalArgumentException("The point parameter cannot be null.");
        }
        return this.getNodeAtPoint(point.x, point.y);
    }

    @Override
    public synchronized void dispose() {
        this.a(true);
    }

    private synchronized void a(boolean bl) {
        Object object = this.b.getWidget();
        Object object2 = WebViewManager.INSTANCE.getRenderProcess(this);
        object2 = object2 != null ? ((RenderProcess)object2).getChannel() : null;
        Channel channel = ((Widget)object).getChannel();
        if (!this.isDisposed()) {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            w w2 = new w(this, channel, countDownLatch);
            object = ((Widget)object).getIPC();
            ((IPC)object).addIPCListener(w2);
            try {
                channel.send(new DisposeBrowserMessage(MessageUIDGenerator.generate()));
                Channel channel2 = channel;
                Object object3 = object2;
                if (object3 != null) {
                    object3.blockWriteMessages();
                }
                if (channel2 != null) {
                    channel2.blockWriteMessages();
                }
                channel.waitForPendingPostRequests();
                if (object2 != null) {
                    object2.waitForPendingPostRequests();
                }
                LatchUtil.await(countDownLatch, new IPCException("Failed to execute WebView dispose post message."));
            }
            finally {
                ((IPC)object).removeIPCListener(w2);
            }
            this.b.dispose();
            this.e.onDisposed(this.getDisposeListeners(), new DisposeEvent(this));
            this.e.dispose();
            WebViewManager.INSTANCE.removeWebView(this);
        }
    }

    @Override
    public synchronized boolean isDisposed() {
        try {
            PingMessage pingMessage = ((WebView)((Object)pingMessage)).b(new PingMessage(MessageUIDGenerator.generate()));
            return !pingMessage.isAlive();
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    public void addDisposeListener(DisposeListener disposeListener) {
        if (!this.m.contains(disposeListener)) {
            this.m.add(disposeListener);
        }
    }

    @Override
    public void removeDisposeListener(DisposeListener disposeListener) {
        this.m.remove(disposeListener);
    }

    @Override
    public List<DisposeListener> getDisposeListeners() {
        return new ArrayList<DisposeListener>(this.m);
    }

    @Override
    public synchronized void loadURL(String string) {
        this.loadURL(-1L, string);
    }

    @Override
    public synchronized void loadURL(long l2, String string) {
        if (string == null) {
            throw new IllegalArgumentException("The url parameter cannot be null.");
        }
        this.a(l2);
        this.a(new LoadURLMessage(MessageUIDGenerator.generate(), string, l2));
    }

    @Override
    public synchronized void loadURL(LoadURLParams loadURLParams) {
        if (loadURLParams == null) {
            throw new IllegalArgumentException("The params parameter cannot be null.");
        }
        String string = loadURLParams.getPostData();
        if (string == null) {
            this.loadURL(loadURLParams.getURL());
            return;
        }
        String string2 = "Content-Type: application/x-www-form-urlencoded\n";
        this.a(new LoadURLMessage(MessageUIDGenerator.generate(), loadURLParams.getURL(), -1L, string2, string.getBytes(Charset.forName("UTF-8"))));
    }

    @Override
    public synchronized void loadHTML(String string) {
        this.loadHTML(-1L, string);
    }

    @Override
    public synchronized void loadHTML(long l2, String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("The html parameter cannot be null or empty.");
        }
        this.a(l2);
        this.loadHTML(l2, new LoadHTMLParams(string, "UTF-8", "about:blank"));
    }

    @Override
    public synchronized void loadHTML(LoadHTMLParams loadHTMLParams) {
        this.loadHTML(-1L, loadHTMLParams);
    }

    @Override
    public synchronized void loadHTML(long l2, LoadHTMLParams loadHTMLParams) {
        if (loadHTMLParams == null) {
            throw new IllegalArgumentException("The params parameter cannot be null.");
        }
        this.loadData(l2, new LoadDataParams(loadHTMLParams.getHTML(), "text/html", loadHTMLParams.getTextEncoding(), loadHTMLParams.getBaseURL()));
    }

    @Override
    public synchronized void loadData(LoadDataParams loadDataParams) {
        this.loadData(-1L, loadDataParams);
    }

    @Override
    public synchronized void loadData(long l2, LoadDataParams loadDataParams) {
        if (loadDataParams == null) {
            throw new IllegalArgumentException("The params parameter cannot be null.");
        }
        this.a(l2);
        this.a(new LoadDataMessage(MessageUIDGenerator.generate(), loadDataParams.getData(), loadDataParams.getMimeType(), loadDataParams.getTextEncoding(), loadDataParams.getBaseURL(), l2));
    }

    @Override
    public synchronized String getHTML() {
        return this.getHTML(-1L);
    }

    @Override
    public synchronized String getHTML(long l2) {
        ((WebView)((Object)getHTMLMessage)).a(l2);
        GetHTMLMessage getHTMLMessage = ((WebView)((Object)getHTMLMessage)).b(new GetHTMLMessage(MessageUIDGenerator.generate(), l2, null));
        return getHTMLMessage.getHTML();
    }

    @Override
    public synchronized String getURL() {
        GetURLMessage getURLMessage = ((WebView)((Object)getURLMessage)).b(new GetURLMessage(MessageUIDGenerator.generate()));
        return getURLMessage.getURL();
    }

    @Override
    public synchronized void executeJavaScript(String string) {
        this.executeJavaScript(-1L, string);
    }

    @Override
    public synchronized JSValue executeJavaScriptAndReturnValue(String string) {
        return this.executeJavaScriptAndReturnValue(-1L, string);
    }

    @Override
    public synchronized void executeJavaScript(long l2, String string) {
        if (string == null) {
            throw new IllegalArgumentException("The javaScript parameter cannot be null.");
        }
        this.a(l2);
        this.a(new ExecuteJavaScriptMessage(MessageUIDGenerator.generate(), l2, string));
    }

    @Override
    public synchronized JSValue executeJavaScriptAndReturnValue(long l2, String string) {
        if (string == null) {
            throw new IllegalArgumentException("The javaScript parameter cannot be null.");
        }
        ((WebView)((Object)executeJavaScriptMessage)).a(l2);
        ExecuteJavaScriptMessage executeJavaScriptMessage = ((WebView)((Object)executeJavaScriptMessage)).b(new ExecuteJavaScriptMessage(MessageUIDGenerator.generate(), l2, string, true));
        return JSValueParser.create(executeJavaScriptMessage);
    }

    @Override
    public void registerFunction(String string, BrowserFunction browserFunction) {
        this.q.put(string, browserFunction);
    }

    @Override
    public void unregisterFunction(String string) {
        this.q.remove(string);
    }

    public List<String> getBrowserFunctionNames() {
        return new ArrayList<String>(this.q.keySet());
    }

    public BrowserFunction getBrowserFunction(String string) {
        return this.q.get(string);
    }

    @Override
    public synchronized String getTitle() {
        GetTitleMessage getTitleMessage = ((WebView)((Object)getTitleMessage)).b(new GetTitleMessage(MessageUIDGenerator.generate()));
        return getTitleMessage.getTitle();
    }

    @Override
    public synchronized void setZoomLevel(double d2) {
        this.a(new SetZoomLevelMessage(MessageUIDGenerator.generate(), d2));
    }

    @Override
    public synchronized double getZoomLevel() {
        GetZoomLevelMessage getZoomLevelMessage = ((WebView)((Object)getZoomLevelMessage)).b(new GetZoomLevelMessage(MessageUIDGenerator.generate()));
        return getZoomLevelMessage.getZoomLevel();
    }

    @Override
    public synchronized void zoomIn() {
        this.a(new SetZoomMessage(MessageUIDGenerator.generate(), PageZoom.PAGE_ZOOM_IN.getValue()));
    }

    @Override
    public synchronized void zoomOut() {
        this.a(new SetZoomMessage(MessageUIDGenerator.generate(), PageZoom.PAGE_ZOOM_OUT.getValue()));
    }

    @Override
    public synchronized void zoomReset() {
        this.a(new SetZoomMessage(MessageUIDGenerator.generate(), PageZoom.PAGE_ZOOM_RESET.getValue()));
    }

    @Override
    public synchronized boolean isLoading() {
        IsLoadingMessage isLoadingMessage = ((WebView)((Object)isLoadingMessage)).b(new IsLoadingMessage(MessageUIDGenerator.generate()));
        return isLoadingMessage.isLoading();
    }

    @Override
    public synchronized void stop() {
        this.a(new StopMessage(MessageUIDGenerator.generate()));
    }

    @Override
    public synchronized void goBack() {
        this.a(new GoBackMessage(MessageUIDGenerator.generate()));
    }

    @Override
    public synchronized boolean canGoBack() {
        CanGoBackMessage canGoBackMessage = ((WebView)((Object)canGoBackMessage)).b(new CanGoBackMessage(MessageUIDGenerator.generate()));
        return canGoBackMessage.canGoBack();
    }

    @Override
    public synchronized void goForward() {
        this.a(new GoForwardMessage(MessageUIDGenerator.generate()));
    }

    @Override
    public synchronized boolean canGoForward() {
        CanGoForwardMessage canGoForwardMessage = ((WebView)((Object)canGoForwardMessage)).b(new CanGoForwardMessage(MessageUIDGenerator.generate()));
        return canGoForwardMessage.canGoForward();
    }

    @Override
    public synchronized boolean canGoToOffset(int n2) {
        CanGoToOffsetMessage canGoToOffsetMessage = ((WebView)((Object)canGoToOffsetMessage)).b(new CanGoToOffsetMessage(MessageUIDGenerator.generate(), n2, false));
        return canGoToOffsetMessage.canGoToOffset();
    }

    @Override
    public synchronized void goToOffset(int n2) {
        this.a(new GoToOffsetMessage(MessageUIDGenerator.generate(), n2));
    }

    @Override
    public synchronized void goToIndex(int n2) {
        this.a(new GoToIndexMessage(MessageUIDGenerator.generate(), n2));
    }

    @Override
    public synchronized int getNavigationEntryCount() {
        GetEntryCountMessage getEntryCountMessage = ((WebView)((Object)getEntryCountMessage)).b(new GetEntryCountMessage(MessageUIDGenerator.generate(), 0));
        return getEntryCountMessage.getEntryCount();
    }

    @Override
    public synchronized int getCurrentNavigationEntryIndex() {
        GetCurrentEntryIndexMessage getCurrentEntryIndexMessage = ((WebView)((Object)getCurrentEntryIndexMessage)).b(new GetCurrentEntryIndexMessage(MessageUIDGenerator.generate(), 0));
        return getCurrentEntryIndexMessage.getIndex();
    }

    @Override
    public synchronized NavigationEntry getCurrentNavigationEntry() {
        return this.a(GetEntryMessage.Flag.CURRENT, -1);
    }

    @Override
    public synchronized NavigationEntry getNavigationEntryAtIndex(int n2) {
        return this.a(GetEntryMessage.Flag.AT_INDEX, n2);
    }

    @Override
    public synchronized NavigationEntry getNavigationEntryAtOffset(int n2) {
        return this.a(GetEntryMessage.Flag.AT_OFFSET, n2);
    }

    private NavigationEntry a(GetEntryMessage.Flag object, int n2) {
        if (((GetEntryMessage)(object2 = ((WebView)object2).b(new GetEntryMessage(MessageUIDGenerator.generate(), (GetEntryMessage.Flag)((Object)object), n2)))).isSuccess()) {
            object = ((GetEntryMessage)object2).getURL();
            String string = ((GetEntryMessage)object2).getTitle();
            long l2 = ((GetEntryMessage)object2).getTimestamp();
            NavigationEntry.PageType pageType = NavigationEntry.PageType.valueOf(((GetEntryMessage)object2).getPageType());
            int n3 = ((GetEntryMessage)object2).getHttpStatusCode();
            Object object2 = ((GetEntryMessage)object2).getOriginalRequestURL();
            return new NavigationEntry((String)object, string, l2, pageType, n3, (String)object2);
        }
        return null;
    }

    @Override
    public synchronized boolean removeNavigationEntryAtIndex(int n2) {
        RemoveEntryAtIndexMessage removeEntryAtIndexMessage = ((WebView)((Object)removeEntryAtIndexMessage)).b(new RemoveEntryAtIndexMessage(MessageUIDGenerator.generate(), n2, false));
        return removeEntryAtIndexMessage.isSuccess();
    }

    @Override
    public synchronized void reload() {
        this.reload(false);
    }

    @Override
    public synchronized void reloadIgnoringCache() {
        this.reloadIgnoringCache(false);
    }

    @Override
    public synchronized void reload(boolean bl) {
        this.a(new ReloadMessage(MessageUIDGenerator.generate(), bl));
    }

    @Override
    public synchronized void reloadIgnoringCache(boolean bl) {
        this.a(new ReloadIgnoringCacheMessage(MessageUIDGenerator.generate(), bl));
    }

    private void a(long l2) {
        boolean bl;
        boolean bl2 = l2 == -1L;
        boolean bl3 = bl = l2 == -2L;
        if (bl2 || bl) {
            return;
        }
        if ((this = WebViewManager.INSTANCE.getRenderProcess((WebView)this)) == null) {
            throw new IllegalStateException("No available loaded document.");
        }
        if (!((RenderProcess)this).isFrameExists(l2)) {
            throw new IllegalArgumentException("The '" + l2 + "' frame ID doesn't exist.");
        }
    }

    private void a(Message message) {
        Object object = ((WebView)object).b.getWidget();
        object = ((Widget)object).getChannel();
        object.send(message);
    }

    private <T extends Message> T b(T t2) {
        Object object = ((WebView)object).b.getWidget();
        object = ((Widget)object).getChannel();
        return object.post(t2);
    }

    static /* synthetic */ void a(WebView webView, OnShowPopupWidgetMessage onShowPopupWidgetMessage) {
        int n2 = onShowPopupWidgetMessage.getChannelId();
        Rectangle rectangle = onShowPopupWidgetMessage.getPopupBounds();
        PopupWidget popupWidget = new PopupWidget(webView.b, n2, rectangle);
        webView.b.addMouseWheelListener(new f(webView, popupWidget));
        try {
            popupWidget.show();
            return;
        }
        finally {
            webView.a(onShowPopupWidgetMessage);
        }
    }

    static /* synthetic */ void a(WebView webView, OnRenderViewCreatedMessage onRenderViewCreatedMessage) {
        webView.e.onRenderCreated(webView.getRenderListeners(), new RenderEvent(webView));
    }

    static /* synthetic */ void a(WebView webView, OnRenderViewGoneMessage object) {
        object = new RenderEvent(webView, ((OnRenderViewGoneMessage)object).getErrorCode(), TerminationStatus.valueOf(((OnRenderViewGoneMessage)object).getTerminationStatus()));
        webView.e.onRenderGone(webView.getRenderListeners(), (RenderEvent)object);
    }

    static /* synthetic */ void a(WebView webView, OnDidStartProvisionalLoadForFrameMessage object) {
        object = new StartLoadingEvent(webView, ((OnDidStartProvisionalLoadForFrameMessage)object).getFrameId(), ((OnDidStartProvisionalLoadForFrameMessage)object).getParentFrameId(), ((OnDidStartProvisionalLoadForFrameMessage)object).isMainFrame(), ((OnDidStartProvisionalLoadForFrameMessage)object).getValidatedURL(), ((OnDidStartProvisionalLoadForFrameMessage)object).isErrorPage());
        webView.e.onStartLoadingFrame(webView.getLoadListeners(), (StartLoadingEvent)object);
    }

    static /* synthetic */ void a(WebView webView, OnDidCommitProvisionalLoadForFrameMessage object) {
        object = new ProvisionalLoadingEvent(webView, ((OnDidCommitProvisionalLoadForFrameMessage)object).getFrameId(), ((OnDidCommitProvisionalLoadForFrameMessage)object).isMainFrame(), ((OnDidCommitProvisionalLoadForFrameMessage)object).getURL());
        webView.e.onProvisionalLoadForFrame(webView.getLoadListeners(), (ProvisionalLoadingEvent)object);
    }

    static /* synthetic */ void a(WebView webView, OnDidFinishLoadMessage object) {
        object = new FinishLoadingEvent(webView, ((OnDidFinishLoadMessage)object).getFrameId(), ((OnDidFinishLoadMessage)object).isMainFrame(), ((OnDidFinishLoadMessage)object).getValidatedURL());
        webView.e.onFinishLoadingFrame(webView.getLoadListeners(), (FinishLoadingEvent)object);
    }

    static /* synthetic */ void a(WebView webView, OnDidFailProvisionalLoadMessage object) {
        object = new FailLoadingEvent(webView, ((OnDidFailProvisionalLoadMessage)object).getFrameId(), ((OnDidFailProvisionalLoadMessage)object).isMainFrame(), ((OnDidFailProvisionalLoadMessage)object).getValidatedURL(), ((OnDidFailProvisionalLoadMessage)object).getErrorCode(), ((OnDidFailProvisionalLoadMessage)object).getErrorDescription());
        webView.e.onFailLoadingFrame(webView.getLoadListeners(), (FailLoadingEvent)object);
    }

    static /* synthetic */ void a(WebView webView, OnDidFailLoadMessage object) {
        object = new FailLoadingEvent(webView, ((OnDidFailLoadMessage)object).getFrameId(), ((OnDidFailLoadMessage)object).isMainFrame(), ((OnDidFailLoadMessage)object).getValidatedURL(), ((OnDidFailLoadMessage)object).getErrorCode(), ((OnDidFailLoadMessage)object).getErrorDescription());
        webView.e.onFailLoadingFrame(webView.getLoadListeners(), (FailLoadingEvent)object);
    }

    static /* synthetic */ void a(WebView webView, OnDocumentAvailableInMainFrameMessage onDocumentAvailableInMainFrameMessage) {
        webView.e.onDocumentLoadedInMainFrame(webView.getLoadListeners(), new LoadEvent(webView));
    }

    static /* synthetic */ void a(WebView webView, OnDocumentLoadedInFrameMessage onDocumentLoadedInFrameMessage) {
        webView.e.onDocumentLoadedInFrame(webView.getLoadListeners(), new FrameLoadEvent(webView, onDocumentLoadedInFrameMessage.getFrameId()));
    }

    static /* synthetic */ void a(WebView webView, OnTitleChangeMessage onTitleChangeMessage) {
        webView.e.onTitleChange(webView.getTitleListeners(), new TitleEvent(webView, onTitleChangeMessage.getTitle()));
    }

    static /* synthetic */ void a(WebView webView, OnTooltipChangeMessage object) {
        object = ((OnTooltipChangeMessage)object).getTooltipText();
        SwingUtilities.invokeLater(new o(webView, (String)object));
    }

    static /* synthetic */ void a(WebView webView, OnShouldCreateWebContentsMessage onShouldCreateWebContentsMessage) {
        Object object = onShouldCreateWebContentsMessage.getFrameName();
        String string = onShouldCreateWebContentsMessage.getTargetURL();
        if (webView.t != null) {
            object = new PopupParams(webView, (String)object, string);
            webView.u = webView.t.handlePopup((PopupParams)object);
            onShouldCreateWebContentsMessage.setShouldCreate(webView.u != null);
        }
        webView.a(onShouldCreateWebContentsMessage);
    }

    static /* synthetic */ void a(WebView webView, OnAddNewContentsMessage onAddNewContentsMessage) {
        try {
            Object object;
            int n2 = onAddNewContentsMessage.getChannelId();
            Object object2 = webView.b.getWidget().getIPC();
            if (!((IPC)object2).hasChannel(n2, ChannelType.Browser)) {
                ((IPC)object2).waitChannel(n2, ChannelType.Browser);
            }
            if ((object = ((IPC)object2).getChannel(n2, ChannelType.Browser)) == null) {
                return;
            }
            object = WebViewManager.INSTANCE.create((Channel)object, webView.getContext());
            object2 = onAddNewContentsMessage.getInitialBounds();
            if (webView.u != null) {
                webView.u.insertBrowser((Browser)object, (Rectangle)object2);
                webView.u = null;
            }
            return;
        }
        finally {
            webView.a(onAddNewContentsMessage);
        }
    }

    static /* synthetic */ void a(WebView webView, OnShowContextMenuMessage object) {
        if (webView.v != null) {
            MediaType mediaType = MediaType.valueOf(((OnShowContextMenuMessage)object).getMediaType());
            object = new ContextMenuParams(webView, mediaType, ((OnShowContextMenuMessage)object).getX(), ((OnShowContextMenuMessage)object).getY(), ((OnShowContextMenuMessage)object).getLinkURL(), ((OnShowContextMenuMessage)object).getLinkText(), ((OnShowContextMenuMessage)object).getSrcURL(), ((OnShowContextMenuMessage)object).isImageBlocked(), ((OnShowContextMenuMessage)object).getPageURL(), ((OnShowContextMenuMessage)object).getFrameURL(), ((OnShowContextMenuMessage)object).getFrameId(), ((OnShowContextMenuMessage)object).getSelectionText(), ((OnShowContextMenuMessage)object).getMisspelledWord(), ((OnShowContextMenuMessage)object).getFrameCharset());
            webView.e.invokeLater(new n(webView, (ContextMenuParams)object));
        }
    }

    static /* synthetic */ void a(WebView webView, OnBeforeDownloadMessage onBeforeDownloadMessage) {
        onBeforeDownloadMessage = webView.p.handle(webView, onBeforeDownloadMessage);
        webView.a(onBeforeDownloadMessage);
    }

    static /* synthetic */ void a(WebView webView, OnRunJavaScriptDialogMessage onRunJavaScriptDialogMessage) {
        webView.o.handle(webView, webView.e, onRunJavaScriptDialogMessage, (Callback<Message>)new m(webView));
    }

    static /* synthetic */ void a(WebView webView, OnWindowCloseMessage onWindowCloseMessage) {
        webView.e.invokeLater(new q(webView));
    }

    static /* synthetic */ void a(WebView webView, OnRunFileChooserMessage onRunFileChooserMessage) {
        webView.o.handle(webView, webView.e, onRunFileChooserMessage, (Callback<Message>)new p(webView));
    }

    static /* synthetic */ void a(WebView webView, OnConsoleMessage onConsoleMessage) {
        webView.e.onConsoleMessage(webView.getConsoleListeners(), new ConsoleEvent(webView, ConsoleEvent.Level.valueOf(onConsoleMessage.getLevel()), onConsoleMessage.getLineNumber(), onConsoleMessage.getMessage(), onConsoleMessage.getSourceId()));
    }

    static /* synthetic */ void a(WebView webView, OnStatusChangeMessage onStatusChangeMessage) {
        webView.e.onStatusChangeMessage(webView.getStatusListeners(), new StatusEvent(webView, onStatusChangeMessage.getURL()));
    }

    static /* synthetic */ void a(WebView webView, OnCacheClearMessage onCacheClearMessage) {
        webView.g.handleMessage(onCacheClearMessage, webView.e);
    }

    static /* synthetic */ void a(WebView webView, OnSelectClientCertificateMessage onSelectClientCertificateMessage) {
        webView.o.handle(webView, webView.e, onSelectClientCertificateMessage, (Callback<Message>)new s(webView));
    }

    static /* synthetic */ void a(WebView webView, OnAllowCertificateErrorMessage onAllowCertificateErrorMessage) {
        int n2 = onAllowCertificateErrorMessage.getCallbackID();
        LoadHandler loadHandler = webView.getLoadHandler();
        if (loadHandler == null) {
            webView.a(new AllowCertificateErrorMessage(MessageUIDGenerator.generate(), n2, true));
            return;
        }
        webView.e.invokeLater(new r(webView, onAllowCertificateErrorMessage, loadHandler, n2));
    }

    static /* synthetic */ void a(WebView object, OnSearchCompleteMessage onSearchCompleteMessage) {
        int n2 = onSearchCompleteMessage.getRequestId();
        object = ((WebView)object).r.remove(n2);
        if (object != null) {
            n2 = onSearchCompleteMessage.getCurrentMatch();
            int n3 = onSearchCompleteMessage.getNumberOfMatches();
            SearchResult searchResult = new SearchResult(n2, n3);
            object.searchComplete(searchResult);
        }
    }

    static /* synthetic */ void a(WebView webView, OnFormRepostWarningShowMessage onFormRepostWarningShowMessage) {
        webView.o.handleReloadPostData(webView, webView.e, new v(webView));
    }

    static /* synthetic */ void a(WebView webView, OnGetParentForWindowlessPluginMessage onGetParentForWindowlessPluginMessage) {
        Object object = SwingUtilities.windowForComponent(webView.getView().getComponent());
        if (object != null && (object = object.getPeer()) != null) {
            try {
                Method method = object.getClass().getMethod("getHWnd", new Class[0]);
                object = method.invoke(object, new Object[0]);
                if (object instanceof Long) {
                    onGetParentForWindowlessPluginMessage.setHandle((Long)object);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }
        webView.a(onGetParentForWindowlessPluginMessage);
    }

    static /* synthetic */ void a(WebView webView, OnRequestPluginStateMessage onRequestPluginStateMessage) {
        webView.f.handleMessage(onRequestPluginStateMessage);
    }

    static /* synthetic */ void a(WebView webView, OnRequestPrintSettingsMessage onRequestPrintSettingsMessage) {
        webView.n.handle(webView.e, onRequestPrintSettingsMessage, new u(webView));
    }

    static /* synthetic */ void a(WebView webView, OnPrintingDoneMessage onPrintingDoneMessage) {
        webView.n.handle(webView.e, onPrintingDoneMessage, webView);
    }

    static /* synthetic */ void a(WebView webView, Message message) {
        webView.a(message);
    }

    static /* synthetic */ Logger a() {
        return a;
    }

    static /* synthetic */ ContextMenuHandler a(WebView webView) {
        return webView.v;
    }

    static /* synthetic */ WidgetView b(WebView webView) {
        return webView.b;
    }

    static {
        com.teamdev.jxbrowser.chromium.internal.d.a().b();
        a = LoggerProvider.getBrowserLogger();
    }
}

