/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.BrowserContext;
import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.ProxyConfig;
import com.teamdev.jxbrowser.chromium.internal.ChromiumExtractor;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.FileUtil;
import com.teamdev.jxbrowser.chromium.internal.MacShortcutSupport;
import com.teamdev.jxbrowser.chromium.internal.NetworkDelegateImpl;
import com.teamdev.jxbrowser.chromium.internal.ProxyParams;
import com.teamdev.jxbrowser.chromium.internal.RenderProcess;
import com.teamdev.jxbrowser.chromium.internal.RenderProcessRegistrar;
import com.teamdev.jxbrowser.chromium.internal.WebView;
import com.teamdev.jxbrowser.chromium.internal.Widget;
import com.teamdev.jxbrowser.chromium.internal.WidgetView;
import com.teamdev.jxbrowser.chromium.internal.ZoomListenerImpl;
import com.teamdev.jxbrowser.chromium.internal.aq;
import com.teamdev.jxbrowser.chromium.internal.ar;
import com.teamdev.jxbrowser.chromium.internal.as;
import com.teamdev.jxbrowser.chromium.internal.d;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelType;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPCException;
import com.teamdev.jxbrowser.chromium.internal.ipc.LatchUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CreateBrowserMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis.
 */
public final class WebViewManager
extends Enum<WebViewManager> {
    private static final Logger a;
    private final IPC b;
    private final List<WebView> c;
    private final RenderProcessRegistrar d;

    private WebViewManager() {
        com.teamdev.jxbrowser.chromium.internal.d.a().b();
        Environment.traceEnvironment();
        Environment.checkEnvironment();
        string = BrowserPreferences.getChromiumDir();
        ChromiumExtractor chromiumExtractor = ChromiumExtractor.create();
        if (chromiumExtractor.shouldExtract(string)) {
            chromiumExtractor.extract(string);
        }
        this.b = IPC.create();
        this.c = new ArrayList<WebView>();
        this.d = new RenderProcessRegistrar();
        this.b.addIPCListener(new aq(this));
        Runtime.getRuntime().addShutdownHook(new Thread(new ar(this)));
    }

    public final IPC getIPC() {
        return this.b;
    }

    public final synchronized RenderProcess getRenderProcess(WebView webView) {
        long l2 = webView.getChannel().getBrowserId();
        return this.d.getRenderProcess(l2);
    }

    public final synchronized WebView getWebView(RenderProcess object2) {
        long l2 = ((RenderProcess)object2).getChannel().getBrowserId();
        for (WebView webView : ((WebViewManager)((Object)this)).getWebViews()) {
            if (webView.getChannel().getBrowserId() != l2) continue;
            return webView;
        }
        return null;
    }

    public final synchronized List<WebView> getWebViews() {
        return new ArrayList<WebView>(this.c);
    }

    public final synchronized void addWebView(WebView webView) {
        if (!this.c.contains(webView)) {
            this.c.add(webView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeWebView(WebView webView) {
        WebViewManager webViewManager = this;
        synchronized (webViewManager) {
            this.c.remove(webView);
        }
        if (this.c.isEmpty()) {
            this.b.stop();
        }
    }

    public final synchronized WebView create(Channel object, BrowserContext object2) {
        object = new Widget((Channel)object, this.b);
        object = new WidgetView((Widget)object);
        object2 = new WebView((WidgetView)object, (BrowserContext)object2);
        ((WebView)object2).initializeDefaultHandlers();
        if (Environment.isMac()) {
            ((WidgetView)object).setMacShortcutSupport(new MacShortcutSupport((WebView)object2));
        }
        this.addWebView((WebView)object2);
        return object2;
    }

    public final synchronized WebView create(BrowserContext browserContext, int n2, ProxyConfig proxyConfig, NetworkDelegateImpl networkDelegateImpl, ZoomListenerImpl zoomListenerImpl) {
        String string;
        String string2;
        String string3 = string2 = browserContext.getDataDir();
        String string4 = string2 != null && !string3.isEmpty() ? string3 + File.separator + "Cache" : "";
        string3 = string2;
        if (Environment.isWindows()) {
            string = "";
        } else {
            String string5 = BrowserPreferences.getDefaultChromiumDir() + File.separator + "Memory";
            if (string3 != null && !string3.isEmpty()) {
                string5 = string3 + File.separator + "Memory";
            }
            string = string5;
        }
        string3 = string;
        Channel channel = this.a(string2, string4, string3, browserContext.getAcceptLanguage(), proxyConfig, n2);
        networkDelegateImpl.initialize(this.b.getMainChannel());
        zoomListenerImpl.initialize(this.b.getMainChannel());
        return this.create(channel, browserContext);
    }

    private Channel a(String object, String string, String string2, String string3, ProxyConfig object2, int n2) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("The dataDir parameter cannot be null or empty");
        }
        if (string3 == null || string3.isEmpty()) {
            throw new IllegalArgumentException("The locale parameter cannot be null or empty");
        }
        if (string == null) {
            throw new IllegalArgumentException("The cacheDir parameter cannot be null");
        }
        if (Environment.isMac() && (string2 == null || string2.isEmpty())) {
            throw new IllegalArgumentException("The memoryDir parameter cannot be null or empty");
        }
        object2 = ProxyParams.from((ProxyConfig)object2);
        FileUtil.createDirs((String)object);
        if (!string.isEmpty()) {
            FileUtil.createDirs(string);
        }
        if (!string2.isEmpty()) {
            FileUtil.createDirs(string2);
        }
        int n3 = ChannelIDGenerator.generate();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        as as2 = new as(this, n3, countDownLatch);
        this.b.start();
        this.b.addIPCListener(as2);
        this.b.send(new CreateBrowserMessage(MessageUIDGenerator.generate(), n3, n2, string, string2, (String)object, string3, ((ProxyParams)object2).getProxyType(), ((ProxyParams)object2).getProxyRules(), ((ProxyParams)object2).getProxyBypassRules(), ((ProxyParams)object2).getProxyAutoConfigURL()));
        try {
            LatchUtil.await(countDownLatch, new IPCException("Failed to get Browser channel " + n3));
        }
        finally {
            this.b.removeIPCListener(as2);
        }
        object = this.b.getChannel(n3, ChannelType.Browser);
        if (object == null) {
            throw new IPCException("Failed to get Browser channel " + n3);
        }
        return object;
    }

    static /* synthetic */ RenderProcessRegistrar a(WebViewManager webViewManager) {
        return webViewManager.d;
    }

    static /* synthetic */ Logger a() {
        return a;
    }

    static /* synthetic */ IPC b(WebViewManager webViewManager) {
        return webViewManager.b;
    }

    static {
        a = LoggerProvider.getBrowserLogger();
    }
}

