/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.KeyCodes;
import com.teamdev.jxbrowser.chromium.internal.KeyCodesFactory;
import com.teamdev.jxbrowser.chromium.internal.MouseDragEventConverter;
import com.teamdev.jxbrowser.chromium.internal.SharedMemoryLibrary;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.FocusMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ForwardKeyboardMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ForwardMouseMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ForwardMouseWheelMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetBoundsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.UnfocusMessage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class Widget {
    private static final Logger a = LoggerProvider.getIPCLogger();
    private final IPC b;
    private final Channel c;
    private final KeyCodes d;
    private final MouseDragEventConverter e;
    private int f;

    public Widget(Channel channel, IPC iPC) {
        this.c = channel;
        this.b = iPC;
        this.d = KeyCodesFactory.create();
        this.e = new MouseDragEventConverter();
    }

    public IPC getIPC() {
        return this.b;
    }

    public Channel getChannel() {
        return this.c;
    }

    public void forwardMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        this.a(mouseWheelEvent, 33);
    }

    private void a(MouseWheelEvent mouseWheelEvent, int n2) {
        Serializable serializable = mouseWheelEvent.getComponent();
        serializable = serializable.getLocationOnScreen();
        int n3 = ((Point)serializable).x;
        int n4 = ((Point)serializable).y;
        int n5 = mouseWheelEvent.getX();
        int n6 = mouseWheelEvent.getY();
        int n7 = mouseWheelEvent.getX();
        int n8 = mouseWheelEvent.getY();
        int n9 = -mouseWheelEvent.getUnitsToScroll();
        int n10 = -mouseWheelEvent.getWheelRotation();
        int n11 = mouseWheelEvent.getScrollType();
        long l2 = mouseWheelEvent.getWhen();
        int n12 = mouseWheelEvent.getModifiersEx();
        boolean bl = mouseWheelEvent.isShiftDown();
        this.c.send(new ForwardMouseWheelMessage(MessageUIDGenerator.generate(), n5, n6, n7, n8, n3, n4, n11, n10, n9, l2, n12, bl, n2));
    }

    public void forwardTouchMoveEvent(MouseEvent iterator) {
        iterator = this.e.getMouseWheelEvents((MouseEvent)((Object)iterator));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            MouseWheelEvent mouseWheelEvent = iterator.next();
            this.a(mouseWheelEvent, 1);
        }
    }

    public void forwardMouseEvent(MouseEvent mouseEvent) {
        boolean bl;
        if (mouseEvent.getID() == 506 && Environment.isWindows() && !(bl = SharedMemoryLibrary.getInstance().isCursorVisible())) {
            this.forwardTouchMoveEvent(mouseEvent);
            return;
        }
        this.e.reset();
        Serializable serializable = mouseEvent.getComponent();
        serializable = serializable.isShowing() ? serializable.getLocationOnScreen() : new Point();
        int n2 = mouseEvent.getID();
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        int n5 = ((Point)serializable).x + n3;
        int n6 = ((Point)serializable).y + n4;
        MouseEvent mouseEvent2 = mouseEvent;
        int n7 = SwingUtilities.isLeftMouseButton(mouseEvent2) ? 1 : (SwingUtilities.isMiddleMouseButton(mouseEvent2) ? 2 : (SwingUtilities.isRightMouseButton(mouseEvent2) ? 3 : 0));
        int n8 = mouseEvent.getClickCount();
        long l2 = mouseEvent.getWhen();
        int n9 = mouseEvent.getModifiersEx();
        this.c.send(new ForwardMouseMessage(MessageUIDGenerator.generate(), n2, n3, n4, n5, n6, n3, n4, n7, n8, l2, n9));
    }

    public void forwardKeyPressedEvent(KeyEvent keyEvent) {
        this.f = Environment.isWindows() ? Widget.a(keyEvent) : keyEvent.getKeyCode();
        this.a(keyEvent, 401, keyEvent.getWhen());
    }

    public void forwardKeyTypedEvent(KeyEvent keyEvent) {
        KeyEvent keyEvent2;
        if (Environment.isWindows()) {
            int n2 = this.f != 0 ? this.f : Widget.a(keyEvent);
            keyEvent2 = new KeyEvent(keyEvent.getComponent(), 401, keyEvent.getWhen(), keyEvent.getModifiers(), n2, keyEvent.getKeyChar(), keyEvent.getKeyLocation());
            long l2 = n2;
            KeyEvent keyEvent3 = keyEvent2;
            try {
                Field field = keyEvent3.getClass().getDeclaredField("rawCode");
                field.setAccessible(true);
                field.setLong(keyEvent3, l2);
            }
            catch (IllegalAccessException illegalAccessException) {
                a.log(Level.SEVERE, "Failed to set native key code.", illegalAccessException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                a.log(Level.SEVERE, "Failed to set native key code.", noSuchFieldException);
            }
        } else {
            int n3 = this.f != 0 ? this.f : keyEvent.getKeyCode();
            keyEvent2 = new KeyEvent(keyEvent.getComponent(), 401, keyEvent.getWhen(), keyEvent.getModifiers(), n3, keyEvent.getKeyChar(), keyEvent.getKeyLocation());
        }
        this.a(keyEvent2, 400, keyEvent.getWhen());
    }

    public void forwardKeyReleasedEvent(KeyEvent keyEvent) {
        this.f = 0;
        this.a(keyEvent, 402, keyEvent.getWhen());
    }

    private void a(KeyEvent keyEvent, int n2, long l2) {
        boolean bl;
        boolean bl2;
        char c2 = keyEvent.getKeyChar();
        int n3 = keyEvent.getModifiersEx();
        int n5 = keyEvent.getKeyCode();
        n5 = this.d.toNativeKeyCode(n5);
        if (Environment.isWindows() && (bl2 = Widget.a(keyEvent))) {
            bl = bl2;
        }
        int n52 = keyEvent.getKeyCode();
        bl2 = Environment.isWindows() ? n52 == 13 : n52 == 10;
        ForwardKeyboardMessage forwardKeyboardMessage = new ForwardKeyboardMessage(MessageUIDGenerator.generate(), n2, bl ? 1 : 0, bl2, c2, l2, n3);
        this.c.send(forwardKeyboardMessage);
    }

    private static int a(KeyEvent keyEvent) {
        int n2 = 0;
        try {
            Field field = keyEvent.getClass().getDeclaredField("rawCode");
            field.setAccessible(true);
            n2 = (int)field.getLong(keyEvent);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            a.log(Level.SEVERE, "Failed to get native key code.", noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            a.log(Level.SEVERE, "Failed to get native key code.", illegalAccessException);
        }
        return n2;
    }

    public void setBounds(Rectangle rectangle) {
        if (!this.c.isClosed()) {
            this.c.send(new SetBoundsMessage(MessageUIDGenerator.generate(), rectangle));
        }
    }

    public void focus() {
        if (!this.c.isClosed()) {
            this.c.send(new FocusMessage(MessageUIDGenerator.generate()));
        }
    }

    public void unfocus() {
        if (!this.c.isClosed()) {
            this.c.send(new UnfocusMessage(MessageUIDGenerator.generate()));
        }
    }
}

