/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.BrowserException;
import com.teamdev.jxbrowser.chromium.BrowserView;
import com.teamdev.jxbrowser.chromium.KeyFilter;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.CursorType;
import com.teamdev.jxbrowser.chromium.internal.DragAndDropData;
import com.teamdev.jxbrowser.chromium.internal.DragAndDropSupport;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.MacShortcutSupport;
import com.teamdev.jxbrowser.chromium.internal.MemoryImage;
import com.teamdev.jxbrowser.chromium.internal.MemoryImageListener;
import com.teamdev.jxbrowser.chromium.internal.ReflectionUtil;
import com.teamdev.jxbrowser.chromium.internal.SharedMemory;
import com.teamdev.jxbrowser.chromium.internal.SharedMemoryLibrary;
import com.teamdev.jxbrowser.chromium.internal.Widget;
import com.teamdev.jxbrowser.chromium.internal.i;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.LatchUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCAdapter;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.DragEndedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.DragTargetMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnCursorChangeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnPaintMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRenderViewCreatedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRenderViewGoneMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnStartDraggingMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnTakeFocusMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ScreenChangedMessage;
import com.teamdev.jxbrowser.chromium.internal.j;
import com.teamdev.jxbrowser.chromium.internal.k;
import com.teamdev.jxbrowser.chromium.internal.l;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class WidgetView
extends JComponent
implements BrowserView {
    private static final Logger a = LoggerProvider.getBrowserLogger();
    private final Widget b;
    private final Dimension c;
    private final MemoryImage d;
    private final KeyListener e;
    private final FocusListener f;
    private final b g;
    private final ComponentListener h;
    private final ComponentListener i;
    private final IPCListener j;
    private final DragAndDropSupport k;
    private KeyFilter l;
    private boolean m;
    private MacShortcutSupport n;

    public WidgetView(Widget object) {
        this.b = object;
        this.c = new Dimension();
        this.d = new MemoryImage();
        this.g = new b(this, null);
        this.e = new a(this, null);
        this.h = new h(this, null);
        this.i = new e(this, null);
        this.f = new f(this, null);
        this.k = new DragAndDropSupport(new c(this, null), new d(this, null));
        this.j = new g(this, null);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.setTransferHandler(new l(this));
        object = this;
        ((WidgetView)object).getWidget().getIPC().addIPCListener(((WidgetView)object).j);
        object = this;
        ((WidgetView)object).b.getChannel().addChannelListener(new k((WidgetView)object));
    }

    public void setIgnoreEnterKeyTypedEvent(boolean bl) {
        this.m = bl;
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 503) {
            super.processMouseMotionEvent(mouseEvent);
            this.b.forwardMouseEvent(mouseEvent);
            return;
        }
        if (mouseEvent.getID() == 506 && this.k.isDragStarted()) {
            super.processMouseMotionEvent(mouseEvent);
            if (this.k.isDragGestureRecognized()) {
                this.k.setDragStarted(false);
                this.k.setDragGestureRecognized(false);
                return;
            }
        } else {
            this.b.forwardMouseEvent(mouseEvent);
        }
    }

    public void setMacShortcutSupport(MacShortcutSupport macShortcutSupport) {
        this.n = macShortcutSupport;
    }

    private void b() {
        this.d.setVisible(false);
        this.removeFocusListener(this.f);
        this.removeComponentListener(this.h);
        this.removeKeyListener(this.e);
        this.removeMouseListener(this.g);
        this.removeMouseWheelListener(this.g);
        this.k.unregisterDragGestureHandler();
        this.repaint();
    }

    private void c() {
        if (!this.d.isVisible()) {
            this.addFocusListener(this.f);
            this.addMouseListener(this.g);
            this.addMouseWheelListener(this.g);
            this.addKeyListener(this.e);
            this.addComponentListener(this.h);
            this.d.setVisible(true);
            this.k.registerDragGestureHandler(this);
            this.repaint();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.c();
        if (Environment.isMac()) {
            WidgetView widgetView = this;
            Window window = SwingUtilities.getWindowAncestor(widgetView);
            if (window != null) {
                window.addComponentListener(widgetView.i);
            }
            this.d();
        }
    }

    public void removeNotify() {
        WidgetView widgetView;
        Window window;
        if (Environment.isMac() && (window = SwingUtilities.getWindowAncestor(widgetView = this)) != null) {
            window.removeComponentListener(widgetView.i);
        }
        this.b();
        super.removeNotify();
    }

    public void dispose() {
        this.getWidget().getIPC().removeIPCListener(this.j);
    }

    public JComponent getComponent() {
        return this;
    }

    public Image getImage() {
        return this.d.getImage();
    }

    public void updateSize(int n2, int n3) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("The width parameter cannot be <= 0.");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("The height parameter cannot be <= 0.");
        }
        if (this.c.width == n2 && this.c.height == n3) {
            return;
        }
        this.c.setSize(n2, n3);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Object object = new Dimension(n2, n3);
        object = new com.teamdev.jxbrowser.chromium.internal.g(this, (Dimension)object, countDownLatch);
        this.d.addMemoryImageListener((MemoryImageListener)object);
        this.getWidget().setBounds(new Rectangle(n2, n3));
        try {
            LatchUtil.await(countDownLatch, new BrowserException("Failed to update view bounds."));
            return;
        }
        finally {
            this.d.removeMemoryImageListener((MemoryImageListener)object);
        }
    }

    public Widget getWidget() {
        return this.b;
    }

    public void setKeyFilter(KeyFilter keyFilter) {
        this.l = keyFilter;
    }

    public void setDragAndDropEnabled(boolean bl) {
        this.k.setDragAndDropEnabled(bl);
    }

    public boolean isDragAndDropEnabled() {
        return this.k.isDragAndDropEnabled();
    }

    public double getDeviceScaleFactor() {
        return this.d.getDeviceScaleFactor();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.d.isVisible() && this.d.isInitialized()) {
            int n2 = this.d.getWidth();
            int n3 = this.d.getHeight();
            graphics = (Graphics2D)graphics;
            double d2 = 1.0 / this.d.getDeviceScaleFactor();
            ((Graphics2D)graphics).scale(d2, d2);
            graphics.drawImage(this.d.getImage(), 0, 0, n2, n3, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void d() {
        v0 = SwingUtilities.getWindowAncestor(this);
        var1_1 = v0;
        var1_1 = v0;
        if (v0 == null) ** GOTO lbl-1000
        if (Environment.isJRE7() || Environment.isJRE8()) {
            var1_1 = var1_1.getPeer();
            var1_1 = ReflectionUtil.invokeMethod(var1_1, "getPlatformWindow");
            var1_1 = ReflectionUtil.invokeMethod(var1_1, "getContentView");
            var1_1 = (Long)ReflectionUtil.invokeMethod(var1_1, "getAWTView");
            v1 = var1_1.longValue();
        } else if (Environment.isJRE6()) {
            var1_1 = var1_1.getPeer();
            var1_1 = (Long)ReflectionUtil.invokeMethod(var1_1, "getViewPtr");
            v1 = var1_1.longValue();
        } else lbl-1000:
        // 2 sources

        {
            v1 = 0L;
        }
        var4_3 = v1;
        var1_2 = SharedMemoryLibrary.getInstance().getScreenId(var4_3);
        this.b.getChannel().send(new ScreenChangedMessage(MessageUIDGenerator.generate(), var1_2));
    }

    static /* synthetic */ void a(WidgetView widgetView, OnPaintMessage object) {
        long l2 = ((OnPaintMessage)object).getPid();
        long l3 = ((OnPaintMessage)object).getSharedMemoryHandle();
        int n2 = ((OnPaintMessage)object).getSharedMemoryCapacity();
        int n3 = ((OnPaintMessage)object).getClientWidth();
        int n4 = ((OnPaintMessage)object).getClientHeight();
        int n5 = ((OnPaintMessage)object).getRectX();
        int n6 = ((OnPaintMessage)object).getRectY();
        int n7 = ((OnPaintMessage)object).getRectWidth();
        int n8 = ((OnPaintMessage)object).getRectHeight();
        Rectangle rectangle = new Rectangle(n5, n6, n7, n8);
        Dimension dimension = new Dimension(n3, n4);
        String string = ((OnPaintMessage)object).getMemoryFilePath();
        double d2 = ((OnPaintMessage)object).getDeviceScaleFactor();
        object = new SharedMemory(l2, l3, n2, dimension, string, d2);
        widgetView.d.resetMemory((SharedMemory)object);
        widgetView.d.updatePixels(rectangle);
        SwingUtilities.invokeLater(new com.teamdev.jxbrowser.chromium.internal.h(widgetView));
    }

    static /* synthetic */ void a(WidgetView widgetView, OnCursorChangeMessage onCursorChangeMessage) {
        int n2 = onCursorChangeMessage.getCursorType();
        byte[] byArray = onCursorChangeMessage.getPixels();
        int n3 = onCursorChangeMessage.getWidth();
        int n4 = onCursorChangeMessage.getHeight();
        widgetView.setCursor(CursorType.toJavaCursor(n2, byArray, n3, n4));
    }

    static /* synthetic */ void a(WidgetView widgetView, OnRenderViewGoneMessage onRenderViewGoneMessage) {
        widgetView.b();
    }

    static /* synthetic */ void a(WidgetView widgetView, OnRenderViewCreatedMessage onRenderViewCreatedMessage) {
        widgetView.c();
    }

    static /* synthetic */ void a(OnTakeFocusMessage onTakeFocusMessage) {
        if (onTakeFocusMessage.isReverse()) {
            SwingUtilities.invokeLater(new j());
            return;
        }
        SwingUtilities.invokeLater(new i());
    }

    static /* synthetic */ void a(WidgetView widgetView, OnStartDraggingMessage object) {
        if (!widgetView.k.isDragAndDropEnabled()) {
            widgetView.b.getChannel().send(new DragEndedMessage(MessageUIDGenerator.generate()));
            return;
        }
        object = new DragAndDropData(((OnStartDraggingMessage)object).getURL(), ((OnStartDraggingMessage)object).getURLTitle(), ((OnStartDraggingMessage)object).getText(), ((OnStartDraggingMessage)object).getHTML(), ((OnStartDraggingMessage)object).getHTMLBaseURL());
        widgetView.k.setDragStarted(true);
        widgetView.k.setData((DragAndDropData)object);
        widgetView.k.setDraggingFromWebView(true);
    }

    static /* synthetic */ void a(WidgetView widgetView, Point point, DragAndDropData dragAndDropData) {
        Point point2 = widgetView.getLocationOnScreen();
        int n2 = point.x - point2.x;
        int n3 = point.y - point2.y;
        int n4 = point.x;
        int n5 = point.y;
        DragTargetMessage.WebDragOperation webDragOperation = widgetView.k.getDragOperation();
        widgetView.b.getChannel().send(new DragTargetMessage(MessageUIDGenerator.generate(), DragTargetMessage.Flag.DragTargetDragEnter, n2, n3, n4, n5, webDragOperation, 0, dragAndDropData.getURL(), dragAndDropData.getURLTitle(), dragAndDropData.getText(), dragAndDropData.getHTML(), dragAndDropData.getHTMLBaseURL()));
    }

    static /* synthetic */ void a(WidgetView widgetView, Point point, boolean bl, DragAndDropData dragAndDropData) {
        if (bl) {
            Point point2 = widgetView.getLocationOnScreen();
            int n2 = point.x - point2.x;
            int n3 = point.y - point2.y;
            int n4 = point.x;
            int n5 = point.y;
            DragTargetMessage.WebDragOperation webDragOperation = widgetView.k.getDragOperation();
            widgetView.b.getChannel().send(new DragTargetMessage(MessageUIDGenerator.generate(), DragTargetMessage.Flag.DragTargetDrop, n2, n3, n4, n5, webDragOperation, 0, dragAndDropData.getURL(), dragAndDropData.getURLTitle(), dragAndDropData.getText(), dragAndDropData.getHTML(), dragAndDropData.getHTMLBaseURL()));
        }
        widgetView.b.getChannel().send(new DragEndedMessage(MessageUIDGenerator.generate()));
        widgetView.k.setData(null);
        widgetView.k.setDraggingFromWebView(false);
    }

    static /* synthetic */ void b(WidgetView widgetView, Point point, boolean bl, DragAndDropData dragAndDropData) {
        if (bl) {
            Point point2 = widgetView.getLocationOnScreen();
            int n2 = point.x - point2.x;
            int n3 = point.y - point2.y;
            int n4 = point.x;
            int n5 = point.y;
            DragTargetMessage.WebDragOperation webDragOperation = widgetView.k.getDragOperation();
            widgetView.b.getChannel().send(new DragTargetMessage(MessageUIDGenerator.generate(), DragTargetMessage.Flag.DragTargetDragOver, n2, n3, n4, n5, webDragOperation, 0, dragAndDropData.getURL(), dragAndDropData.getURLTitle(), dragAndDropData.getText(), dragAndDropData.getHTML(), dragAndDropData.getHTMLBaseURL()));
        }
    }

    static /* synthetic */ void a(WidgetView widgetView, boolean bl, DragAndDropData dragAndDropData) {
        if (bl) {
            widgetView.b.getChannel().send(new DragTargetMessage(MessageUIDGenerator.generate(), DragTargetMessage.Flag.DragTargetDragLeave, 0, 0, 0, 0, DragTargetMessage.WebDragOperation.WebDragOperationNone, 0, dragAndDropData.getURL(), dragAndDropData.getURLTitle(), dragAndDropData.getText(), dragAndDropData.getHTML(), dragAndDropData.getHTMLBaseURL()));
        }
    }

    private final class d
    extends DropTargetAdapter {
        private boolean a;
        private /* synthetic */ WidgetView b;

        private d(WidgetView widgetView) {
            this.b = widgetView;
        }

        public final void dragEnter(DropTargetDragEvent serializable) {
            if (!this.b.k.isDragAndDropEnabled()) {
                serializable.rejectDrag();
                return;
            }
            if (!this.b.k.isDraggingFromWebView()) {
                this.a(serializable.getTransferable());
                if (this.b.k.getData() == null) {
                    serializable.rejectDrag();
                    return;
                }
                this.a = true;
                Point point = this.b.getLocationOnScreen();
                serializable = serializable.getLocation();
                serializable = new Point(point.x + ((Point)serializable).x, point.y + ((Point)serializable).y);
                WidgetView.a(this.b, (Point)serializable, this.b.k.getData());
            }
        }

        public final void dragExit(DropTargetEvent dropTargetEvent) {
            if (!this.b.k.isDraggingFromWebView()) {
                WidgetView.a(this.b, this.a, this.b.k.getData());
                this.a = false;
            }
        }

        public final void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (!this.b.k.isDraggingFromWebView()) {
                Point point = this.b.getLocationOnScreen();
                Point point2 = dropTargetDropEvent.getLocation();
                point = new Point(point.x + point2.x, point.y + point2.y);
                if (Environment.isMac()) {
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    this.a(dropTargetDropEvent.getTransferable());
                    WidgetView.a(this.b, point, this.b.k.getData());
                }
                WidgetView.a(this.b, point, this.a, this.b.k.getData());
                dropTargetDropEvent.dropComplete(true);
                this.a = false;
            }
        }

        public final void dragOver(DropTargetDragEvent serializable) {
            if (!this.b.k.isDraggingFromWebView()) {
                Point point = this.b.getLocationOnScreen();
                serializable = serializable.getLocation();
                serializable = new Point(point.x + ((Point)serializable).x, point.y + ((Point)serializable).y);
                WidgetView.b(this.b, (Point)serializable, this.a, this.b.k.getData());
            }
        }

        private void a(Transferable transferable) {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            DataFlavor[] dataFlavorArray2 = dataFlavorArray;
            dataFlavorArray2 = dataFlavorArray;
            int n2 = dataFlavorArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = dataFlavorArray2[i2];
                try {
                    if ("application/x-java-url; class=java.net.URL".equals(((DataFlavor)object).getMimeType())) {
                        object = (URL)transferable.getTransferData((DataFlavor)object);
                        this.b.k.setData(DragAndDropData.create((URL)object));
                        continue;
                    }
                    if (!((DataFlavor)object).getMimeType().contains("text/plain; class=java.lang.String")) continue;
                    object = (String)transferable.getTransferData((DataFlavor)object);
                    this.b.k.setData(DragAndDropData.create((String)object));
                    continue;
                }
                catch (Exception exception) {
                    a.log(Level.WARNING, "Failed to read drop data.", exception.getMessage());
                }
            }
        }

        /* synthetic */ d(WidgetView widgetView, l l2) {
            this(widgetView);
        }
    }

    private final class c
    extends DragSourceAdapter {
        private boolean a;
        private /* synthetic */ WidgetView b;

        private c(WidgetView widgetView) {
            this.b = widgetView;
        }

        public final void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            this.a = true;
            WidgetView.a(this.b, dragSourceDragEvent.getLocation(), this.b.k.getData());
        }

        public final void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            WidgetView.a(this.b, dragSourceDropEvent.getLocation(), this.a, this.b.k.getData());
            this.a = false;
        }

        public final void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            WidgetView.b(this.b, dragSourceDragEvent.getLocation(), this.a, this.b.k.getData());
        }

        public final void dragExit(DragSourceEvent dragSourceEvent) {
            WidgetView.a(this.b, this.a, this.b.k.getData());
            this.a = false;
        }

        /* synthetic */ c(WidgetView widgetView, l l2) {
            this(widgetView);
        }
    }

    private final class g
    extends IPCAdapter {
        private /* synthetic */ WidgetView a;

        private g(WidgetView widgetView) {
            this.a = widgetView;
        }

        public final void onChannelRemoved(Channel channel) {
            boolean bl;
            Channel channel2 = this.a.getWidget().getChannel();
            boolean bl2 = channel.getChannelId() == channel2.getChannelId();
            boolean bl3 = bl = channel.getType() == channel2.getType();
            if (bl2 && bl) {
                this.a.b();
            }
        }

        /* synthetic */ g(WidgetView widgetView, l l2) {
            this(widgetView);
        }
    }

    private final class f
    extends FocusAdapter {
        private /* synthetic */ WidgetView a;

        private f(WidgetView widgetView) {
            this.a = widgetView;
        }

        public final void focusGained(FocusEvent focusEvent) {
            this.a.b.focus();
        }

        public final void focusLost(FocusEvent focusEvent) {
            this.a.b.unfocus();
        }

        /* synthetic */ f(WidgetView widgetView, l l2) {
            this(widgetView);
        }
    }

    private final class h
    extends ComponentAdapter {
        private /* synthetic */ WidgetView a;

        private h(WidgetView widgetView) {
            this.a = widgetView;
        }

        public final void componentResized(ComponentEvent serializable) {
            serializable = serializable.getComponent();
            serializable = ((Component)serializable).getBounds();
            this.a.b.setBounds((Rectangle)serializable);
        }

        /* synthetic */ h(WidgetView widgetView, l l2) {
            this(widgetView);
        }
    }

    private final class a
    extends KeyAdapter {
        private /* synthetic */ WidgetView a;

        private a(WidgetView widgetView) {
            this.a = widgetView;
        }

        public final void keyPressed(KeyEvent keyEvent) {
            if (this.a(keyEvent)) {
                this.a.b.forwardKeyPressedEvent(keyEvent);
            }
            if (this.a.n != null) {
                this.a.n.handleKeyPress(keyEvent);
            }
        }

        public final void keyTyped(KeyEvent keyEvent) {
            if (this.a(keyEvent)) {
                this.a.b.forwardKeyTypedEvent(keyEvent);
            }
        }

        public final void keyReleased(KeyEvent keyEvent) {
            if (this.a(keyEvent)) {
                this.a.b.forwardKeyReleasedEvent(keyEvent);
            }
        }

        private boolean a(KeyEvent keyEvent) {
            boolean bl = keyEvent.getKeyChar() == '\n';
            boolean bl2 = keyEvent.getID() == 400;
            if (bl2 && bl && this.a.m) {
                return false;
            }
            return this.a.l == null || !this.a.l.filter(keyEvent);
        }

        /* synthetic */ a(WidgetView widgetView, l l2) {
            this(widgetView);
        }
    }

    private final class b
    extends MouseAdapter {
        private /* synthetic */ WidgetView a;

        private b(WidgetView widgetView) {
            this.a = widgetView;
        }

        public final void mousePressed(MouseEvent mouseEvent) {
            this.a.b.forwardMouseEvent(mouseEvent);
            this.a.requestFocus();
        }

        public final void mouseReleased(MouseEvent mouseEvent) {
            this.a.b.forwardMouseEvent(mouseEvent);
        }

        public final void mouseEntered(MouseEvent mouseEvent) {
            this.a.b.forwardMouseEvent(mouseEvent);
        }

        public final void mouseExited(MouseEvent mouseEvent) {
            this.a.b.forwardMouseEvent(mouseEvent);
        }

        public final void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.a.b.forwardMouseWheelEvent(mouseWheelEvent);
            mouseWheelEvent.consume();
        }

        /* synthetic */ b(WidgetView widgetView, l l2) {
            this(widgetView);
        }
    }

    private final class e
    extends ComponentAdapter {
        private /* synthetic */ WidgetView a;

        private e(WidgetView widgetView) {
            this.a = widgetView;
        }

        public final void componentMoved(ComponentEvent componentEvent) {
            this.a.d();
        }

        /* synthetic */ e(WidgetView widgetView, l l2) {
            this(widgetView);
        }
    }
}

