/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.FileUtil;
import com.teamdev.jxbrowser.chromium.internal.SharedMemoryLibrary;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChromiumProcessLogger;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChromiumProcessListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChromiumProcess {
    private static final Logger a = LoggerProvider.getChromiumProcessLogger();
    private Process b;
    private final File c;
    private final List d;

    public ChromiumProcess(String s2) {
        String name;
        if (Environment.isWindows()) {
            name = "jxbrowser-chromium.exe";
        } else if (Environment.isMac()) {
            name = "jxbrowser.app/Contents/MacOS/jxbrowser";
        } else if (Environment.isLinux()) {
            name = "jxbrowser-chromium";
        } else {
            throw new RuntimeException("Unsupported operating system.");
        }
        this.c = new File(s2, name);
        if (!this.c.exists()) {
            throw new IllegalArgumentException("File doesn't exist: " + this.c);
        }
        if (!this.c.isFile()) {
            throw new IllegalArgumentException("File isn't a normal file: " + this.c);
        }
        this.d = new ArrayList();
    }

    public void addChromiumProcessListener(ChromiumProcessListener chromiumprocesslistener) {
        if (!this.d.contains(chromiumprocesslistener)) {
            this.d.add(chromiumprocesslistener);
        }
    }

    public void removeChromiumProcessListener(ChromiumProcessListener chromiumprocesslistener) {
        this.d.remove(chromiumprocesslistener);
    }

    public List getChromiumProcessListeners() {
        return new ArrayList(this.d);
    }

    public int start(int i2) {
        ProcessBuilder processbuilder;
        a.info("Start Chromium process...");
        String s2 = this.c.getParentFile().getAbsolutePath();
        LinkedHashSet<String> linkedhashset = new LinkedHashSet<String>();
        linkedhashset.add(this.c.getAbsolutePath());
        linkedhashset.add(String.valueOf(i2));
        linkedhashset.add(String.valueOf(SharedMemoryLibrary.getInstance().getCurrentProcessId()));
        String userAgent = BrowserPreferences.getUserAgent();
        if (userAgent != null && !userAgent.isEmpty()) {
            linkedhashset.add("--user-agent=" + userAgent);
        }
        linkedhashset.addAll(BrowserPreferences.getChromiumSwitches());
        ArrayList<String> command = new ArrayList<String>(linkedhashset);
        ProcessBuilder processbuilder1 = processbuilder = new ProcessBuilder(command);
        if (Environment.isLinux()) {
            Map<String, String> map = processbuilder1.environment();
            String obj = s2;
            if (map.containsKey("LD_LIBRARY_PATH")) {
                obj = obj + ':' + map.get("LD_LIBRARY_PATH");
            }
            map.put("LD_LIBRARY_PATH", obj);
        }
        Map<String, String> environment = processbuilder.environment();
        a.info("reset CFProcessPath from value:" + environment.get("CFProcessPath"));
        environment.remove("CFProcessPath");
        processbuilder.directory(new File(s2));
        processbuilder.redirectErrorStream(true);
        ChromiumProcess.a(s2);
        try {
            StringBuilder stringbuilder = new StringBuilder();
            for (String s1 : command) {
                stringbuilder.append(s1);
                stringbuilder.append(' ');
            }
            a.info("Command line: " + stringbuilder);
            this.b = processbuilder.start();
            new ChromiumProcessLogger().startLogging(this.b);
            int k2 = this.b.waitFor();
            this.b = null;
            a.info("Chromium process exit code " + k2);
            Iterator iterator = this.getChromiumProcessListeners().iterator();
            while (iterator.hasNext()) {
                ((ChromiumProcessListener)iterator.next()).onExit(k2);
            }
            return k2;
        }
        catch (InterruptedException interruptedexception) {
            throw new RuntimeException(interruptedexception);
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void a(String s2) {
        if (Environment.isLinux()) {
            String[] stringArray;
            String libPath = Environment.is64Bit() ? "/lib/x86_64-linux-gnu" : "/lib/i386-linux-gnu";
            File libFile = new File(libPath + "/libudev.so.0");
            a.info("The '" + libFile.getAbsolutePath() + "' library exists: " + (libFile.exists() ? "TRUE" : "FALSE"));
            if (libFile.exists()) {
                return;
            }
            libFile = new File(s2 + "/libudev.so.0");
            a.info("The '" + libFile.getAbsolutePath() + "' library exists: " + (libFile.exists() ? "TRUE" : "FALSE"));
            if (libFile.exists()) {
                return;
            }
            if (Environment.is64Bit()) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "/lib/x86_64-linux-gnu";
                stringArray2[1] = "/lib64";
                stringArray = stringArray2;
                stringArray2[2] = "/usr/lib64";
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "/lib/i386-linux-gnu";
                stringArray3[1] = "/lib";
                stringArray = stringArray3;
                stringArray3[2] = "/usr/lib";
            }
            String[] as2 = stringArray;
            File obj1 = null;
            int i2 = as2.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                a.info("Looking for libudev.so.x.x.x in '" + as2[j2] + "'...");
                obj1 = FileUtil.findByTemplate(as2[j2], "libudev.so.");
                if (obj1 == null) continue;
                a.info("Found the '" + obj1.getAbsolutePath() + "' library");
                s2 = "/bin/ln -s " + obj1.getAbsolutePath() + ' ' + s2 + "/libudev.so.0";
                a.info("Create symlink: " + s2);
                try {
                    Runtime.getRuntime().exec(s2);
                }
                catch (IOException ioexception) {
                    a.log(Level.SEVERE, "Failed to execute the '" + s2 + "' command.", ioexception);
                }
                break;
            }
            if (obj1 == null) {
                a.info("Failed to find libudev.so.x.x.x");
            }
        }
    }

    public boolean isStarted() {
        return this.b != null;
    }
}

