/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelType;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChromiumProcess;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPCException;
import com.teamdev.jxbrowser.chromium.internal.ipc.LatchUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.Sender;
import com.teamdev.jxbrowser.chromium.internal.ipc.Server;
import com.teamdev.jxbrowser.chromium.internal.ipc.SocketUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ServerAdapter;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ServerListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.h;
import com.teamdev.jxbrowser.chromium.internal.ipc.i;
import com.teamdev.jxbrowser.chromium.internal.ipc.j;
import com.teamdev.jxbrowser.chromium.internal.ipc.k;
import com.teamdev.jxbrowser.chromium.internal.ipc.l;
import com.teamdev.jxbrowser.chromium.internal.ipc.m;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ShutdownMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPC
implements Sender {
    private static final Logger a = LoggerProvider.getIPCLogger();
    private Channel b;
    private final Server c;
    private final ChromiumProcess d;
    private final List<Channel> e;
    private final List<IPCListener> f;
    private final ServerListener g;

    public static IPC create() {
        Object object = new Server();
        String string = BrowserPreferences.getChromiumDir();
        object = new IPC((Server)object, new ChromiumProcess(string));
        return object;
    }

    public IPC(Server server, ChromiumProcess chromiumProcess) {
        this.c = server;
        this.d = chromiumProcess;
        this.g = new a(this, null);
        this.e = new ArrayList<Channel>();
        this.f = new ArrayList<IPCListener>();
    }

    public Channel getMainChannel() {
        return this.b;
    }

    public boolean isStarted() {
        return this.c.isStarted();
    }

    public void start() {
        a.info("Starting IPC...");
        if (this.c.isStarted()) {
            a.info("IPC is already started.");
            if (!this.d.isStarted()) {
                a.info("Chromium process is dead. Restarting IPC...");
                this.b = this.a(false);
                return;
            }
            return;
        }
        this.b = this.a(true);
        this.c.addServerListener(this.g);
        a.info("IPC is started.");
    }

    private Channel a(boolean bl) {
        Object object;
        Object object2;
        AtomicReference atomicReference = new AtomicReference();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicReference<IPCException> atomicReference2 = new AtomicReference<IPCException>();
        m m2 = new m(this, atomicReference, countDownLatch);
        this.c.addServerListener(m2);
        if (bl) {
            int n2;
            int n3 = n2 = SocketUtil.getNextAvailablePort(1100);
            AtomicReference<IPCException> atomicReference3 = atomicReference2;
            object2 = countDownLatch;
            object = this;
            a.info("Starting IPC Server...");
            CountDownLatch countDownLatch2 = new CountDownLatch(1);
            object = new Thread(new l((IPC)object, countDownLatch2, n3, atomicReference3, (CountDownLatch)object2));
            ((Thread)object).setName("IPC Server Thread");
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
            LatchUtil.await(countDownLatch2, new RuntimeException(new TimeoutException()), 15);
            this.a(countDownLatch, atomicReference2, n2);
        } else {
            this.a(countDownLatch, atomicReference2, this.c.getPort());
        }
        try {
            LatchUtil.await(countDownLatch, new IPCException("Failed to initialize IPC. Remote process doesn't respond."));
        }
        finally {
            this.c.removeServerListener(m2);
        }
        object = atomicReference2;
        object2 = ((AtomicReference)object).get();
        if (object2 != null) {
            throw object2;
        }
        return (Channel)atomicReference.get();
    }

    private void a(CountDownLatch countDownLatch, AtomicReference<IPCException> atomicReference, int n2) {
        a.info("Starting IPC Process...");
        Thread thread = new Thread(new k((IPC)((Object)thread), n2, atomicReference, countDownLatch));
        thread.setName("IPC Process Thread");
        thread.setDaemon(true);
        thread.start();
    }

    public void shutdown() {
        a.info("Shutdown IPC...");
        if (this.c.isStarted()) {
            this.b();
            this.c.removeServerListener(this.g);
            this.c.stop();
            this.c();
        }
    }

    public void stop() {
        a.info("Stopping IPC...");
        if (!this.c.isStarted()) {
            a.info("IPC is already stopped.");
            return;
        }
        this.b();
        this.c.stop();
        IPC iPC = this;
        while (!iPC.e.isEmpty()) {
            a.info("Waiting for channels disconnection...");
            for (Channel channel : iPC.getChannels()) {
                a.info("\tWaiting for channel: " + channel);
            }
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        this.c.removeServerListener(this.g);
        this.c();
        a.info("IPC is stopped.");
    }

    private void b() {
        if (this.b.isClosed()) {
            return;
        }
        a.info("Stopping main channel...");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        i i2 = new i(this, countDownLatch);
        this.c.addServerListener(i2);
        this.send(new ShutdownMessage(MessageUIDGenerator.generate()));
        try {
            LatchUtil.await(countDownLatch, new IPCException("Failed to execute shutdown post message."));
            return;
        }
        finally {
            this.c.removeServerListener(i2);
        }
    }

    private void c() {
        a.info("Waiting process exit...");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        j j2 = new j(this, countDownLatch);
        this.d.addChromiumProcessListener(j2);
        try {
            if (this.d.isStarted()) {
                LatchUtil.await(countDownLatch, new IPCException("Chromium process hasn't been exited because of timeout."));
            }
            return;
        }
        finally {
            this.d.removeChromiumProcessListener(j2);
        }
    }

    public void addIPCListener(IPCListener iPCListener) {
        if (!this.f.contains(iPCListener)) {
            this.f.add(iPCListener);
        }
    }

    public void removeIPCListener(IPCListener iPCListener) {
        this.f.remove(iPCListener);
    }

    public List<IPCListener> getIPCListeners() {
        return new ArrayList<IPCListener>(this.f);
    }

    public Channel getChannel(long l2, ChannelType channelType) {
        for (Channel channel : ((IPC)this).getChannels()) {
            boolean bl;
            boolean bl2 = channel.getChannelId() == l2;
            boolean bl3 = bl = channel.getType() == channelType;
            if (!bl2 || !bl) continue;
            return channel;
        }
        return null;
    }

    public boolean hasChannel(long l2, ChannelType channelType) {
        for (Channel channel : ((IPC)this).getChannels()) {
            boolean bl;
            boolean bl2 = channel.getChannelId() == l2;
            boolean bl3 = bl = channel.getType() == channelType;
            if (!bl2 || !bl) continue;
            return true;
        }
        return false;
    }

    public void waitChannel(long l2, ChannelType channelType) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        h h2 = new h(this, l2, channelType, countDownLatch);
        this.addIPCListener(h2);
        if (this.hasChannel(l2, channelType)) {
            return;
        }
        try {
            LatchUtil.await(countDownLatch, new IPCException("Failed to get Browser channel " + l2));
            return;
        }
        finally {
            this.removeIPCListener(h2);
        }
    }

    public List<Channel> getChannels() {
        return new ArrayList<Channel>(this.e);
    }

    @Override
    public void send(Message message) {
        if (!this.isStarted()) {
            throw new IllegalStateException("IPC isn't started.");
        }
        this.b.send(message);
    }

    @Override
    public <T extends Message> T post(T t2) {
        if (!this.isStarted()) {
            throw new IllegalStateException("IPC isn't started.");
        }
        return this.b.post(t2);
    }

    static /* synthetic */ ChromiumProcess a(IPC iPC) {
        return iPC.d;
    }

    static /* synthetic */ Server b(IPC iPC) {
        return iPC.c;
    }

    static /* synthetic */ Channel c(IPC iPC) {
        return iPC.b;
    }

    private final class a
    extends ServerAdapter {
        private /* synthetic */ IPC a;

        private a(IPC iPC) {
            this.a = iPC;
        }

        public final void onChannelConnected(Channel channel) {
            if (!((a)this).a.hasChannel(channel.getChannelId(), channel.getType())) {
                ((a)this).a.e.add(channel);
                a.info("Channel is connected: " + channel);
                for (IPCListener iPCListener : ((a)this).a.getIPCListeners()) {
                    iPCListener.onChannelAdded(channel);
                }
            }
        }

        public final void onChannelDisconnected(Channel channel) {
            if (((a)this).a.e.remove(channel)) {
                a.info("Channel is disconnected: " + channel);
                for (IPCListener iPCListener : ((a)this).a.getIPCListeners()) {
                    iPCListener.onChannelRemoved(channel);
                }
            }
        }

        /* synthetic */ a(IPC iPC, m m2) {
            this(iPC);
        }
    }
}

