/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.IPCLogger;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelStream;
import com.teamdev.jxbrowser.chromium.internal.ipc.ServerException;
import com.teamdev.jxbrowser.chromium.internal.ipc.SocketInfo;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessagesBufferIterator;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketChannelReader
implements Runnable {
    private static final IPCLogger a = (IPCLogger)LoggerProvider.getIPCLogger();
    private SocketInfo b;
    private final ChannelStream c;
    private final List<ChannelListener> d;

    public SocketChannelReader(ChannelStream channelStream) {
        this.c = channelStream;
        this.d = new ArrayList<ChannelListener>();
    }

    public void setSocketInfo(SocketInfo socketInfo) {
        this.b = socketInfo;
    }

    public void addChannelListener(ChannelListener channelListener) {
        if (!this.d.contains(channelListener)) {
            this.d.add(channelListener);
        }
    }

    public void removeChannelListener(ChannelListener channelListener) {
        this.d.remove(channelListener);
    }

    public List<ChannelListener> getChannelListeners() {
        return new ArrayList<ChannelListener>(this.d);
    }

    @Override
    public void run() {
        InputStream inputStream = this.c.getInputStream();
        inputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (true) {
            try {
                int n2;
                while ((n2 = ((DataInputStream)inputStream).read(byArray)) != -1) {
                    Object object;
                    byteArrayOutputStream.write(byArray, 0, n2);
                    MessagesBufferIterator messagesBufferIterator = new MessagesBufferIterator(byteArrayOutputStream.toByteArray());
                    while (messagesBufferIterator.hasNext()) {
                        object = messagesBufferIterator.next();
                        if (a.isMessageTypeEnabled(object.getType())) {
                            a.info("READ:  " + object.toString() + ", " + this.b);
                        }
                        for (ChannelListener channelListener : this.getChannelListeners()) {
                            try {
                                channelListener.onMessageReceived((Message)object);
                            }
                            catch (Exception exception) {
                                a.log(Level.SEVERE, "Failed to process message.", exception);
                            }
                        }
                    }
                    object = messagesBufferIterator.getLeftBytes();
                    byteArrayOutputStream.reset();
                    byteArrayOutputStream.write((byte[])object, 0, ((Object)object).length);
                }
            }
            catch (SocketException socketException) {
                a.info("Stopping channel reader because '" + socketException.getMessage() + '\'');
            }
            catch (IOException iOException) {
                if (this.c.isClosed()) continue;
                throw new ServerException("Failed to read bytes from socket stream.", iOException);
            }
            catch (Exception exception) {
                a.log(Level.SEVERE, "Unexpected error in channel reader.", exception);
                continue;
            }
            break;
        }
        this.d.clear();
        this.c.close();
    }
}

