/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.IPCLogger;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelStream;
import com.teamdev.jxbrowser.chromium.internal.ipc.ServerException;
import com.teamdev.jxbrowser.chromium.internal.ipc.SocketInfo;
import com.teamdev.jxbrowser.chromium.internal.ipc.g;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageType;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.NonBlockingMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class SocketChannelWriter
implements Runnable {
    private static final IPCLogger a = (IPCLogger)LoggerProvider.getIPCLogger();
    private SocketInfo b;
    private final ChannelStream c;
    private final BlockingQueue<Message> d;
    private final AtomicBoolean e;

    public SocketChannelWriter(ChannelStream channelStream) {
        this.c = channelStream;
        this.e = new AtomicBoolean();
        this.d = new LinkedBlockingQueue<Message>();
        this.c.addChannelStreamListener(new g(this));
    }

    public void setSocketInfo(SocketInfo socketInfo) {
        this.b = socketInfo;
    }

    public void blockWriteMessages() {
        this.e.set(true);
    }

    public void write(Message message) {
        if (this.c.isClosed()) {
            throw new IllegalStateException("Channel is already closed.");
        }
        if (this.e.get() && !message.getType().isCallback() && !(message instanceof NonBlockingMessage)) {
            a.warning("Failed to process " + (Object)((Object)message.getType()) + " message because channel is already closed.");
            throw new IllegalStateException("Channel is being closed. All messages are blocked.");
        }
        this.d.add(message);
    }

    public void run() {
        if (this.c.isClosed()) {
            return;
        }
        OutputStream outputStream = this.c.getOutputStream();
        while (!this.c.isClosed()) {
            Message message = null;
            try {
                message = this.d.take();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            if (message == null || message instanceof a) continue;
            if (a.isMessageTypeEnabled(message.getType())) {
                a.info("WRITE: " + message.toString() + ", " + this.b);
            }
            try {
                byte[] byArray = new byte[message.getSize()];
                message.serialize(byArray);
                outputStream.write(byArray);
                outputStream.flush();
            }
            catch (SocketException socketException) {
                a.info("Stopping channel writer because '" + socketException.getMessage() + '\'');
                break;
            }
            catch (IOException iOException) {
                if (this.c.isClosed()) continue;
                throw new ServerException("Failed to write bytes to socket stream.", iOException);
            }
            catch (Exception exception) {
                a.log(Level.SEVERE, "Unexpected error in channel writer.", exception);
            }
        }
        this.d.clear();
        this.c.close();
    }

    static /* synthetic */ BlockingQueue a(SocketChannelWriter socketChannelWriter) {
        return socketChannelWriter.d;
    }

    private static final class a
    implements Message {
        private a() {
        }

        public final int getUID() {
            throw new UnsupportedOperationException();
        }

        public final MessageType getType() {
            throw new UnsupportedOperationException();
        }

        public final int getSize() {
            throw new UnsupportedOperationException();
        }

        public final void serialize(byte[] byArray) {
            throw new UnsupportedOperationException();
        }

        public final void deserialize(byte[] byArray) {
            throw new UnsupportedOperationException();
        }

        /* synthetic */ a(g g2) {
            this();
        }
    }
}

