/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONTokener {
    private int a;
    private Reader b;
    private char c;
    private boolean d;
    private static final String[] e;

    public JSONTokener(Reader reader) {
        this.b = reader.markSupported() ? reader : new BufferedReader(reader);
        this.d = false;
        this.a = 0;
    }

    public JSONTokener(String string) {
        this(new StringReader(string));
    }

    public void back() throws JSONException {
        block4: {
            if (!this.d && this.a > 0) break block4;
            throw new JSONException(e[7]);
        }
        --this.a;
        this.d = true;
    }

    public static int dehexchar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 55;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 87;
        }
        return -1;
    }

    public boolean more() throws JSONException {
        char c = this.next();
        if (c == '\u0000') {
            return false;
        }
        this.back();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char next() throws JSONException {
        int n;
        if (this.d) {
            this.d = false;
            if (this.c != '\u0000') {
                ++this.a;
            }
            return this.c;
        }
        try {
            n = this.b.read();
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
        if (n <= 0) {
            this.c = '\u0000';
            return '\u0000';
        }
        ++this.a;
        this.c = (char)n;
        return this.c;
    }

    public char next(char c) throws JSONException {
        char c2 = this.next();
        if (c2 != c) {
            throw this.syntaxError(e[1] + c + e[0] + c2 + "'");
        }
        return c2;
    }

    public String next(int n) throws JSONException {
        int n2 = JSONException.b;
        if (n == 0) {
            return "";
        }
        char[] cArray = new char[n];
        int n3 = 0;
        if (this.d) {
            this.d = false;
            cArray[0] = this.c;
            n3 = 1;
        }
        try {
            int n4;
            while (n3 < n && (n4 = this.b.read(cArray, n3, n - n3)) != -1) {
                n3 += n4;
                if (n2 == 0) continue;
                break;
            }
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
        this.a += n3;
        if (n3 < n) {
            throw this.syntaxError(e[4]);
        }
        this.c = cArray[n - 1];
        return new String(cArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char nextClean() throws JSONException {
        char c;
        while ((c = this.next()) != '\u0000' && c <= ' ') {
        }
        return c;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String nextString(char var1_1) throws JSONException {
        var4_2 = JSONException.b;
        var3_3 = new StringBuffer();
        block15: while (true) {
            var2_4 = this.next();
            switch (var2_4) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError(JSONTokener.e[3]);
                }
                case '\\': {
                    var2_4 = this.next();
                    switch (var2_4) {
                        case 'b': {
                            var3_3.append('\b');
                            if (var4_2 == 0) continue block15;
                        }
                        case 't': {
                            var3_3.append('\t');
                            if (var4_2 == 0) continue block15;
                        }
                        case 'n': {
                            var3_3.append('\n');
                            if (var4_2 == 0) continue block15;
                        }
                        case 'f': {
                            var3_3.append('\f');
                            if (var4_2 == 0) continue block15;
                        }
                        case 'r': {
                            var3_3.append('\r');
                            if (var4_2 == 0) continue block15;
                        }
                        case 'u': {
                            var3_3.append((char)Integer.parseInt(this.next(4), 16));
                            if (var4_2 == 0) continue block15;
                        }
                        case 'x': {
                            var3_3.append((char)Integer.parseInt(this.next(2), 16));
                            if (var4_2 == 0) ** break;
                            break;
                        }
                    }
                    var3_3.append(var2_4);
                    if (var4_2 == 0) ** break;
                    break;
                }
            }
            if (var2_4 == var1_1) {
                return var3_3.toString();
            }
            var3_3.append(var2_4);
        }
    }

    public String nextTo(char c) throws JSONException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            char c2;
            block12: {
                block13: {
                    block11: {
                        c2 = this.next();
                        if (c2 == c || c2 == '\u0000') break block11;
                        if (c2 == '\n') break block11;
                        if (c2 != '\r') break block12;
                    }
                    if (c2 == '\u0000') break block13;
                    this.back();
                }
                return stringBuffer.toString().trim();
            }
            stringBuffer.append(c2);
        }
    }

    public String nextTo(String string) throws JSONException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            char c;
            block12: {
                block13: {
                    block11: {
                        c = this.next();
                        if (string.indexOf(c) >= 0 || c == '\u0000') break block11;
                        if (c == '\n') break block11;
                        if (c != '\r') break block12;
                    }
                    if (c == '\u0000') break block13;
                    this.back();
                }
                return stringBuffer.toString().trim();
            }
            stringBuffer.append(c);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nextValue() throws JSONException {
        int n = JSONException.b;
        char c = this.nextClean();
        switch (c) {
            case '\"': 
            case '\'': {
                return this.nextString(c);
            }
            case '{': {
                this.back();
                return new JSONObject(this);
            }
            case '(': 
            case '[': {
                this.back();
                return new JSONArray(this);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (c >= ' ' && e[5].indexOf(c) < 0) {
            stringBuffer.append(c);
            c = this.next();
            if (n == 0) continue;
        }
        this.back();
        String string = stringBuffer.toString().trim();
        if (string.equals("")) {
            throw this.syntaxError(e[6]);
        }
        return JSONObject.stringToValue(string);
    }

    public char skipTo(char c) throws JSONException {
        char c2;
        int n = JSONException.b;
        try {
            int n2 = this.a;
            this.b.mark(Integer.MAX_VALUE);
            do {
                if ((c2 = this.next()) != '\u0000') continue;
                this.b.reset();
                this.a = n2;
                return c2;
            } while (c2 != c);
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
        this.back();
        char c3 = c2;
        if (JSONObject.b) {
            JSONException.b = ++n;
        }
        return c3;
    }

    public JSONException syntaxError(String string) {
        return new JSONException(string + this.toString());
    }

    public String toString() {
        return e[2] + this.a;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "m\u0011p\t`jX\u007f\u0014p/PuGw+F1@";
        int n2 = -1;
        block15: while (true) {
            char[] cArray;
            block20: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block19: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block19;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block20;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 74;
                                break;
                            }
                            case 1: {
                                n8 = 49;
                                break;
                            }
                            case 2: {
                                n8 = 17;
                                break;
                            }
                            case 3: {
                                n8 = 103;
                                break;
                            }
                            default: {
                                n8 = 4;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\u000fIa\u0002g>TuG#";
                    n2 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "jPeGg\"Pc\u0006g>TcG";
                    n2 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\u001f_e\u0002v'X\u007f\u0006p/U1\u0014p8X\u007f\u0000";
                    n2 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\u0019Ds\u0014p8X\u007f\u0000$(^d\t`9\u0011t\u0015v%C";
                    n2 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "f\u000bL\u001a+\u0016\u0013J\u001c?w\u0012";
                    n2 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "\u0007Xb\u0014m$V1\u0011e&Dt";
                    n2 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "\u0019Et\u0017t#_vGf+RzGp=^1\u0014p/AbGm9\u0011\u007f\bpjBd\u0017t%Ce\u0002`";
                    n2 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        e = stringArray3;
    }
}

