/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.data;

import com.agilemind.commons.data.Database;
import com.agilemind.commons.data.I;
import com.agilemind.commons.data.J;
import com.agilemind.commons.data.K;
import com.agilemind.commons.util.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class UTFReader {
    public static final UTFReader SHORT_UTF_READER = new I();
    public static final UTFReader LONG_UTF_READER = new J();
    public static final UTFReader VAR_UTF_READER = new K();

    public abstract int getLength(DataInput var1) throws IOException;

    public abstract void skipUTF(DataInput var1) throws IOException;

    public abstract String readUTF(DataInput var1) throws IOException;

    public abstract void writeUTF(DataOutput var1, String var2) throws IOException;

    protected static void skipNormalUTF(DataInput dataInput) throws IOException {
        int n2 = dataInput.readUnsignedShort();
        dataInput.skipBytes(n2);
    }

    public static UTFReader getUTFReader(Version version) {
        return version.compareTo(Database.VERSION_1_1) <= 0 ? SHORT_UTF_READER : LONG_UTF_READER;
    }
}

