/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.gui.chart.views;

import com.agilemind.commons.gui.chart.data.XYChartData;
import com.agilemind.commons.gui.chart.views.ChartProvider;
import com.agilemind.commons.gui.chart.views.CustomDateAxis;
import com.agilemind.commons.gui.chart.views.CustomNumberAxis;
import com.agilemind.commons.gui.chart.views.DifferenceXYAreaRenderer;
import com.agilemind.commons.gui.chart.views.DifferenceXYItemRenderer;
import com.agilemind.commons.gui.chart.views.NewRangedChartPanel;
import com.agilemind.commons.gui.locale.LocalizedFreeChart;
import com.agilemind.commons.gui.util.UiUtil;
import com.agilemind.commons.util.DateUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public class TrendsChart<T extends Number>
implements ChartProvider<XYChartData<T>> {
    public static final int DEFAULT_MAX_RANGE = 100;
    public static final int DEFAULT_MIN_RANGE = 0;
    public static final Color DEFAULT_AREA_COLOR;
    public static final Color DEFAULT_OUTLINE_COLOR;
    public static final Color RANGE_LINE_COLOR;
    public static final Ellipse2D.Double SMALL_SHAPE;
    public static final Ellipse2D.Double MEDIUM_SHAPE;
    public static final Ellipse2D.Double BIG_SHAPE;
    public static final int SINGLE_SERIES = 0;
    public static final double AXIS_MARGIN = 0.02;
    public static final float AREA_TRANSPARENT = 0.7f;
    private LocalizedFreeChart a;
    private DifferenceXYAreaRenderer b = new DifferenceXYAreaRenderer();
    private XYPlot c;
    private CustomDateAxis d = new CustomDateAxis();
    private CustomNumberAxis e = new CustomNumberAxis();
    private static final String[] f;

    public TrendsChart() {
        this.e.setLowerMargin(0.0);
        this.e.setUpperMargin(0.0);
        this.c = new XYPlot((XYDataset)new DefaultTableXYDataset(), (ValueAxis)this.d, (ValueAxis)this.e, (XYItemRenderer)this.b);
        this.c.setDomainZeroBaselineVisible(true);
        this.c.setRangeZeroBaselineVisible(true);
        this.c.setBackgroundPaint((Paint)UiUtil.TRANSPARENT_COLOR);
        this.c.setForegroundAlpha(0.7f);
        this.c.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        this.a = new LocalizedFreeChart((Plot)this.c);
        this.a.setBackgroundPaint(UiUtil.TRANSPARENT_COLOR);
        this.a.removeLegend();
    }

    private void a(XYAreaRenderer xYAreaRenderer) {
        this.c.setRangeGridlineStroke(UiUtil.createBasicStroke(1));
        this.c.setRangeGridlinePaint((Paint)RANGE_LINE_COLOR);
        this.c.setOutlinePaint((Paint)UiUtil.CHART_RANGE_COLOR);
        this.c.setOutlineStroke(UiUtil.createBasicStroke(1));
        this.c.setDomainGridlinePaint((Paint)RANGE_LINE_COLOR);
        this.c.setDomainGridlineStroke(UiUtil.createBasicStroke(1));
        this.c.getDomainAxis().setLowerMargin(0.0);
        this.c.getDomainAxis().setUpperMargin(0.0);
        this.c.setInsets(new RectangleInsets(5.0, 5.0, 5.0, 20.0));
        xYAreaRenderer.setSeriesShape(0, (Shape)MEDIUM_SHAPE);
        xYAreaRenderer.setSeriesOutlineStroke(0, UiUtil.createBasicStroke(3));
    }

    private void b(XYAreaRenderer xYAreaRenderer) {
        this.c.setDomainGridlinesVisible(false);
        this.c.getDomainAxis().setVisible(false);
        this.c.setRangeGridlinesVisible(false);
        this.c.getRangeAxis().setVisible(false);
        this.c.setAxisOffset(new RectangleInsets(1.0, 0.0, 1.0, 0.0));
        this.c.getDomainAxis().setLowerMargin(0.02);
        this.c.getDomainAxis().setUpperMargin(0.02);
        this.c.setOutlinePaint((Paint)UiUtil.TRANSPARENT_COLOR);
        this.c.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        xYAreaRenderer.setSeriesShape(0, (Shape)SMALL_SHAPE);
        xYAreaRenderer.setSeriesOutlineStroke(0, UiUtil.createBasicStroke(1));
    }

    @Override
    public void setChartData(XYChartData<T> xYChartData) {
        Cloneable cloneable;
        TimeTableXYDataset timeTableXYDataset;
        int n2;
        block8: {
            block7: {
                n2 = NewRangedChartPanel.p;
                if (xYChartData.getSeriesDatasets().size() == 0) {
                    return;
                }
                timeTableXYDataset = new TimeTableXYDataset();
                com.agilemind.commons.gui.chart.data.XYDataset<T> xYDataset = xYChartData.getSeriesDatasets().get(0);
                this.a(timeTableXYDataset, xYDataset, f[1]);
                if (xYDataset.getColor() == null) break block7;
                this.b.setSeriesOutlinePaint(0, xYDataset.getColor());
                this.b.setSeriesPaint(0, UiUtil.getBlendColor(xYDataset.getColor(), Color.WHITE, 0.25f));
                if (n2 == 0) break block8;
            }
            this.b.setSeriesPaint(0, DEFAULT_AREA_COLOR);
            this.b.setSeriesOutlinePaint(0, DEFAULT_OUTLINE_COLOR);
        }
        this.b.setPeriod(xYChartData.getDifferencePeriodDate());
        this.c.setDataset(0, (XYDataset)timeTableXYDataset);
        for (int i2 = 1; i2 < xYChartData.getSeriesDatasets().size(); ++i2) {
            cloneable = xYChartData.getSeriesDatasets().get(i2);
            TimeTableXYDataset timeTableXYDataset2 = new TimeTableXYDataset();
            this.a(timeTableXYDataset2, (Map<Date, T>)((Object)cloneable), f[0] + i2);
            this.a(i2, ((com.agilemind.commons.gui.chart.data.XYDataset)cloneable).getColor());
            this.c.setDataset(i2, (XYDataset)timeTableXYDataset2);
            if (n2 == 0) continue;
        }
        Date date = xYChartData.getStartDatePeriod();
        cloneable = xYChartData.getEndDatePeriod();
        if (date != null && cloneable != null) {
            this.d.setRange(DateUtil.getStartDay(date), (Date)cloneable);
        }
        this.a(xYChartData);
        if (xYChartData.isReverse()) {
            this.c.setRangeZeroBaselinePaint((Paint)UiUtil.TRANSPARENT_COLOR);
        }
        this.e.setInverted(xYChartData.isReverse());
    }

    private void a(TimeTableXYDataset timeTableXYDataset, Map<Date, T> map, String string) {
        int n2 = NewRangedChartPanel.p;
        for (Map.Entry<Date, T> entry : map.entrySet()) {
            Date date = entry.getKey();
            Number number = (Number)entry.getValue();
            if (number != null) {
                timeTableXYDataset.add((TimePeriod)new Day(date), number, (Comparable)((Object)string), true);
            }
            if (n2 == 0) continue;
        }
    }

    private void a(int n2, Paint paint) {
        DifferenceXYItemRenderer differenceXYItemRenderer = new DifferenceXYItemRenderer(3);
        differenceXYItemRenderer.setSeriesPaint(0, paint);
        differenceXYItemRenderer.setSeriesShape(0, BIG_SHAPE);
        differenceXYItemRenderer.setSeriesStroke(0, UiUtil.createBasicStroke(2));
        differenceXYItemRenderer.setBaseShapesFilled(true);
        this.c.setRenderer(n2, (XYItemRenderer)differenceXYItemRenderer);
    }

    private void a(XYChartData<T> xYChartData) {
        block3: {
            block4: {
                int n2;
                block2: {
                    n2 = NewRangedChartPanel.p;
                    if (!xYChartData.isAutoRange()) break block2;
                    this.c.getRangeAxis().setRange(0.0, (double)this.a(xYChartData.getSeriesDatasets()));
                    if (n2 == 0) break block3;
                }
                if (xYChartData.getMaxRange() <= 0) break block4;
                this.c.getRangeAxis().setRange((double)xYChartData.getMinRange(), (double)xYChartData.getMaxRange());
                if (n2 == 0) break block3;
            }
            this.c.getRangeAxis().setRange(0.0, 100.0);
        }
    }

    private long a(List<com.agilemind.commons.gui.chart.data.XYDataset<T>> list) {
        int n2 = NewRangedChartPanel.p;
        long l2 = 0L;
        for (com.agilemind.commons.gui.chart.data.XYDataset<T> xYDataset : list) {
            for (Number number : xYDataset.values()) {
                if (number == null && n2 == 0) continue;
                long l3 = l2 = l2 >= number.longValue() ? l2 : number.longValue();
                if (n2 == 0) continue;
            }
            if (n2 == 0) continue;
        }
        int n3 = 0;
        if (l2 != 0L) {
            n3 = Math.round((float)l2 / 4.0f);
        }
        return l2 + (long)n3 + 5L;
    }

    public void setLocale(Locale locale) {
        this.d.setLocale(locale);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n2, int n3) {
        this.a.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, n2, n3), null, null);
    }

    public void setShowRange(boolean bl2) {
        block3: {
            block2: {
                if (!bl2) break block2;
                this.a(this.b);
                if (NewRangedChartPanel.p == 0) break block3;
            }
            this.b(this.b);
        }
    }

    public void setShowShapes(boolean bl2) {
        this.b.setShowShape(bl2);
    }

    public void setGridColor(Paint paint) {
        this.c.setDomainGridlinePaint(paint);
        this.c.setRangeGridlinePaint(paint);
        this.c.setOutlinePaint(paint);
        this.d.setTickMarkPaint(paint);
        this.e.setTickMarkPaint(paint);
    }

    public void setLabelColor(Paint paint) {
        this.d.setTickLabelPaint(paint);
        this.e.setTickLabelPaint(paint);
    }

    public LocalizedFreeChart getChart() {
        return this.a;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "!\tZi;\u0017";
        int n3 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block13;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 115;
                                break;
                            }
                            case 1: {
                                n9 = 104;
                                break;
                            }
                            case 2: {
                                n9 = 52;
                                break;
                            }
                            case 3: {
                                n9 = 14;
                                break;
                            }
                            default: {
                                n9 = 94;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "'\u001aQ`:\u0000";
                    n3 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        f = stringArray3;
        DEFAULT_AREA_COLOR = new Color(239, 245, 251);
        DEFAULT_OUTLINE_COLOR = new Color(93, 145, 204);
        RANGE_LINE_COLOR = new Color(240, 240, 240);
        SMALL_SHAPE = new Ellipse2D.Double(-1.0, -1.0, 2.0, 2.0);
        MEDIUM_SHAPE = new Ellipse2D.Double(-2.0, -2.0, 4.0, 4.0);
        BIG_SHAPE = new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0);
    }
}

