/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.gui.locale;

import com.agilemind.commons.gui.locale.keysets.BundleButtonStringKeySet;
import com.agilemind.commons.gui.locale.keysets.ButtonStringKeySet;
import com.agilemind.commons.gui.util.UiUtil;
import com.agilemind.commons.localization.Localizator;
import com.agilemind.commons.localization.stringkey.StringKey;
import java.util.MissingResourceException;
import javax.swing.AbstractButton;
import javax.swing.Icon;

public class DefaultButtonLocalizator
implements Localizator {
    protected ButtonStringKeySet keySet;
    protected AbstractButton button;

    public DefaultButtonLocalizator(AbstractButton abstractButton, ButtonStringKeySet buttonStringKeySet) {
        this.button = abstractButton;
        this.keySet = buttonStringKeySet;
        this.reloadLanguage();
    }

    @Override
    public void reloadLanguage() {
        try {
            UiUtil.setText(this.button, this.keySet.getText());
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            this.button.setIcon(this.keySet.getIcon());
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        Icon icon = this.keySet.getRolloverIcon();
        if (icon != null) {
            this.button.setRolloverIcon(icon);
        }
        Icon icon2 = this.keySet.getPressedIcon();
        if (icon2 != null) {
            this.button.setPressedIcon(icon2);
        }
        Icon icon3 = this.keySet.getSelectedIcon();
        if (icon3 != null) {
            this.button.setSelectedIcon(icon3);
        }
        Icon icon4 = this.keySet.getRolloverSelectedIcon();
        if (icon4 != null) {
            this.button.setRolloverSelectedIcon(icon4);
        }
        try {
            this.button.setToolTipText(this.keySet.getTooltip());
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.button.revalidate();
    }

    public void setKey(StringKey stringKey) {
        this.setKeySet(new BundleButtonStringKeySet(stringKey));
    }

    public void setKeySet(ButtonStringKeySet buttonStringKeySet) {
        this.keySet = buttonStringKeySet;
        this.reloadLanguage();
    }
}

