/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.gui.util;

import com.agilemind.commons.gui.ColorThemeDescriptor;
import com.agilemind.commons.gui.util.d;
import com.agilemind.commons.gui.util.e;
import com.agilemind.commons.gui.util.f;
import com.agilemind.commons.localization.stringkey.StringKey;
import com.agilemind.commons.util.MathUtil;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.ThreadSafeUtil;
import com.agilemind.commons.util.os.Platform;
import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.plaf.scheme.ColorScheme;
import com.agilemind.utils.StyleConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.awt.image.ToolkitImage;

public class UiUtil {
    private static final Logger a;
    public static final Color[] PREDEFINED_COLORS;
    public static final Color[] PREDEFINED_SMOOTH_COLORS;
    public static final Color EMAIL_TEMPLATE_COLOR;
    public static final Color LINK_HOVER_COLOR;
    public static final Color PROGRESS_COLOR;
    public static final Color RED_COLOR;
    public static final Color LIGHT_YELLOW_COLOR;
    public static final Color TRANSPARENT_COLOR;
    public static final Color CHART_RANGE_COLOR;
    public static final Color LIGHT_GRAY_COLOR;
    public static final String HIDE_TAB_AREA;
    public static final String LINK_TABS;
    public static final String SHOW_ADD_TABS_BUTTON;
    public static final Font NOTIFY_FONT;
    public static final Font CHART_SLIDER_FONT;
    public static final Font SUB_FONT;
    public static final double GOLDEN_RATIO = 1.61803398875;
    public static final Color GREEN_TEXT_ON_WHITE;
    public static final Color DARK_MENU_BAR_BACKGROUND;
    public static final Color GREEN_COLOR_ON_DARK;
    public static final Color DARK_BACKGROUND;
    public static final Color TEXT_COLOR;
    public static final Color TEXT_DESCRIPTION_COLOR;
    public static final Color TEXT_HEADER_COLOR;
    public static final Color DARK_SEPARATOR_COLOR;
    public static final Color DARK_TOOLBAR_BACKGROUND;
    public static final Color DARK_STATUSBAR_COLOR;
    public static final LineBorder LINE_GREY_BORDER;
    public static final LineBorder DARK_LINE_GREY_BORDER;
    public static final Border LINE_STROKE_BORDER;
    public static final Border TABLE_BORDER;
    public static final Border TOOLBAR_BORDER;
    public static final Border BOTTOM_TOOLBAR_BORDER;
    private static final GridBagConstraints b;
    public static boolean c;
    private static final String[] d;

    private UiUtil() {
    }

    public static Color getUnSelectedColor() {
        return PureLookAndFeel.getCurrentTheme().getUnSelectedColor();
    }

    public static Color getMenuBackground() {
        return PureLookAndFeel.getCurrentTheme().getMenuBackground();
    }

    public static Color getPrimaryControl() {
        return PureLookAndFeel.getCurrentTheme().getPrimaryControl();
    }

    public static Color getMainTextColor() {
        return PureLookAndFeel.getCurrentTheme().getAcceleratorForeground();
    }

    public static Color getBackgroundColor() {
        return PureLookAndFeel.getCurrentTheme().getBackgroundColor();
    }

    public static Color getBackgroundLightColor() {
        return PureLookAndFeel.getCurrentTheme().getGradientDarkColor();
    }

    public static Color getInactiveControlTextColor() {
        return PureLookAndFeel.getCurrentTheme().getInactiveControlTextColor();
    }

    public static Color getInactiveTextfieldColor() {
        return PureLookAndFeel.getCurrentTheme().getInactiveTextFieldColor();
    }

    public static Color getLinkColor() {
        return PureLookAndFeel.getCurrentTheme().getLinkColor();
    }

    public static Color getFocusColor() {
        return PureLookAndFeel.getCurrentTheme().getFocusColor();
    }

    public static Color getDarkBackgroundColor() {
        return PureLookAndFeel.getCurrentTheme().getTableHeaderSortedColor();
    }

    public static Color getControlColor() {
        return PureLookAndFeel.getCurrentTheme().getControl();
    }

    public static String getHEXColorCode(Color color) {
        int n2 = color.getRGB();
        String string = Integer.toHexString(n2);
        return "#" + string.substring(2);
    }

    public static Font getWizardHeaderFont() {
        return UIManager.getDefaults().getFont(d[19]).deriveFont(1, 16.0f);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addMenuItem(JComponent jComponent, JMenuItem jMenuItem) {
        block5: {
            block6: {
                JComponent jComponent2;
                boolean bl2;
                block4: {
                    bl2 = c;
                    if (!(jComponent instanceof JPopupMenu)) break block4;
                    jComponent2 = (JPopupMenu)jComponent;
                    ((JPopupMenu)jComponent2).add(jMenuItem);
                    if (!bl2) break block5;
                }
                if (!(jComponent instanceof JMenu)) break block6;
                jComponent2 = (JMenu)jComponent;
                ((JMenu)jComponent2).add(jMenuItem);
                if (!bl2) break block5;
            }
            throw new IllegalArgumentException(d[0] + jComponent);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addSeparator(JComponent jComponent) {
        block5: {
            block6: {
                JComponent jComponent2;
                boolean bl2;
                block4: {
                    bl2 = c;
                    if (!(jComponent instanceof JPopupMenu)) break block4;
                    jComponent2 = (JPopupMenu)jComponent;
                    ((JPopupMenu)jComponent2).addSeparator();
                    if (!bl2) break block5;
                }
                if (!(jComponent instanceof JMenu)) break block6;
                jComponent2 = (JMenu)jComponent;
                ((JMenu)jComponent2).addSeparator();
                if (!bl2) break block5;
            }
            throw new IllegalArgumentException(d[21] + jComponent);
        }
    }

    public static Stroke createBasicStroke(int n2) {
        return new BasicStroke(n2, 1, 1);
    }

    public static void selectLine(JTextArea jTextArea, int n2) {
        try {
            int n3 = jTextArea.getLineStartOffset(n2);
            int n4 = jTextArea.getLineEndOffset(n2);
            jTextArea.select(n3, n4);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static void selectLine(JTextArea jTextArea, String string) {
        boolean bl2 = c;
        List<String> list = StringUtil.splitLinesFast(jTextArea.getText());
        int n2 = 0;
        for (String string2 : list) {
            if (string2.equals(string)) {
                UiUtil.selectLine(jTextArea, n2);
                if (!bl2) break;
            }
            ++n2;
            if (!bl2) continue;
            break;
        }
    }

    public static Dimension getGoldenWidthDimension(int n2, int n3) {
        Dimension dimension;
        Dimension dimension2 = dimension;
        Dimension dimension3 = dimension;
        int n4 = n2;
        double d2 = n3 == 0 ? (double)n2 / 1.61803398875 : (double)n2 * 1.61803398875;
        dimension2(n4, (int)d2);
        return dimension3;
    }

    public static Dimension getGoldenHeightDimension(int n2, int n3) {
        Dimension dimension;
        Dimension dimension2 = dimension;
        Dimension dimension3 = dimension;
        double d2 = n3 == 0 ? (double)n2 * 1.61803398875 : (double)n2 / 1.61803398875;
        dimension2((int)d2, n2);
        return dimension3;
    }

    public static void setUnderline(JComponent jComponent) {
        UiUtil.setUnderline(jComponent, jComponent.getFont());
    }

    public static void setUnderline(JComponent jComponent, Font font) {
        UiUtil.setUnderline(jComponent, font, UiUtil.getLinkColor());
    }

    public static void setUnderline(JComponent jComponent, Font font, Color color) {
        jComponent.setFont(font);
        jComponent.setForeground(color);
        jComponent.setOpaque(false);
        jComponent.setBorder(new UnderlineBorder(jComponent));
    }

    public static void setRequired(Component component) {
        UiUtil.setBold(component);
    }

    public static <T extends Component> T bold(T t2) {
        UiUtil.setBold(t2);
        return t2;
    }

    public static void setBold(Component component) {
        UiUtil.setBold(component, true);
    }

    public static void setBold(Component component, boolean bl2) {
        Component component2 = component;
        int n2 = bl2 ? 1 : 0;
        UiUtil.deriveFont(component2, n2);
    }

    public static void setItalic(Component component) {
        UiUtil.setItalic(component, true);
    }

    public static void setItalic(Component component, boolean bl2) {
        Component component2 = component;
        int n2 = bl2 ? 2 : 0;
        UiUtil.deriveFont(component2, n2);
    }

    public static void deriveFont(Component component, int n2) {
        component.setFont(component.getFont().deriveFont(n2));
    }

    public static void setFontSize(Component component, float f2) {
        component.setFont(component.getFont().deriveFont(f2));
    }

    public static int getTextWidth(String string, Font font) {
        AffineTransform affineTransform = new AffineTransform();
        FontRenderContext fontRenderContext = new FontRenderContext(affineTransform, true, true);
        return (int)font.getStringBounds(string, fontRenderContext).getWidth();
    }

    public static int getTextWidth(String string, Component component) {
        FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
        return fontMetrics.stringWidth(string);
    }

    public static void setMenuEnabled(JMenu jMenu, boolean bl2) {
        Component[] componentArray;
        boolean bl3 = c;
        for (Component component : componentArray = jMenu.getMenuComponents()) {
            if (component instanceof JMenu) {
                UiUtil.setMenuEnabled((JMenu)component, bl2);
                component.setEnabled(bl2);
                if (!bl3) continue;
            }
            component.setEnabled(bl2);
        }
    }

    public static String highlightGray(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(d[16]).append(string).append(d[15]).append(" ").append(string2).append(d[17]).append(d[14]);
        return stringBuilder.toString();
    }

    public static void setWindowsCopyPaste(JTextComponent jTextComponent) {
        jTextComponent.getInputMap().put(Platform.getKeyStroke(d[9]), d[7]);
        jTextComponent.getInputMap().put(Platform.getKeyStroke(d[8]), d[10]);
    }

    public static void setApplicationLookAndFeel() {
        try {
            UIManager.setLookAndFeel(d[20]);
        }
        catch (Exception exception) {
            a.error("", (Throwable)exception);
        }
    }

    public static void setDefaultColorScheme() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (!(lookAndFeel instanceof PureLookAndFeel)) {
            a.error(d[6]);
            return;
        }
        PureLookAndFeel.setCurrentTheme((ColorScheme)ColorScheme.DEFAULT);
        try {
            UIManager.setLookAndFeel(d[5]);
        }
        catch (Exception exception) {
            a.error("", (Throwable)exception);
        }
    }

    public static void updateColorScheme(ColorThemeDescriptor colorThemeDescriptor) {
        block7: {
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            if (!(lookAndFeel instanceof PureLookAndFeel)) {
                a.error(d[1]);
                return;
            }
            if (colorThemeDescriptor == null || colorThemeDescriptor.getColorScheme() == PureLookAndFeel.getCurrentTheme()) break block7;
            PureLookAndFeel.setCurrentTheme((ColorScheme)colorThemeDescriptor.getColorScheme());
            try {
                UIManager.setLookAndFeel(d[2]);
            }
            catch (Exception exception) {
                a.error("", (Throwable)exception);
            }
        }
    }

    public static DefaultMutableTreeNode findNode(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        boolean bl2 = c;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode2.getUserObject() == object) {
                return defaultMutableTreeNode2;
            }
            if (defaultMutableTreeNode2.getChildCount() > 0) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = UiUtil.findNode(defaultMutableTreeNode2, object);
                if (defaultMutableTreeNode3 != null) {
                    return defaultMutableTreeNode3;
                }
            }
            if (!bl2) continue;
        }
        return null;
    }

    public static List<String> getSuitableFontNames() {
        boolean bl2 = c;
        ArrayList<String> arrayList = new ArrayList<String>();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String string : graphicsEnvironment.getAvailableFontFamilyNames()) {
            Font font = new Font(string, 0, 0);
            if (!font.canDisplay('a') || UiUtil.isBold(font)) continue;
            if (UiUtil.isItalic(font)) continue;
            arrayList.add(string);
        }
        ArrayList<String> arrayList2 = arrayList;
        if (arrayList2 == null) {
            throw new IllegalStateException(String.format(d[13], d[12], d[11]));
        }
        return arrayList2;
    }

    public static boolean isBold(Font font) {
        String string = font.getFontName(Locale.ENGLISH).toLowerCase();
        if (string.contains(d[4])) {
            return true;
        }
        String string2 = font.getPSName().toLowerCase();
        return string2.contains(d[3]);
    }

    public static boolean isItalic(Font font) {
        boolean bl2;
        block10: {
            block9: {
                block8: {
                    String string = font.getFontName(Locale.ENGLISH).toLowerCase();
                    if (!string.contains(d[23]) && !string.contains(d[25])) break block8;
                    return true;
                }
                String string = font.getPSName().toLowerCase();
                if (!string.contains(d[22]) && !string.contains(d[24])) break block9;
                bl2 = true;
                break block10;
            }
            bl2 = false;
        }
        return bl2;
    }

    public static void expandAllFast(JTree jTree) {
        jTree.setUI(null);
        UiUtil.expandAll(jTree, true);
        jTree.updateUI();
    }

    public static void expandAll(JTree jTree, boolean bl2) {
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        UiUtil.a(jTree, new TreePath(treeNode), bl2);
    }

    private static void a(JTree jTree, TreePath treePath, boolean bl2) {
        block7: {
            block6: {
                boolean bl3 = c;
                TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                if (treeNode.getChildCount() >= 0) {
                    Enumeration<? extends TreeNode> enumeration = treeNode.children();
                    while (enumeration.hasMoreElements()) {
                        TreeNode treeNode2 = enumeration.nextElement();
                        TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                        UiUtil.a(jTree, treePath2, bl2);
                        if (!bl3) continue;
                    }
                }
                if (!bl2) break block6;
                jTree.expandPath(treePath);
                if (!bl3) break block7;
            }
            jTree.collapsePath(treePath);
        }
    }

    public static void setScrollPaneBackground(JScrollPane jScrollPane, JComponent jComponent) {
        jScrollPane.getViewport().setBackground(jComponent.getBackground());
    }

    public static Color getGrayScale(Color color) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        int n5 = (299 * n2 + 587 * n3 + 144 * n4) / 1030;
        return new Color(n5, n5, n5, color.getAlpha());
    }

    public static Icon getColorizedIcon(Icon icon, Color color) {
        block8: {
            BufferedImage bufferedImage;
            BufferedImage bufferedImage2;
            int n2;
            boolean bl2;
            block10: {
                ImageIcon imageIcon;
                block9: {
                    bl2 = c;
                    if (!(icon instanceof ImageIcon)) break block8;
                    n2 = color.getRGB();
                    bufferedImage2 = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 6);
                    imageIcon = (ImageIcon)icon;
                    if (!(imageIcon.getImage() instanceof BufferedImage)) break block9;
                    bufferedImage = (BufferedImage)imageIcon.getImage();
                    if (!bl2) break block10;
                }
                bufferedImage = ((ToolkitImage)imageIcon.getImage()).getBufferedImage();
            }
            for (int i2 = 0; i2 < bufferedImage.getWidth(); ++i2) {
                for (int i3 = 0; i3 < bufferedImage.getHeight(); ++i3) {
                    int n3 = bufferedImage.getRGB(i2, i3);
                    if (n3 != Color.BLACK.getRGB() && n3 != -1842205) continue;
                    bufferedImage2.setRGB(i2, i3, n2);
                    continue;
                }
                if (!bl2) continue;
            }
            return new ImageIcon(bufferedImage2);
        }
        return icon;
    }

    public static void requestFocus(Component component) {
        ThreadSafeUtil.invokeLater(new d(component));
    }

    public static Icon getRoundIcon(Color color, int n2, int n3) {
        ImageIcon imageIcon;
        block4: {
            boolean bl2;
            block6: {
                block5: {
                    boolean bl3 = c;
                    BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.setColor(TRANSPARENT_COLOR);
                    graphics2D.fillRect(0, 0, n2, n3);
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D.setPaint(color);
                    graphics2D.fillOval(0, 1, n2 - 2, n3 - 2);
                    graphics2D.dispose();
                    imageIcon = new ImageIcon(bufferedImage);
                    if (!StringKey.c) break block4;
                    if (!bl3) break block5;
                    bl2 = false;
                    break block6;
                }
                bl2 = true;
            }
            c = bl2;
        }
        return imageIcon;
    }

    public static BufferedImage fastScale(Image image, int n2, int n3) {
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        ImageObserver imageObserver = null;
        AffineTransform affineTransform = AffineTransform.getScaleInstance((double)n2 / (double)image.getWidth(imageObserver), (double)n3 / (double)image.getHeight(imageObserver));
        graphics2D.drawImage(image, affineTransform, imageObserver);
        return bufferedImage;
    }

    public static void gradientPaint(Graphics graphics, JPanel jPanel) {
        if (!jPanel.isOpaque()) {
            return;
        }
        Color color = UIManager.getColor(d[18]);
        int n2 = jPanel.getWidth();
        int n3 = jPanel.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, jPanel.getBackground(), n2, 0.0f, color));
        graphics2D.fillRect(0, 0, n2, n3);
        graphics2D.setPaint(paint);
    }

    public static void setText(AbstractButton abstractButton, String string) {
        UiUtil.setText(abstractButton, string, true);
    }

    public static void setText(AbstractButton abstractButton, String string, boolean bl2) {
        block3: {
            if (StringUtil.isEmpty(string) || !bl2) break block3;
            int n2 = string.indexOf(95);
            if (n2 != -1) {
                char c2 = string.charAt(n2 + 1);
                abstractButton.setMnemonic(c2);
                string = string.substring(0, n2) + string.substring(n2 + 1);
            }
        }
        abstractButton.setText(string);
    }

    public static Color getColor(Color color, Color color2, double d2) {
        int n2 = UiUtil.a(color.getRed(), color2.getRed(), d2);
        int n3 = UiUtil.a(color.getGreen(), color2.getGreen(), d2);
        int n4 = UiUtil.a(color.getBlue(), color2.getBlue(), d2);
        return new Color(n2, n3, n4);
    }

    public static Color getColor(double d2, double d3, Color color, Color color2, double d4) {
        double d5 = MathUtil.getProportion(d2, d3, d4);
        return UiUtil.getColor(color, color2, d5);
    }

    private static int a(int n2, int n3, double d2) {
        return (int)((double)n2 + (double)(n3 - n2) * d2);
    }

    public static Border createTableBorder(int n2, int n3, int n4, int n5) {
        return BorderFactory.createMatteBorder(n2, n3, n4, n5, PureLookAndFeel.getCurrentTheme().getTableHeaderColor());
    }

    public static JPanel wrapInBackgroundImage(JComponent jComponent, Icon icon) {
        return UiUtil.wrapInBackgroundImage(jComponent, icon, 1, 10);
    }

    public static JPanel wrapInBackgroundImage(JComponent jComponent, Icon icon, int n2, int n3) {
        jComponent.setOpaque(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jComponent, b);
        JLabel jLabel = new JLabel(icon);
        jLabel.setPreferredSize(new Dimension(1, 1));
        jLabel.setMinimumSize(new Dimension(1, 1));
        jLabel.setVerticalAlignment(n2);
        jLabel.setHorizontalAlignment(n3);
        jPanel.add((Component)jLabel, b);
        return jPanel;
    }

    public static void setAllSizes(JComponent jComponent, Dimension dimension) {
        jComponent.setMinimumSize(dimension);
        jComponent.setMaximumSize(dimension);
        jComponent.setPreferredSize(dimension);
    }

    public static void addHotKey(JComponent jComponent, Action action, KeyStroke keyStroke, String string) {
        UiUtil.addHotKey(jComponent, action, keyStroke, string, 2);
    }

    public static void addHotKey(JComponent jComponent, Action action, KeyStroke keyStroke, String string, int n2) {
        jComponent.getInputMap(n2).put(keyStroke, string);
        jComponent.getActionMap().put(string, action);
    }

    public static void setEnabled(Container container, boolean bl2) {
        Component[] componentArray;
        boolean bl3 = c;
        for (Component component : componentArray = container.getComponents()) {
            component.setEnabled(bl2);
            if (!bl3) continue;
        }
    }

    public static String getRandomColor() {
        return Integer.toHexString(MathUtil.random(0xFFFFFF));
    }

    public static void addPopupMenu(JComponent jComponent, JPopupMenu jPopupMenu) {
        jComponent.addMouseListener(new PopUpMouseListener(jPopupMenu, jComponent));
    }

    public static void adjustFocus(JComponent jComponent) {
        block4: {
            if (jComponent.hasFocus() || !jComponent.isRequestFocusEnabled()) break block4;
            jComponent.requestFocus();
        }
    }

    public static void addPopupMenuListener(JMenu jMenu, ActionListener actionListener) {
        block5: {
            block4: {
                if (!Platform.isOSX()) break block4;
                jMenu.addMenuListener(new e(actionListener));
                if (!c) break block5;
            }
            jMenu.getPopupMenu().addPopupMenuListener(new f(actionListener));
        }
    }

    public static ImageIcon mergeIcons(ImageIcon imageIcon, ImageIcon imageIcon2, ImageObserver imageObserver) {
        return new ImageIcon(UiUtil.mergeImages(imageIcon.getImage(), imageIcon2.getImage(), imageObserver));
    }

    public static Image mergeImages(Image image, Image image2, ImageObserver imageObserver) {
        int n2 = image.getWidth(imageObserver);
        int n3 = image.getHeight(imageObserver);
        int n4 = image2.getWidth(imageObserver);
        int n5 = image2.getHeight(imageObserver);
        BufferedImage bufferedImage = new BufferedImage(n2 + n4, Math.max(n3, n5), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, n2, n3, imageObserver);
        graphics2D.drawImage(image2, n2, 0, n4, n5, imageObserver);
        return bufferedImage;
    }

    public static void antialiasedPaint(Graphics graphics, AntialiasedPainter antialiasedPainter) {
        antialiasedPainter.antialiasedPaint(graphics);
    }

    public static Color getColor(String string) {
        if (string.charAt(0) == '#') {
            string = string.substring(1);
        }
        return new Color(Integer.parseInt(string, 16));
    }

    public static Color getWhiterColor(Color color) {
        return UiUtil.getBlendColor(color, Color.WHITE, 0.5f);
    }

    public static Color getDarkerColor(Color color) {
        return UiUtil.getBlendColor(color, Color.BLACK, 0.5f);
    }

    public static Color getBlendColor(Color color, Color color2, float f2) {
        Color color3;
        block4: {
            boolean bl2;
            block6: {
                block5: {
                    boolean bl3 = c;
                    float f3 = (float)(1.0 - (double)f2);
                    float[] fArray = new float[3];
                    color.getColorComponents(fArray);
                    float[] fArray2 = new float[3];
                    color2.getColorComponents(fArray2);
                    float[] fArray3 = new float[3];
                    fArray3[0] = fArray[0] * f2 + fArray2[0] * f3;
                    fArray3[1] = fArray[1] * f2 + fArray2[1] * f3;
                    fArray3[2] = fArray[2] * f2 + fArray2[2] * f3;
                    color3 = new Color(fArray3[0], fArray3[1], fArray3[2]);
                    if (!bl3) break block4;
                    if (!StringKey.c) break block5;
                    bl2 = false;
                    break block6;
                }
                bl2 = true;
            }
            StringKey.c = bl2;
        }
        return color3;
    }

    public static JDialog getDialog(Component component) {
        boolean bl2 = c;
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            if (!(component2 instanceof JDialog)) continue;
            return (JDialog)component2;
        }
        return null;
    }

    public static ImageIcon getArrowDownIcon() {
        return StyleConstants.arrowDown;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[29];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0015\u0001cOh\u001c\nFXY\u001c";
        int n3 = 28;
        block39: while (true) {
            char[] cArray;
            block44: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block43: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block43;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block44;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 125;
                                break;
                            }
                            case 1: {
                                n9 = 104;
                                break;
                            }
                            case 2: {
                                n9 = 7;
                                break;
                            }
                            case 3: {
                                n9 = 42;
                                break;
                            }
                            default: {
                                n9 = 60;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 28: {
                    HIDE_TAB_AREA = string.intern();
                    string2 = "\u000e\u0000h]}\u0019\fSK^\u000e*r^H\u0012\u0006";
                    n3 = 29;
                    continue block39;
                }
                case 29: {
                    SHOW_ADD_TABS_BUTTON = string.intern();
                    string2 = "\u0011\u0001iAh\u001c\nt";
                    n3 = 30;
                    continue block39;
                }
                case 30: {
                    LINK_TABS = string.intern();
                    string2 = ">\ti\rH]\tcN\u001c\u0010\ri_\u001c\u0014\u001cbG\u001c\t\u0007'";
                    n3 = -1;
                    continue block39;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "-\u001duOp\u0012\u0007lkR\u0019.bOP]\u0001tD\u001b\tHnDU\t";
                    n3 = 0;
                    continue block39;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u001e\u0007j\u0004]\u001a\u0001kOQ\u0014\u0006c\u0004L\u0011\ta\u0004l\b\u001abfS\u0012\u0003FDX;\rbF";
                    n3 = 1;
                    continue block39;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u001f\u0007kN";
                    n3 = 2;
                    continue block39;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u001f\u0007kN";
                    n3 = 3;
                    continue block39;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u001e\u0007j\u0004]\u001a\u0001kOQ\u0014\u0006c\u0004L\u0011\ta\u0004l\b\u001abfS\u0012\u0003FDX;\rbF";
                    n3 = 4;
                    continue block39;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "-\u001duOp\u0012\u0007lkR\u0019.bOP]\u0001tD\u001b\tHnDU\t";
                    n3 = 5;
                    continue block39;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u001e\u0007wS\u0011\t\u0007*IP\u0014\u0018eE]\u000f\f";
                    n3 = 6;
                    continue block39;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u000e\u0000nLH]!Iyy/<";
                    n3 = 7;
                    continue block39;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u001e\u0007i^N\u0012\u0004'cr.-U~";
                    n3 = 8;
                    continue block39;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\r\tt^YP\u000euEQP\u000bkCL\u001f\u0007fXX";
                    n3 = 9;
                    continue block39;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u001a\rsyI\u0014\u001cfHP\u0018.hDH3\tjOO";
                    n3 = 10;
                    continue block39;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\u001e\u0007j\u0005]\u001a\u0001kOQ\u0014\u0006c\u0005_\u0012\u0005jER\u000eG`_UR\u001dsCPR=n\u007fH\u0014\u0004";
                    n3 = 11;
                    continue block39;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "=&h^r\b\u0004k\nQ\u0018\u001coEX]Mt\u0004\u0019\u000eHj_O\tHiEH]\u001ab^I\u000f\u0006'DI\u0011\u0004";
                    n3 = 12;
                    continue block39;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "AGo^Q\u0011V";
                    n3 = 13;
                    continue block39;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "A\u000ehDH]\u000bhFS\u000fU%MN\u001c\u0011%\u0014";
                    n3 = 14;
                    continue block39;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "A\u0000sGPC";
                    n3 = 15;
                    continue block39;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "AGaER\tV";
                    n3 = 16;
                    continue block39;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "\u001e\u0007i^N\u0012\u0004";
                    n3 = 17;
                    continue block39;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "1\teOPS\u000ehDH";
                    n3 = 18;
                    continue block39;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "\u001e\u0007j\u0004]\u001a\u0001kOQ\u0014\u0006c\u0004L\u0011\ta\u0004l\b\u001abfS\u0012\u0003FDX;\rbF";
                    n3 = 19;
                    continue block39;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = ">\ti\rH]\tcN\u001c\u000e\rwKN\u001c\u001chX\u001c\t\u0007'";
                    n3 = 20;
                    continue block39;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "\u0014\u001cfFU\u001e";
                    n3 = 21;
                    continue block39;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "\u0014\u001cfFU\u001e";
                    n3 = 22;
                    continue block39;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "\u0012\nkCM\b\r";
                    n3 = 23;
                    continue block39;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = "\u0012\nkCM\b\r";
                    n3 = 24;
                    continue block39;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = "<\u001anKP";
                    n3 = 25;
                    continue block39;
                }
                case 25: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = "<\u001anKP";
                    n3 = 26;
                    continue block39;
                }
                case 26: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 28;
                    string2 = "<\u001anKP";
                    n3 = 27;
                    continue block39;
                }
                case 27: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        d = stringArray3;
        a = LoggerFactory.getLogger(UiUtil.class);
        PREDEFINED_COLORS = new Color[]{new Color(5223680), new Color(15418112), new Color(5472740), new Color(16026624), new Color(9455334), new Color(16108588), new Color(6038025), new Color(33280), new Color(1245311), new Color(4835529), new Color(12845255), new Color(0x7D7D7D), new Color(7539854), new Color(3156087), new Color(13179470), new Color(4116093)};
        PREDEFINED_SMOOTH_COLORS = new Color[]{new Color(16169381), new Color(12379040), new Color(12570867), new Color(14333657), new Color(16438179), new Color(16509622), new Color(14599676), new Color(13351604), new Color(11917747), new Color(12170199), new Color(12380640), new Color(15513325), new Color(0xD7D7D7), new Color(12632021), new Color(15645642), new Color(13103321)};
        EMAIL_TEMPLATE_COLOR = new Color(250, 250, 250);
        LINK_HOVER_COLOR = new Color(4490958);
        PROGRESS_COLOR = new Color(7772872);
        RED_COLOR = new Color(16138240);
        LIGHT_YELLOW_COLOR = new Color(16775915);
        TRANSPARENT_COLOR = new Color(255, 255, 255, 0);
        CHART_RANGE_COLOR = new Color(230, 230, 230);
        LIGHT_GRAY_COLOR = new Color(245, 245, 245);
        NOTIFY_FONT = new Font(d[28], 1, 14);
        CHART_SLIDER_FONT = new Font(d[26], 0, 10);
        SUB_FONT = new Font(d[27], 0, 9);
        GREEN_TEXT_ON_WHITE = new Color(5348380);
        DARK_MENU_BAR_BACKGROUND = StyleConstants.DARK_BACKGROUND;
        GREEN_COLOR_ON_DARK = StyleConstants.TEXT_SELECTED_COLOR;
        DARK_BACKGROUND = StyleConstants.DARK_BACKGROUND2;
        TEXT_COLOR = StyleConstants.TEXT_COLOR;
        TEXT_DESCRIPTION_COLOR = StyleConstants.TEXT_DESCRIPTION_COLOR;
        TEXT_HEADER_COLOR = new Color(5668792);
        DARK_SEPARATOR_COLOR = StyleConstants.DARK_MENU_SELECTED_BACKGROUND;
        DARK_TOOLBAR_BACKGROUND = new Color(52, 52, 52);
        DARK_STATUSBAR_COLOR = new Color(33, 33, 33);
        LINE_GREY_BORDER = new LineBorder(PureLookAndFeel.getCurrentTheme().getTableHeaderSortedColor());
        DARK_LINE_GREY_BORDER = new LineBorder(PureLookAndFeel.getCurrentTheme().getTableHeaderColor());
        LINE_STROKE_BORDER = new LineBorder(UiUtil.getPrimaryControl());
        TABLE_BORDER = UiUtil.createTableBorder(1, 0, 1, 0);
        TOOLBAR_BORDER = UiUtil.createTableBorder(0, 0, 1, 0);
        BOTTOM_TOOLBAR_BORDER = UiUtil.createTableBorder(1, 0, 0, 0);
        b = new GridBagConstraints();
        UiUtil.b.gridx = 0;
        UiUtil.b.gridy = 0;
        UiUtil.b.weightx = 1.0;
        UiUtil.b.weighty = 1.0;
        UiUtil.b.fill = 1;
        UiUtil.b.anchor = 18;
    }

    public static class PopUpMouseListener
    extends MouseAdapter {
        private final JPopupMenu a;
        private final JComponent b;

        public PopUpMouseListener(JPopupMenu jPopupMenu, JComponent jComponent) {
            this.a = jPopupMenu;
            this.b = jComponent;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.a.show(this.b, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.a.show(this.b, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public static abstract class AntialiasedPainter {
        public void antialiasedPaint(Graphics graphics) {
            block3: {
                block2: {
                    if (!(graphics instanceof Graphics2D)) break block2;
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                    Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_RENDERING);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    this.paint(graphics2D);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
                    graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, object2);
                    if (!c) break block3;
                }
                this.paint(graphics);
            }
        }

        protected abstract void paint(Graphics var1);
    }

    public static class UnderlineBorder
    implements Border {
        private JComponent a;

        public UnderlineBorder(JComponent jComponent) {
            this.a = jComponent;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            String string;
            Object object;
            Serializable serializable;
            int n6;
            block10: {
                block12: {
                    boolean bl2;
                    block11: {
                        block9: {
                            bl2 = c;
                            n6 = 0;
                            if (!(this.a instanceof JLabel)) break block9;
                            serializable = (JLabel)this.a;
                            object = ((JLabel)serializable).getIcon();
                            if (object != null) {
                                n6 = object.getIconWidth() + ((JLabel)serializable).getIconTextGap();
                            }
                            string = ((JLabel)serializable).getText();
                            if (!bl2) break block10;
                        }
                        if (!(this.a instanceof JTextComponent)) break block11;
                        string = ((JTextComponent)this.a).getText();
                        if (!bl2) break block10;
                    }
                    if (!(this.a instanceof AbstractButton)) break block12;
                    serializable = (AbstractButton)this.a;
                    object = ((AbstractButton)serializable).getIcon();
                    if (object != null) {
                        n6 = object.getIconWidth() + ((AbstractButton)serializable).getIconTextGap();
                    }
                    string = ((AbstractButton)serializable).getText();
                    if (!bl2) break block10;
                }
                throw new IllegalArgumentException();
            }
            if (!StringUtil.isEmpty(string)) {
                serializable = this.a.getForeground();
                object = this.a.getFont();
                graphics.setColor((Color)serializable);
                FontMetrics fontMetrics = this.a.getFontMetrics((Font)object);
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
                n4 = Math.min((int)rectangle2D.getWidth(), n4);
                int n7 = (int)rectangle2D.getHeight();
                n3 = n3 + n5 - (n5 - n7) / 2 - 1;
                graphics.drawLine(n2 + n6, n3, n2 + n4 + n6, n3);
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 0);
        }
    }

    public static class UnderlineDashedBorder
    implements Border {
        private int a;

        public UnderlineDashedBorder(int n2) {
            this.a = n2;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = component.getForeground();
            graphics2D.setStroke(new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{this.a}, 0.0f));
            graphics2D.setColor(color);
            graphics2D.drawLine(0, n5, n4, n5);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 1, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

