/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io;

import com.agilemind.commons.io.CopyUtils;
import com.agilemind.commons.io.ReadContentTimeoutException;
import com.agilemind.commons.io.a;
import com.agilemind.commons.localization.stringkey.StringKey;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.Util;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;

public class IOUtils {
    public static final int NO_TIMEOUT = 0;
    public static boolean b;
    private static final String[] a;

    private IOUtils() {
    }

    public static void copyFolder(File file, File file2, boolean bl2) throws IOException {
        if (file.exists()) {
            IOUtils.a(file, file2, false, bl2, null);
        }
    }

    public static void copyFolder(File file, File file2, boolean bl2, FilenameFilter filenameFilter) throws IOException {
        if (file.exists()) {
            IOUtils.a(file, file2, false, bl2, filenameFilter);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream;
        block32: {
            boolean bl2 = b;
            fileInputStream = new FileInputStream(file);
            Throwable throwable = null;
            try {
                block29: {
                    FileOutputStream fileOutputStream;
                    block30: {
                        fileOutputStream = new FileOutputStream(file2);
                        Throwable throwable2 = null;
                        try {
                            int n2;
                            byte[] byArray = new byte[1024];
                            while ((n2 = ((InputStream)fileInputStream).read(byArray)) > 0) {
                                ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                                if (!bl2) continue;
                            }
                            if (fileOutputStream == null) break block29;
                            if (throwable2 == null) break block30;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throw throwable4;
                            }
                            finally {
                                block31: {
                                    if (fileOutputStream != null) {
                                        if (throwable2 != null) {
                                            try {
                                                ((OutputStream)fileOutputStream).close();
                                                break block31;
                                            }
                                            catch (Throwable throwable5) {
                                                throwable2.addSuppressed(throwable5);
                                                if (!bl2) break block31;
                                            }
                                        }
                                        ((OutputStream)fileOutputStream).close();
                                    }
                                }
                            }
                        }
                        try {
                            ((OutputStream)fileOutputStream).close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                        break block29;
                    }
                    ((OutputStream)fileOutputStream).close();
                }
                if (fileInputStream == null) return true;
                if (throwable == null) break block32;
            }
            catch (Throwable throwable7) {
                try {
                    throwable = throwable7;
                    throw throwable7;
                }
                catch (Throwable throwable8) {
                    throw throwable8;
                }
                finally {
                    block33: {
                        if (fileInputStream != null) {
                            if (throwable != null) {
                                try {
                                    ((InputStream)fileInputStream).close();
                                    break block33;
                                }
                                catch (Throwable throwable9) {
                                    throwable.addSuppressed(throwable9);
                                    if (!bl2) break block33;
                                }
                            }
                            ((InputStream)fileInputStream).close();
                        }
                    }
                }
            }
            try {
                ((InputStream)fileInputStream).close();
                return true;
            }
            catch (Throwable throwable10) {
                throwable.addSuppressed(throwable10);
                return true;
            }
        }
        ((InputStream)fileInputStream).close();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void a(File file, File file2, boolean bl2, boolean bl3, FilenameFilter filenameFilter) throws IOException {
        File[] fileArray;
        boolean bl4 = b;
        if (!file.exists()) return;
        if (!file2.exists()) {
            file2.mkdirs();
            if (bl3) {
                file2.deleteOnExit();
            }
        }
        for (File file3 : fileArray = filenameFilter != null ? file.listFiles(filenameFilter) : file.listFiles()) {
            File file4 = new File(file2, file3.getName());
            if (file3.isDirectory()) {
                file4.mkdir();
                if (bl3) {
                    file4.deleteOnExit();
                }
                IOUtils.a(file3, file4, bl2, bl3, filenameFilter);
                if (!bl4) continue;
            }
            if (bl2) {
                file3.renameTo(file4);
                if (!bl4) continue;
            }
            if (bl3) {
                CopyUtils.temporaryCopy(file3, file4);
                if (!bl4) continue;
            }
            CopyUtils.copy(file3, file4);
            if (!bl4) continue;
        }
        if (!bl2) return;
        file.delete();
    }

    public static boolean recursiveDelete(File file) {
        boolean bl2 = b;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    IOUtils.recursiveDelete(file2);
                    if (!bl2) continue;
                }
                boolean bl3 = file2.delete();
                if (bl3) continue;
                System.err.println(a[8] + file2.getAbsolutePath());
            }
        }
        return file.delete();
    }

    public static IOException throwIOException(String string, Throwable throwable) {
        IOException iOException = new IOException(string);
        iOException.initCause(throwable);
        return iOException;
    }

    public static File createFile(File file, String ... stringArray) {
        for (String string : stringArray) {
            file = new File(file, string);
        }
        return file;
    }

    public static String load(String string) throws IOException {
        return IOUtils.load(new File(string));
    }

    public static String load(File file) throws IOException {
        return IOUtils.load(file, null);
    }

    public static String loadFromUTF8(File file) throws IOException {
        return IOUtils.load(file, a[11]);
    }

    public static String loadFromUTF8(InputStream inputStream) throws IOException {
        return IOUtils.load(inputStream, a[12]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String load(File file, String string) throws IOException {
        String string2;
        if (file.length() > Integer.MAX_VALUE) {
            throw new IOException(a[6]);
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            string2 = IOUtils.load(fileInputStream, string);
        }
        catch (Throwable throwable) {
            if (fileInputStream == null) throw throwable;
            fileInputStream.close();
            throw throwable;
        }
        if (fileInputStream == null) return string2;
        fileInputStream.close();
        return string2;
    }

    public static String load(InputStream inputStream) throws IOException {
        return IOUtils.load(inputStream, null);
    }

    public static String load(InputStream inputStream, String string) throws IOException {
        String string2;
        block6: {
            ByteArrayOutputStream byteArrayOutputStream;
            block5: {
                int n2;
                boolean bl2 = b;
                byteArrayOutputStream = new ByteArrayOutputStream();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                byte[] byArray = new byte[8192];
                while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                    if (!bl2) continue;
                    boolean bl3 = StringKey.c = !StringKey.c;
                }
                if (!StringUtil.isEmpty(string)) break block5;
                string2 = new String(byteArrayOutputStream.toByteArray());
                if (!bl2) break block6;
            }
            string2 = new String(byteArrayOutputStream.toByteArray(), string);
        }
        return string2;
    }

    public static Collection<String> loadLines(String string) throws IOException {
        File file = new File(string);
        return IOUtils.loadLines(file);
    }

    public static List<String> loadLines(File file) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        IOUtils.loadLines(file, new a(arrayList));
        return arrayList;
    }

    public static void loadLines(File file, LineAcceptor lineAcceptor) throws IOException {
        String string;
        boolean bl2 = b;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            lineAcceptor.accept(string);
            if (!bl2) continue;
        }
        bufferedReader.close();
    }

    public static void save2UTF8(File file, String string) throws IOException {
        IOUtils.save(file, string, a[10]);
    }

    public static void save(File file, String string, String string2) throws IOException {
        block4: {
            File file2 = file.getParentFile();
            if (file2 == null || file2.exists()) break block4;
            file2.mkdirs();
        }
        Writer writer = IOUtils.createWriter(file, string2);
        writer.write(string);
        writer.close();
    }

    public static Writer createWriter(File file, String string) throws IOException {
        BufferedWriter bufferedWriter;
        block3: {
            block2: {
                if (!StringUtil.isEmpty(string)) break block2;
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                if (!b) break block3;
            }
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string));
        }
        return bufferedWriter;
    }

    public static File createRandomFile(File file, String string) {
        return IOUtils.createRandomFile(file, null, string);
    }

    public static File createRandomFile(File file, String string, String string2) {
        File file2;
        File file3;
        do {
            File file4;
            String string3 = StringUtil.createRandomSignature(8);
            if (!StringUtil.isEmpty(string)) {
                string3 = string + string3;
            }
            File file5 = file4;
            file2 = file4;
            File file6 = file;
            StringBuilder stringBuilder = new StringBuilder().append(string3);
            String string4 = StringUtil.isEmpty(string2) ? "" : '.' + string2;
            file5(file6, stringBuilder.append(string4).toString());
        } while ((file3 = file2).exists());
        return file3;
    }

    public static File createRandomFolder(File file) {
        File file2 = IOUtils.createRandomFile(file, null);
        file2.mkdirs();
        return file2;
    }

    public static void zipFolder(File file, File file2) throws IOException {
        IOUtils.zipFolder(file, new File[]{file2});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zipFolder(File file, File[] fileArray) throws IOException {
        FileOutputStream fileOutputStream;
        block30: {
            boolean bl2 = b;
            fileOutputStream = new FileOutputStream(file);
            Throwable throwable = null;
            try {
                block27: {
                    ZipOutputStream zipOutputStream;
                    block28: {
                        zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
                        Throwable throwable2 = null;
                        try {
                            byte[] byArray = new byte[2048];
                            IOUtils.a(fileArray, null, zipOutputStream, byArray);
                            if (zipOutputStream == null) break block27;
                            if (throwable2 == null) break block28;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throw throwable4;
                            }
                            finally {
                                block29: {
                                    if (zipOutputStream != null) {
                                        if (throwable2 != null) {
                                            try {
                                                zipOutputStream.close();
                                                break block29;
                                            }
                                            catch (Throwable throwable5) {
                                                throwable2.addSuppressed(throwable5);
                                                if (!bl2) break block29;
                                            }
                                        }
                                        zipOutputStream.close();
                                    }
                                }
                            }
                        }
                        try {
                            zipOutputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                        break block27;
                    }
                    zipOutputStream.close();
                }
                if (fileOutputStream == null) return;
                if (throwable == null) break block30;
            }
            catch (Throwable throwable7) {
                try {
                    throwable = throwable7;
                    throw throwable7;
                }
                catch (Throwable throwable8) {
                    throw throwable8;
                }
                finally {
                    block31: {
                        if (fileOutputStream != null) {
                            if (throwable != null) {
                                try {
                                    fileOutputStream.close();
                                    break block31;
                                }
                                catch (Throwable throwable9) {
                                    throwable.addSuppressed(throwable9);
                                    if (!bl2) break block31;
                                }
                            }
                            fileOutputStream.close();
                        }
                    }
                }
            }
            try {
                fileOutputStream.close();
                return;
            }
            catch (Throwable throwable10) {
                throwable.addSuppressed(throwable10);
                return;
            }
        }
        fileOutputStream.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void a(File[] fileArray, File file, ZipOutputStream zipOutputStream, byte[] byArray) throws IOException {
        boolean bl2 = b;
        if (fileArray == null) return;
        File[] fileArray2 = fileArray;
        int n2 = fileArray2.length;
        int n3 = 0;
        do {
            block34: {
                FileInputStream fileInputStream;
                block35: {
                    File file2;
                    block37: {
                        if (n3 >= n2) return;
                        file2 = fileArray2[n3];
                        if (!file2.isDirectory()) break block37;
                        IOUtils.a(file2.listFiles(), new File(file, file2.getName()), zipOutputStream, byArray);
                        if (!bl2) break block34;
                    }
                    fileInputStream = new FileInputStream(file2);
                    Throwable throwable = null;
                    try {
                        block31: {
                            BufferedInputStream bufferedInputStream;
                            block32: {
                                bufferedInputStream = new BufferedInputStream(fileInputStream, 2048);
                                Throwable throwable2 = null;
                                try {
                                    int n4;
                                    ZipEntry zipEntry = new ZipEntry(new File(file, file2.getName()).toString());
                                    zipEntry.setTime(file2.lastModified());
                                    zipOutputStream.putNextEntry(zipEntry);
                                    while ((n4 = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                                        zipOutputStream.write(byArray, 0, n4);
                                        if (!bl2) continue;
                                    }
                                    if (bufferedInputStream == null) break block31;
                                    if (throwable2 == null) break block32;
                                }
                                catch (Throwable throwable3) {
                                    try {
                                        throwable2 = throwable3;
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throw throwable4;
                                    }
                                    finally {
                                        block33: {
                                            if (bufferedInputStream != null) {
                                                if (throwable2 != null) {
                                                    try {
                                                        bufferedInputStream.close();
                                                        break block33;
                                                    }
                                                    catch (Throwable throwable5) {
                                                        throwable2.addSuppressed(throwable5);
                                                        if (!bl2) break block33;
                                                    }
                                                }
                                                bufferedInputStream.close();
                                            }
                                        }
                                    }
                                }
                                try {
                                    bufferedInputStream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                                break block31;
                            }
                            bufferedInputStream.close();
                        }
                        if (fileInputStream == null) break block34;
                        if (throwable == null) break block35;
                    }
                    catch (Throwable throwable7) {
                        try {
                            throwable = throwable7;
                            throw throwable7;
                        }
                        catch (Throwable throwable8) {
                            throw throwable8;
                        }
                        finally {
                            block36: {
                                if (fileInputStream != null) {
                                    if (throwable != null) {
                                        try {
                                            fileInputStream.close();
                                            break block36;
                                        }
                                        catch (Throwable throwable9) {
                                            throwable.addSuppressed(throwable9);
                                            if (!bl2) break block36;
                                        }
                                    }
                                    fileInputStream.close();
                                }
                            }
                        }
                    }
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable10) {
                        throwable.addSuppressed(throwable10);
                    }
                    break block34;
                }
                fileInputStream.close();
            }
            ++n3;
        } while (!bl2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zipFile(File file, File file2) throws IOException {
        FileOutputStream fileOutputStream;
        block30: {
            boolean bl2 = b;
            fileOutputStream = new FileOutputStream(file2);
            Throwable throwable = null;
            try {
                ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
                Throwable throwable2 = null;
                try {
                    IOUtils.a(zipOutputStream, file);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    block29: {
                        if (zipOutputStream != null) {
                            if (throwable2 != null) {
                                try {
                                    zipOutputStream.close();
                                    break block29;
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                    if (!bl2) break block29;
                                }
                            }
                            zipOutputStream.close();
                        }
                    }
                }
                if (fileOutputStream == null) return;
                if (throwable == null) break block30;
            }
            catch (Throwable throwable5) {
                try {
                    throwable = throwable5;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    throw throwable6;
                }
                finally {
                    block31: {
                        if (fileOutputStream != null) {
                            if (throwable != null) {
                                try {
                                    fileOutputStream.close();
                                    break block31;
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                    if (!bl2) break block31;
                                }
                            }
                            fileOutputStream.close();
                        }
                    }
                }
            }
            try {
                fileOutputStream.close();
                return;
            }
            catch (Throwable throwable8) {
                throwable.addSuppressed(throwable8);
                return;
            }
        }
        fileOutputStream.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void a(ZipOutputStream zipOutputStream, File file) throws IOException {
        FileInputStream fileInputStream;
        block15: {
            boolean bl2 = b;
            fileInputStream = new FileInputStream(file);
            Throwable throwable = null;
            try {
                int n2;
                ZipEntry zipEntry = new ZipEntry(file.getName());
                zipOutputStream.putNextEntry(zipEntry);
                byte[] byArray = new byte[2048];
                while ((n2 = fileInputStream.read(byArray)) > 0) {
                    zipOutputStream.write(byArray, 0, n2);
                    if (!bl2) continue;
                }
                if (fileInputStream == null) return;
                if (throwable == null) break block15;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    block16: {
                        if (fileInputStream != null) {
                            if (throwable != null) {
                                try {
                                    fileInputStream.close();
                                    break block16;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    if (!bl2) break block16;
                                }
                            }
                            fileInputStream.close();
                        }
                    }
                }
            }
            try {
                fileInputStream.close();
                return;
            }
            catch (Throwable throwable5) {
                throwable.addSuppressed(throwable5);
                return;
            }
        }
        fileInputStream.close();
    }

    public static void unzip(InputStream inputStream, OutputStream outputStream) throws IOException {
        boolean bl2 = b;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        if (zipEntry != null) {
            int n2;
            byte[] byArray = new byte[2048];
            while ((n2 = zipInputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n2);
                if (!bl2) continue;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzipFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream;
        block30: {
            boolean bl2 = b;
            fileInputStream = new FileInputStream(file);
            Throwable throwable = null;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                Throwable throwable2 = null;
                try {
                    IOUtils.unzip(fileInputStream, fileOutputStream);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    block29: {
                        if (fileOutputStream != null) {
                            if (throwable2 != null) {
                                try {
                                    fileOutputStream.close();
                                    break block29;
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                    if (!bl2) break block29;
                                }
                            }
                            fileOutputStream.close();
                        }
                    }
                }
                if (fileInputStream == null) return;
                if (throwable == null) break block30;
            }
            catch (Throwable throwable5) {
                try {
                    throwable = throwable5;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    throw throwable6;
                }
                finally {
                    block31: {
                        if (fileInputStream != null) {
                            if (throwable != null) {
                                try {
                                    fileInputStream.close();
                                    break block31;
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                    if (!bl2) break block31;
                                }
                            }
                            fileInputStream.close();
                        }
                    }
                }
            }
            try {
                fileInputStream.close();
                return;
            }
            catch (Throwable throwable8) {
                throwable.addSuppressed(throwable8);
                return;
            }
        }
        fileInputStream.close();
    }

    public static boolean isZipFile(File file) throws IOException {
        if (file.isDirectory()) {
            return false;
        }
        if (!file.canRead()) {
            throw new IOException(a[1] + file.getAbsolutePath());
        }
        if (file.length() < 4L) {
            return false;
        }
        return IOUtils.isZipStream(new FileInputStream(file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isZipStream(InputStream inputStream) throws IOException {
        boolean bl2;
        DataInputStream dataInputStream;
        block16: {
            boolean bl3 = b;
            dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            Throwable throwable = null;
            try {
                int n2 = dataInputStream.readInt();
                dataInputStream.close();
                bl2 = n2 == 1347093252;
                if (dataInputStream == null) return bl2;
                if (throwable == null) break block16;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    block17: {
                        if (dataInputStream != null) {
                            if (throwable != null) {
                                try {
                                    dataInputStream.close();
                                    break block17;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    if (!bl3) break block17;
                                }
                            }
                            dataInputStream.close();
                        }
                    }
                }
            }
            try {
                dataInputStream.close();
                return bl2;
            }
            catch (Throwable throwable5) {
                throwable.addSuppressed(throwable5);
                if (!bl3) return bl2;
            }
        }
        dataInputStream.close();
        return bl2;
    }

    public static void deleteFolder(File file) throws IOException {
        IOUtils.recursiveDelete(file);
        if (file.exists()) {
            throw new IOException(a[0] + file.getAbsolutePath() + '\"');
        }
    }

    public static IOException throwIOException(Throwable throwable) {
        return new IOException(throwable);
    }

    public static List<File> recursiveListFiles(File file, String ... stringArray) {
        boolean bl2 = b;
        ArrayList<File> arrayList = new ArrayList<File>();
        block10: for (File file2 : file.listFiles()) {
            block13: {
                if (file2.isDirectory()) {
                    arrayList.addAll(IOUtils.recursiveListFiles(file2, stringArray));
                    if (!bl2) continue;
                }
                if (stringArray.length != 0) break block13;
                arrayList.add(file2);
                if (!bl2) continue;
            }
            for (String string : stringArray) {
                if (!file2.getName().toLowerCase().endsWith(string.toLowerCase())) continue;
                arrayList.add(file2);
                if (!bl2) continue block10;
            }
            if (!bl2) continue;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeBytes(File file, byte[] byArray) throws IOException {
        boolean bl2 = b;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        Throwable throwable = null;
        try {
            fileOutputStream.write(byArray);
            return;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            block14: {
                if (fileOutputStream != null) {
                    if (throwable != null) {
                        try {
                            fileOutputStream.close();
                            break block14;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                            if (!bl2) break block14;
                        }
                    }
                    fileOutputStream.close();
                }
            }
        }
    }

    public static byte[] readBytes(File file) throws IOException, InterruptedException {
        FileInputStream fileInputStream = new FileInputStream(file);
        return IOUtils.readBytes(fileInputStream);
    }

    public static byte[] readBytes(InputStream inputStream) throws IOException, InterruptedException {
        return IOUtils.readBytes(inputStream, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream inputStream, int n2) throws IOException, InterruptedException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        try {
            int n3;
            long l2 = System.currentTimeMillis();
            while ((n3 = inputStream.read(byArray)) != -1) {
                Util.checkInterrupted();
                byteArrayOutputStream.write(byArray, 0, n3);
                if (n2 == 0 || System.currentTimeMillis() - l2 <= (long)n2) continue;
                throw new ReadContentTimeoutException();
            }
        }
        catch (EOFException eOFException) {
            if (!StringUtil.stackTraceToString(eOFException).contains(a[4])) {
                throw eOFException;
            }
        }
        finally {
            inputStream.close();
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray2;
    }

    public static String readString(File file, String string) throws IOException, InterruptedException {
        return new String(IOUtils.readBytes(file), string);
    }

    public static String readString(InputStream inputStream, String string) throws IOException, InterruptedException {
        return new String(IOUtils.readBytes(inputStream), string);
    }

    public static void append(Writer writer, CharSequence charSequence) throws IOException {
        block5: {
            block4: {
                if (charSequence != null) break block4;
                writer.write(a[3]);
                if (!b) break block5;
            }
            writer.write(charSequence.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String encode(String string) {
        char[] cArray;
        boolean bl2 = b;
        StringBuilder stringBuilder = new StringBuilder();
        for (char c2 : cArray = string.toCharArray()) {
            if (!Character.isLetterOrDigit(c2) && c2 != ' ' && c2 != '_') {
                String string2 = Integer.toHexString(c2);
                string2 = "#" + StringUtil.createMonoString(4 - string2.length(), '0') + string2;
                stringBuilder.append(string2);
                if (!bl2) continue;
            }
            stringBuilder.append(c2);
            if (!bl2) continue;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String decode(String string) {
        boolean bl2 = b;
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            block5: {
                char c2;
                block4: {
                    c2 = cArray[n2];
                    if (c2 != '#') break block4;
                    int n3 = Integer.parseInt(new String(new char[]{cArray[n2 + 1], cArray[n2 + 2], cArray[n2 + 3], cArray[n2 + 4]}), 16);
                    stringBuilder.append((char)n3);
                    n2 += 5;
                    if (!bl2) break block5;
                }
                stringBuilder.append(c2);
                ++n2;
            }
            if (!bl2) continue;
        }
        return stringBuilder.toString();
    }

    public static String buildQueryString(Map<String, Object> map) throws UnsupportedEncodingException {
        Set<Map.Entry<String, Object>> set = map.entrySet();
        return IOUtils.buildQueryString(set);
    }

    public static String buildQueryString(Collection<Map.Entry<String, Object>> collection) throws UnsupportedEncodingException {
        return IOUtils.buildQueryString(collection, a[7]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String buildQueryString(Collection<Map.Entry<String, Object>> collection, String string) throws UnsupportedEncodingException {
        boolean bl2 = b;
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<String, Object>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            block11: {
                Object object;
                String string2;
                block10: {
                    Map.Entry<String, Object> entry = iterator.next();
                    string2 = entry.getKey();
                    object = entry.getValue();
                    if (!(object instanceof List)) break block10;
                    Iterator iterator2 = ((List)object).iterator();
                    while (iterator2.hasNext()) {
                        String string3 = (String)iterator2.next();
                        stringBuilder.append(URLEncoder.encode(string2, string));
                        stringBuilder.append('=');
                        stringBuilder.append(URLEncoder.encode(string3, string));
                        if (iterator2.hasNext()) {
                            stringBuilder.append('&');
                        }
                        if (!bl2) continue;
                    }
                    if (!bl2) break block11;
                }
                stringBuilder.append(URLEncoder.encode(string2, string));
                stringBuilder.append('=');
                stringBuilder.append(URLEncoder.encode(StringUtil.getStringOrEmpty(object), string));
            }
            if (iterator.hasNext()) {
                stringBuilder.append('&');
            }
            if (!bl2) continue;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canWrite(File file) {
        if (file.exists() && !file.canWrite()) {
            return false;
        }
        try {
            boolean bl2 = file.exists();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, a[5]);
            randomAccessFile.close();
            if (bl2) return true;
            file.delete();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isGifImage(byte[] byArray) {
        boolean bl2 = b;
        try {
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(byArray));
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            while (iterator.hasNext()) {
                ImageReader imageReader = iterator.next();
                if (imageReader.getFormatName().equalsIgnoreCase(a[9])) {
                    return true;
                }
                if (!bl2) continue;
                break;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] convertToJPG(byte[] byArray) throws IOException {
        boolean bl2 = b;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
        Throwable throwable = null;
        try {
            ImageIO.write((RenderedImage)bufferedImage, a[13], imageOutputStream);
            imageOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            block14: {
                if (imageOutputStream != null) {
                    if (throwable != null) {
                        try {
                            imageOutputStream.close();
                            break block14;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                            if (!bl2) break block14;
                        }
                    }
                    imageOutputStream.close();
                }
            }
        }
    }

    public static Image createStaticImage(byte[] byArray) {
        if (IOUtils.isGifImage(byArray)) {
            try {
                byArray = IOUtils.convertToJPG(byArray);
            }
            catch (IOException | IndexOutOfBoundsException exception) {
                exception.printStackTrace();
            }
        }
        return new ImageIcon(byArray).getImage();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeAsGZip(File file, String string, String string2) throws IOException {
        FileOutputStream fileOutputStream;
        block47: {
            boolean bl2 = b;
            fileOutputStream = new FileOutputStream(file.getAbsolutePath() + a[2]);
            Throwable throwable = null;
            try {
                block44: {
                    ByteArrayOutputStream byteArrayOutputStream;
                    block45: {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        Throwable throwable2 = null;
                        try {
                            byteArrayOutputStream.write(string.getBytes(string2));
                            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new BufferedOutputStream(fileOutputStream));
                            Throwable throwable3 = null;
                            try {
                                gZIPOutputStream.write(byteArrayOutputStream.toByteArray());
                            }
                            catch (Throwable throwable4) {
                                throwable3 = throwable4;
                                throw throwable4;
                            }
                            finally {
                                block43: {
                                    if (gZIPOutputStream != null) {
                                        if (throwable3 != null) {
                                            try {
                                                gZIPOutputStream.close();
                                                break block43;
                                            }
                                            catch (Throwable throwable5) {
                                                throwable3.addSuppressed(throwable5);
                                                if (!bl2) break block43;
                                            }
                                        }
                                        gZIPOutputStream.close();
                                    }
                                }
                            }
                            if (byteArrayOutputStream == null) break block44;
                            if (throwable2 == null) break block45;
                        }
                        catch (Throwable throwable6) {
                            try {
                                throwable2 = throwable6;
                                throw throwable6;
                            }
                            catch (Throwable throwable7) {
                                throw throwable7;
                            }
                            finally {
                                block46: {
                                    if (byteArrayOutputStream != null) {
                                        if (throwable2 != null) {
                                            try {
                                                byteArrayOutputStream.close();
                                                break block46;
                                            }
                                            catch (Throwable throwable8) {
                                                throwable2.addSuppressed(throwable8);
                                                if (!bl2) break block46;
                                            }
                                        }
                                        byteArrayOutputStream.close();
                                    }
                                }
                            }
                        }
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Throwable throwable9) {
                            throwable2.addSuppressed(throwable9);
                        }
                        break block44;
                    }
                    byteArrayOutputStream.close();
                }
                if (fileOutputStream == null) return;
                if (throwable == null) break block47;
            }
            catch (Throwable throwable10) {
                try {
                    throwable = throwable10;
                    throw throwable10;
                }
                catch (Throwable throwable11) {
                    throw throwable11;
                }
                finally {
                    block48: {
                        if (fileOutputStream != null) {
                            if (throwable != null) {
                                try {
                                    fileOutputStream.close();
                                    break block48;
                                }
                                catch (Throwable throwable12) {
                                    throwable.addSuppressed(throwable12);
                                    if (!bl2) break block48;
                                }
                            }
                            fileOutputStream.close();
                        }
                    }
                }
            }
            try {
                fileOutputStream.close();
                return;
            }
            catch (Throwable throwable13) {
                throwable.addSuppressed(throwable13);
                return;
            }
        }
        fileOutputStream.close();
    }

    public static List<File> buildPath(File file) {
        boolean bl2 = b;
        LinkedList<File> linkedList = new LinkedList<File>();
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            linkedList.addFirst(file2);
            if (!bl2) continue;
        }
        return linkedList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeSilently(Closeable closeable) {
        if (closeable == null) return;
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[14];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "p`\u0011[d@.\u0004V(Ak\u001c\\|@.\u0014Pz@m\u0004Vz\\.\u0018PmWo\u0002Z`\\.R";
        int n3 = -1;
        block21: while (true) {
            char[] cArray;
            block26: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block25: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block25;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block26;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 37;
                                break;
                            }
                            case 1: {
                                n9 = 14;
                                break;
                            }
                            case 2: {
                                n9 = 112;
                                break;
                            }
                            case 3: {
                                n9 = 57;
                                break;
                            }
                            default: {
                                n9 = 8;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "fo\u001eWgQ.\u0002\\iA.\u0016Pd@.";
                    n3 = 0;
                    continue block21;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u000bi\n";
                    n3 = 1;
                    continue block21;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "K{\u001cU";
                    n3 = 2;
                    continue block21;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "Oo\u0006X&Pz\u0019U&_g\u0000\u0017O\u007fG pfU{\u0004j|Wk\u0011T&Wk\u0011]\\Wo\u0019UmW&";
                    n3 = 3;
                    continue block21;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "Wy";
                    n3 = 4;
                    continue block21;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "qa\u001f\u0019jLiP_aIk";
                    n3 = 5;
                    continue block21;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "pZ6\u00140";
                    n3 = 6;
                    continue block21;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "p`\u0011[d@.\u0004V(Ak\u001c\\|@.";
                    n3 = 7;
                    continue block21;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "Bg\u0016";
                    n3 = 8;
                    continue block21;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "pZ6\u00140";
                    n3 = 9;
                    continue block21;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "pZ6\u00140";
                    n3 = 10;
                    continue block21;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "pZ6\u00140";
                    n3 = 11;
                    continue block21;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "O~\u0017";
                    n3 = 12;
                    continue block21;
                }
                case 12: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        a = stringArray3;
    }

    public static abstract class LineAcceptor {
        protected abstract void accept(String var1);
    }
}

