/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.ftp;

import com.agilemind.commons.io.IOUtils;
import com.agilemind.commons.io.ftp.FTPClientPlugin;
import com.agilemind.commons.io.ftp.FtpClientFile;
import com.agilemind.commons.io.ftp.FtpConnection;
import com.agilemind.commons.io.ftp.data.IFtpSettings;
import com.agilemind.commons.localization.stringkey.StringKey;
import com.agilemind.commons.util.OperationLogger;
import com.agilemind.commons.util.Util;
import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.j2ssh.sftp.SftpSubsystemClient;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.IgnoreHostKeyVerification;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHToolsFTPClientPlugin
extends FTPClientPlugin {
    private SshClient d;
    private SftpClient e;
    private SftpSubsystemClient f;
    private IFtpSettings g;
    private static final Logger h = LoggerFactory.getLogger(SSHToolsFTPClientPlugin.class);

    SSHToolsFTPClientPlugin(IFtpSettings iFtpSettings) {
        this.g = iFtpSettings;
        this.d = new SshClient();
    }

    @Override
    public boolean changeWorkingDirectory(String string) throws IOException {
        if (string != null) {
            this.e.cd(string);
        }
        return string.equals(this.e.pwd());
    }

    @Override
    public boolean makeDirectory(String string) throws IOException {
        this.e.mkdir(string);
        return true;
    }

    @Override
    public boolean sendFile(String string, String string2) throws IOException {
        this.e.put(new File(string, string2).toString(), string2);
        return true;
    }

    @Override
    public boolean deleteFile(String string) {
        try {
            this.e.rm(string);
            return true;
        }
        catch (IOException iOException) {
            h.error("", (Throwable)iOException);
            return true;
        }
    }

    @Override
    protected FtpClientFile[] listFiles(FtpClientFile ftpClientFile) throws IOException {
        List list = this.e.ls(ftpClientFile.getFullName());
        return this.a(ftpClientFile, list);
    }

    private FtpClientFile[] a(FtpClientFile ftpClientFile, List<SftpFile> list) {
        boolean bl2 = FtpConnection.d;
        FtpClientFile[] ftpClientFileArray = new FtpClientFile[list.size()];
        for (int i2 = 0; i2 < ftpClientFileArray.length; ++i2) {
            SftpFile sftpFile = list.get(i2);
            ftpClientFileArray[i2] = new FtpClientFile(ftpClientFile, sftpFile.getFilename(), sftpFile.isDirectory(), this);
            if (!bl2) continue;
        }
        return ftpClientFileArray;
    }

    @Override
    public IFtpSettings getFtpSettings() {
        return this.g;
    }

    @Override
    public String printWorkingDirectory() throws IOException {
        return this.e.pwd();
    }

    @Override
    protected void doDisonnecting(OperationLogger operationLogger) throws InterruptedException {
        try {
            operationLogger.log(a.getDisconnectingMessage());
            if (this.f != null) {
                this.f.close();
            }
            if (this.e != null) {
                this.e.quit();
            }
            this.d.disconnect();
        }
        catch (IOException iOException) {
            operationLogger.log(a.getFailedStatusMessage());
            h.error("", (Throwable)iOException);
        }
        operationLogger.log(a.getDoneStatusMessage());
    }

    @Override
    public void connection(OperationLogger operationLogger) throws IOException, InterruptedException {
        block12: {
            boolean bl2;
            block14: {
                block13: {
                    boolean bl3;
                    block11: {
                        block10: {
                            bl3 = FtpConnection.d;
                            operationLogger.log(a.getConnectingMessage());
                            SshConnectionProperties sshConnectionProperties = new SshConnectionProperties();
                            sshConnectionProperties.setHost(this.g.getHost());
                            sshConnectionProperties.setPort(this.g.getPort());
                            try {
                                this.d.connect(sshConnectionProperties, (HostKeyVerification)new IgnoreHostKeyVerification());
                            }
                            catch (IOException iOException) {
                                operationLogger.log(a.getFailedStatusMessage());
                                throw IOUtils.throwIOException(a.getConnectionFailedMessage(), iOException);
                            }
                            Util.checkInterrupted();
                            operationLogger.log(a.getLoginToServerMessage());
                            PasswordAuthenticationClient passwordAuthenticationClient = new PasswordAuthenticationClient();
                            passwordAuthenticationClient.setUsername(this.g.getLogin());
                            passwordAuthenticationClient.setPassword(this.g.getPassword());
                            int n2 = this.d.authenticate((SshAuthenticationClient)passwordAuthenticationClient);
                            if (n2 != 4) break block10;
                            Util.checkInterrupted();
                            operationLogger.log(a.getDoneStatusMessage());
                            this.e = this.d.openSftpClient();
                            this.f = this.d.openSftpChannel();
                            if (!bl3) break block11;
                        }
                        operationLogger.log(a.getFailedStatusMessage());
                        throw new IOException(a.getLoginFailedMessage());
                    }
                    if (!StringKey.c) break block12;
                    if (!bl3) break block13;
                    bl2 = false;
                    break block14;
                }
                bl2 = true;
            }
            FtpConnection.d = bl2;
        }
    }

    @Override
    public boolean isConnected() {
        return true;
    }
}

