/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.pagereader.cache;

import com.agilemind.commons.io.IOUtils;
import com.agilemind.commons.io.pagereader.PageReaderContent;
import com.agilemind.commons.io.pagereader.PageReaderContentImpl;
import com.agilemind.commons.io.pagereader.cache.Cache;
import com.agilemind.commons.io.pagereader.cache.MemoryCacheStorage;
import com.agilemind.commons.io.pagereader.cache.PagesCacheKey;
import com.agilemind.commons.io.pagereader.cache.c;
import com.agilemind.commons.io.pagereader.cache.d;
import com.agilemind.commons.io.pagereader.cache.impl.CacheStorage;
import com.agilemind.commons.io.pagereader.cache.impl.LockedCache;
import com.agilemind.commons.util.JSONUtil;
import com.agilemind.commons.util.UnicodeURLFactory;
import com.agilemind.commons.util.UnicodeURLUtil;
import com.agilemind.commons.util.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;

public class PagesCache
extends LockedCache<PagesCacheKey, PageReaderContent> {
    public PagesCache(CacheStorage<PagesCacheKey, PageReaderContent> cacheStorage) {
        super(cacheStorage);
    }

    public static class FilePagesStorage
    extends CacheStorage<PagesCacheKey, PageReaderContent> {
        private File a;
        private boolean c;
        private boolean d;
        private Map<String, d> e;
        private static final String[] f;

        private FilePagesStorage(boolean bl2) throws IOException {
            this(new File(f[7]), bl2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private FilePagesStorage(File file, boolean bl2) throws IOException {
            File file2;
            int n2 = Cache.b;
            this.e = new HashMap<String, d>();
            this.a = file;
            this.c = bl2;
            if (!this.a.exists()) {
                this.a.mkdirs();
            }
            if (!(file2 = new File(this.a, f[3])).exists()) return;
            String string = IOUtils.load(file2);
            BufferedReader bufferedReader = null;
            try {
                String string2;
                bufferedReader = new BufferedReader(new StringReader(string));
                while ((string2 = bufferedReader.readLine()) != null) {
                    try {
                        Map<String, Object> map = JSONUtil.toMapFromJsonString(string2);
                        this.e.put((String)map.get(f[2]), new d((String)map.get(f[1]), map, null));
                    }
                    catch (JSONException jSONException) {
                        if (n2 == 0) continue;
                    }
                }
            }
            catch (Throwable throwable) {
                if (bufferedReader == null) throw throwable;
                bufferedReader.close();
                throw throwable;
            }
            if (bufferedReader == null) return;
            bufferedReader.close();
            return;
        }

        public String getFileName(String string) {
            d d2 = this.e.get(string);
            return d2 != null ? com.agilemind.commons.io.pagereader.cache.d.access$300(d2) : null;
        }

        @Override
        protected PageReaderContent getFromCache(PagesCacheKey pagesCacheKey) throws IOException, InterruptedException {
            d d2;
            PageReaderContentImpl pageReaderContentImpl = null;
            if (this.c && (d2 = this.e.get(pagesCacheKey.getPageURL())) != null) {
                byte[] byArray = IOUtils.readBytes(new File(this.a, com.agilemind.commons.io.pagereader.cache.d.access$300(d2)));
                String string = (String)com.agilemind.commons.io.pagereader.cache.d.access$400(d2).get(f[0]);
                pageReaderContentImpl = new PageReaderContentImpl(string, byArray, UnicodeURLFactory.getInstance().createUnicodeURL(pagesCacheKey.getPageURL()), com.agilemind.commons.io.pagereader.cache.d.access$400(d2));
            }
            return pageReaderContentImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void putToCache(PagesCacheKey pagesCacheKey, PageReaderContent pageReaderContent) throws IOException {
            File file;
            String string;
            block15: {
                block14: {
                    if (this.d && pageReaderContent.getPageBytes().length == 0 && pageReaderContent.needRedirect()) {
                        return;
                    }
                    string = pagesCacheKey.getPageURL();
                    if (!this.e.containsKey(string)) break block14;
                    file = new File(this.a, com.agilemind.commons.io.pagereader.cache.d.access$300(this.e.get(string)));
                    if (Cache.b == 0) break block15;
                }
                file = IOUtils.createRandomFile(this.a, UnicodeURLUtil.getURLExtension(pagesCacheKey.a));
            }
            String string2 = file.getName();
            IOUtils.writeBytes(file, pageReaderContent.getPageBytes());
            Map<String, Object> map = pageReaderContent.getParams();
            if (!this.e.containsKey(string)) {
                try (BufferedWriter bufferedWriter = null;){
                    bufferedWriter = new BufferedWriter(new FileWriter(new File(this.a, f[6]), true));
                    map.put(f[5], string);
                    map.put(f[4], string2);
                    bufferedWriter.write(JSONUtil.toJsonString(map));
                    bufferedWriter.newLine();
                }
            }
            this.e.put(string, new d(string2, map, null));
        }

        public void setIgnoreStoreRedirects(boolean bl2) {
            this.d = bl2;
        }

        /* synthetic */ FilePagesStorage(File file, boolean bl2, c c2) throws IOException {
            this(file, bl2);
        }

        /* synthetic */ FilePagesStorage(boolean bl2, c c2) throws IOException {
            this(bl2);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[8];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "YhH?\u0017Tsc%\u0011UcO%\u0015";
            int n3 = -1;
            block15: while (true) {
                char[] cArray;
                block20: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block19: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block19;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block20;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 58;
                                    break;
                                }
                                case 1: {
                                    n9 = 7;
                                    break;
                                }
                                case 2: {
                                    n9 = 38;
                                    break;
                                }
                                case 3: {
                                    n9 = 75;
                                    break;
                                }
                                default: {
                                    n9 = 114;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "\\nJ.\"[`C";
                        n3 = 0;
                        continue block15;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "JfA.'hK";
                        n3 = 1;
                        continue block15;
                    }
                    case 1: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 3;
                        string2 = "YfE#\u0017\u0014kI,";
                        n3 = 2;
                        continue block15;
                    }
                    case 2: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 4;
                        string2 = "\\nJ.\"[`C";
                        n3 = 3;
                        continue block15;
                    }
                    case 3: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 5;
                        string2 = "JfA.'hK";
                        n3 = 4;
                        continue block15;
                    }
                    case 4: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 6;
                        string2 = "YfE#\u0017\u0014kI,";
                        n3 = 5;
                        continue block15;
                    }
                    case 5: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 7;
                        string2 = "\\nJ.-YfE#\u0017";
                        n3 = 6;
                        continue block15;
                    }
                    case 6: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            f = stringArray3;
        }
    }

    public static class FilePagesLog
    extends FilePagesStorage {
        public FilePagesLog(File file) throws IOException {
            super(file, false, null);
        }

        public FilePagesLog() throws IOException {
            super(false, null);
        }
    }

    public static class FilePagesCache
    extends FilePagesStorage {
        public FilePagesCache(File file) throws IOException {
            super(file, true, null);
        }

        public FilePagesCache() throws IOException {
            super(true, null);
        }
    }

    public static class FixedPageCacheStorage
    extends MemoryCacheStorage<PagesCacheKey, PageReaderContent> {
        private String[] c;

        public FixedPageCacheStorage(String ... stringArray) {
            this.c = stringArray;
        }

        @Override
        protected PageReaderContent getFromCache(PagesCacheKey pagesCacheKey) throws IOException {
            if (Util.contains(this.c, pagesCacheKey.getPageURL())) {
                return (PageReaderContent)super.getFromCache(pagesCacheKey);
            }
            return null;
        }

        @Override
        protected void putToCache(PagesCacheKey pagesCacheKey, PageReaderContent pageReaderContent) throws IOException {
            if (Util.contains(this.c, pagesCacheKey.getPageURL())) {
                super.putToCache(pagesCacheKey, pageReaderContent);
            }
        }
    }
}

