/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.searchengine.analyzers.util;

import com.agilemind.commons.io.IOUtils;
import com.agilemind.commons.io.searchengine.analyzers.util.HtmlUtils;
import com.agilemind.commons.io.searchengine.analyzers.util.l;
import com.agilemind.commons.io.searchengine.analyzers.util.m;
import com.agilemind.commons.io.searchengine.analyzers.util.n;
import com.agilemind.commons.io.searchengine.analyzers.util.o;
import com.agilemind.commons.io.searchengine.analyzers.util.p;
import com.agilemind.commons.io.searchengine.analyzers.util.r;
import com.agilemind.commons.io.searchengine.analyzers.util.s;
import com.agilemind.commons.io.searchengine.analyzers.util.t;
import com.agilemind.commons.io.utils.UrlUtils;
import com.agilemind.commons.util.Charset;
import com.agilemind.commons.util.LinkPrototypicalNodeFactory;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLUtil;
import com.agilemind.commons.util.Util;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.htmlparser.Node;
import org.htmlparser.NodeFactory;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.Tag;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.tags.ImageTag;
import org.htmlparser.tags.LinkTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLCollector {
    private static final Logger a;
    public static final String ANCHOR_SPLIT_REGEX;
    public static final String PATH_SPLIT_REGEX;
    private UnicodeURL b;
    private String c;
    public static final String IMAGE_ANCHOR;
    public static final URLType URL_TYPE_ALL;
    public static final URLType URL_TYPE_MAIL;
    public static final URLType URL_TYPE_HTTP;
    public static final URLType URL_TYPE_LOCAL;
    public static final URLType URL_TYPE_SUBFOLDER;
    public static final URLType URL_TYPE_REMOTE;
    public static final URLType URL_TYPE_LOCAL_REMOTE;
    public static final URLType URL_TYPE_LOCAL_HTTP;
    public static final URLType URL_TYPE_REMOTE_HTTP;
    public static final URLType URL_TYPE_LOCAL_RELATIVE;
    public static final URLType URL_TYPE_IMAGE;
    public static final URLType URL_TYPE_TEXT;
    private static final String[] d;

    public URLCollector(UnicodeURL unicodeURL, String string) {
        this.b = unicodeURL;
        this.c = string;
    }

    public Set<UnicodeURL> getUniqueUrls(URLType uRLType, String[] stringArray) throws IOException, InterruptedException {
        return new HashSet<UnicodeURL>(this.getUrls(uRLType, Arrays.asList(stringArray), Charset.UTF8));
    }

    public Set<UnicodeURL> getUniqueUrls(URLType uRLType) throws IOException, InterruptedException {
        return new HashSet<UnicodeURL>(this.getUrls(uRLType, null, Charset.UTF8));
    }

    public List<UnicodeURL> getUrls(URLType uRLType) throws IOException, InterruptedException {
        return this.getUrls(uRLType, null, Charset.UTF8);
    }

    public List<UnicodeURL> getUrls(URLType uRLType, Collection<String> collection, Charset charset) throws IOException, InterruptedException {
        int n2 = URLType.b;
        List<LinkDescription> list = this.getUrls(uRLType, collection, charset, false, null);
        ArrayList<UnicodeURL> arrayList = new ArrayList<UnicodeURL>();
        for (LinkDescription linkDescription : list) {
            arrayList.add(linkDescription.getLink());
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    public List<LinkDescription> getUrls(URLType uRLType, Collection<String> collection, Charset charset, boolean bl2, UnicodeURL unicodeURL) throws IOException, InterruptedException {
        try {
            Lexer lexer = new Lexer(this.c);
            NodeList nodeList = this.a(lexer);
            return this.a(uRLType, collection, charset, bl2, unicodeURL, lexer.getPage(), nodeList);
        }
        catch (ParserException parserException) {
            throw IOUtils.throwIOException(parserException);
        }
    }

    public List<UnicodeURL> getUrls(URLType uRLType, NodeList nodeList, Page page) throws InterruptedException {
        int n2 = URLType.b;
        List<LinkDescription> list = this.a(uRLType, null, Charset.UTF8, false, null, page, nodeList);
        ArrayList<UnicodeURL> arrayList = new ArrayList<UnicodeURL>();
        for (LinkDescription linkDescription : list) {
            arrayList.add(linkDescription.getLink());
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<LinkDescription> a(URLType uRLType, Collection<String> collection, Charset charset, boolean bl2, UnicodeURL unicodeURL, Page page, NodeList nodeList) throws InterruptedException {
        int n2 = URLType.b;
        Util.checkInterrupted();
        ArrayList<LinkDescription> arrayList = new ArrayList<LinkDescription>();
        for (int i2 = 0; i2 < nodeList.size(); ++i2) {
            LinkTag linkTag = (LinkTag)nodeList.elementAt(i2);
            if (linkTag.isJavascriptLink() && n2 == 0) continue;
            String string = StringUtil.trim(linkTag.getLink());
            string = URLCollector.removeMultipleSlash(StringUtil.decode(string));
            if (linkTag.isMailLink()) {
                string = d[15] + string;
            }
            String string2 = linkTag.getLinkText();
            try {
                Object object;
                UnicodeURL unicodeURL2;
                block26: {
                    block25: {
                        if (this.b != null) break block25;
                        unicodeURL2 = new UnicodeURL(this.b, string, charset);
                        if (n2 == 0) break block26;
                    }
                    unicodeURL2 = new UnicodeURL(this.a(string), charset, bl2);
                }
                if (!uRLType.accept(this.b, unicodeURL2, (Tag)linkTag)) continue;
                if (collection != null) {
                    string2 = StringUtil.isEmpty(string2) ? "" : string2.toLowerCase();
                    List<String> list = Arrays.asList(string2.split(d[16]));
                    object = unicodeURL2.getPath();
                    int n3 = ((String)object).lastIndexOf(47);
                    if (n3 != ((String)object).length() - 1) {
                        object = ((String)object).substring(n3);
                    }
                    List<String> list2 = Arrays.asList(((String)object).toLowerCase().split(d[14]));
                    for (String string3 : collection) {
                        if (list2.contains(string3) || list.contains(string3)) {
                            arrayList.add(new LinkDescription(unicodeURL2, unicodeURL, string2, page.row(linkTag.getStartPosition()), page.column(linkTag.getStartPosition()), page.row(linkTag.getEndPosition()), page.column(linkTag.getEndPosition())));
                            if (n2 == 0) break;
                        }
                        if (n2 == 0) continue;
                    }
                    if (n2 == 0) continue;
                }
                boolean bl3 = false;
                object = null;
                string2 = StringUtil.isEmpty(string2) ? "" : StringUtil.trimHTML(string2.replaceAll(d[13], " "));
                NodeList nodeList2 = linkTag.getChildren();
                for (int i3 = 0; nodeList2 != null && i3 < nodeList2.size(); ++i3) {
                    Node node = nodeList2.elementAt(i3);
                    if (!(node instanceof ImageTag)) continue;
                    bl3 = true;
                    try {
                        object = this.b == null ? new UnicodeURL(this.b, ((ImageTag)node).getImageURL(), charset) : new UnicodeURL(UrlUtils.resolveUrl(this.b.getIDNURL().toString(), ((ImageTag)node).getImageURL()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    string2 = ((ImageTag)node).getAttribute(d[17]);
                    break;
                }
                if (!bl3) {
                    string2 = StringUtil.decode(string2.replaceAll(d[18], ""));
                }
                arrayList.add(new LinkDescription(unicodeURL2, unicodeURL, string2, (UnicodeURL)object, bl3 ? AnchorType.IMAGE : AnchorType.TEXT, page.row(linkTag.getStartPosition()) + 1, page.column(linkTag.getStartPosition()), page.row(linkTag.getEndPosition()) + 1, page.column(linkTag.getEndPosition()), HtmlUtils.isNofollow((CompositeTag)linkTag)));
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    public static String removeMultipleSlash(String string) {
        int n2;
        String string2;
        String string3;
        block9: {
            if (string == null) {
                throw new IllegalArgumentException(String.format(d[4], d[7], d[11], d[10]));
            }
            string3 = "";
            string2 = "";
            n2 = string.indexOf(d[6]);
            if (n2 <= 0 || n2 >= 6) break block9;
            string3 = string.substring(0, n2 + 3);
            string = string.substring(n2 + 3);
        }
        if ((n2 = string.indexOf("?")) >= 0) {
            string2 = string.substring(n2);
            string = string.substring(0, n2);
        }
        String string4 = string3 + string.replaceAll(d[8], d[3]) + string2;
        if (string4 == null) {
            throw new IllegalStateException(String.format(d[12], d[9], d[5]));
        }
        return string4;
    }

    private String a(String string) {
        if (string.startsWith(d[2])) {
            string = this.b.getProtocol() + ":" + string;
        }
        return UrlUtils.resolveUrl(this.b.toString(), string);
    }

    private NodeList a(Lexer lexer) throws ParserException {
        Parser parser = new Parser(lexer);
        parser.setNodeFactory((NodeFactory)new LinkPrototypicalNodeFactory());
        return parser.extractAllNodesThatMatch((NodeFilter)new NodeClassFilter(LinkTag.class));
    }

    public static boolean isLocalURL(UnicodeURL unicodeURL, UnicodeURL unicodeURL2) {
        boolean bl2;
        block5: {
            block4: {
                boolean bl3 = UnicodeURLUtil.getHostWithoutWWW(unicodeURL2).equalsIgnoreCase(UnicodeURLUtil.getHostWithoutWWW(unicodeURL));
                if (!unicodeURL.getProtocol().contains(d[1]) || !unicodeURL2.getProtocol().contains(d[0])) break block4;
                bl2 = true;
                if (URLType.b == 0) break block5;
            }
            bl2 = unicodeURL2.getProtocol().equals(unicodeURL.getProtocol());
        }
        return bl3 &= bl2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[21];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "6\u0000^)$3w\\!_Qb\u001d}\u0018B\u0000L\\$A\u0000\u0012\"$6\u0000<_VWg=C[HtH^";
        int n3 = 20;
        block31: while (true) {
            char[] cArray;
            block36: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block35: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block35;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block36;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 109;
                                break;
                            }
                            case 1: {
                                n9 = 92;
                                break;
                            }
                            case 2: {
                                n9 = 97;
                                break;
                            }
                            case 3: {
                                n9 = 3;
                                break;
                            }
                            default: {
                                n9 = 120;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 20: {
                    ANCHOR_SPLIT_REGEX = string.intern();
                    string2 = "6s=.'1r<";
                    n3 = 21;
                    continue block31;
                }
                case 21: {
                    PATH_SPLIT_REGEX = string.intern();
                    string2 = "6\u0015\fb\u001f\b\u0001";
                    n3 = 22;
                    continue block31;
                }
                case 22: {
                    IMAGE_ANCHOR = string.intern();
                    string2 = "\u0005(\u0015s";
                    n3 = -1;
                    continue block31;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0005(\u0015s";
                    n3 = 0;
                    continue block31;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "Bs";
                    n3 = 1;
                    continue block31;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "ImN";
                    n3 = 2;
                    continue block31;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = ",.\u0006v\u0015\b2\u0015#\u001e\u0002.AC6\u0002(/v\u0014\u0001|\u0011b\n\f1\u0004w\u001d\u001f|F&\u000bJ|\u000eeXH/O&\u000bM1\u0014p\fM2\u000ewX\u000f9Am\r\u00010";
                    n3 = 3;
                    continue block31;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u001f9\fl\u000e\b\u0011\u0014o\f\u0004,\rf+\u0001=\u0012k";
                    n3 = 4;
                    continue block31;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "WsN";
                    n3 = 5;
                    continue block31;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u0018.\rP\f\u001f5\u000fd";
                    n3 = 6;
                    continue block31;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "ErH,\u0003_p\u001c";
                    n3 = 7;
                    continue block31;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u000e3\f,\u0019\n5\rf\u0015\u00042\u0005,\u001b\u00021\fl\u0016\u001es\blW\u001e9\u0000q\u001b\u00059\u000fd\u0011\u00039Nb\u0016\f0\u0018y\u001d\u001f/Nv\f\u00040NV*!\u001f\u000eo\u0014\b?\u0015l\n";
                    n3 = 8;
                    continue block31;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u001f9\fl\u000e\b\u0011\u0014o\f\u0004,\rf+\u0001=\u0012k";
                    n3 = 9;
                    continue block31;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u000e3\f,\u0019\n5\rf\u0015\u00042\u0005,\u001b\u00021\fl\u0016\u001es\blW\u001e9\u0000q\u001b\u00059\u000fd\u0011\u00039Nb\u0016\f0\u0018y\u001d\u001f/Nv\f\u00040NV*!\u001f\u000eo\u0014\b?\u0015l\n";
                    n3 = 10;
                    continue block31;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "-\u0012\u000ew6\u00180\r#\u0015\b(\tl\u001cMy\u0012-]\u001e|\fv\u000b\u0019|\u000fl\fM.\u0004w\r\u001f2Am\r\u00010";
                    n3 = 11;
                    continue block31;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "1z\u000fa\u000b\u001dg";
                    n3 = 12;
                    continue block31;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "6s=.'1r<";
                    n3 = 13;
                    continue block31;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "\u0000=\bo\f\u0002f";
                    n3 = 14;
                    continue block31;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "6\u0000^)$3w\\!_Qb\u001d}\u0018B\u0000L\\$A\u0000\u0012\"$6\u0000<_VWg=C[HtH^";
                    n3 = 15;
                    continue block31;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "\f0\u0015";
                    n3 = 16;
                    continue block31;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "Qs^_\u000fFrK<F";
                    n3 = 17;
                    continue block31;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "\u0000=\bo\f\u0002";
                    n3 = 18;
                    continue block31;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "\u0005(\u0015s";
                    n3 = 19;
                    continue block31;
                }
                case 19: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        d = stringArray3;
        a = LoggerFactory.getLogger(URLCollector.class);
        URL_TYPE_ALL = new l();
        URL_TYPE_MAIL = new t(d[19], null);
        URL_TYPE_HTTP = new t(d[20], null);
        URL_TYPE_LOCAL = new CompositeURLType(new m(), new NotURLType(URL_TYPE_MAIL));
        URL_TYPE_SUBFOLDER = new n();
        URL_TYPE_REMOTE = new CompositeURLType(new o(), new NotURLType(URL_TYPE_MAIL));
        URL_TYPE_LOCAL_REMOTE = new NotURLType(URL_TYPE_MAIL);
        URL_TYPE_LOCAL_HTTP = new CompositeURLType(URL_TYPE_LOCAL, URL_TYPE_HTTP);
        URL_TYPE_REMOTE_HTTP = new CompositeURLType(URL_TYPE_REMOTE, URL_TYPE_HTTP);
        URL_TYPE_LOCAL_RELATIVE = new CompositeURLType(URL_TYPE_LOCAL, new p());
        URL_TYPE_IMAGE = new r();
        URL_TYPE_TEXT = new s();
    }

    public static class LinkDescription {
        private UnicodeURL a;
        private UnicodeURL b;
        private String c;
        private UnicodeURL d;
        private int e;
        private int f;
        private int g;
        private int h;
        private AnchorType i;
        private boolean j;

        public LinkDescription(UnicodeURL unicodeURL, UnicodeURL unicodeURL2, String string, int n2, int n3, int n4, int n5) {
            this(unicodeURL, unicodeURL2, string, null, AnchorType.TEXT, n2, n3, n4, n5, false);
        }

        public LinkDescription(UnicodeURL unicodeURL, UnicodeURL unicodeURL2, String string, UnicodeURL unicodeURL3, AnchorType anchorType, int n2, int n3, int n4, int n5, boolean bl2) {
            this.a = unicodeURL;
            this.c = string;
            this.d = unicodeURL3;
            this.e = n2;
            this.f = n3;
            this.b = unicodeURL2;
            this.i = anchorType;
            this.g = n4;
            this.h = n5;
            this.j = bl2;
        }

        public UnicodeURL getLink() {
            return this.a;
        }

        public String getAnchorText() {
            return this.c;
        }

        public int getRow() {
            return this.e;
        }

        public int getColumn() {
            return this.f;
        }

        public int getEndRow() {
            return this.g;
        }

        public int getEndColumn() {
            return this.h;
        }

        public UnicodeURL getSourceLink() {
            return this.b;
        }

        public AnchorType getAnchorType() {
            return this.i;
        }

        public UnicodeURL getImageSrc() {
            return this.d;
        }

        public boolean isNofollow() {
            return this.j;
        }
    }

    public static final class AnchorType
    extends Enum<AnchorType> {
        public static final /* enum */ AnchorType TEXT;
        public static final /* enum */ AnchorType IMAGE;
        private static final /* synthetic */ AnchorType[] a;
        private static final String[] b;

        public static AnchorType[] values() {
            return (AnchorType[])a.clone();
        }

        public static AnchorType valueOf(String string) {
            return Enum.valueOf(AnchorType.class, string);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "o<r'w";
            int n3 = -1;
            block9: while (true) {
                char[] cArray;
                block14: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block13: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block13;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block14;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 38;
                                    break;
                                }
                                case 1: {
                                    n9 = 113;
                                    break;
                                }
                                case 2: {
                                    n9 = 51;
                                    break;
                                }
                                case 3: {
                                    n9 = 96;
                                    break;
                                }
                                default: {
                                    n9 = 50;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "r4k4";
                        n3 = 0;
                        continue block9;
                    }
                    case 0: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            b = stringArray3;
            TEXT = new AnchorType();
            IMAGE = new AnchorType();
            a = new AnchorType[]{TEXT, IMAGE};
        }
    }

    public static class CompositeURLType
    extends URLType {
        private URLType a;
        private URLType c;

        public CompositeURLType(URLType uRLType, URLType uRLType2) {
            this.a = uRLType;
            this.c = uRLType2;
        }

        @Override
        public boolean accept(UnicodeURL unicodeURL, UnicodeURL unicodeURL2, Tag tag) {
            return this.a.accept(unicodeURL, unicodeURL2, tag) && this.c.accept(unicodeURL, unicodeURL2, tag);
        }
    }

    public static class NotURLType
    extends URLType {
        private URLType a;

        public NotURLType(URLType uRLType) {
            this.a = uRLType;
        }

        @Override
        public boolean accept(UnicodeURL unicodeURL, UnicodeURL unicodeURL2, Tag tag) {
            return !this.a.accept(unicodeURL, unicodeURL2, tag);
        }
    }

    public static abstract class URLType {
        public static int b;

        public abstract boolean accept(UnicodeURL var1, UnicodeURL var2, Tag var3);
    }
}

