/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.searchengine.analyzers.util;

import com.agilemind.commons.io.pagereader.HttpResponseIOExeption;
import com.agilemind.commons.io.pagereader.PageReader;
import com.agilemind.commons.io.pagereader.PageReaderContent;
import com.agilemind.commons.io.pagereader.ReadURLSettings;
import com.agilemind.commons.io.searchengine.analyzers.util.TooManyRedirectsException;
import com.agilemind.commons.io.searchengine.analyzers.util.URLCollector;
import com.agilemind.commons.localization.stringkey.CommonsStringKey;
import com.agilemind.commons.util.Charset;
import com.agilemind.commons.util.OperationLogger;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLUtil;
import com.agilemind.commons.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class URLsGetter {
    private PageReader a;
    private int b;
    private String c;
    private ReadURLSettings d;
    private OperationLogger e;
    private static final String[] f;

    public URLsGetter(PageReader pageReader, int n2, String string, ReadURLSettings readURLSettings, OperationLogger operationLogger) {
        this.a = pageReader;
        this.b = n2;
        this.c = string;
        this.d = readURLSettings;
        this.e = operationLogger;
    }

    public Map<UnicodeURL, UnicodeURL> getUniqueUrlsFromPage(UnicodeURL unicodeURL, int n2, URLCollector.URLType uRLType) throws Exception {
        int n3 = URLCollector.URLType.b;
        List<URLCollector.LinkDescription> list = this.getUrlsFromPage(unicodeURL, n2, uRLType);
        HashMap<UnicodeURL, UnicodeURL> hashMap = new HashMap<UnicodeURL, UnicodeURL>();
        if (list != null) {
            for (URLCollector.LinkDescription linkDescription : list) {
                hashMap.put(linkDescription.getLink(), linkDescription.getSourceLink());
                if (n3 == 0) continue;
            }
        }
        return hashMap;
    }

    public List<URLCollector.LinkDescription> getUrlsFromPage(UnicodeURL unicodeURL, int n2, URLCollector.URLType uRLType) throws Exception {
        block10: {
            PageReaderContent pageReaderContent = this.a.getContent(unicodeURL, new ReadURLSettings(this.d, true, false));
            Util.checkInterrupted();
            if (pageReaderContent.needRedirect()) {
                return this.a(pageReaderContent, n2, uRLType);
            }
            if (pageReaderContent.getPageBytes().length == 0) {
                return null;
            }
            try {
                String string = pageReaderContent.createPage();
                Util.checkInterrupted();
                if (StringUtil.isEmpty(string) || this.b == 0) break block10;
                URLCollector uRLCollector = new URLCollector(unicodeURL, string);
                Charset charset = Charset.findCharsetByName(pageReaderContent.getContentEncoding());
                List<URLCollector.LinkDescription> list = uRLCollector.getUrls(uRLType, null, charset, true, unicodeURL);
                this.e.log(new CommonsStringKey(f[5]).getString(unicodeURL, URLsGetter.b(list).size()));
                return list;
            }
            catch (IOException iOException) {
                this.e.log(new CommonsStringKey(f[4]).getString(unicodeURL));
            }
        }
        return new ArrayList<URLCollector.LinkDescription>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<URLCollector.LinkDescription> a(PageReaderContent pageReaderContent, int n2, URLCollector.URLType uRLType) throws Exception {
        List<URLCollector.LinkDescription> list;
        if (n2 >= 9) {
            throw new TooManyRedirectsException(f[6] + n2);
        }
        UnicodeURL unicodeURL = pageReaderContent.getRedirectUrl();
        if (unicodeURL == null || !URLsGetter.isSameHost(unicodeURL, this.c)) return new ArrayList<URLCollector.LinkDescription>();
        unicodeURL = new UnicodeURL(URLCollector.removeMultipleSlash(unicodeURL.toString()));
        UnicodeURL unicodeURL2 = pageReaderContent.getRequestURL();
        this.checkDoubleLinks(unicodeURL2, unicodeURL);
        try {
            list = this.getUrlsFromPage(unicodeURL, ++n2, uRLType);
        }
        catch (HttpResponseIOExeption httpResponseIOExeption) {
            if (httpResponseIOExeption.getResponseCode() < 400 || httpResponseIOExeption.getResponseCode() >= 600) throw httpResponseIOExeption;
            list = new ArrayList<URLCollector.LinkDescription>(1);
            if (URLCollector.URLType.b != 0) {
                throw httpResponseIOExeption;
            }
        }
        if (list == null || this.a(list)) return list;
        list.add(new URLCollector.LinkDescription(unicodeURL, null, null, 0, 0, 0, 0));
        return list;
    }

    private boolean a(List<URLCollector.LinkDescription> list) {
        int n2 = URLCollector.URLType.b;
        if (list == null) {
            throw new IllegalArgumentException(String.format(f[3], f[1], f[2], f[0]));
        }
        for (URLCollector.LinkDescription linkDescription : list) {
            if (URLsGetter.a(linkDescription)) {
                return true;
            }
            if (n2 == 0) continue;
        }
        return false;
    }

    private static Set<UnicodeURL> b(List<URLCollector.LinkDescription> list) {
        int n2 = URLCollector.URLType.b;
        HashSet<UnicodeURL> hashSet = new HashSet<UnicodeURL>();
        for (URLCollector.LinkDescription linkDescription : list) {
            hashSet.add(linkDescription.getLink());
            if (n2 == 0) continue;
        }
        return hashSet;
    }

    protected static boolean isDiffOnlySlash(UnicodeURL unicodeURL, UnicodeURL unicodeURL2) {
        block13: {
            String string = unicodeURL.getQuery();
            String string2 = unicodeURL2.getQuery();
            boolean bl2 = string == null;
            boolean bl3 = string2 == null;
            if (bl2 ^ bl3) {
                return false;
            }
            if (string == null || string.equals(string2)) break block13;
            return false;
        }
        String string = unicodeURL.getPath();
        String string3 = unicodeURL2.getPath();
        boolean bl4 = string.length() > string3.length() ? URLsGetter.a(string3, string) : URLsGetter.a(string, string3);
        return bl4;
    }

    private static boolean a(String string, String string2) {
        boolean bl2;
        block5: {
            block4: {
                if (string2.charAt(string2.length() - 1) != '/' || !string.equals(string2.substring(0, string2.length() - 1))) break block4;
                bl2 = true;
                break block5;
            }
            bl2 = false;
        }
        return bl2;
    }

    public void checkDoubleLinks(UnicodeURL unicodeURL, UnicodeURL unicodeURL2) {
    }

    public static boolean isSameHost(UnicodeURL unicodeURL, String string) {
        block6: {
            String string2 = UnicodeURLUtil.getHostWithoutWWW(unicodeURL);
            if (StringUtil.isEmpty(string2) && !unicodeURL.isLocal()) break block6;
            if (!string2.equalsIgnoreCase(string)) break block6;
            return true;
        }
        return false;
    }

    public static boolean isProperUrlByExtension(String string, boolean bl2, Pattern[] patternArray) {
        block7: {
            if (!bl2 || string.contains(".")) break block7;
            return true;
        }
        if (patternArray == null) {
            return false;
        }
        return StringUtil.anyFind(string, patternArray);
    }

    private static boolean a(URLCollector.LinkDescription linkDescription) {
        boolean bl2 = linkDescription.getSourceLink() == null;
        return bl2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u000e\u001b'1<\u0004\u001a:\u00178\t\u001d; >\u0019\u0011-\t4\u0003\u001f\r .\u000e\u0006 5)\u0004\u001b'6";
        int n3 = -1;
        block14: while (true) {
            char[] cArray;
            block19: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block18: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block18;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block19;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 109;
                                break;
                            }
                            case 1: {
                                n9 = 116;
                                break;
                            }
                            case 2: {
                                n9 = 73;
                                break;
                            }
                            case 3: {
                                n9 = 69;
                                break;
                            }
                            default: {
                                n9 = 93;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0018\u0006%6\u001b\u001f\u001b$\u0015<\n\u0011";
                    n3 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u000e\u001b$j<\n\u001d% 0\u0004\u001a-j>\u0002\u0019$*3\u001e[ *r\u001e\u0011(7>\u0005\u0011'\"4\u0003\u0011f$3\f\u00180?8\u001f\u0007f0)\u0004\u0018f\u0010\u000f!\u0007\u000e )\u0019\u0011;";
                    n3 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = ",\u0006.00\b\u001a=e;\u0002\u0006i\u0005\u0013\u0002\u0000\u000701\u0001T9$/\f\u0019,18\u001fTn`.JT&#}H\u0007g`.M\u0019<6)M\u001a&1}\u000f\u0011i+(\u0001\u0018";
                    n3 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0001\u001b(!\r\f\u0013,\u0011<\u001e\u001fg,2(\f* -\u0019\u001d&+";
                    n3 = 3;
                    continue block14;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0001\u001b(!\r\f\u0013,\u0011<\u001e\u001fg6(\u000e\u0017,6.";
                    n3 = 4;
                    continue block14;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "9\u001b&e0\f\u001a0e/\b\u0010 78\u000e\u0000iepST";
                    n3 = 5;
                    continue block14;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        f = stringArray3;
    }
}

