/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.searchengine.analyzers.util;

import com.agilemind.commons.io.searchengine.analyzers.util.Flags;
import com.agilemind.commons.io.searchengine.analyzers.util.URLCollector;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.oro.text.perl.Perl5Util;

public class UrlValidator
implements Serializable {
    public static final int ALLOW_ALL_SCHEMES = 1;
    public static final int ALLOW_2_SLASHES = 2;
    public static final int NO_FRAGMENTS = 4;
    private Flags a = null;
    private Set<String> b = new HashSet<String>();
    protected String[] defaultSchemes = new String[]{c[7], c[8], c[9]};
    private static final String[] c;

    public UrlValidator() {
        this(null);
    }

    public UrlValidator(String[] stringArray) {
        this(stringArray, 0);
    }

    public UrlValidator(int n2) {
        this(null, n2);
    }

    public UrlValidator(String[] stringArray, int n2) {
        this.a = new Flags(n2);
        if (this.a.isOn(1L)) {
            return;
        }
        if (stringArray == null) {
            stringArray = this.defaultSchemes;
        }
        this.b.addAll(Arrays.asList(stringArray));
    }

    public boolean isValid(String string) {
        if (string == null) {
            return false;
        }
        Perl5Util perl5Util = new Perl5Util();
        Perl5Util perl5Util2 = new Perl5Util();
        if (!perl5Util2.match(c[14], string)) {
            return false;
        }
        if (!perl5Util.match(c[15], string)) {
            return false;
        }
        if (!this.isValidScheme(perl5Util.group(2))) {
            return false;
        }
        if (!this.isValidAuthority(perl5Util.group(4))) {
            return false;
        }
        if (!this.isValidPath(perl5Util.group(5))) {
            return false;
        }
        if (!this.isValidQuery(perl5Util.group(7))) {
            return false;
        }
        return this.isValidFragment(perl5Util.group(9));
    }

    protected boolean isValidScheme(String string) {
        block10: {
            if (string == null) {
                return false;
            }
            Perl5Util perl5Util = new Perl5Util();
            if (!perl5Util.match(c[10], string)) {
                return false;
            }
            if (!this.a.isOff(1L) || this.b.contains(string)) break block10;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isValidAuthority(String string) {
        Perl5Util perl5Util;
        boolean bl2;
        String string3;
        boolean bl3;
        Perl5Util perl5Util2;
        int n2;
        block31: {
            block30: {
                n2 = URLCollector.URLType.b;
                if (string == null) {
                    return false;
                }
                perl5Util2 = new Perl5Util();
                Perl5Util perl5Util22 = new Perl5Util();
                if (!perl5Util2.match(c[6], string)) {
                    return false;
                }
                bl3 = false;
                string3 = perl5Util2.group(1);
                bl2 = perl5Util22.match(c[1], string3);
                if (!bl2) break block30;
                for (int i2 = 1; i2 <= 4; ++i2) {
                    String string2 = perl5Util22.group(i2);
                    if (string2 == null || string2.length() <= 0) {
                        return false;
                    }
                    try {
                        if (Integer.parseInt(string2) <= 255) continue;
                        return false;
                    }
                    catch (NumberFormatException stringArray) {
                        return false;
                    }
                }
                if (n2 == 0) break block31;
            }
            Perl5Util perl5Util3 = new Perl5Util();
            bl3 = perl5Util3.match(c[5], string3);
        }
        if (bl3) {
            String string2;
            char[] cArray = string3.toCharArray();
            int n4 = 1;
            for (char c2 : cArray) {
                if (c2 != '.') continue;
                ++n4;
                if (n2 == 0) continue;
            }
            String[] stringArray = new String[n4];
            int n3 = 1;
            int n5 = 0;
            Perl5Util perl5Util3 = new Perl5Util();
            while (n3 != 0) {
                n3 = perl5Util3.match(c[4], string3) ? 1 : 0;
                if (n3 == 0) continue;
                stringArray[n5] = perl5Util3.group(1);
                int n6 = stringArray[n5].length() + 1;
                string3 = n6 >= string3.length() ? "" : string3.substring(n6);
                ++n5;
                if (n2 == 0) continue;
            }
            if ((string2 = stringArray[n5 - 1]).length() < 2 || string2.length() > 4) {
                return false;
            }
            Perl5Util perl5Util4 = new Perl5Util();
            if (!perl5Util4.match(c[3], string2.substring(0, 1))) {
                return false;
            }
            if (n5 < 2) {
                return false;
            }
        }
        if (!bl3 && !bl2) {
            return false;
        }
        String string6 = perl5Util2.group(2);
        if (string6 != null && !(perl5Util = new Perl5Util()).match(c[2], string6)) {
            return false;
        }
        String string4 = perl5Util2.group(3);
        return UrlValidator.a(string4);
    }

    protected boolean isValidPath(String string) {
        block15: {
            int n2;
            block14: {
                if (string == null) {
                    return false;
                }
                Perl5Util perl5Util = new Perl5Util();
                if (!perl5Util.match(c[11], string)) {
                    return false;
                }
                n2 = this.countToken(c[13], string);
                if (!this.a.isOff(2L) || n2 <= 0) break block14;
                return false;
            }
            int n3 = this.countToken("/", string);
            int n4 = this.countToken(c[12], string);
            if (n4 <= 0 || n3 - n2 - 1 > n4) break block15;
            return false;
        }
        return true;
    }

    protected boolean isValidQuery(String string) {
        if (string == null) {
            return true;
        }
        Perl5Util perl5Util = new Perl5Util();
        return perl5Util.match(c[0], string);
    }

    protected boolean isValidFragment(String string) {
        boolean bl2;
        block5: {
            block4: {
                if (string != null && !this.a.isOff(4L)) break block4;
                bl2 = true;
                break block5;
            }
            bl2 = false;
        }
        return bl2;
    }

    protected int countToken(String string, String string2) {
        int n2 = URLCollector.URLType.b;
        int n3 = 0;
        int n4 = 0;
        while (n3 != -1) {
            if ((n3 = string2.indexOf(string, n3)) <= -1) continue;
            ++n3;
            ++n4;
            if (n2 == 0) continue;
        }
        return n4;
    }

    private static boolean a(String string) {
        boolean bl2;
        block5: {
            block4: {
                if (string != null && string.trim().length() != 0) break block4;
                bl2 = true;
                break block5;
            }
            bl2 = false;
        }
        return bl2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[16];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "z\u0006T#\u000f||S";
        int n3 = -1;
        block23: while (true) {
            char[] cArray;
            block28: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block27: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block27;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block28;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 85;
                                break;
                            }
                            case 1: {
                                n9 = 88;
                                break;
                            }
                            case 2: {
                                n9 = 124;
                                break;
                            }
                            case 3: {
                                n9 = 13;
                                break;
                            }
                            default: {
                                n9 = 37;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "z\u0006TQA.iP>X|\u0003RP\r\t<\u0007<\tf%UV\u000b\bp i^dtOp\f\u000ev!%y1#M!\u0016(qX\"";
                    n3 = 0;
                    continue block23;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "z\u0006F%y1#M!\u0010(qX\"";
                    n3 = 1;
                    continue block23;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "z\u0006'l\b/\u0019QWxz";
                    n3 = 2;
                    continue block23;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "zp'Sy&cSM\u0003htR2\u001f~|!&\fz";
                    n3 = 3;
                    continue block23;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "z\u0006'Sy&cSM\u0003htR2\u001f~|!&\r\tv'Sy&cSM\u0003htR2\u001f~|!&\f\u007f|S";
                    n3 = 4;
                    continue block23;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "z\u0006TVDx\"= \u007f\t<  y{\u0005V$\ro\u0004\u0018'\fjpR'\fjw";
                    n3 = 5;
                    continue block23;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "=,\b}";
                    n3 = 6;
                    continue block23;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "=,\b}V";
                    n3 = 7;
                    continue block23;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "3,\f";
                    n3 = 8;
                    continue block23;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "z\u0006'l\b/\u0019QWxz";
                    n3 = 9;
                    continue block23;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "z\u0006T\"~x\u0004\u000b7esgA&\t{ySs\u000fr}XR\u001e\brU2\u0001z";
                    n3 = 10;
                    continue block23;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "{v";
                    n3 = 11;
                    continue block23;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "zw";
                    n3 = 12;
                    continue block23;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "z\u0006'Q\u0015ehQQ\u0014bo!&\u0001z";
                    n3 = 13;
                    continue block23;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "z\u0006T%~\u000bbS2\u0006\bsU7\fjpS\"\r\u000e\u0006S2\u0006\brU$\u001a}\u0003\"2\u0006\brU%yjp'S\u0006\brU$\u001a}{T#\u000f|qC\"";
                    n3 = 14;
                    continue block23;
                }
                case 14: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        c = stringArray3;
    }
}

