/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.searchengine.analyzers.util;

import com.agilemind.commons.io.pagereader.PageReader;
import com.agilemind.commons.io.searchengine.analyzers.util.URLCollector;
import com.agilemind.commons.io.searchengine.captcha.SearchEngineManager;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngine;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngineQuery;
import com.agilemind.commons.io.searchengine.searchengines.SearchResults;
import com.agilemind.commons.util.OperationLogger;
import com.agilemind.commons.util.UnicodeURL;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class UrlsAnalyzer {
    private SearchEngine a;
    private SearchEngineManager b;

    public UrlsAnalyzer(SearchEngine searchEngine, SearchEngineManager searchEngineManager) {
        this.a = searchEngine;
        this.b = searchEngineManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<UnicodeURL> getUrls(PageReader pageReader, String string, int n2, Date date) throws IOException, InterruptedException {
        int n3 = URLCollector.URLType.b;
        LinkedHashSet<UnicodeURL> linkedHashSet = new LinkedHashSet<UnicodeURL>();
        if (n2 <= 0) {
            return linkedHashSet;
        }
        boolean bl2 = false;
        SearchResults searchResults = this.a.search(pageReader, this.b, OperationLogger.EMPTY_OPERATION_LOGGER, new SearchEngineQuery.Keyword(string), date);
        block2: do {
            List<SearchResults.Result> list = searchResults.getFoundResults();
            for (SearchResults.Result result : list) {
                UnicodeURL unicodeURL = result.getFoundURL();
                linkedHashSet.add(unicodeURL);
                if (linkedHashSet.size() == n2) {
                    bl2 = true;
                    if (n3 == 0) continue block2;
                }
                if (n3 == 0) continue;
            }
        } while (!bl2 && (searchResults = searchResults.getNextPageSearch()) != null);
        return linkedHashSet;
    }
}

