/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.searchengine.searchengines;

import com.agilemind.commons.io.searchengine.searchengines.BackLinkSearchEngine;
import com.agilemind.commons.io.searchengine.searchengines.CacheIndexedSearchEngine;
import com.agilemind.commons.io.searchengine.searchengines.DirectSearchEngine;
import com.agilemind.commons.io.searchengine.searchengines.PageIndexedSearchEngine;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngine;
import com.agilemind.commons.io.searchengine.searchengines.SearchEnginePagination;
import com.agilemind.commons.io.searchengine.searchengines.SiteIndexedSearchEngine;
import com.agilemind.commons.io.searchengine.searchengines.WebBasedSearchEngine;
import com.agilemind.commons.util.UnicodeURL;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;

public abstract class SearchEngineQuery<T> {
    private int a;
    private boolean b;
    private SearchEnginePagination.PerPage c;

    SearchEngineQuery(SearchEnginePagination.PerPage perPage, int n2, boolean bl2) {
        this.c = perPage;
        this.a = n2;
        this.b = bl2;
    }

    public abstract SearchEngine.SearchEngineParser getSearchEngineParser(SearchEngine var1);

    public abstract T getSearchQuery();

    public int getPage() {
        return this.a;
    }

    public int getUrlsPerPage(SearchEngine searchEngine) {
        return this.c.getPerPage(this.getSearchEngineParser(searchEngine).getLinksPerPage());
    }

    public int getPreviousResults(SearchEngine searchEngine) {
        return this.a * this.getUrlsPerPage(searchEngine);
    }

    public boolean isWithOmittedResults() {
        return this.b;
    }

    public static class PageIndexed
    extends SearchEngineQuery<UnicodeURL> {
        private UnicodeURL d;

        public PageIndexed(UnicodeURL unicodeURL) {
            super(SearchEnginePagination.MIN, 0, false);
            this.d = unicodeURL;
        }

        @Override
        public SearchEngine.SearchEngineParser getSearchEngineParser(SearchEngine searchEngine) {
            PageIndexedSearchEngine pageIndexedSearchEngine = (PageIndexedSearchEngine)((Object)searchEngine);
            return pageIndexedSearchEngine.getPageIndexedParser();
        }

        @Override
        public UnicodeURL getSearchQuery() {
            return this.d;
        }
    }

    public static class CacheIndexed
    extends SearchEngineQuery<UnicodeURL> {
        private UnicodeURL d;

        public CacheIndexed(UnicodeURL unicodeURL) {
            this(unicodeURL, SearchEnginePagination.MIN);
        }

        public CacheIndexed(UnicodeURL unicodeURL, SearchEnginePagination.PerPage perPage) {
            this(unicodeURL, perPage, 0);
        }

        public CacheIndexed(UnicodeURL unicodeURL, SearchEnginePagination.PerPage perPage, int n2) {
            this(unicodeURL, perPage, n2, false);
        }

        public CacheIndexed(UnicodeURL unicodeURL, SearchEnginePagination.PerPage perPage, int n2, boolean bl2) {
            super(perPage, n2, bl2);
            this.d = unicodeURL;
        }

        @Override
        public UnicodeURL getSearchQuery() {
            return this.d;
        }

        @Override
        public SearchEngine.SearchEngineParser getSearchEngineParser(SearchEngine searchEngine) {
            CacheIndexedSearchEngine cacheIndexedSearchEngine = (CacheIndexedSearchEngine)((Object)searchEngine);
            return cacheIndexedSearchEngine.getCacheIndexedParser();
        }
    }

    public static class SiteIndexed
    extends SearchEngineQuery<UnicodeURL> {
        private UnicodeURL d;
        private boolean e;

        public SiteIndexed(UnicodeURL unicodeURL) {
            this(unicodeURL, SearchEnginePagination.MIN, true);
        }

        public SiteIndexed(UnicodeURL unicodeURL, SearchEnginePagination.PerPage perPage, boolean bl2) {
            this(unicodeURL, perPage, bl2, 0);
        }

        public SiteIndexed(UnicodeURL unicodeURL, SearchEnginePagination.PerPage perPage, boolean bl2, int n2) {
            this(unicodeURL, perPage, bl2, n2, false);
        }

        public SiteIndexed(UnicodeURL unicodeURL, SearchEnginePagination.PerPage perPage, boolean bl2, int n2, boolean bl3) {
            super(perPage, n2, bl3);
            this.d = unicodeURL;
            this.e = bl2;
        }

        @Override
        public UnicodeURL getSearchQuery() {
            return this.d;
        }

        public boolean isShowLinksToThisURLOnly() {
            return this.e;
        }

        @Override
        public SearchEngine.SearchEngineParser getSearchEngineParser(SearchEngine searchEngine) {
            SiteIndexedSearchEngine siteIndexedSearchEngine = (SiteIndexedSearchEngine)((Object)searchEngine);
            return siteIndexedSearchEngine.getSiteIndexedParser();
        }
    }

    public static class BackLink
    extends SearchEngineQuery<UnicodeURL> {
        private UnicodeURL d;
        private boolean e;
        private boolean f;

        public BackLink(UnicodeURL unicodeURL) {
            this(unicodeURL, SearchEnginePagination.MIN, true, true);
        }

        public BackLink(UnicodeURL unicodeURL, SearchEnginePagination.PerPage perPage, boolean bl2, boolean bl3) {
            this(unicodeURL, perPage, bl2, bl3, 0, false);
        }

        public BackLink(UnicodeURL unicodeURL, SearchEnginePagination.PerPage perPage, boolean bl2, boolean bl3, int n2, boolean bl4) {
            super(perPage, n2, bl4);
            this.d = unicodeURL;
            this.e = bl2;
            this.f = bl3;
        }

        @Override
        public UnicodeURL getSearchQuery() {
            return this.d;
        }

        public boolean isShowLinksToThisURLOnly() {
            return this.e;
        }

        public boolean isExceptFromDomain() {
            return this.f;
        }

        @Override
        public SearchEngine.SearchEngineParser getSearchEngineParser(SearchEngine searchEngine) {
            BackLinkSearchEngine backLinkSearchEngine = (BackLinkSearchEngine)((Object)searchEngine);
            return backLinkSearchEngine.getBackLinksParser();
        }
    }

    public static class Cached
    extends SearchEngineQuery<UnicodeURL> {
        private UnicodeURL d;

        public Cached(UnicodeURL unicodeURL) {
            super(SearchEnginePagination.MIN, 0, false);
            this.d = unicodeURL;
        }

        @Override
        public UnicodeURL getSearchQuery() {
            return this.d;
        }

        @Override
        public SearchEngine.SearchEngineParser getSearchEngineParser(SearchEngine searchEngine) {
            CacheIndexedSearchEngine cacheIndexedSearchEngine = (CacheIndexedSearchEngine)((Object)searchEngine);
            return cacheIndexedSearchEngine.getCacheIndexedParser();
        }
    }

    public static class Keyword
    extends SearchEngineQuery<String> {
        private String d;
        private boolean e;

        public Keyword(String string) {
            this(string, SearchEnginePagination.MIN, false);
        }

        public Keyword(String string, SearchEnginePagination.PerPage perPage, boolean bl2) {
            this(string, perPage, 0, bl2);
        }

        public Keyword(String string, SearchEnginePagination.PerPage perPage, int n2, boolean bl2) {
            this(string, perPage, n2, false, bl2);
        }

        public Keyword(String string, SearchEnginePagination.PerPage perPage, int n2, boolean bl2, boolean bl3) {
            super(perPage, n2, bl2);
            this.d = string;
            this.e = bl3;
        }

        @Override
        public String getSearchQuery() {
            return this.d;
        }

        @Override
        public SearchEngine.SearchEngineParser getSearchEngineParser(SearchEngine searchEngine) {
            DirectSearchEngine directSearchEngine = (DirectSearchEngine)((Object)searchEngine);
            return directSearchEngine.getQueryParser();
        }

        public UnicodeURL getSearchQueryURL(WebBasedSearchEngine webBasedSearchEngine) throws MalformedURLException, UnsupportedEncodingException {
            WebBasedSearchEngine.WebBasedSearchEngineParser webBasedSearchEngineParser = (WebBasedSearchEngine.WebBasedSearchEngineParser)this.getSearchEngineParser(webBasedSearchEngine);
            return webBasedSearchEngineParser.getSearchQueryURL(this);
        }

        public boolean isUseUniversalSearch() {
            return this.e;
        }
    }
}

