/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.searchengine.spider;

import com.agilemind.commons.io.pagereader.IConnectionSettings;
import com.agilemind.commons.io.pagereader.PageReader;
import com.agilemind.commons.io.pagereader.PageReaderFactory;
import com.agilemind.commons.io.searchengine.spider.SpiderFilter;
import com.agilemind.commons.io.searchengine.spider.SpiderLimit;
import com.agilemind.commons.io.searchengine.spider.SpiderTask;
import com.agilemind.commons.localization.stringkey.StringKey;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class Spider {
    private Map<String, Integer> a = new HashMap<String, Integer>();
    private SpiderLimit b;
    PageReader c;
    private SpiderFilter d;

    protected Spider(IConnectionSettings iConnectionSettings, SpiderFilter spiderFilter) {
        this.c = PageReaderFactory.getInstance(iConnectionSettings).createPageReaderForNonSearchEngine();
        this.d = spiderFilter;
    }

    public synchronized void setLimit(SpiderLimit spiderLimit) {
        this.b = spiderLimit;
    }

    public void collectURLs(UnicodeURL unicodeURL) throws InterruptedException, IOException {
        this.addTask(0, unicodeURL, this);
    }

    protected abstract void addTask(int var1, UnicodeURL var2, Spider var3) throws InterruptedException, IOException;

    public synchronized SpiderLimit getLimit() {
        return this.b;
    }

    public synchronized void proceedLocalURL(UnicodeURL unicodeURL, SpiderTask spiderTask) throws InterruptedException, IOException {
        block6: {
            String string = UnicodeURLUtil.getPage(unicodeURL).toIDNString().toLowerCase();
            if (!this.b.check(this, spiderTask, unicodeURL) || !this.notProceeded(string, spiderTask)) break block6;
            if (!this.d.accept(unicodeURL)) break block6;
            this.addTask(spiderTask.getDeep() + 1, unicodeURL, this);
        }
    }

    protected boolean notProceeded(String string, SpiderTask spiderTask) {
        int n2 = SpiderLimit.b;
        Integer n3 = this.a.get(string);
        int n4 = spiderTask.getDeep();
        if (n3 == null) {
            this.a.put(string, n4);
            return true;
        }
        if (n4 < n3) {
            this.a.put(string, n4);
            return true;
        }
        if (StringKey.c) {
            SpiderLimit.b = ++n2;
        }
        return false;
    }

    public static class ThisPageOnlyLimit
    extends UpToNDeepLinksLimit {
        public ThisPageOnlyLimit() {
            super(0);
        }
    }

    public static class UpToNPagesLimit
    extends SpiderLimit {
        public UpToNPagesLimit() {
        }

        public UpToNPagesLimit(int n2) {
            super(n2);
        }

        @Override
        public boolean check(Spider spider, SpiderTask spiderTask, UnicodeURL unicodeURL) {
            return spider.a.size() < this.getLimit();
        }
    }

    public static class UpToNDeepLinksLimit
    extends SpiderLimit {
        public UpToNDeepLinksLimit() {
        }

        public UpToNDeepLinksLimit(int n2) {
            super(n2);
        }

        @Override
        public boolean check(Spider spider, SpiderTask spiderTask, UnicodeURL unicodeURL) {
            return spiderTask.getDeep() < this.getLimit();
        }
    }

    public static class DontLimit
    extends SpiderLimit {
        @Override
        public boolean check(Spider spider, SpiderTask spiderTask, UnicodeURL unicodeURL) {
            return true;
        }
    }
}

