/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.modules.concurrent.util.operations;

import com.agilemind.commons.localization.IStringKey;
import com.agilemind.commons.localization.exception.ILocalizedException;
import com.agilemind.commons.localization.stringkey.CommonsStringKey;
import com.agilemind.commons.localization.stringkey.OperationConstants;
import com.agilemind.commons.localization.stringkey.StringKey;
import com.agilemind.commons.modules.concurrent.util.operations.CompositeOperation;
import com.agilemind.commons.modules.concurrent.util.operations.OperationState;
import com.agilemind.commons.modules.concurrent.util.operations.events.OperationProgressEvent;
import com.agilemind.commons.modules.concurrent.util.operations.events.OperationProgressListener;
import com.agilemind.commons.modules.concurrent.util.operations.events.OperationStateEvent;
import com.agilemind.commons.util.OperationLogger;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Operation
implements OperationLogger,
OperationConstants {
    private final IStringKey a;
    private final boolean b;
    private final boolean c;
    private String d;
    private final Object e;
    private OperationState f;
    private final List<OperationProgressListener> g;
    private final List<OperationLogger> h;
    private long i;
    private long j;
    private Throwable k;
    private String l;
    private static final Logger m;
    private String n;
    public static boolean o;
    private static final String[] p;

    Operation(IStringKey iStringKey, boolean bl2, boolean bl3) {
        boolean bl4 = o;
        this.e = new Object();
        this.f = OperationState.STARTING;
        this.g = new CopyOnWriteArrayList<OperationProgressListener>();
        this.h = new ArrayList<OperationLogger>();
        this.a = iStringKey;
        this.l = iStringKey.getString();
        this.b = bl2;
        this.c = bl3;
        if (StringKey.c) {
            boolean bl5 = !bl4;
            o = bl5;
        }
    }

    public void executeOperation() {
        this.i = System.currentTimeMillis();
        try {
            this.a(OperationState.RUNNING);
            this.log(STARTING_STRING_KEY.getString());
            if (m.isDebugEnabled()) {
                String string = this.getClass().getSimpleName();
                if (StringUtil.isEmpty(string)) {
                    string = this.getClass().getName();
                }
                if (StringUtil.isEmpty(string)) {
                    string = p[5];
                }
                Logger logger = m;
                StringBuilder stringBuilder = new StringBuilder().append(p[1]);
                String string2 = StringUtil.isEmpty(this.l) ? p[0] : this.l;
                logger.debug(stringBuilder.append(string2).append(p[2]).append(string).append(p[4]).toString());
            }
            this.execute();
            if (!this.c) {
                this.checkStopped();
                this.a(OperationState.OK);
            }
        }
        catch (InterruptedException interruptedException) {
            this.log(STOPPED_STRING_KEY.getString());
            this.a(OperationState.STOPPED);
        }
        catch (Throwable throwable) {
            Operation operation = this;
            String string = throwable instanceof ILocalizedException ? ((ILocalizedException)((Object)throwable)).getText() : new CommonsStringKey(p[3]).getString();
            operation.log(string);
            this.a(throwable);
            this.a(OperationState.FAILED);
        }
    }

    protected abstract void execute() throws Exception;

    public abstract void stop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkStopped() throws InterruptedException {
        OperationState operationState;
        Object object = this.e;
        synchronized (object) {
            operationState = this.f;
        }
        if (operationState == OperationState.STOPPING) {
            throw new InterruptedException();
        }
        Util.checkInterrupted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canStop() {
        Object object = this.e;
        synchronized (object) {
            if (this.f == OperationState.RUNNING) return true;
            if (this.f != OperationState.STARTING) return false;
            return true;
        }
    }

    public void addOperationProgressListener(OperationProgressListener operationProgressListener) {
        this.g.add(operationProgressListener);
    }

    public void removeOperationProgressListener(OperationProgressListener operationProgressListener) {
        this.g.remove(operationProgressListener);
    }

    void a() {
        this.g.clear();
    }

    void b() {
        boolean bl2 = o;
        OperationProgressEvent operationProgressEvent = new OperationProgressEvent(this, this.getCompletePercent());
        for (OperationProgressListener operationProgressListener : this.g) {
            operationProgressListener.progressChanged(operationProgressEvent);
            if (!bl2) continue;
        }
    }

    protected void operationSuccess() {
    }

    protected void operationFinished() {
    }

    private void a(Throwable throwable) {
        m.error("", throwable);
        this.k = throwable;
    }

    public Throwable getException() {
        return this.k;
    }

    public Throwable findException() {
        Throwable throwable;
        block7: {
            boolean bl2 = o;
            throwable = this.getException();
            if (throwable != null || !this.isComposite()) break block7;
            for (Operation operation : ((CompositeOperation)this).getSubOperations()) {
                throwable = operation.findException();
                if (throwable != null && !bl2) break;
                if (!bl2) continue;
                break;
            }
        }
        return throwable;
    }

    public String getStackTrace() {
        return StringUtil.stackTraceToString(this.k);
    }

    public abstract double getCompletePercent();

    public abstract double getFailedPercent();

    public abstract int getRealSubOperationCount();

    protected abstract double getRealCompletePercent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(OperationState operationState) {
        block14: {
            OperationStateEvent operationStateEvent;
            boolean bl2;
            block15: {
                bl2 = o;
                operationStateEvent = null;
                Iterator<OperationProgressListener> iterator = this.e;
                synchronized (iterator) {
                    block13: {
                        OperationState object = this.getOperationState();
                        if (operationState == object || !Operation.a(object, operationState)) break block13;
                        this.f = operationState;
                        operationStateEvent = new OperationStateEvent(this, operationState);
                    }
                }
                if (operationStateEvent == null) break block14;
                if (operationState != OperationState.OK) break block15;
                this.operationSuccess();
            }
            if (operationState.a) {
                this.j = System.currentTimeMillis();
                this.operationFinished();
            }
            for (OperationProgressListener operationProgressListener : this.g) {
                operationProgressListener.operationStateChanged(operationStateEvent);
                if (!bl2) continue;
            }
        }
    }

    private static boolean a(OperationState operationState, OperationState operationState2) {
        return Operation.b(operationState, operationState2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean b(OperationState operationState, OperationState operationState2) {
        switch (operationState) {
            case STARTING: {
                if (operationState2 == OperationState.RUNNING) return true;
                if (operationState2 == OperationState.STOPPING) return true;
                return false;
            }
            case RUNNING: {
                if (operationState2 == OperationState.STOPPING) return true;
                if (operationState2 == OperationState.OK) return true;
                if (operationState2 == OperationState.FAILED) return true;
                return false;
            }
            case STOPPING: {
                if (operationState2 != OperationState.STOPPED) return false;
                return true;
            }
            case STOPPED: 
            case OK: 
            case FAILED: {
                return false;
            }
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationState getOperationState() {
        Object object = this.e;
        synchronized (object) {
            return this.f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogger(OperationLogger operationLogger) {
        List<OperationLogger> list = this.h;
        synchronized (list) {
            this.h.add(operationLogger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogger(OperationLogger operationLogger) {
        List<OperationLogger> list = this.h;
        synchronized (list) {
            this.h.remove(operationLogger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationLogger[] getOperationLoggers() {
        OperationLogger[] operationLoggerArray;
        List<OperationLogger> list = this.h;
        synchronized (list) {
            operationLoggerArray = this.h.toArray(new OperationLogger[this.h.size()]);
        }
        return operationLoggerArray;
    }

    @Override
    public void log(String string) {
        OperationLogger[] operationLoggerArray;
        boolean bl2 = o;
        this.d = string;
        for (OperationLogger operationLogger : operationLoggerArray = this.getOperationLoggers()) {
            operationLogger.log(string);
            if (!bl2) continue;
        }
    }

    public long getOperationTime() {
        if (this.i == 0L) {
            return 0L;
        }
        long l2 = this.j == 0L ? System.currentTimeMillis() - this.i : this.j - this.i;
        return l2;
    }

    public String getName() {
        return this.l;
    }

    public IStringKey getNameKey() {
        return this.a;
    }

    public String getOperationStatus() {
        return this.d;
    }

    public boolean isDeterminate() {
        return this.b;
    }

    public boolean isComposite() {
        return this.c;
    }

    public String toString() {
        return this.getName();
    }

    public String getPrevName(Operation operation) {
        block6: {
            if (this.n == null) {
                block5: {
                    List<Operation> list = operation.getTreePath(this);
                    if (list.size() <= 1) break block5;
                    this.n = list.get(list.size() - 2).getName();
                    if (!o) break block6;
                }
                this.n = "";
            }
        }
        return this.n;
    }

    public long getStartTime() {
        return this.i;
    }

    public List<Operation> getTreePath(Operation operation) {
        ArrayList<Operation> arrayList = new ArrayList<Operation>();
        this.a(arrayList, operation);
        Collections.reverse(arrayList);
        return arrayList;
    }

    abstract boolean a(List<Operation> var1, Operation var2);

    public String getCommand(boolean bl2) {
        return null;
    }

    public abstract void cleanup();

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0013U\"6\u001e\u0010_";
        int n3 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block17;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 93;
                                break;
                            }
                            case 1: {
                                n9 = 26;
                                break;
                            }
                            case 2: {
                                n9 = 125;
                                break;
                            }
                            case 3: {
                                n9 = 120;
                                break;
                            }
                            default: {
                                n9 = 95;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0012j\u0018\n>)s\u0012\u0016\u007f\u007f";
                    n3 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u007fA";
                    n3 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "2j\u0018\n>)s\u0012\u0016q.n\u001c\f*.4\u001b\u001961\u007f\u0019";
                    n3 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0000:\u0018\u0000:>o\t\u001dqs4";
                    n3 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0013U\";\u0013\u001cI.'\u0011\u001cW8";
                    n3 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        p = stringArray3;
        m = LoggerFactory.getLogger(Operation.class);
    }
}

