/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.util;

import com.agilemind.commons.util.StringUtil;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class DateUtil {
    public static final long DAY_LONG = 86400000L;

    private DateUtil() {
    }

    public static Date getStartDay(Date date) {
        if (date != null) {
            Calendar calendar = DateUtil.getStartCalendar(date);
            return calendar.getTime();
        }
        return null;
    }

    public static Calendar getStartCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        DateUtil.setStartDayCalendar(calendar, date);
        return calendar;
    }

    public static void setStartDayCalendar(Calendar calendar, Date date) {
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static Date getToday() {
        return DateUtil.getStartDay(new Date());
    }

    public static Date getPlusThreeMonthsDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.getToday());
        calendar.add(2, 3);
        return calendar.getTime();
    }

    public static boolean theSameDay(Date date, Date date2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        return calendar.get(5) == calendar2.get(5) && calendar.get(2) == calendar2.get(2) && calendar.get(1) == calendar2.get(1);
    }

    public static Date minusDays(int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -n2);
        return calendar.getTime();
    }

    public static Date plusSeconds(Date date, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, n2);
        return calendar.getTime();
    }

    public static long daysAfter(Date date) {
        return -DateUtil.daysBefore(date);
    }

    public static long daysBefore(Date date) {
        return (long)Math.floor((double)(date.getTime() - System.currentTimeMillis()) / 8.64E7);
    }

    public static long getDifferenceDays(Date date) {
        return DateUtil.getDifferenceDays(date, new Date());
    }

    public static long getDifferenceDays(Date date, Date date2) {
        long l2 = date2.getTime() - date.getTime();
        return TimeUnit.DAYS.convert(l2, TimeUnit.MILLISECONDS);
    }

    public static Date min(Date date, Date date2) {
        return date.before(date2) ? date : date2;
    }

    public static Date max(Date date, Date date2) {
        return date.before(date2) ? date2 : date;
    }

    public static int compareDates(Date date, Date date2, int n2) {
        boolean bl2 = StringUtil.i;
        int[] nArray = new int[]{1, 2, 5, 11, 12, 13, 14};
        int n3 = Arrays.binarySearch(nArray, n2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        if (n3 >= 0) {
            for (int i2 = n3 + 1; i2 < nArray.length; ++i2) {
                calendar.set(nArray[i2], 0);
                calendar2.set(nArray[i2], 0);
                if (!bl2) continue;
            }
        }
        return calendar.compareTo(calendar2);
    }

    public static Date nextDay(Date date) {
        return DateUtil.moveDay(date, 1);
    }

    public static Date prevDay(Date date) {
        return DateUtil.moveDay(date, -1);
    }

    public static Date moveDay(Date date, int n2) {
        return new Date(date.getTime() + 86400000L * (long)n2);
    }

    public static long nextDay(long l2) {
        return DateUtil.moveDay(l2, 1);
    }

    public static long prevDay(long l2) {
        return DateUtil.moveDay(l2, -1);
    }

    public static long moveDay(long l2, int n2) {
        return l2 + 86400000L * (long)n2;
    }

    public static boolean between(Date date, Date date2, Date date3) {
        return date.equals(date2) || date.equals(date3) || date.after(date2) && date.before(date3);
    }

    public static synchronized Date createDate(int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(n2, n3, n4, n5, n6, 0);
        return calendar.getTime();
    }
}

