/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.util;

import com.agilemind.commons.util.StringUtil;
import java.math.BigDecimal;
import java.util.Collection;

public class MathUtil {
    public static final long MS_IN_DAY = 86400000L;
    private static final String[] a;

    private MathUtil() {
    }

    public static float max(float[] fArray) {
        boolean bl2 = StringUtil.i;
        if (fArray.length < 1) {
            throw new IllegalArgumentException();
        }
        float f2 = fArray[0];
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            f2 = Math.max(f2, fArray[i2]);
            if (!bl2) continue;
        }
        return f2;
    }

    public static float min(float[] fArray) {
        boolean bl2 = StringUtil.i;
        if (fArray.length < 1) {
            throw new IllegalArgumentException();
        }
        float f2 = fArray[0];
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            f2 = Math.min(f2, fArray[i2]);
            if (!bl2) continue;
        }
        return f2;
    }

    public static String floatToString(float f2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = (int)Math.floor(f2);
        stringBuilder.append(n2);
        stringBuilder.append('.');
        int n3 = (int)((f2 - (float)n2) * 100.0f);
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        return stringBuilder.toString();
    }

    public static boolean exist(String[] stringArray, String string) {
        boolean bl2 = StringUtil.i;
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static float[] getNeutralized2(float[] fArray, int n2) {
        boolean bl2 = StringUtil.i;
        float[] fArray2 = new float[fArray.length];
        for (int i2 = n2; i2 < fArray.length; ++i2) {
            fArray2[i2] = MathUtil.getAverage(fArray, i2 - 1, 2);
            if (!bl2) continue;
        }
        return fArray2;
    }

    public static float[] getNeutralized(float[] fArray, int n2) {
        boolean bl2 = StringUtil.i;
        float[] fArray2 = new float[fArray.length];
        for (int i2 = n2; i2 < fArray.length; ++i2) {
            fArray2[i2] = MathUtil.getAverage(fArray, i2 - n2, n2);
            if (!bl2) continue;
        }
        return fArray2;
    }

    public static long[] getDifference(long[] lArray) {
        boolean bl2 = StringUtil.i;
        long[] lArray2 = new long[lArray.length];
        long l2 = -1L;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            block3: {
                if (lArray[i2] == 0L) continue;
                if (l2 != -1L) break block3;
                l2 = lArray[i2];
            }
            lArray2[i2] = lArray[i2] - l2;
            l2 = lArray[i2];
            if (!bl2) continue;
        }
        return lArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static float[] getDifference(float[] fArray) {
        boolean bl2 = StringUtil.i;
        float[] fArray2 = new float[fArray.length];
        float f2 = -1.0f;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (f2 == -1.0f && fArray[i2] != 0.0f) {
                f2 = fArray[i2];
            }
            if (fArray[i2] != 0.0f) {
                fArray2[i2] = fArray[i2] - f2;
                f2 = fArray[i2];
                if (!bl2) continue;
            }
            if (i2 <= 0) continue;
            fArray2[i2] = fArray2[i2 - 1];
            if (!bl2) continue;
        }
        return fArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double getPercentDifference(double d2, double d3) {
        double d4 = d2 - d3;
        if (d4 > 0.0) {
            double d5 = MathUtil.getRoundUpPercent(d2, d4);
            if (!StringUtil.i) return d5;
        }
        if (d4 != 0.0) return -MathUtil.getRoundUpPercent(d2 - d4, Math.abs(d4));
        return 0.0;
    }

    public static double getPercent(double d2, double d3) {
        return MathUtil.getPercent(100, d2, d3);
    }

    public static double getPercent(int n2, double d2, double d3) {
        block4: {
            if (d2 != 0.0 && d3 != 0.0) break block4;
            return 0.0;
        }
        return (double)n2 / d2 * d3;
    }

    public static double getRoundUpPercent(double d2, double d3) {
        if (d2 == 0.0) {
            return 0.0;
        }
        BigDecimal bigDecimal = new BigDecimal(d3 / d2);
        bigDecimal = bigDecimal.setScale(3, 4).multiply(new BigDecimal(a[0]));
        return bigDecimal.doubleValue();
    }

    public static int getValueFromRange(int n2, int n3, int n4, Collection<Integer> collection) {
        boolean bl2 = StringUtil.i;
        int n5 = 0;
        for (int n6 : collection) {
            n5 = Math.max(n5, n6);
            if (!bl2) continue;
        }
        double d2 = n5 != 0 ? (double)n4 / (double)n5 : 0.0;
        double d3 = d2;
        return (int)Math.round((double)n3 + (double)(n2 - n3) * d3);
    }

    public static double round(double d2, int n2) {
        BigDecimal bigDecimal = new BigDecimal(d2);
        bigDecimal = bigDecimal.setScale(n2, 4);
        return bigDecimal.doubleValue();
    }

    public static String getDateString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = byArray[1] < 10 ? "0" : "";
        StringBuilder stringBuilder2 = stringBuilder.append(string).append(byArray[1]).append('-');
        String string2 = byArray[2] < 10 ? "0" : "";
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append(byArray[2]).append('-');
        String string3 = byArray[0] < 10 ? "0" : "";
        return stringBuilder3.append(string3).append(byArray[0]).toString();
    }

    public static String getTimeString(byte[] byArray) {
        return MathUtil.getTimeString((byArray[0] * 60 + byArray[1]) * 60 + byArray[2]);
    }

    public static String getTimeString(int n2) {
        int n3 = n2 / 3600;
        int n4 = (n2 -= n3 * 3600) / 60;
        StringBuilder stringBuilder = new StringBuilder();
        String string = n3 < 10 ? "0" : "";
        StringBuilder stringBuilder2 = stringBuilder.append(string).append(n3).append(':');
        String string2 = n4 < 10 ? "0" : "";
        return stringBuilder2.append(string2).append(n4).toString();
    }

    public static float getAverage(float[] fArray, int n2, int n3) {
        boolean bl2 = StringUtil.i;
        float f2 = 0.0f;
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (n2 + i2 >= fArray.length || fArray[n2 + i2] == 0.0f) continue;
            ++n4;
            f2 += fArray[n2 + i2];
            if (!bl2) continue;
        }
        if (n4 == 0) {
            return 0.0f;
        }
        return f2 / (float)n4;
    }

    public static long getAverage(long[] lArray, int n2, int n3) {
        boolean bl2 = StringUtil.i;
        long l2 = 0L;
        long l3 = 0L;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (n2 + i2 >= lArray.length || lArray[n2 + i2] == 0L) continue;
            ++l3;
            l2 += lArray[n2 + i2];
            if (!bl2) continue;
        }
        if (l3 == 0L) {
            return 0L;
        }
        return l2 / l3;
    }

    public static int getInt(String string, int n2) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public static float getFloat(String string, float f2) {
        try {
            return Float.parseFloat(string);
        }
        catch (NullPointerException nullPointerException) {
            return f2;
        }
        catch (NumberFormatException numberFormatException) {
            return f2;
        }
    }

    public static int hexStringToInt(String string, int n2) {
        try {
            block4: {
                if (string == null || !string.startsWith(a[1])) break block4;
                return Integer.parseInt(string.substring(2), 16);
            }
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public static String getStrIFNotEmpty(String string) {
        return MathUtil.getStrIFNotEmpty(string, "");
    }

    public static String getStrIFNotEmpty(String string, String string2) {
        block4: {
            if (string == null || string.length() == 0) break block4;
            return string;
        }
        return string2;
    }

    public static long bytesToLong(byte[] byArray) {
        int n2;
        boolean bl2 = StringUtil.i;
        int n3 = 4;
        int n4 = 0;
        byte[] byArray2 = new byte[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray2[n4] = byArray[n2];
            ++n4;
            if (!bl2) continue;
        }
        n2 = 0;
        long l2 = 0L;
        for (int i2 = 0; i2 < 32; i2 += 8) {
            l2 |= (long)(byArray2[n2] & 0xFF) << i2;
            ++n2;
            if (!bl2) continue;
        }
        return l2;
    }

    public static byte[] intToBytes(int n2) {
        byte[] byArray = new byte[4];
        MathUtil.intToBytes(byArray, 0, n2);
        return byArray;
    }

    public static void intToBytes(byte[] byArray, int n2, int n3) {
        if (n2 + 3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        byArray[n2 + 3] = (byte)((n3 & 0xFF000000) >> 24);
        byArray[n2 + 2] = (byte)((n3 & 0xFF0000) >> 16);
        byArray[n2 + 1] = (byte)((n3 & 0xFF00) >> 8);
        byArray[n2] = (byte)(n3 & 0xFF);
    }

    public static short bytesToShort(byte[] byArray, int n2) {
        if (n2 + 1 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        long l2 = byArray[n2] >= 0 ? (long)byArray[n2] : (long)(256 + byArray[n2]);
        long l3 = l2;
        long l4 = l3;
        long l5 = byArray[n2 + 1] >= 0 ? (long)(byArray[n2 + 1] * 256) : (long)((256 + byArray[n2 + 1]) * 256);
        l3 = l4 + l5;
        return (short)l3;
    }

    public static byte[] shortToBytes(int n2) {
        byte[] byArray = new byte[2];
        MathUtil.shortToBytes(byArray, 0, n2);
        return byArray;
    }

    public static void shortToBytes(byte[] byArray, int n2, int n3) {
        if (n2 + 1 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        byArray[n2 + 1] = (byte)((n3 & 0xFF00) >> 8);
        byArray[n2] = (byte)(n3 & 0xFF);
    }

    public static int random(int n2) {
        return MathUtil.random(0, n2);
    }

    public static int random(int n2, int n3) {
        return (int)(Math.random() * (double)(n3 - n2)) + n2;
    }

    public static long random(long l2) {
        return MathUtil.random(0L, l2);
    }

    public static long random(long l2, long l3) {
        return (long)(Math.random() * (double)(l3 - l2)) + l2;
    }

    public static double getProportion(double d2, double d3, double d4) {
        return (d4 - d2) / (d3 - d2);
    }

    public static double getValue(double d2, double d3, double d4) {
        return d2 + (d3 - d2) * d4;
    }

    public static <T extends Comparable<T>> boolean less(T t2, T t3) {
        boolean bl2 = t2.compareTo(t3) < 0;
        return bl2;
    }

    public static <T extends Comparable<T>> boolean lessOrEqual(T t2, T t3) {
        boolean bl2 = t2.compareTo(t3) <= 0;
        return bl2;
    }

    public static <T extends Comparable<T>> boolean more(T t2, T t3) {
        boolean bl2 = t2.compareTo(t3) > 0;
        return bl2;
    }

    public static <T extends Comparable<T>> boolean moreOrEqual(T t2, T t3) {
        boolean bl2 = t2.compareTo(t3) >= 0;
        return bl2;
    }

    public static int inchesToMM(double d2) {
        return (int)(d2 * 25.4);
    }

    public static double mmToInches(double d2) {
        return d2 / 25.4;
    }

    public static double mmToPixels(double d2, int n2) {
        return MathUtil.mmToInches(d2) * (double)n2;
    }

    public static double inchesToPixel(double d2, int n2) {
        return MathUtil.mmToPixels(MathUtil.inchesToMM(d2), n2);
    }

    public static String getDownloadSizeMB(long l2) {
        return Math.ceil((double)l2 / 1024.0 / 102.4) / 10.0 + a[2];
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0017H\u0002";
        int n3 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block14;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 38;
                                break;
                            }
                            case 1: {
                                n9 = 120;
                                break;
                            }
                            case 2: {
                                n9 = 50;
                                break;
                            }
                            case 3: {
                                n9 = 20;
                                break;
                            }
                            default: {
                                n9 = 31;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0016\u0000";
                    n3 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u00065p";
                    n3 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        a = stringArray3;
    }
}

