/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.util;

import com.agilemind.commons.util.Function;
import com.agilemind.commons.util.MathUtil;
import com.agilemind.commons.util.Precondition;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.r;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Util {
    public static final Comparator<Object> FAST_COMPARATOR = new FastComparator<Object>(false);
    public static final Comparator<Object> FAST_REVERSE_COMPARATOR = new FastComparator<Object>(false);

    private Util() {
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static int compare(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof String) {
            return ((String)object).compareToIgnoreCase((String)object2);
        }
        if (object instanceof Boolean) {
            boolean bl2;
            boolean bl3 = (Boolean)object;
            if (bl3 == (bl2 = ((Boolean)object2).booleanValue())) {
                return 0;
            }
            if (bl3) {
                return 1;
            }
            return -1;
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2);
        }
        String string = object.toString();
        String string2 = object2.toString();
        return string.compareToIgnoreCase(string2);
    }

    public static int compareInteger(Integer n2, Integer n3) {
        if (n2 == null && n3 == null) {
            return 0;
        }
        if (n2 == null) {
            return 1;
        }
        if (n3 == null) {
            return -1;
        }
        return n2.compareTo(n3);
    }

    public static <E extends Number, T extends Collection<E>> int compareCollections(T t2, T t3) {
        boolean bl2 = StringUtil.i;
        Iterator<E> iterator = t2.iterator();
        Iterator<E> iterator2 = t3.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            int n2;
            Number number = (Number)iterator.next();
            Number number2 = (Number)iterator2.next();
            if (number == null && number2 == null && !bl2) continue;
            if (number == null) {
                return -1;
            }
            if (number2 == null) {
                return 1;
            }
            int n3 = number.intValue();
            if (n3 > (n2 = number2.intValue())) {
                return 1;
            }
            if (n3 < n2) {
                return -1;
            }
            if (!bl2) continue;
        }
        return t2.size() - t3.size();
    }

    public static <T> Collection<T> max(Collection<T> collection, Comparator<T> comparator) {
        boolean bl2 = StringUtil.i;
        ArrayList<T> arrayList = new ArrayList<T>();
        T t2 = Collections.max(collection, comparator);
        if (t2 != null) {
            for (T t3 : collection) {
                if (comparator.compare(t2, t3) == 0) {
                    arrayList.add(t3);
                }
                if (!bl2) continue;
            }
        }
        return arrayList;
    }

    public static <T> Collection<T> intersection(Collection<T> collection, Collection<T> collection2) {
        boolean bl2 = StringUtil.i;
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t2 : collection) {
            if (collection2.contains(t2)) {
                arrayList.add(t2);
            }
            if (!bl2) continue;
        }
        return arrayList;
    }

    public static <T, H> void removeFirstEmptyValues(Map<T, H> map) {
        boolean bl2 = StringUtil.i;
        Iterator<Map.Entry<T, H>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            block4: {
                block3: {
                    Map.Entry<T, H> entry = iterator.next();
                    if (entry.getValue() != null) break block3;
                    iterator.remove();
                    if (!bl2) break block4;
                }
                return;
            }
            if (!bl2) continue;
        }
    }

    public static boolean contains(int[] nArray, int n2) {
        return Util.indexOf(nArray, n2) != -1;
    }

    public static int indexOf(int[] nArray, int n2) {
        boolean bl2 = StringUtil.i;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public static <E> boolean contains(E[] EArray, E e2) {
        return Util.contains(Arrays.asList(EArray), e2);
    }

    public static <E> boolean contains(Collection<E> collection, E e2) {
        boolean bl2 = StringUtil.i;
        for (E e3 : collection) {
            if (e3.equals(e2)) {
                return true;
            }
            if (!bl2) continue;
        }
        return false;
    }

    public static <E> boolean contains(Collection<E> collection, E e2, Comparator<E> comparator) {
        boolean bl2 = StringUtil.i;
        for (E e3 : collection) {
            if (comparator.compare(e3, e2) == 0) {
                return true;
            }
            if (!bl2) continue;
        }
        return false;
    }

    public static <E> int indexOf(E[] EArray, E e2) {
        boolean bl2 = StringUtil.i;
        for (int i2 = 0; i2 < EArray.length; ++i2) {
            if (!EArray[i2].equals(e2)) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(Iterable<?> iterable, Object object) {
        boolean bl2 = StringUtil.i;
        int n2 = 0;
        for (Object obj : iterable) {
            if (obj.equals(object)) {
                return n2;
            }
            ++n2;
            if (!bl2) continue;
        }
        return -1;
    }

    public static <K, V extends Comparable> LinkedHashMap<K, V> sortByValues(Map<K, V> map) {
        boolean bl2 = StringUtil.i;
        LinkedList<Map.Entry<K, V>> linkedList = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(linkedList, new r());
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : linkedList) {
            linkedHashMap.put(entry.getKey(), entry.getValue());
            if (!bl2) continue;
        }
        return linkedHashMap;
    }

    public static <T> int indexedBinarySearch(List<T> list, T t2, Comparator<T> comparator) {
        return Util.indexedBinarySearch(list, t2, 0, list.size(), comparator);
    }

    public static <T> int indexedBinarySearch(List<T> list, T t2, int n2, int n3, Comparator<T> comparator) {
        boolean bl2 = StringUtil.i;
        int n4 = n2;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            block4: {
                int n6;
                block5: {
                    int n7;
                    block3: {
                        n6 = n4 + n5 >> 1;
                        T t3 = list.get(n6);
                        n7 = comparator.compare(t3, t2);
                        if (n7 >= 0) break block3;
                        n4 = n6 + 1;
                        if (!bl2) break block4;
                    }
                    if (n7 <= 0) break block5;
                    n5 = n6 - 1;
                    if (!bl2) break block4;
                }
                return n6;
            }
            if (!bl2) continue;
        }
        return -(n4 + 1);
    }

    public static int countBytes(InputStream inputStream) throws IOException {
        boolean bl2 = StringUtil.i;
        int n2 = 0;
        while (inputStream.read() != -1) {
            ++n2;
            if (!bl2) continue;
        }
        return n2;
    }

    public static void checkInterrupted() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    public static Boolean invert(Boolean bl2) {
        return bl2 == null || bl2 == false ? Boolean.TRUE : Boolean.FALSE;
    }

    public static <T> T random(T[] TArray) {
        assert (TArray != null && TArray.length > 0);
        return TArray[MathUtil.random(TArray.length)];
    }

    public static String getSystemProperties() {
        boolean bl2 = StringUtil.i;
        StringBuilder stringBuilder = new StringBuilder();
        Properties properties = System.getProperties();
        for (Object object : properties.keySet()) {
            String string = properties.getProperty((String)object);
            stringBuilder.append(object).append('=').append(string).append('\n');
            if (!bl2) continue;
        }
        return stringBuilder.toString();
    }

    public static <T> T[] merge(T[] TArray, T[] TArray2) {
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length + TArray2.length);
        System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
        System.arraycopy(TArray2, 0, objectArray, TArray.length, TArray2.length);
        return objectArray;
    }

    public static Color[] copy(Color[] colorArray) {
        return Arrays.copyOf(colorArray, colorArray.length);
    }

    public static <T> Collection<T> subtract(Collection<T> collection, T[] TArray) {
        return Util.subtract(collection, Arrays.asList(TArray));
    }

    public static <T> Collection<T> subtract(Collection<T> collection, Collection<T> collection2) {
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        arrayList.removeAll(collection2);
        return arrayList;
    }

    public static void reverse(Object[] objectArray) {
        boolean bl2 = StringUtil.i;
        if (objectArray == null) {
            return;
        }
        int n2 = 0;
        for (int i2 = objectArray.length - 1; i2 > n2; --i2, ++n2) {
            Object object = objectArray[i2];
            objectArray[i2] = objectArray[n2];
            objectArray[n2] = object;
            if (!bl2) continue;
        }
    }

    public static <T> List<T> subList(List<T> list, int n2) {
        return n2 >= 0 ? list.subList(0, Math.min(list.size(), n2)) : list;
    }

    public static <T> List<T> filter(Iterable<T> iterable, Precondition<T> ... preconditionArray) {
        boolean bl2 = StringUtil.i;
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t2 : iterable) {
            boolean bl3 = false;
            for (Precondition<T> precondition : preconditionArray) {
                if (precondition.accept(t2)) {
                    bl3 = true;
                    if (!bl2) continue;
                }
                bl3 = false;
                if (!bl2) break;
                if (!bl2) continue;
            }
            if (bl3) {
                arrayList.add(t2);
            }
            if (!bl2) continue;
        }
        return arrayList;
    }

    public static <T> T[] filter(Class<T> clazz, T[] TArray, Precondition<T> ... preconditionArray) {
        boolean bl2 = StringUtil.i;
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t2 : TArray) {
            boolean bl3 = false;
            for (Precondition<T> precondition : preconditionArray) {
                if (precondition.accept(t2)) {
                    bl3 = true;
                    if (!bl2) continue;
                }
                bl3 = false;
                if (!bl2) break;
                if (!bl2) continue;
            }
            if (!bl3) continue;
            arrayList.add(t2);
            if (!bl2) continue;
        }
        return arrayList.toArray((Object[])Array.newInstance(clazz, arrayList.size()));
    }

    public static <T> T find(Iterable<T> iterable, Precondition<T> precondition) {
        boolean bl2 = StringUtil.i;
        for (T t2 : iterable) {
            if (precondition.accept(t2)) {
                return t2;
            }
            if (!bl2) continue;
        }
        return null;
    }

    public static <T> T findLast(List<T> list, Precondition<T> precondition) {
        boolean bl2 = StringUtil.i;
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            T t2 = list.get(i2);
            if (!precondition.accept(t2)) continue;
            return t2;
        }
        return null;
    }

    public static <F, T> List<T> transform(Iterable<F> iterable, Function<F, T> function) {
        boolean bl2 = StringUtil.i;
        ArrayList<T> arrayList = new ArrayList<T>();
        for (F f2 : iterable) {
            arrayList.add(function.apply(f2));
            if (!bl2) continue;
        }
        return arrayList;
    }

    public static <F, T> T[] transform(Class<T> clazz, F[] FArray, Function<F, T> function) {
        boolean bl2 = StringUtil.i;
        if (FArray == null) {
            return null;
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz, FArray.length);
        for (int i2 = 0; i2 < FArray.length; ++i2) {
            objectArray[i2] = function.apply(FArray[i2]);
            if (!bl2) continue;
        }
        return objectArray;
    }

    public static class FastComparator<T>
    implements Comparator<T>,
    Serializable {
        private boolean a;

        public FastComparator(boolean bl2) {
            this.a = bl2;
        }

        @Override
        public int compare(T t2, T t3) {
            return this.a ? Util.compare(t3, t2) : Util.compare(t2, t3);
        }
    }
}

