/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.syntax;

import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import org.jedit.syntax.TokenMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntaxDocument
extends PlainDocument {
    private static final Logger a = LoggerFactory.getLogger(SyntaxDocument.class);
    protected TokenMarker tokenMarker;

    public SyntaxDocument(AbstractDocument.Content content) {
        super(content);
    }

    public TokenMarker getTokenMarker() {
        return this.tokenMarker;
    }

    public void setTokenMarker(TokenMarker tokenMarker) {
        this.tokenMarker = tokenMarker;
        if (tokenMarker == null) {
            return;
        }
        this.tokenMarker.insertLines(0, this.getDefaultRootElement().getElementCount());
        this.tokenizeLines();
    }

    public void tokenizeLines() {
        this.tokenizeLines(0, this.getDefaultRootElement().getElementCount());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void tokenizeLines(int n2, int n3) {
        int n4 = TokenMarker.b;
        if (this.tokenMarker == null) return;
        if (!this.tokenMarker.supportsMultilineTokens()) {
            return;
        }
        Segment segment = new Segment();
        Element element = this.getDefaultRootElement();
        n3 += n2;
        try {
            int i2 = n2;
            do {
                if (i2 >= n3) return;
                Element element2 = element.getElement(i2);
                int n5 = element2.getStartOffset();
                this.getText(n5, element2.getEndOffset() - n5 - 1, segment);
                this.tokenMarker.markTokens(segment, i2);
                ++i2;
            } while (n4 == 0);
            return;
        }
        catch (BadLocationException badLocationException) {
            a.error("", (Throwable)badLocationException);
        }
    }

    public void beginCompoundEdit() {
    }

    public void endCompoundEdit() {
    }

    public void addUndoableEdit(UndoableEdit undoableEdit) {
    }

    @Override
    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange;
        if (this.tokenMarker != null && (elementChange = documentEvent.getChange(this.getDefaultRootElement())) != null) {
            this.tokenMarker.insertLines(elementChange.getIndex() + 1, elementChange.getChildrenAdded().length - elementChange.getChildrenRemoved().length);
        }
        super.fireInsertUpdate(documentEvent);
    }

    @Override
    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange;
        if (this.tokenMarker != null && (elementChange = documentEvent.getChange(this.getDefaultRootElement())) != null) {
            this.tokenMarker.deleteLines(elementChange.getIndex() + 1, elementChange.getChildrenRemoved().length - elementChange.getChildrenAdded().length);
        }
        super.fireRemoveUpdate(documentEvent);
    }
}

