/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.syntax;

import com.agilemind.commons.localization.stringkey.StringKey;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.jedit.syntax.SyntaxStyle;
import org.jedit.syntax.Token;
import org.jedit.syntax.TokenMarker;

public class SyntaxUtilities {
    private SyntaxUtilities() {
    }

    public static boolean regionMatches(boolean bl2, Segment segment, int n2, String string) {
        int n3 = TokenMarker.b;
        int n4 = n2 + string.length();
        char[] cArray = segment.array;
        if (n4 > segment.offset + segment.count) {
            return false;
        }
        int n5 = n2;
        int n6 = 0;
        while (n5 < n4) {
            char c2 = cArray[n5];
            char c3 = string.charAt(n6);
            if (bl2) {
                c2 = Character.toUpperCase(c2);
                c3 = Character.toUpperCase(c3);
            }
            if (c2 != c3) {
                return false;
            }
            ++n5;
            ++n6;
            if (n3 == 0) continue;
        }
        return true;
    }

    public static int regionMatches(Pattern pattern, Segment segment, int n2, int n3) {
        String string = new String(segment.array, n2, n3);
        Matcher matcher = pattern.matcher(string);
        return matcher.find() && matcher.start() == 0 ? matcher.end() : -1;
    }

    public static boolean regionMatches(boolean bl2, Segment segment, int n2, char[] cArray) {
        int n3 = TokenMarker.b;
        int n4 = n2 + cArray.length;
        char[] cArray2 = segment.array;
        if (n4 > segment.offset + segment.count) {
            return false;
        }
        int n5 = n2;
        int n6 = 0;
        while (n5 < n4) {
            char c2 = cArray2[n5];
            char c3 = cArray[n6];
            if (bl2) {
                c2 = Character.toUpperCase(c2);
                c3 = Character.toUpperCase(c3);
            }
            if (c2 != c3) {
                return false;
            }
            ++n5;
            ++n6;
            if (n3 == 0) continue;
        }
        return true;
    }

    public static SyntaxStyle[] getDefaultSyntaxStyles() {
        int n2 = TokenMarker.b;
        SyntaxStyle[] syntaxStyleArray = new SyntaxStyle[14];
        syntaxStyleArray[1] = new SyntaxStyle(Color.black, true, false);
        syntaxStyleArray[2] = new SyntaxStyle(new Color(0x990033), true, false);
        syntaxStyleArray[13] = new SyntaxStyle(new Color(0x990033), true, false);
        syntaxStyleArray[6] = new SyntaxStyle(Color.black, false, true);
        syntaxStyleArray[7] = new SyntaxStyle(Color.magenta, false, false);
        syntaxStyleArray[8] = new SyntaxStyle(new Color(38400), false, false);
        syntaxStyleArray[12] = new SyntaxStyle(Color.red, false, false);
        syntaxStyleArray[3] = new SyntaxStyle(new Color(6619289), false, false);
        syntaxStyleArray[4] = new SyntaxStyle(new Color(6619289), false, true);
        syntaxStyleArray[5] = new SyntaxStyle(new Color(0x990033), false, true);
        syntaxStyleArray[9] = new SyntaxStyle(Color.black, false, true);
        syntaxStyleArray[10] = new SyntaxStyle(Color.red, false, true);
        syntaxStyleArray[11] = new SyntaxStyle(Color.black, false, true);
        if (n2 != 0) {
            StringKey.c = !StringKey.c;
        }
        return syntaxStyleArray;
    }

    public static int paintSyntaxLine(Segment segment, Token token, SyntaxStyle[] syntaxStyleArray, TabExpander tabExpander, Graphics graphics, int n2, int n3) {
        byte by2;
        int n4 = TokenMarker.b;
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        while ((by2 = token.id) != 127 || n4 != 0) {
            boolean bl2;
            int n5;
            block7: {
                block6: {
                    n5 = token.length;
                    bl2 = false;
                    if (by2 != 0) break block6;
                    if (!color.equals(graphics.getColor())) {
                        graphics.setColor(color);
                    }
                    if (font.equals(graphics.getFont())) break block7;
                    graphics.setFont(font);
                    if (n4 == 0) break block7;
                }
                syntaxStyleArray[by2].setGraphicsFlags(graphics, font);
                bl2 = true;
            }
            segment.count = n5;
            int n6 = n2;
            n2 = Utilities.drawTabbedText(segment, n2, n3, graphics, tabExpander, 0);
            if (bl2 && syntaxStyleArray[by2].isUnderline()) {
                graphics.drawLine(n6, n3 + 2, n2, n3 + 2);
            }
            segment.offset += n5;
            token = token.next;
            if (n4 == 0) continue;
        }
        return n2;
    }
}

