/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.textarea;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import org.jedit.textarea.JEditTextArea;
import org.jedit.textarea.TextAreaDefaults;
import org.jedit.textarea.TextAreaHighlight;
import org.jedit.textarea.TextAreaPainter;
import org.jedit.textarea.c;

public class Gutter
extends JComponent
implements SwingConstants {
    private boolean a = false;
    private boolean b = false;
    private JEditTextArea c;
    private TextAreaDefaults d;
    private JPopupMenu e;
    private TextAreaHighlight f;
    private int g = 0;
    private int h = 0;
    private Dimension i = new Dimension(0, 0);
    private Dimension j = new Dimension(0, 0);
    private Color k;
    private FontMetrics l;
    private int m;
    private int n = 0;
    private boolean o = true;
    private boolean p = false;
    private boolean q = true;
    private boolean r = false;

    public Gutter(JEditTextArea jEditTextArea, TextAreaDefaults textAreaDefaults) {
        this.c = jEditTextArea;
        this.d = textAreaDefaults;
        this.setBackground(textAreaDefaults.gutterBgColor);
        this.setForeground(textAreaDefaults.gutterFgColor);
        this.setHighlightedForeground(textAreaDefaults.gutterHighlightColor);
        this.setFont(textAreaDefaults.gutterFont);
        this.setBorder(textAreaDefaults.gutterBorderWidth, textAreaDefaults.gutterBorderColor);
        this.setLineNumberAlignment(textAreaDefaults.gutterNumberAlignment);
        this.setGutterWidth(textAreaDefaults.gutterWidth);
        this.setCollapsed(textAreaDefaults.gutterCollapsed);
        this.setCollapseEnabled(textAreaDefaults.gutterCollapseEnabled);
        c c2 = new c(this);
        this.addMouseListener(c2);
        this.addMouseMotionListener(c2);
    }

    public void setAntiAliasingEnabled(boolean bl2) {
        this.b = this.a;
        this.a = bl2;
    }

    private void a(Graphics graphics) {
        block5: {
            block4: {
                if (!this.a) break block4;
                ((Graphics2D)graphics).setRenderingHints(TextAreaPainter.ANTI_ALIASED_RENDERING);
                if (JEditTextArea.n == 0) break block5;
            }
            if (this.b != this.a) {
                ((Graphics2D)graphics).setRenderingHints(TextAreaPainter.DEFAULT_RENDERING);
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (!this.p) {
            this.a(graphics);
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this.f != null) {
                this.paintCustomHighlights(graphics);
            }
            if (this.o) {
                this.paintLineNumbers(graphics);
            }
        }
    }

    protected void paintLineNumbers(Graphics graphics) {
        int n2 = JEditTextArea.n;
        FontMetrics fontMetrics = this.c.getPainter().getFontMetrics();
        int n3 = fontMetrics.getHeight();
        int n4 = (int)Math.round((double)(this.g + n3 - fontMetrics.getMaxDescent()) / 2.0);
        int n5 = this.c.getFirstLine() + 1;
        int n6 = n5 + this.getHeight() / n3;
        int n7 = Math.max(1, n5);
        int n8 = Math.min(this.c.getLineCount(), n6);
        graphics.setFont(this.getFont());
        graphics.setColor(this.getForeground());
        int n9 = n5;
        while (n9 <= n6) {
            block7: {
                block9: {
                    int n10;
                    String string;
                    block8: {
                        if (n9 < n7 || n9 > n8 && n2 == 0) break block7;
                        string = Integer.toString(n9);
                        switch (this.m) {
                            case 4: {
                                n10 = this.i.width - this.j.width - (this.l.stringWidth(string) + 1);
                                if (n2 == 0) break;
                            }
                            case 0: {
                                n10 = (this.i.width - this.j.width - this.l.stringWidth(string)) / 2;
                                if (n2 == 0) break;
                            }
                            default: {
                                n10 = 1;
                            }
                        }
                        if (this.n <= 1 || n9 % this.n != 0) break block8;
                        graphics.setColor(this.getHighlightedForeground());
                        graphics.drawString(string, this.h + n10, n4);
                        graphics.setColor(this.getForeground());
                        if (n2 == 0) break block9;
                    }
                    graphics.drawString(string, this.h + n10, n4);
                }
                graphics.setColor(this.getForeground());
            }
            ++n9;
            n4 += n3;
            if (n2 == 0) continue;
        }
    }

    protected void paintCustomHighlights(Graphics graphics) {
        int n2 = JEditTextArea.n;
        int n3 = this.c.getPainter().getFontMetrics().getHeight();
        int n4 = this.c.getFirstLine();
        int n5 = n4 + this.getHeight() / n3;
        int n6 = 0;
        int n7 = n4;
        while (n7 < n5) {
            this.f.paintHighlight(graphics, n7, n6);
            ++n7;
            n6 += n3;
            if (n2 == 0) continue;
        }
    }

    public void addCustomHighlight(TextAreaHighlight textAreaHighlight) {
        textAreaHighlight.init(this.c, this.f);
        this.f = textAreaHighlight;
    }

    public void setBorder(int n2, Color color) {
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, n2, color));
    }

    @Override
    public void setBorder(Border border) {
        block3: {
            block2: {
                super.setBorder(border);
                if (border != null) break block2;
                this.h = 0;
                this.j.width = 0;
                this.j.height = 0;
                if (JEditTextArea.n == 0) break block3;
            }
            Insets insets = border.getBorderInsets(this);
            this.h = insets.left;
            this.j.width = insets.left + insets.right;
            this.j.height = insets.top + insets.bottom;
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.l = this.getFontMetrics(font);
        this.g = this.l.getHeight() - this.l.getMaxDescent();
    }

    public void setHighlightedForeground(Color color) {
        this.k = color;
    }

    public Color getHighlightedForeground() {
        return this.k;
    }

    public void setGutterWidth(int n2) {
        if (n2 < this.j.width) {
            n2 = this.j.width;
        }
        this.i.width = n2;
        if (!this.p) {
            this.c.revalidate();
        }
    }

    public int getGutterWidth() {
        return this.i.width;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.p) {
            return this.j;
        }
        return this.i;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return this.f == null ? null : this.f.getToolTipText(mouseEvent);
    }

    public boolean isLineNumberingEnabled() {
        return this.o;
    }

    public void setLineNumberingEnabled(boolean bl2) {
        if (this.o == bl2) {
            return;
        }
        this.o = bl2;
        this.setBorder(this.d.gutterBorderWidth, this.o ? this.d.gutterBorderColor : this.getBackground());
        this.repaint();
    }

    public int getLineNumberAlignment() {
        return this.m;
    }

    public void setLineNumberAlignment(int n2) {
        if (this.m == n2) {
            return;
        }
        this.m = n2;
        this.repaint();
    }

    public boolean isCollapsed() {
        return this.p;
    }

    public void setCollapsed(boolean bl2) {
        if (this.p == bl2) {
            return;
        }
        this.p = bl2;
        this.c.revalidate();
    }

    public void toggleCollapsed() {
        this.setCollapsed(!this.p);
    }

    public boolean isCollapseEnabled() {
        return this.q;
    }

    public void setCollapseEnabled(boolean bl2) {
        this.q = bl2;
    }

    public int getHighlightInterval() {
        return this.n;
    }

    public void setHighlightInterval(int n2) {
        if (n2 <= 1) {
            n2 = 0;
        }
        this.n = n2;
        this.repaint();
    }

    public JPopupMenu getContextMenu() {
        return this.e;
    }

    public void setContextMenu(JPopupMenu jPopupMenu) {
        this.e = jPopupMenu;
    }

    static /* synthetic */ JPopupMenu access$000(Gutter gutter) {
        return gutter.e;
    }

    static /* synthetic */ JEditTextArea access$100(Gutter gutter) {
        return gutter.c;
    }

    static /* synthetic */ boolean access$200(Gutter gutter) {
        return gutter.r;
    }

    static /* synthetic */ Dimension access$300(Gutter gutter) {
        return gutter.i;
    }

    static /* synthetic */ Dimension access$400(Gutter gutter) {
        return gutter.j;
    }
}

