/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.textarea;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.text.BadLocationException;
import org.jedit.textarea.JEditTextArea;
import org.jedit.textarea.TextUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InputHandler
extends KeyAdapter {
    private static final Logger a;
    public static final String SMART_HOME_END_PROPERTY;
    public static final ActionListener BACKSPACE;
    public static final ActionListener BACKSPACE_WORD;
    public static final ActionListener DELETE;
    public static final ActionListener DELETE_WORD;
    public static final ActionListener END;
    public static final ActionListener DOCUMENT_END;
    public static final ActionListener SELECT_END;
    public static final ActionListener SELECT_DOC_END;
    public static final ActionListener INSERT_BREAK;
    public static final ActionListener INSERT_TAB;
    public static final ActionListener HOME;
    public static final ActionListener DOCUMENT_HOME;
    public static final ActionListener SELECT_HOME;
    public static final ActionListener SELECT_DOC_HOME;
    public static final ActionListener NEXT_CHAR;
    public static final ActionListener NEXT_LINE;
    public static final ActionListener NEXT_PAGE;
    public static final ActionListener NEXT_WORD;
    public static final ActionListener SELECT_NEXT_CHAR;
    public static final ActionListener SELECT_NEXT_LINE;
    public static final ActionListener SELECT_NEXT_PAGE;
    public static final ActionListener SELECT_NEXT_WORD;
    public static final ActionListener OVERWRITE;
    public static final ActionListener PREV_CHAR;
    public static final ActionListener PREV_LINE;
    public static final ActionListener PREV_PAGE;
    public static final ActionListener PREV_WORD;
    public static final ActionListener SELECT_PREV_CHAR;
    public static final ActionListener SELECT_PREV_LINE;
    public static final ActionListener SELECT_PREV_PAGE;
    public static final ActionListener SELECT_PREV_WORD;
    public static final ActionListener REPEAT;
    public static final ActionListener SELECT_ALL;
    public static final ActionListener COPY_SELECTION;
    public static final ActionListener CUT_SELECTION;
    public static final ActionListener PASTE_SELECTION;
    public static final ActionListener INSERT_CHAR;
    private static Hashtable<String, ActionListener> b;
    protected ActionListener inputAction = INSERT_CHAR;
    protected ActionListener grabAction;
    protected boolean repeat;
    protected int repeatCount;
    protected MacroRecorder recorder;
    private static final String c;

    public static ActionListener getAction(String string) {
        return b.get(string);
    }

    public static String getActionName(ActionListener actionListener) {
        int n2 = JEditTextArea.n;
        Enumeration<String> enumeration = InputHandler.getActions();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            ActionListener actionListener2 = InputHandler.getAction(string);
            if (actionListener2 == actionListener) {
                return string;
            }
            if (n2 == 0) continue;
        }
        return null;
    }

    public static Enumeration<String> getActions() {
        return b.keys();
    }

    public abstract void addDefaultKeyBindings();

    public abstract void addKeyBinding(String var1, ActionListener var2);

    public abstract void removeKeyBinding(String var1);

    public abstract void removeAllKeyBindings();

    public void grabNextKeyStroke(ActionListener actionListener) {
        this.grabAction = actionListener;
    }

    public boolean isRepeatEnabled() {
        return this.repeat;
    }

    public void setRepeatEnabled(boolean bl2) {
        this.repeat = bl2;
        if (!bl2) {
            this.repeatCount = 0;
        }
    }

    public int getRepeatCount() {
        return this.repeat ? Math.max(1, this.repeatCount) : 1;
    }

    public void setRepeatCount(int n2) {
        this.repeatCount = n2;
    }

    public ActionListener getInputAction() {
        return this.inputAction;
    }

    public void setInputAction(ActionListener actionListener) {
        this.inputAction = actionListener;
    }

    public MacroRecorder getMacroRecorder() {
        return this.recorder;
    }

    public void setMacroRecorder(MacroRecorder macroRecorder) {
        this.recorder = macroRecorder;
    }

    public void executeAction(ActionListener actionListener, Object object, String string) {
        int n2;
        boolean bl2;
        block10: {
            ActionEvent actionEvent;
            int n3;
            block9: {
                n3 = JEditTextArea.n;
                actionEvent = new ActionEvent(object, 1001, string);
                if (actionListener instanceof Wrapper) {
                    actionListener.actionPerformed(actionEvent);
                    return;
                }
                bl2 = this.repeat;
                n2 = this.getRepeatCount();
                if (!(actionListener instanceof NonRepeatable)) break block9;
                actionListener.actionPerformed(actionEvent);
                if (n3 == 0) break block10;
            }
            for (int i2 = 0; i2 < Math.max(1, n2); ++i2) {
                actionListener.actionPerformed(actionEvent);
                if (n3 == 0) continue;
            }
        }
        if (this.grabAction == null) {
            if (this.recorder != null && !(actionListener instanceof NonRecordable)) {
                if (n2 != 1) {
                    this.recorder.actionPerformed(REPEAT, String.valueOf(n2));
                }
                this.recorder.actionPerformed(actionListener, string);
            }
            if (bl2) {
                this.setRepeatEnabled(false);
            }
        }
    }

    public static JEditTextArea getTextArea(EventObject eventObject) {
        Object object;
        int n2 = JEditTextArea.n;
        if (eventObject != null && (object = eventObject.getSource()) instanceof Component) {
            Component component = (Component)object;
            do {
                if (component instanceof JEditTextArea) {
                    return (JEditTextArea)component;
                }
                if (component == null && n2 == 0) break;
                component = component.getParent();
            } while (n2 == 0);
        }
        a.error(c);
        return null;
    }

    protected void handleGrabAction(KeyEvent keyEvent) {
        String string;
        ActionListener actionListener;
        block3: {
            block5: {
                int n2;
                int n3;
                block4: {
                    block2: {
                        n3 = JEditTextArea.n;
                        actionListener = this.grabAction;
                        this.grabAction = null;
                        char c2 = keyEvent.getKeyChar();
                        n2 = keyEvent.getKeyCode();
                        if (c2 == '\u0000') break block2;
                        string = String.valueOf(c2);
                        if (n3 == 0) break block3;
                    }
                    if (n2 != 9) break block4;
                    string = "\t";
                    if (n3 == 0) break block3;
                }
                if (n2 != 10) break block5;
                string = "\n";
                if (n3 == 0) break block3;
            }
            string = "\u0000";
        }
        this.executeAction(actionListener, keyEvent.getSource(), string);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String string2;
        int n2;
        String string3 = ".n\u0013i@\u000b^ \u0007\u0005\u0014O\u0015!\u0005\r\u0013}s\u0012\tO!!\u000e\u0005U3s\u000e\u0019W8Y2\tK;!\u0014LO<:\u0013LO;s2\u0003V5:\u000eL|!*@PI;>\u0001\u0005Uz4\u0015\u0015{>6\u0018\u0018\u0015;!\u0007R";
        int n3 = -1;
        block50: while (true) {
            char[] cArray;
            block59: {
                int n4;
                int n5;
                char[] cArray2;
                block58: {
                    char[] cArray3 = string3.toCharArray();
                    n2 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n6;
                    if (n6 <= 1) break block58;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n2) break block59;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n2;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n2 % 5) {
                            case 0: {
                                n8 = 108;
                                break;
                            }
                            case 1: {
                                n8 = 59;
                                break;
                            }
                            case 2: {
                                n8 = 84;
                                break;
                            }
                            case 3: {
                                n8 = 83;
                                break;
                            }
                            default: {
                                n8 = 96;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n2;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n7 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n2);
            }
            string2 = new String(cArray);
            switch (n3) {
                default: {
                    c = string2.intern();
                    string3 = "%U$&\u0014$Z:7\f\tIz;\u000f\u0001^\u0011=\u0004";
                    n3 = 0;
                    continue block50;
                }
                case 0: 
            }
            break;
        }
        SMART_HOME_END_PROPERTY = string2.intern();
        a = LoggerFactory.getLogger(InputHandler.class);
        BACKSPACE = new backspace();
        BACKSPACE_WORD = new backspace_word();
        DELETE = new delete();
        DELETE_WORD = new delete_word();
        END = new end(false);
        DOCUMENT_END = new document_end(false);
        SELECT_END = new end(true);
        SELECT_DOC_END = new document_end(true);
        INSERT_BREAK = new insert_break();
        INSERT_TAB = new insert_tab();
        HOME = new home(false);
        DOCUMENT_HOME = new document_home(false);
        SELECT_HOME = new home(true);
        SELECT_DOC_HOME = new document_home(true);
        NEXT_CHAR = new next_char(false);
        NEXT_LINE = new next_line(false);
        NEXT_PAGE = new next_page(false);
        NEXT_WORD = new next_word(false);
        SELECT_NEXT_CHAR = new next_char(true);
        SELECT_NEXT_LINE = new next_line(true);
        SELECT_NEXT_PAGE = new next_page(true);
        SELECT_NEXT_WORD = new next_word(true);
        OVERWRITE = new overwrite();
        PREV_CHAR = new prev_char(false);
        PREV_LINE = new prev_line(false);
        PREV_PAGE = new prev_page(false);
        PREV_WORD = new prev_word(false);
        SELECT_PREV_CHAR = new prev_char(true);
        SELECT_PREV_LINE = new prev_line(true);
        SELECT_PREV_PAGE = new prev_page(true);
        SELECT_PREV_WORD = new prev_word(true);
        REPEAT = new repeat();
        SELECT_ALL = new select_all();
        COPY_SELECTION = new copy_selection();
        CUT_SELECTION = new cut_selection();
        PASTE_SELECTION = new paste_selection();
        INSERT_CHAR = new insert_char();
        Hashtable<String, ActionListener> hashtable = b = new Hashtable();
        String string4 = "\u000eZ78\u0013\u001cZ76";
        int n9 = -1;
        block53: while (true) {
            char[] cArray;
            block61: {
                int n10;
                int n11;
                char[] cArray6;
                block60: {
                    char[] cArray7 = string4.toCharArray();
                    n2 = 0;
                    int n12 = cArray7.length;
                    cArray6 = cArray7;
                    n11 = n12;
                    if (n12 <= 1) break block60;
                    cArray = cArray6;
                    n10 = n11;
                    if (n11 <= n2) break block61;
                }
                do {
                    char[] cArray8 = cArray6;
                    char[] cArray9 = cArray6;
                    int n13 = n2;
                    while (true) {
                        int n14;
                        char c3 = cArray8[n13];
                        switch (n2 % 5) {
                            case 0: {
                                n14 = 108;
                                break;
                            }
                            case 1: {
                                n14 = 59;
                                break;
                            }
                            case 2: {
                                n14 = 84;
                                break;
                            }
                            case 3: {
                                n14 = 83;
                                break;
                            }
                            default: {
                                n14 = 96;
                            }
                        }
                        cArray8[n13] = (char)(c3 ^ n14);
                        ++n2;
                        cArray6 = cArray9;
                        n11 = n11;
                        if (n11 != 0) break;
                        cArray9 = cArray6;
                        n10 = n11;
                        n13 = n11;
                        cArray8 = cArray6;
                    }
                    cArray = cArray6;
                    n10 = n11;
                } while (n11 > n2);
            }
            string = new String(cArray).intern();
            switch (n9) {
                default: {
                    hashtable.put(string, BACKSPACE);
                    hashtable = b;
                    string4 = "\u000eZ78\u0013\u001cZ76M\u001bT&7";
                    n9 = 0;
                    continue block53;
                }
                case 0: {
                    hashtable.put(string, BACKSPACE_WORD);
                    hashtable = b;
                    string4 = "\b^86\u0014\t";
                    n9 = 1;
                    continue block53;
                }
                case 1: {
                    hashtable.put(string, DELETE);
                    hashtable = b;
                    string4 = "\b^86\u0014\t\u0016#<\u0012\b";
                    n9 = 2;
                    continue block53;
                }
                case 2: {
                    hashtable.put(string, DELETE_WORD);
                    hashtable = b;
                    string4 = "\tU0";
                    n9 = 3;
                    continue block53;
                }
                case 3: {
                    hashtable.put(string, END);
                    hashtable = b;
                    string4 = "\u001f^86\u0003\u0018\u00161=\u0004";
                    n9 = 4;
                    continue block53;
                }
                case 4: {
                    hashtable.put(string, SELECT_END);
                    hashtable = b;
                    string4 = "\bT7&\r\tU ~\u0005\u0002_";
                    n9 = 5;
                    continue block53;
                }
                case 5: {
                    hashtable.put(string, DOCUMENT_END);
                    hashtable = b;
                    string4 = "\u001f^86\u0003\u0018\u00160<\u0003A^:7";
                    n9 = 6;
                    continue block53;
                }
                case 6: {
                    hashtable.put(string, SELECT_DOC_END);
                    hashtable = b;
                    string4 = "\u0005U'6\u0012\u0018\u00166!\u0005\rP";
                    n9 = 7;
                    continue block53;
                }
                case 7: {
                    hashtable.put(string, INSERT_BREAK);
                    hashtable = b;
                    string4 = "\u0005U'6\u0012\u0018\u0016 2\u0002";
                    n9 = 8;
                    continue block53;
                }
                case 8: {
                    hashtable.put(string, INSERT_TAB);
                    hashtable = b;
                    string4 = "\u0004T96";
                    n9 = 9;
                    continue block53;
                }
                case 9: {
                    hashtable.put(string, HOME);
                    hashtable = b;
                    string4 = "\u001f^86\u0003\u0018\u0016<<\r\t";
                    n9 = 10;
                    continue block53;
                }
                case 10: {
                    hashtable.put(string, SELECT_HOME);
                    hashtable = b;
                    string4 = "\bT7&\r\tU ~\b\u0003V1";
                    n9 = 11;
                    continue block53;
                }
                case 11: {
                    hashtable.put(string, DOCUMENT_HOME);
                    hashtable = b;
                    string4 = "\u001f^86\u0003\u0018\u00160<\u0003AS;>\u0005";
                    n9 = 12;
                    continue block53;
                }
                case 12: {
                    hashtable.put(string, SELECT_DOC_HOME);
                    hashtable = b;
                    string4 = "\u0002^,'M\u000fS5!";
                    n9 = 13;
                    continue block53;
                }
                case 13: {
                    hashtable.put(string, NEXT_CHAR);
                    hashtable = b;
                    string4 = "\u0002^,'M\u0000R:6";
                    n9 = 14;
                    continue block53;
                }
                case 14: {
                    hashtable.put(string, NEXT_LINE);
                    hashtable = b;
                    string4 = "\u0002^,'M\u001cZ36";
                    n9 = 15;
                    continue block53;
                }
                case 15: {
                    hashtable.put(string, NEXT_PAGE);
                    hashtable = b;
                    string4 = "\u0002^,'M\u001bT&7";
                    n9 = 16;
                    continue block53;
                }
                case 16: {
                    hashtable.put(string, NEXT_WORD);
                    hashtable = b;
                    string4 = "\u001f^86\u0003\u0018\u0016:6\u0018\u0018\u00167;\u0001\u001e";
                    n9 = 17;
                    continue block53;
                }
                case 17: {
                    hashtable.put(string, SELECT_NEXT_CHAR);
                    hashtable = b;
                    string4 = "\u001f^86\u0003\u0018\u0016:6\u0018\u0018\u00168:\u000e\t";
                    n9 = 18;
                    continue block53;
                }
                case 18: {
                    hashtable.put(string, SELECT_NEXT_LINE);
                    hashtable = b;
                    string4 = "\u001f^86\u0003\u0018\u0016:6\u0018\u0018\u0016$2\u0007\t";
                    n9 = 19;
                    continue block53;
                }
                case 19: {
                    hashtable.put(string, SELECT_NEXT_PAGE);
                    hashtable = b;
                    string4 = "\u001f^86\u0003\u0018\u0016:6\u0018\u0018\u0016#<\u0012\b";
                    n9 = 20;
                    continue block53;
                }
                case 20: {
                    hashtable.put(string, SELECT_NEXT_WORD);
                    hashtable = b;
                    string4 = "\u0003M1!\u0017\u001eR 6";
                    n9 = 21;
                    continue block53;
                }
                case 21: {
                    hashtable.put(string, OVERWRITE);
                    hashtable = b;
                    string4 = "\u001cI1%M\u000fS5!";
                    n9 = 22;
                    continue block53;
                }
                case 22: {
                    hashtable.put(string, PREV_CHAR);
                    hashtable = b;
                    string4 = "\u001cI1%M\u0000R:6";
                    n9 = 23;
                    continue block53;
                }
                case 23: {
                    hashtable.put(string, PREV_LINE);
                    hashtable = b;
                    string4 = "\u001cI1%M\u001cZ36";
                    n9 = 24;
                    continue block53;
                }
                case 24: {
                    hashtable.put(string, PREV_PAGE);
                    hashtable = b;
                    string4 = "\u001cI1%M\u001bT&7";
                    n9 = 25;
                    continue block53;
                }
                case 25: {
                    hashtable.put(string, PREV_WORD);
                    hashtable = b;
                    string4 = "\u001f^86\u0003\u0018\u0016$!\u0005\u001a\u00167;\u0001\u001e";
                    n9 = 26;
                    continue block53;
                }
                case 26: {
                    hashtable.put(string, SELECT_PREV_CHAR);
                    hashtable = b;
                    string4 = "\u001f^86\u0003\u0018\u0016$!\u0005\u001a\u00168:\u000e\t";
                    n9 = 27;
                    continue block53;
                }
                case 27: {
                    hashtable.put(string, SELECT_PREV_LINE);
                    hashtable = b;
                    string4 = "\u001f^86\u0003\u0018\u0016$!\u0005\u001a\u0016$2\u0007\t";
                    n9 = 28;
                    continue block53;
                }
                case 28: {
                    hashtable.put(string, SELECT_PREV_PAGE);
                    hashtable = b;
                    string4 = "\u001f^86\u0003\u0018\u0016$!\u0005\u001a\u0016#<\u0012\b";
                    n9 = 29;
                    continue block53;
                }
                case 29: {
                    hashtable.put(string, SELECT_PREV_WORD);
                    hashtable = b;
                    string4 = "\u001e^$6\u0001\u0018";
                    n9 = 30;
                    continue block53;
                }
                case 30: {
                    hashtable.put(string, REPEAT);
                    hashtable = b;
                    string4 = "\u0005U'6\u0012\u0018\u00167;\u0001\u001e";
                    n9 = 31;
                    continue block53;
                }
                case 31: {
                    hashtable.put(string, INSERT_CHAR);
                    hashtable = b;
                    string4 = "\u001f^86\u0003\u0018\u00165?\f";
                    n9 = 32;
                    continue block53;
                }
                case 32: 
            }
            break;
        }
        hashtable.put(string, SELECT_ALL);
    }

    public static class paste_selection
    implements ActionListener,
    NonRepeatable {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            if (jEditTextArea.isEditable()) {
                jEditTextArea.paste();
            }
        }
    }

    public static class cut_selection
    implements ActionListener,
    NonRepeatable {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            if (jEditTextArea.isEditable()) {
                jEditTextArea.cut();
            }
        }
    }

    public static class copy_selection
    implements ActionListener,
    NonRepeatable {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            jEditTextArea.copy();
        }
    }

    public static class select_all
    implements ActionListener,
    NonRepeatable {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            jEditTextArea.selectAll();
        }
    }

    public static class insert_char
    implements ActionListener,
    NonRepeatable {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block4: {
                JEditTextArea jEditTextArea;
                block3: {
                    int n2 = JEditTextArea.n;
                    jEditTextArea = InputHandler.getTextArea(actionEvent);
                    String string = actionEvent.getActionCommand();
                    int n3 = jEditTextArea.getInputHandler().getRepeatCount();
                    if (!jEditTextArea.isEditable()) break block3;
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i2 = 0; i2 < n3; ++i2) {
                        stringBuilder.append(string);
                        if (n2 == 0) continue;
                    }
                    jEditTextArea.overwriteSetSelectedText(stringBuilder.toString());
                    if (n2 == 0) break block4;
                }
                jEditTextArea.getToolkit().beep();
            }
        }
    }

    public static class repeat
    implements ActionListener,
    NonRecordable {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            jEditTextArea.getInputHandler().setRepeatEnabled(true);
            String string = actionEvent.getActionCommand();
            if (string != null) {
                jEditTextArea.getInputHandler().setRepeatCount(Integer.parseInt(string));
            }
        }
    }

    public static class prev_word
    implements ActionListener {
        private boolean a;

        public prev_word(boolean bl2) {
            this.a = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block13: {
                int n2;
                int n3;
                JEditTextArea jEditTextArea;
                block12: {
                    int n4;
                    block11: {
                        boolean bl2;
                        String string;
                        block10: {
                            n4 = JEditTextArea.n;
                            jEditTextArea = InputHandler.getTextArea(actionEvent);
                            n3 = jEditTextArea.getCaretPosition();
                            int n5 = jEditTextArea.getCaretLine();
                            n2 = jEditTextArea.getLineStartOffset(n5);
                            string = jEditTextArea.getLineText(n5);
                            bl2 = false;
                            if ((n3 -= n2) != 0) break block10;
                            if (n2 == 0) {
                                jEditTextArea.getToolkit().beep();
                                return;
                            }
                            --n3;
                            if (n4 == 0) break block11;
                        }
                        if (bl2) {
                            while (n3 > 0 && string.charAt(n3 - 1) == ' ') {
                                --n3;
                                if (n4 == 0) continue;
                            }
                        }
                        if (n3 > 0) {
                            String string2 = "";
                            n3 = TextUtilities.findWordStart(string, n3 - 1, string2);
                        }
                    }
                    if (!this.a) break block12;
                    jEditTextArea.select(jEditTextArea.getMarkPosition(), n2 + n3);
                    if (n4 == 0) break block13;
                }
                jEditTextArea.setCaretPosition(n2 + n3);
            }
        }
    }

    public static class prev_page
    implements ActionListener {
        private boolean a;

        public prev_page(boolean bl2) {
            this.a = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block5: {
                int n2;
                JEditTextArea jEditTextArea;
                block4: {
                    jEditTextArea = InputHandler.getTextArea(actionEvent);
                    int n3 = jEditTextArea.getFirstLine();
                    int n4 = jEditTextArea.getVisibleLines();
                    int n5 = jEditTextArea.getCaretLine();
                    if (n3 < n4) {
                        n3 = n4;
                    }
                    jEditTextArea.setFirstLine(n3 - n4);
                    n2 = jEditTextArea.getLineStartOffset(Math.max(0, n5 - n4));
                    if (!this.a) break block4;
                    jEditTextArea.select(jEditTextArea.getMarkPosition(), n2);
                    if (JEditTextArea.n == 0) break block5;
                }
                jEditTextArea.setCaretPosition(n2);
            }
        }
    }

    public static class prev_line
    implements ActionListener {
        private boolean a;

        public prev_line(boolean bl2) {
            this.a = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n2;
            JEditTextArea jEditTextArea;
            block6: {
                int n3;
                block5: {
                    jEditTextArea = InputHandler.getTextArea(actionEvent);
                    n3 = jEditTextArea.getCaretPosition();
                    int n4 = jEditTextArea.getCaretLine();
                    if (n4 == 0) {
                        jEditTextArea.getToolkit().beep();
                        return;
                    }
                    n2 = jEditTextArea.getMagicCaretPosition();
                    if (n2 == -1) {
                        n2 = jEditTextArea.offsetToX(n4, n3 - jEditTextArea.getLineStartOffset(n4));
                    }
                    n3 = jEditTextArea.getLineStartOffset(n4 - 1) + jEditTextArea.xToOffset(n4 - 1, n2 + 1);
                    if (!this.a) break block5;
                    jEditTextArea.select(jEditTextArea.getMarkPosition(), n3);
                    if (JEditTextArea.n == 0) break block6;
                }
                jEditTextArea.setCaretPosition(n3);
            }
            jEditTextArea.setMagicCaretPosition(n2);
        }
    }

    public static class prev_char
    implements ActionListener {
        private boolean a;

        public prev_char(boolean bl2) {
            this.a = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block5: {
                int n2;
                JEditTextArea jEditTextArea;
                block4: {
                    jEditTextArea = InputHandler.getTextArea(actionEvent);
                    n2 = jEditTextArea.getCaretPosition();
                    if (n2 == 0) {
                        jEditTextArea.getToolkit().beep();
                        return;
                    }
                    if (!this.a) break block4;
                    jEditTextArea.select(jEditTextArea.getMarkPosition(), n2 - 1);
                    if (JEditTextArea.n == 0) break block5;
                }
                jEditTextArea.setCaretPosition(n2 - 1);
            }
        }
    }

    public static class overwrite
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea;
            jEditTextArea.setOverwriteEnabled(!(jEditTextArea = InputHandler.getTextArea(actionEvent)).isOverwriteEnabled());
        }
    }

    public static class next_word
    implements ActionListener {
        private boolean a;

        public next_word(boolean bl2) {
            this.a = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block15: {
                int n2;
                int n3;
                JEditTextArea jEditTextArea;
                block14: {
                    int n4;
                    block13: {
                        boolean bl2;
                        int n5;
                        String string;
                        block12: {
                            n4 = JEditTextArea.n;
                            jEditTextArea = InputHandler.getTextArea(actionEvent);
                            n3 = jEditTextArea.getCaretPosition();
                            int n6 = jEditTextArea.getCaretLine();
                            n2 = jEditTextArea.getLineStartOffset(n6);
                            string = jEditTextArea.getLineText(n6);
                            n5 = string.length();
                            bl2 = false;
                            if ((n3 -= n2) != n5) break block12;
                            if (n2 + n3 == jEditTextArea.getDocumentLength()) {
                                jEditTextArea.getToolkit().beep();
                                return;
                            }
                            ++n3;
                            if (n4 == 0) break block13;
                        }
                        if (bl2) {
                            while (n3 < n5 && string.charAt(n3) == ' ') {
                                ++n3;
                                if (n4 == 0) continue;
                            }
                        }
                        if (n3 < n5) {
                            String string2 = "";
                            if (bl2) {
                                for (n3 = TextUtilities.findWordEnd(string, n3 + 1, string2); n3 < n5 && string.charAt(n3) == ' '; ++n3) {
                                    if (n4 == 0) continue;
                                }
                            }
                        }
                    }
                    if (!this.a) break block14;
                    jEditTextArea.select(jEditTextArea.getMarkPosition(), n2 + n3);
                    if (n4 == 0) break block15;
                }
                jEditTextArea.setCaretPosition(n2 + n3);
            }
        }
    }

    public static class next_page
    implements ActionListener {
        private boolean a;

        public next_page(boolean bl2) {
            this.a = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block5: {
                int n2;
                JEditTextArea jEditTextArea;
                block4: {
                    jEditTextArea = InputHandler.getTextArea(actionEvent);
                    int n3 = jEditTextArea.getLineCount();
                    int n4 = jEditTextArea.getFirstLine();
                    int n5 = jEditTextArea.getVisibleLines();
                    int n6 = jEditTextArea.getCaretLine();
                    if ((n4 += n5) + n5 >= n3 - 1) {
                        n4 = n3 - n5;
                    }
                    jEditTextArea.setFirstLine(n4);
                    n2 = jEditTextArea.getLineStartOffset(Math.min(jEditTextArea.getLineCount() - 1, n6 + n5));
                    if (!this.a) break block4;
                    jEditTextArea.select(jEditTextArea.getMarkPosition(), n2);
                    if (JEditTextArea.n == 0) break block5;
                }
                jEditTextArea.setCaretPosition(n2);
            }
        }
    }

    public static class next_line
    implements ActionListener {
        private boolean a;

        public next_line(boolean bl2) {
            this.a = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n2;
            JEditTextArea jEditTextArea;
            block6: {
                int n3;
                block5: {
                    jEditTextArea = InputHandler.getTextArea(actionEvent);
                    n3 = jEditTextArea.getCaretPosition();
                    int n4 = jEditTextArea.getCaretLine();
                    if (n4 == jEditTextArea.getLineCount() - 1) {
                        jEditTextArea.getToolkit().beep();
                        return;
                    }
                    n2 = jEditTextArea.getMagicCaretPosition();
                    if (n2 == -1) {
                        n2 = jEditTextArea.offsetToX(n4, n3 - jEditTextArea.getLineStartOffset(n4));
                    }
                    n3 = jEditTextArea.getLineStartOffset(n4 + 1) + jEditTextArea.xToOffset(n4 + 1, n2 + 1);
                    if (!this.a) break block5;
                    jEditTextArea.select(jEditTextArea.getMarkPosition(), n3);
                    if (JEditTextArea.n == 0) break block6;
                }
                jEditTextArea.setCaretPosition(n3);
            }
            jEditTextArea.setMagicCaretPosition(n2);
        }
    }

    public static class next_char
    implements ActionListener {
        private boolean a;

        public next_char(boolean bl2) {
            this.a = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block5: {
                int n2;
                JEditTextArea jEditTextArea;
                block4: {
                    jEditTextArea = InputHandler.getTextArea(actionEvent);
                    n2 = jEditTextArea.getCaretPosition();
                    if (n2 == jEditTextArea.getDocumentLength()) {
                        jEditTextArea.getToolkit().beep();
                        return;
                    }
                    if (!this.a) break block4;
                    jEditTextArea.select(jEditTextArea.getMarkPosition(), n2 + 1);
                    if (JEditTextArea.n == 0) break block5;
                }
                jEditTextArea.setCaretPosition(n2 + 1);
            }
        }
    }

    public static class insert_tab
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            if (!jEditTextArea.isEditable()) {
                jEditTextArea.getToolkit().beep();
                return;
            }
            jEditTextArea.overwriteSetSelectedText("\t");
        }
    }

    public static class insert_break
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            if (!jEditTextArea.isEditable()) {
                jEditTextArea.getToolkit().beep();
                return;
            }
            jEditTextArea.setSelectedText("\n");
        }
    }

    public static class document_home
    implements ActionListener {
        private boolean a;

        public document_home(boolean bl2) {
            this.a = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                JEditTextArea jEditTextArea;
                block2: {
                    jEditTextArea = InputHandler.getTextArea(actionEvent);
                    if (!this.a) break block2;
                    jEditTextArea.select(jEditTextArea.getMarkPosition(), 0);
                    if (JEditTextArea.n == 0) break block3;
                }
                jEditTextArea.setCaretPosition(0);
            }
        }
    }

    public static class home
    implements ActionListener {
        private boolean a;
        private static final String b;

        public home(boolean bl2) {
            this.a = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block18: {
                int n2;
                JEditTextArea jEditTextArea;
                block17: {
                    int n3;
                    block13: {
                        int n4;
                        block16: {
                            int n5;
                            block15: {
                                int n6;
                                block14: {
                                    block10: {
                                        block12: {
                                            block11: {
                                                n3 = JEditTextArea.n;
                                                jEditTextArea = InputHandler.getTextArea(actionEvent);
                                                n2 = jEditTextArea.getCaretPosition();
                                                int n7 = jEditTextArea.getFirstLine();
                                                n5 = jEditTextArea.getLineStartOffset(jEditTextArea.getCaretLine());
                                                int n8 = n7 == 0 ? 0 : n7 + jEditTextArea.getElectricScroll();
                                                n6 = jEditTextArea.getLineStartOffset(n8);
                                                if (n2 == 0) {
                                                    jEditTextArea.getToolkit().beep();
                                                    return;
                                                }
                                                if (Boolean.TRUE.equals(jEditTextArea.getClientProperty(b))) break block10;
                                                n4 = TextUtilities.getLeadingWhiteSpace(jEditTextArea.getLineText(jEditTextArea.getCaretLine()));
                                                if (n2 != (n4 += n5)) break block11;
                                                n2 = n5;
                                                if (n3 == 0) break block12;
                                            }
                                            n2 = n4;
                                        }
                                        if (n3 == 0) break block13;
                                    }
                                    if (n2 != n6) break block14;
                                    n2 = 0;
                                    if (n3 == 0) break block13;
                                }
                                if (n2 != n5) break block15;
                                n2 = n6;
                                if (n3 == 0) break block13;
                            }
                            n4 = TextUtilities.getLeadingWhiteSpace(jEditTextArea.getLineText(jEditTextArea.getCaretLine()));
                            if (n2 != (n4 += n5)) break block16;
                            n2 = n5;
                            if (n3 == 0) break block13;
                        }
                        n2 = n4;
                    }
                    if (!this.a) break block17;
                    jEditTextArea.select(jEditTextArea.getMarkPosition(), n2);
                    if (n3 == 0) break block18;
                }
                jEditTextArea.setCaretPosition(n2);
            }
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "Ri(\u001aRSf6\u000bJ~uv\u0007Ivb\u001d\u0001B".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 27;
                                break;
                            }
                            case 1: {
                                n7 = 7;
                                break;
                            }
                            case 2: {
                                n7 = 88;
                                break;
                            }
                            case 3: {
                                n7 = 111;
                                break;
                            }
                            default: {
                                n7 = 38;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            b = new String(cArray).intern();
        }
    }

    public static class document_end
    implements ActionListener {
        private boolean a;

        public document_end(boolean bl2) {
            this.a = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                JEditTextArea jEditTextArea;
                block2: {
                    jEditTextArea = InputHandler.getTextArea(actionEvent);
                    if (!this.a) break block2;
                    jEditTextArea.select(jEditTextArea.getMarkPosition(), jEditTextArea.getDocumentLength());
                    if (JEditTextArea.n == 0) break block3;
                }
                jEditTextArea.setCaretPosition(jEditTextArea.getDocumentLength());
            }
        }
    }

    public static class end
    implements ActionListener {
        private boolean a;
        private static final String b;

        public end(boolean bl2) {
            this.a = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block17: {
                int n2;
                JEditTextArea jEditTextArea;
                block16: {
                    int n3;
                    block13: {
                        int n4;
                        block15: {
                            int n5;
                            block14: {
                                int n6;
                                block12: {
                                    int n7;
                                    block11: {
                                        block10: {
                                            n3 = JEditTextArea.n;
                                            jEditTextArea = InputHandler.getTextArea(actionEvent);
                                            n2 = jEditTextArea.getCaretPosition();
                                            n4 = jEditTextArea.getLineEndOffset(jEditTextArea.getCaretLine()) - 1;
                                            n7 = jEditTextArea.getFirstLine() + jEditTextArea.getVisibleLines();
                                            if (n7 < jEditTextArea.getLineCount()) break block10;
                                            n7 = Math.min(jEditTextArea.getLineCount() - 1, n7);
                                            if (n3 == 0) break block11;
                                        }
                                        n7 -= jEditTextArea.getElectricScroll() + 1;
                                    }
                                    n5 = jEditTextArea.getLineEndOffset(n7) - 1;
                                    n6 = jEditTextArea.getDocumentLength();
                                    if (n2 == n6) {
                                        jEditTextArea.getToolkit().beep();
                                        return;
                                    }
                                    if (Boolean.TRUE.equals(jEditTextArea.getClientProperty(b))) break block12;
                                    n2 = n4;
                                    if (n3 == 0) break block13;
                                }
                                if (n2 != n5) break block14;
                                n2 = n6;
                                if (n3 == 0) break block13;
                            }
                            if (n2 != n4) break block15;
                            n2 = n5;
                            if (n3 == 0) break block13;
                        }
                        n2 = n4;
                    }
                    if (!this.a) break block16;
                    jEditTextArea.select(jEditTextArea.getMarkPosition(), n2);
                    if (n3 == 0) break block17;
                }
                jEditTextArea.setCaretPosition(n2);
            }
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = ":\u0001%,,;\u000e;=4\u0016\u001d{17\u001e\n\u00107<".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 115;
                                break;
                            }
                            case 1: {
                                n7 = 111;
                                break;
                            }
                            case 2: {
                                n7 = 85;
                                break;
                            }
                            case 3: {
                                n7 = 89;
                                break;
                            }
                            default: {
                                n7 = 88;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            b = new String(cArray).intern();
        }
    }

    public static class delete_word
    implements ActionListener {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n2;
            int n3;
            int n4;
            JEditTextArea jEditTextArea;
            block11: {
                String string;
                block10: {
                    jEditTextArea = InputHandler.getTextArea(actionEvent);
                    n4 = jEditTextArea.getSelectionStart();
                    if (n4 != jEditTextArea.getSelectionEnd()) {
                        jEditTextArea.setSelectedText("");
                        return;
                    }
                    int n5 = jEditTextArea.getCaretLine();
                    n3 = jEditTextArea.getLineStartOffset(n5);
                    n2 = n4 - n3;
                    if (n2 != (string = jEditTextArea.getLineText(jEditTextArea.getCaretLine())).length()) break block10;
                    if (n3 + n2 == jEditTextArea.getDocumentLength()) {
                        jEditTextArea.getToolkit().beep();
                        return;
                    }
                    ++n2;
                    if (JEditTextArea.n == 0) break block11;
                }
                String string2 = "";
                n2 = TextUtilities.findWordEnd(string, n2 + 1, string2);
            }
            try {
                jEditTextArea.getDocument().remove(n4, n2 + n3 - n4);
                return;
            }
            catch (BadLocationException badLocationException) {
                a.error("", (Throwable)badLocationException);
            }
        }
    }

    public static class delete
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block11: {
                JEditTextArea jEditTextArea;
                block10: {
                    jEditTextArea = InputHandler.getTextArea(actionEvent);
                    if (!jEditTextArea.isEditable()) {
                        jEditTextArea.getToolkit().beep();
                        return;
                    }
                    if (jEditTextArea.getSelectionStart() == jEditTextArea.getSelectionEnd()) break block10;
                    jEditTextArea.setSelectedText("");
                    if (JEditTextArea.n == 0) break block11;
                }
                int n2 = jEditTextArea.getCaretPosition();
                if (n2 == jEditTextArea.getDocumentLength()) {
                    jEditTextArea.getToolkit().beep();
                    return;
                }
                try {
                    jEditTextArea.getDocument().remove(n2, 1);
                }
                catch (BadLocationException badLocationException) {
                    a.error("", (Throwable)badLocationException);
                }
            }
        }
    }

    public static class backspace_word
    implements ActionListener {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n2;
            int n3;
            int n4;
            JEditTextArea jEditTextArea;
            block11: {
                String string;
                block10: {
                    jEditTextArea = InputHandler.getTextArea(actionEvent);
                    n4 = jEditTextArea.getSelectionStart();
                    if (n4 != jEditTextArea.getSelectionEnd()) {
                        jEditTextArea.setSelectedText("");
                        return;
                    }
                    int n5 = jEditTextArea.getCaretLine();
                    n3 = jEditTextArea.getLineStartOffset(n5);
                    n2 = n4 - n3;
                    string = jEditTextArea.getLineText(jEditTextArea.getCaretLine());
                    if (n2 != 0) break block10;
                    if (n3 == 0) {
                        jEditTextArea.getToolkit().beep();
                        return;
                    }
                    --n2;
                    if (JEditTextArea.n == 0) break block11;
                }
                String string2 = "";
                n2 = TextUtilities.findWordStart(string, n2 - 1, string2);
            }
            try {
                jEditTextArea.getDocument().remove(n2 + n3, n4 - (n2 + n3));
                return;
            }
            catch (BadLocationException badLocationException) {
                a.error("", (Throwable)badLocationException);
            }
        }
    }

    public static class backspace
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block11: {
                JEditTextArea jEditTextArea;
                block10: {
                    jEditTextArea = InputHandler.getTextArea(actionEvent);
                    if (!jEditTextArea.isEditable()) {
                        jEditTextArea.getToolkit().beep();
                        return;
                    }
                    if (jEditTextArea.getSelectionStart() == jEditTextArea.getSelectionEnd()) break block10;
                    jEditTextArea.setSelectedText("");
                    if (JEditTextArea.n == 0) break block11;
                }
                int n2 = jEditTextArea.getCaretPosition();
                if (n2 == 0) {
                    jEditTextArea.getToolkit().beep();
                    return;
                }
                try {
                    jEditTextArea.getDocument().remove(n2 - 1, 1);
                }
                catch (BadLocationException badLocationException) {
                    a.error("", (Throwable)badLocationException);
                }
            }
        }
    }

    public static interface MacroRecorder {
        public void actionPerformed(ActionListener var1, String var2);
    }

    public static interface Wrapper {
    }

    public static interface NonRecordable {
    }

    public static interface NonRepeatable {
    }
}

