/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.textarea;

import com.agilemind.commons.gui.TextComponentPopupMenu;
import com.agilemind.commons.gui.TextComponentToolbar;
import com.agilemind.commons.gui.search.SearchReplaceControllerHelper;
import com.agilemind.commons.gui.search.TextComponentSearchReplaceHelper;
import com.agilemind.commons.gui.undoredo.UndoRedoHandler;
import com.agilemind.commons.gui.util.UiUtil;
import com.agilemind.commons.util.StringUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.Timer;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.jedit.gui.KeyEventWorkaround;
import org.jedit.syntax.SyntaxDocument;
import org.jedit.syntax.SyntaxStyle;
import org.jedit.syntax.Token;
import org.jedit.syntax.TokenMarker;
import org.jedit.textarea.DefaultInputHandler;
import org.jedit.textarea.Gutter;
import org.jedit.textarea.InputHandler;
import org.jedit.textarea.TextAreaDefaults;
import org.jedit.textarea.TextAreaPainter;
import org.jedit.textarea.TextUtilities;
import org.jedit.textarea.a;
import org.jedit.textarea.b;
import org.jedit.textarea.d;
import org.jedit.textarea.e;
import org.jedit.textarea.h;
import org.jedit.textarea.i;
import org.jedit.textarea.j;
import org.jedit.textarea.l;
import org.jedit.textarea.m;
import org.jedit.textarea.n;
import org.jedit.textarea.o;
import org.jedit.textarea.p;
import org.jedit.textarea.q;
import org.jedit.textarea.r;
import org.jedit.textarea.t;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JEditTextArea
extends JTextComponent {
    public static String LEFT_OF_SCROLLBAR;
    protected static String CENTER;
    protected static String RIGHT;
    protected static String LEFT;
    protected static String BOTTOM;
    protected static JEditTextArea focusedComponent;
    protected static Timer caretTimer;
    private InputHandler a = new DefaultInputHandler();
    Segment b;
    protected TextAreaPainter painter;
    protected Gutter gutter;
    protected EventListenerList listenerList;
    protected r caretEvent;
    protected boolean caretBlinks;
    protected boolean caretVisible;
    protected boolean blink;
    protected boolean editable;
    protected int maxHorizontalScrollWidth;
    protected int firstLine;
    protected int visibleLines;
    protected int electricScroll;
    protected int horizontalOffset;
    protected JScrollBar vertical;
    protected JScrollBar horizontal;
    protected boolean scrollBarsInitialized;
    protected SyntaxDocument document;
    protected m documentHandler;
    protected boolean documentHandlerInstalled;
    protected int selectionStart;
    protected int selectionStartLine;
    protected int selectionEnd;
    protected int selectionEndLine;
    protected boolean biasLeft;
    protected int bracketPosition;
    protected int bracketLine;
    protected int magicCaret;
    protected boolean overwrite;
    protected boolean rectSelect;
    private p c = new p(0, 0, null);
    private int d;
    private boolean e = false;
    private boolean f = false;
    private boolean g = false;
    private int h = -1;
    private int i = -1;
    private JPopupMenu j;
    private UndoRedoHandler k;
    private static final Logger l;
    public static final TextComponentPopupMenu.DocumentFactory SYNTAX_DOCUMENT_FACTORY;
    public static int n;
    private static final String[] o;

    public JEditTextArea(SearchReplaceControllerHelper searchReplaceControllerHelper, String string) {
        this(searchReplaceControllerHelper, null, string);
    }

    public JEditTextArea(SearchReplaceControllerHelper searchReplaceControllerHelper, TextComponentToolbar textComponentToolbar, String string) {
        this(searchReplaceControllerHelper, TextAreaDefaults.getDefaults(), textComponentToolbar, string);
    }

    public JEditTextArea(SearchReplaceControllerHelper searchReplaceControllerHelper, TextAreaDefaults textAreaDefaults, TextComponentToolbar textComponentToolbar, String string) {
        this.a(textAreaDefaults);
        new TextComponentSearchReplaceHelper(searchReplaceControllerHelper, this);
        TextComponentPopupMenu textComponentPopupMenu = new TextComponentPopupMenu(this, textComponentToolbar, SYNTAX_DOCUMENT_FACTORY, textAreaDefaults.editable);
        this.setPopupMenu(textComponentPopupMenu);
        this.k = textComponentPopupMenu.getUndoRedoHandler();
        UiUtil.setWindowsCopyPaste(this);
        this.setTabSize(4);
        this.setName(string);
    }

    private void a(TextAreaDefaults textAreaDefaults) {
        this.enableEvents(8L);
        this.painter = new TextAreaPainter(this, textAreaDefaults);
        this.gutter = new Gutter(this, textAreaDefaults);
        this.documentHandler = new m(this);
        this.listenerList = new EventListenerList();
        this.caretEvent = new r(this);
        this.bracketPosition = -1;
        this.bracketLine = -1;
        this.blink = true;
        this.b = new Segment();
        this.setLayout(new q(this));
        this.add(LEFT, this.gutter);
        this.add(CENTER, this.painter);
        this.vertical = new JScrollBar(1);
        this.add(RIGHT, this.vertical);
        this.horizontal = new JScrollBar(0);
        this.add(BOTTOM, this.horizontal);
        this.vertical.addAdjustmentListener(new j(this));
        this.horizontal.addAdjustmentListener(new j(this));
        this.painter.addComponentListener(new b(this));
        this.painter.addMouseListener(new d(this));
        this.painter.addMouseMotionListener(new n(this));
        this.addFocusListener(new o(this));
        this.editable = textAreaDefaults.editable;
        this.caretVisible = textAreaDefaults.caretVisible;
        this.caretBlinks = textAreaDefaults.caretBlinks;
        this.electricScroll = textAreaDefaults.electricScroll;
        focusedComponent = this;
        this.a();
        this.painter.addComponentListener(new a(this));
    }

    @Override
    public TextUI getUI() {
        return null;
    }

    @Override
    public void setUI(TextUI textUI) {
    }

    @Override
    public void updateUI() {
    }

    private void a() {
        this.addMouseWheelListener(new h(this));
    }

    public JPopupMenu getPopupMenu() {
        return this.j;
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.j = jPopupMenu;
    }

    public void setLineNumbersVisible(boolean bl2) {
        this.gutter.setLineNumberingEnabled(bl2);
        this.gutter.setCollapsed(!bl2);
        this.gutter.setCollapseEnabled(bl2);
    }

    @Override
    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public InputHandler getInputHandler() {
        return this.a;
    }

    @Override
    public final boolean isManagingFocus() {
        return true;
    }

    @Override
    public final Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public final TextAreaPainter getPainter() {
        return this.painter;
    }

    public final Gutter getGutter() {
        return this.gutter;
    }

    public final boolean isCaretBlinkEnabled() {
        return this.caretBlinks;
    }

    public void setCaretBlinkEnabled(boolean bl2) {
        this.caretBlinks = bl2;
        if (!bl2) {
            this.blink = false;
        }
        this.painter.invalidateSelectedLines();
    }

    public final boolean isCaretVisible() {
        return (!this.caretBlinks || this.blink) && this.caretVisible;
    }

    public void setCaretVisible(boolean bl2) {
        this.caretVisible = bl2;
        this.blink = true;
        this.painter.invalidateSelectedLines();
    }

    public final void blinkCaret() {
        block3: {
            block2: {
                if (!this.caretBlinks) break block2;
                this.blink = !this.blink;
                this.painter.invalidateSelectedLines();
                if (n == 0) break block3;
            }
            this.blink = true;
        }
    }

    public final int getElectricScroll() {
        return this.electricScroll;
    }

    public final void setElectricScroll(int n2) {
        this.electricScroll = n2;
    }

    public void updateScrollBars() {
        int n2;
        this.e();
        if (this.vertical != null && this.visibleLines != 0) {
            int n3;
            n2 = this.getLineCount();
            if (this.firstLine < 0) {
                this.setFirstLine(0);
                return;
            }
            if (n2 < this.firstLine + this.visibleLines && (n3 = Math.max(0, n2 - this.visibleLines)) != this.firstLine) {
                this.setFirstLine(n3);
                return;
            }
            this.vertical.setValues(this.firstLine, this.visibleLines, 0, this.getLineCount());
            this.vertical.setUnitIncrement(2);
            this.vertical.setBlockIncrement(this.visibleLines);
        }
        n2 = this.painter.getWidth();
        if (this.horizontal != null && n2 != 0) {
            this.maxHorizontalScrollWidth = 0;
            this.painter.repaint();
            this.horizontal.setUnitIncrement(this.painter.getFontMetrics().charWidth('w'));
            this.horizontal.setBlockIncrement(n2 / 2);
        }
    }

    private boolean b() {
        return this.c.a > this.getWidth();
    }

    private boolean c() {
        return this.getLineCount() > this.getVisibleLines();
    }

    public final int getFirstLine() {
        return this.firstLine;
    }

    public void setFirstLine(int n2) {
        if (n2 == this.firstLine) {
            return;
        }
        this.firstLine = n2;
        this.maxHorizontalScrollWidth = 0;
        if (n2 != this.vertical.getValue()) {
            this.updateScrollBars();
        }
        this.painter.repaint();
        this.gutter.repaint();
    }

    public final int getVisibleLines() {
        return this.visibleLines;
    }

    public final void recalculateVisibleLines() {
        if (this.painter == null) {
            return;
        }
        int n2 = this.painter.getHeight();
        int n3 = this.painter.getFontMetrics().getHeight();
        this.visibleLines = n2 / n3;
        this.updateScrollBars();
    }

    void d() {
        int n2 = this.getTokenMarker().getMaxLineWidth();
        if (n2 != this.maxHorizontalScrollWidth) {
            this.maxHorizontalScrollWidth = n2;
            this.horizontal.setValues(-this.horizontalOffset, this.painter.getWidth(), 0, this.maxHorizontalScrollWidth + this.painter.getFontMetrics().charWidth('w'));
        }
    }

    public final int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void setHorizontalOffset(int n2) {
        if (n2 == this.horizontalOffset) {
            return;
        }
        this.horizontalOffset = n2;
        if (n2 != this.horizontal.getValue()) {
            this.updateScrollBars();
        }
        this.painter.repaint();
    }

    public boolean setOrigin(int n2, int n3) {
        boolean bl2 = false;
        if (n3 != this.horizontalOffset) {
            this.horizontalOffset = n3;
            bl2 = true;
        }
        if (n2 != this.firstLine) {
            this.firstLine = n2;
            bl2 = true;
        }
        if (bl2) {
            this.updateScrollBars();
            this.painter.repaint();
            this.gutter.repaint();
        }
        return bl2;
    }

    public boolean scrollToCaret() {
        int n2 = this.getCaretLine();
        int n3 = this.getLineStartOffset(n2);
        int n4 = this.getLineLength(n2);
        int n5 = Math.max(0, Math.min(n4 - 1, (this.biasLeft ? this.selectionStart : this.selectionEnd) - n3));
        return this.scrollTo(n2, n5);
    }

    public boolean scrollTo(int n2, int n3) {
        int n4;
        int n5;
        block13: {
            block14: {
                int n6;
                int n7;
                int n8;
                int n9;
                block12: {
                    block11: {
                        block10: {
                            n9 = n;
                            if (this.visibleLines == 0) {
                                this.setFirstLine(Math.max(0, n2 - this.electricScroll));
                                return true;
                            }
                            n5 = this.firstLine;
                            if (n2 >= this.firstLine + this.electricScroll) break block10;
                            n5 = Math.max(0, n2 - this.electricScroll);
                            if (n9 == 0) break block11;
                        }
                        if (n2 + this.electricScroll >= this.firstLine + this.visibleLines) {
                            n5 = n2 - this.visibleLines + this.electricScroll + 1;
                            if (n5 + this.visibleLines >= this.getLineCount()) {
                                n5 = this.getLineCount() - this.visibleLines;
                            }
                            if (n5 < 0) {
                                n5 = 0;
                            }
                        }
                    }
                    n8 = this.offsetToX(n2, n3);
                    int n10 = this.painter.getSize().width;
                    n7 = this.painter.getFontMetrics().charWidth('w');
                    n6 = this.horizontalOffset - n8;
                    if (n8 < n10) break block12;
                    n4 = Math.min(0, n6 + n10 - 10 * n7);
                    if (n9 == 0) break block13;
                }
                if (n8 >= 0) break block14;
                n4 = Math.min(0, n6 + 10 * n7);
                if (n9 == 0) break block13;
            }
            n4 = this.horizontalOffset;
        }
        return this.setOrigin(n5, n4);
    }

    public int lineToY(int n2) {
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        return (n2 - this.firstLine) * fontMetrics.getHeight() - (fontMetrics.getLeading() + fontMetrics.getMaxDescent());
    }

    public int yToLine(int n2) {
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        int n3 = fontMetrics.getHeight();
        return Math.max(0, Math.min(this.getLineCount() - 1, n2 / n3 + this.firstLine));
    }

    public int offsetToX(int n2, int n3) {
        int n4 = n;
        TokenMarker tokenMarker = this.getTokenMarker();
        FontMetrics fontMetrics = this.painter.getFontMetrics();
        this.getLineText(n2, this.b);
        int n5 = this.b.offset;
        int n6 = this.horizontalOffset;
        if (tokenMarker == null) {
            this.b.count = n3;
            return n6 + Utilities.getTabbedTextWidth(this.b, fontMetrics, n6, (TabExpander)this.painter, 0);
        }
        Token token = tokenMarker.markTokens(this.b, n2);
        Font font = this.painter.getFont();
        SyntaxStyle[] syntaxStyleArray = this.painter.getStyles();
        while (true) {
            int n7;
            block8: {
                byte by2;
                block7: {
                    if ((by2 = token.id) == 127) {
                        return n6;
                    }
                    if (by2 != 0) break block7;
                    fontMetrics = this.painter.getFontMetrics();
                    if (n4 == 0) break block8;
                }
                fontMetrics = syntaxStyleArray[by2].getFontMetrics(font);
            }
            if (n3 + n5 < this.b.offset + (n7 = token.length)) {
                this.b.count = n3 - (this.b.offset - n5);
                return n6 + Utilities.getTabbedTextWidth(this.b, fontMetrics, n6, (TabExpander)this.painter, 0);
            }
            this.b.count = n7;
            n6 += Utilities.getTabbedTextWidth(this.b, fontMetrics, n6, (TabExpander)this.painter, 0);
            this.b.offset += n7;
            token = token.next;
        }
    }

    public int xToOffset(int n2, int n3) {
        int n4;
        int n5;
        char[] cArray;
        FontMetrics fontMetrics;
        TokenMarker tokenMarker;
        int n6;
        block15: {
            n6 = n;
            tokenMarker = this.getTokenMarker();
            fontMetrics = this.painter.getFontMetrics();
            this.getLineText(n2, this.b);
            cArray = this.b.array;
            n5 = this.b.offset;
            int n7 = this.b.count;
            n4 = this.horizontalOffset;
            if (tokenMarker != null) break block15;
            for (int i2 = 0; i2 < n7; ++i2) {
                int n8;
                block17: {
                    char c2;
                    block16: {
                        c2 = cArray[i2 + n5];
                        if (c2 != '\t') break block16;
                        n8 = (int)this.painter.nextTabStop(n4, i2) - n4;
                        if (n6 == 0) break block17;
                    }
                    n8 = fontMetrics.charWidth(c2);
                }
                if (this.painter.isBlockCaretEnabled() ? n3 - n8 <= n4 : n3 - n8 / 2 <= n4) {
                    return i2;
                }
                n4 += n8;
                if (n6 == 0) continue;
            }
            return n7;
        }
        Token token = tokenMarker.markTokens(this.b, n2);
        int n9 = 0;
        Font font = this.painter.getFont();
        SyntaxStyle[] syntaxStyleArray = this.painter.getStyles();
        while (true) {
            block19: {
                byte by2;
                block18: {
                    if ((by2 = token.id) == 127) {
                        return n9;
                    }
                    if (by2 != 0) break block18;
                    fontMetrics = this.painter.getFontMetrics();
                    if (n6 == 0) break block19;
                }
                fontMetrics = syntaxStyleArray[by2].getFontMetrics(font);
            }
            int n10 = token.length;
            for (int i3 = 0; i3 < n10; ++i3) {
                int n11;
                block21: {
                    char c3;
                    block20: {
                        c3 = cArray[n5 + n9 + i3];
                        if (c3 != '\t') break block20;
                        n11 = (int)this.painter.nextTabStop(n4, n9 + i3) - n4;
                        if (n6 == 0) break block21;
                    }
                    n11 = fontMetrics.charWidth(c3);
                }
                if (this.painter.isBlockCaretEnabled() ? n3 - n11 <= n4 : n3 - n11 / 2 <= n4) {
                    return n9 + i3;
                }
                n4 += n11;
                if (n6 == 0) continue;
            }
            n9 += n10;
            token = token.next;
        }
    }

    public int xyToOffset(int n2, int n3) {
        int n4 = this.yToLine(n3);
        int n5 = this.getLineStartOffset(n4);
        return n5 + this.xToOffset(n4, n2);
    }

    @Override
    public final SyntaxDocument getDocument() {
        return this.document;
    }

    public void setDocument(SyntaxDocument syntaxDocument) {
        if (this.document == syntaxDocument) {
            return;
        }
        if (this.document != null) {
            this.document.removeDocumentListener(this.documentHandler);
        }
        this.document = syntaxDocument;
        syntaxDocument.addDocumentListener(this.documentHandler);
        this.documentHandlerInstalled = true;
        this.maxHorizontalScrollWidth = 0;
        this.a(0, 0);
        this.updateScrollBars();
        this.painter.repaint();
        this.gutter.repaint();
    }

    public final TokenMarker getTokenMarker() {
        return this.document.getTokenMarker();
    }

    public final void setTokenMarker(TokenMarker tokenMarker) {
        this.document.setTokenMarker(tokenMarker);
    }

    public final int getDocumentLength() {
        return this.document.getLength();
    }

    public final int getLineCount() {
        return this.document.getDefaultRootElement().getElementCount();
    }

    public final int getLineOfOffset(int n2) {
        return this.document.getDefaultRootElement().getElementIndex(n2);
    }

    public int getLineStartOffset(int n2) {
        Element element = this.document.getDefaultRootElement().getElement(n2);
        if (element == null) {
            return -1;
        }
        return element.getStartOffset();
    }

    public int getLineEndOffset(int n2) {
        Element element = this.document.getDefaultRootElement().getElement(n2);
        if (element == null) {
            return -1;
        }
        return element.getEndOffset();
    }

    public int getLineLength(int n2) {
        Element element = this.document.getDefaultRootElement().getElement(n2);
        if (element == null) {
            return -1;
        }
        return element.getEndOffset() - element.getStartOffset() - 1;
    }

    @Override
    public String getText() {
        try {
            return this.document.getText(0, this.document.getLength());
        }
        catch (BadLocationException badLocationException) {
            l.error("", (Throwable)badLocationException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setText(String string) {
        try {
            this.document.beginCompoundEdit();
            this.document.remove(0, this.document.getLength());
            this.document.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            l.error("", (Throwable)badLocationException);
        }
        finally {
            this.document.endCompoundEdit();
        }
        this.k.discardAllEdits();
        this.setCaretPosition(0);
    }

    public UndoRedoHandler getUndoRedoHandler() {
        return this.k;
    }

    @Override
    public final String getText(int n2, int n3) {
        try {
            return this.document.getText(n2, n3);
        }
        catch (BadLocationException badLocationException) {
            l.error("", (Throwable)badLocationException);
            return null;
        }
    }

    public final void getText(int n2, int n3, Segment segment) {
        try {
            this.document.getText(n2, n3, segment);
        }
        catch (BadLocationException badLocationException) {
            l.error("", (Throwable)badLocationException);
            segment.count = 0;
            segment.offset = 0;
        }
    }

    public final String getLineText(int n2) {
        int n3 = this.getLineStartOffset(n2);
        return this.getText(n3, this.getLineEndOffset(n2) - n3 - 1);
    }

    public final void getLineText(int n2, Segment segment) {
        int n3 = this.getLineStartOffset(n2);
        this.getText(n3, this.getLineEndOffset(n2) - n3 - 1, segment);
    }

    @Override
    public final int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionStart(int n2) {
        if (n2 == this.selectionStartLine) {
            return this.selectionStart;
        }
        if (this.rectSelect) {
            Element element = this.document.getDefaultRootElement();
            int n3 = this.selectionStart - element.getElement(this.selectionStartLine).getStartOffset();
            Element element2 = element.getElement(n2);
            int n4 = element2.getStartOffset();
            int n5 = element2.getEndOffset() - 1;
            return Math.min(n5, n4 + n3);
        }
        return this.getLineStartOffset(n2);
    }

    public final int getSelectionStartLine() {
        return this.selectionStartLine;
    }

    @Override
    public final void setSelectionStart(int n2) {
        this.select(n2, this.selectionEnd, true);
    }

    @Override
    public final int getSelectionEnd() {
        return this.selectionEnd;
    }

    public int getSelectionEnd(int n2) {
        if (n2 == this.selectionEndLine) {
            return this.selectionEnd;
        }
        if (this.rectSelect) {
            Element element = this.document.getDefaultRootElement();
            int n3 = this.selectionEnd - element.getElement(this.selectionEndLine).getStartOffset();
            Element element2 = element.getElement(n2);
            int n4 = element2.getStartOffset();
            int n5 = element2.getEndOffset() - 1;
            return Math.min(n5, n4 + n3);
        }
        return this.getLineEndOffset(n2) - 1;
    }

    public final int getSelectionEndLine() {
        return this.selectionEndLine;
    }

    @Override
    public final void setSelectionEnd(int n2) {
        this.select(this.selectionStart, n2, true);
    }

    @Override
    public final int getCaretPosition() {
        return this.biasLeft ? this.selectionStart : this.selectionEnd;
    }

    public final int getCaretLine() {
        return this.biasLeft ? this.selectionStartLine : this.selectionEndLine;
    }

    public final int getMarkPosition() {
        return this.biasLeft ? this.selectionEnd : this.selectionStart;
    }

    public final int getMarkLine() {
        return this.biasLeft ? this.selectionEndLine : this.selectionStartLine;
    }

    @Override
    public final void setCaretPosition(int n2) {
        this.a(n2, n2);
    }

    @Override
    public final void selectAll() {
        this.select(0, this.getDocumentLength(), false);
    }

    public final void selectNone() {
        this.a(this.getCaretPosition(), this.getCaretPosition());
    }

    @Override
    public void select(int n2, int n3) {
        this.select(n2, n3, true);
    }

    private void a(int n2, int n3) {
        this.select(n2, n3, true);
    }

    public void select(int n2, int n3, boolean bl2) {
        boolean bl3;
        int n4;
        int n5;
        block8: {
            block7: {
                if (n2 > n3) break block7;
                n5 = n2;
                n4 = n3;
                bl3 = false;
                if (n == 0) break block8;
            }
            n5 = n3;
            n4 = n2;
            bl3 = true;
        }
        int n6 = this.getDocumentLength();
        if (n5 < 0 || n4 > n6) {
            n4 = 0;
            n5 = 0;
        }
        if (n5 != this.selectionStart || n4 != this.selectionEnd || bl3 != this.biasLeft) {
            this.updateBracketHighlight(n3);
            int n7 = this.getLineOfOffset(n5);
            int n8 = this.getLineOfOffset(n4);
            this.painter.invalidateLineRange(this.selectionStartLine, this.selectionEndLine);
            this.painter.invalidateLineRange(n7, n8);
            this.document.addUndoableEdit(new t(this, this.selectionStart, this.selectionEnd));
            this.selectionStart = n5;
            this.selectionEnd = n4;
            this.selectionStartLine = n7;
            this.selectionEndLine = n8;
            this.biasLeft = bl3;
            this.gutter.repaint();
            this.fireCaretEvent();
        }
        this.blink = true;
        caretTimer.restart();
        if (this.selectionStart == this.selectionEnd) {
            this.rectSelect = false;
        }
        this.magicCaret = -1;
        if (bl2) {
            this.scrollToCaret();
        }
    }

    @Override
    public final String getSelectedText() {
        int n2 = n;
        if (this.selectionStart == this.selectionEnd) {
            return null;
        }
        if (this.rectSelect) {
            Element element = this.document.getDefaultRootElement();
            int n3 = this.selectionStart - element.getElement(this.selectionStartLine).getStartOffset();
            int n4 = this.selectionEnd - element.getElement(this.selectionEndLine).getStartOffset();
            if (n4 < n3) {
                int n5 = n4;
                n4 = n3;
                n3 = n5;
            }
            StringBuilder stringBuilder = new StringBuilder();
            Segment segment = new Segment();
            for (int i2 = this.selectionStartLine; i2 <= this.selectionEndLine; ++i2) {
                Element element2 = element.getElement(i2);
                int n6 = element2.getStartOffset();
                int n7 = element2.getEndOffset() - 1;
                n6 = Math.min(n6 + n3, n7);
                int n8 = Math.min(n4 - n3, n7 - n6);
                this.getText(n6, n8, segment);
                stringBuilder.append(segment.array, segment.offset, segment.count);
                if (i2 == this.selectionEndLine) continue;
                stringBuilder.append('\n');
                if (n2 == 0) continue;
            }
            return stringBuilder.toString();
        }
        return this.getText(this.selectionStart, this.selectionEnd - this.selectionStart);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSelectedText(String string) {
        block17: {
            int n2 = n;
            if (!this.editable) {
                throw new InternalError(o[3]);
            }
            this.document.beginCompoundEdit();
            try {
                if (this.rectSelect) {
                    int n3;
                    int n4;
                    Element element = this.document.getDefaultRootElement();
                    int n5 = this.selectionStart - element.getElement(this.selectionStartLine).getStartOffset();
                    int n6 = this.selectionEnd - element.getElement(this.selectionEndLine).getStartOffset();
                    if (n6 < n5) {
                        n4 = n6;
                        n6 = n5;
                        n5 = n4;
                    }
                    n4 = 0;
                    int n7 = 0;
                    for (n3 = this.selectionStartLine; n3 <= this.selectionEndLine; ++n3) {
                        Element element2 = element.getElement(n3);
                        int n8 = element2.getStartOffset();
                        int n9 = element2.getEndOffset() - 1;
                        int n10 = Math.min(n9, n8 + n5);
                        this.document.remove(n10, Math.min(n9 - n10, n6 - n5));
                        if (string == null && n2 == 0) continue;
                        n7 = string.indexOf(10, n4);
                        if (n7 == -1) {
                            n7 = string.length();
                        }
                        this.document.insertString(n10, string.substring(n4, n7), null);
                        n4 = Math.min(string.length(), n7 + 1);
                        if (n2 == 0) continue;
                    }
                    if (string != null && n7 != string.length()) {
                        n3 = element.getElement(this.selectionEndLine).getEndOffset() - 1;
                        this.document.insertString(n3, "\n", null);
                        this.document.insertString(n3 + 1, string.substring(n7 + 1), null);
                    }
                    if (n2 == 0) break block17;
                }
                this.document.remove(this.selectionStart, this.selectionEnd - this.selectionStart);
                if (string != null) {
                    this.document.insertString(this.selectionStart, string, null);
                }
            }
            catch (BadLocationException badLocationException) {
                l.error("", (Throwable)badLocationException);
                throw new InternalError(o[4]);
            }
            finally {
                this.document.endCompoundEdit();
            }
        }
        this.setCaretPosition(this.selectionEnd);
    }

    @Override
    public void replaceSelection(String string) {
        this.setSelectedText(string);
    }

    @Override
    public final boolean isEditable() {
        return this.editable;
    }

    @Override
    public final void setEditable(boolean bl2) {
        this.editable = bl2;
    }

    public final int getMagicCaretPosition() {
        return this.magicCaret;
    }

    public final void setMagicCaretPosition(int n2) {
        this.magicCaret = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void overwriteSetSelectedText(String string) {
        if (!this.overwrite || this.selectionStart != this.selectionEnd) {
            this.setSelectedText(string);
            return;
        }
        int n2 = this.getCaretPosition();
        int n3 = this.getLineEndOffset(this.getCaretLine());
        if (n3 - n2 <= string.length()) {
            this.setSelectedText(string);
            return;
        }
        this.document.beginCompoundEdit();
        try {
            this.document.remove(n2, string.length());
            this.document.insertString(n2, string, null);
            return;
        }
        catch (BadLocationException badLocationException) {
            l.error("", (Throwable)badLocationException);
            return;
        }
        finally {
            this.document.endCompoundEdit();
        }
    }

    public final boolean isOverwriteEnabled() {
        return this.overwrite;
    }

    public final void setOverwriteEnabled(boolean bl2) {
        this.overwrite = bl2;
        this.painter.invalidateSelectedLines();
    }

    public final boolean isSelectionRectangular() {
        return this.rectSelect;
    }

    public final void setSelectionRectangular(boolean bl2) {
        this.rectSelect = bl2;
        this.painter.invalidateSelectedLines();
    }

    public final int getBracketPosition() {
        return this.bracketPosition;
    }

    public final int getBracketLine() {
        return this.bracketLine;
    }

    @Override
    public final void addCaretListener(CaretListener caretListener) {
        this.listenerList.add(CaretListener.class, caretListener);
    }

    @Override
    public final void removeCaretListener(CaretListener caretListener) {
        this.listenerList.remove(CaretListener.class, caretListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void appendCut() {
        if (!this.editable) return;
        this.appendCopy();
        if (this.selectionStart == this.selectionEnd) {
            int n2 = this.getCaretLine();
            int n3 = this.getLineStartOffset(n2);
            int n4 = this.getLineEndOffset(n2);
            if (n4 == this.document.getLength() + 1) {
                --n4;
            }
            try {
                this.document.remove(n3, n4 - n3);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (n == 0) return;
        }
        this.setSelectedText("");
    }

    @Override
    public void cut() {
        if (this.editable && this.selectionStart != this.selectionEnd) {
            this.copy();
            this.setSelectedText("");
        }
    }

    public void appendCopy() {
        String string;
        block5: {
            block4: {
                if (this.selectionStart != this.selectionEnd) break block4;
                int n2 = this.getCaretLine();
                int n3 = this.getLineStartOffset(n2);
                int n4 = this.getLineEndOffset(n2);
                string = this.getText(n3, n4 - n3);
                this.setSelectionStart(n3);
                this.setSelectionEnd(n3);
                if (n == 0) break block5;
            }
            string = this.getSelectedText();
        }
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        try {
            String string2 = ((String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor)).replace('\r', '\n');
            clipboard.setContents(new StringSelection(string2 + string), null);
        }
        catch (Exception exception) {
            clipboard.setContents(new StringSelection(string), null);
        }
    }

    @Override
    public void copy() {
        if (this.selectionStart != this.selectionEnd) {
            String string = this.getSelectedText();
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(string), null);
        }
    }

    @Override
    public void paste() {
        if (this.editable) {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            try {
                String string = ((String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor)).replace('\r', '\n');
                this.setSelectedText(string);
            }
            catch (Exception exception) {
                this.getToolkit().beep();
            }
        }
    }

    public void insert(String string, int n2) {
        this.select(n2, n2);
        this.setSelectedText(string);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.documentHandlerInstalled) {
            this.documentHandlerInstalled = true;
            this.document.addDocumentListener(this.documentHandler);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (focusedComponent == this) {
            focusedComponent = null;
        }
        if (this.documentHandlerInstalled) {
            this.document.removeDocumentListener(this.documentHandler);
            this.documentHandlerInstalled = false;
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        int n2 = n;
        if ((keyEvent = KeyEventWorkaround.processKeyEvent(keyEvent)) == null) {
            return;
        }
        InputHandler inputHandler = this.getInputHandler();
        switch (keyEvent.getID()) {
            case 400: {
                inputHandler.keyTyped(keyEvent);
                if (n2 == 0) break;
            }
            case 401: {
                inputHandler.keyPressed(keyEvent);
                if (n2 == 0) break;
            }
            case 402: {
                inputHandler.keyReleased(keyEvent);
            }
        }
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    protected void fireCaretEvent() {
        int n2 = n;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; --i2) {
            if (objectArray[i2] != CaretListener.class) continue;
            ((CaretListener)objectArray[i2 + 1]).caretUpdate(this.caretEvent);
            if (n2 == 0) continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateBracketHighlight(int n2) {
        if (!this.painter.isBracketHighlightEnabled()) {
            return;
        }
        if (this.bracketLine != -1) {
            this.painter.invalidateLine(this.bracketLine);
        }
        if (n2 == 0) {
            this.bracketLine = -1;
            this.bracketPosition = -1;
            return;
        }
        try {
            int n3 = TextUtilities.findMatchingBracket(this.document, n2 - 1);
            if (n3 != -1) {
                this.bracketLine = this.getLineOfOffset(n3);
                this.bracketPosition = n3 - this.getLineStartOffset(this.bracketLine);
                if (this.bracketLine != -1) {
                    this.painter.invalidateLine(this.bracketLine);
                }
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            l.error("", (Throwable)badLocationException);
        }
        this.bracketPosition = -1;
        this.bracketLine = -1;
    }

    protected void documentChanged(DocumentEvent documentEvent) {
        block7: {
            int n2;
            block8: {
                int n3;
                int n4;
                block6: {
                    block5: {
                        DocumentEvent.ElementChange elementChange;
                        block4: {
                            n4 = n;
                            elementChange = documentEvent.getChange(this.document.getDefaultRootElement());
                            if (elementChange != null) break block4;
                            n3 = 0;
                            if (n4 == 0) break block5;
                        }
                        n3 = elementChange.getChildrenAdded().length - elementChange.getChildrenRemoved().length;
                    }
                    n2 = this.getLineOfOffset(documentEvent.getOffset());
                    if (n3 != 0) break block6;
                    this.painter.invalidateLine(n2);
                    if (n4 == 0) break block7;
                }
                if (n2 >= this.firstLine) break block8;
                this.setFirstLine(this.firstLine + n3);
                if (n4 == 0) break block7;
            }
            this.painter.invalidateLineRange(n2, this.firstLine + this.visibleLines);
            this.gutter.repaint();
            this.updateScrollBars();
        }
    }

    public void setShadowCaretPosition(int n2) {
        block5: {
            block4: {
                this.i = n2;
                if (n2 != -1) break block4;
                this.h = -1;
                if (n == 0) break block5;
            }
            this.h = this.getLineOfOffset(n2);
            if (!this.scrollTo(this.h, this.i - this.getLineStartOffset(this.h))) {
                this.repaint();
            }
        }
    }

    public int getShadowCaretLine() {
        return this.h;
    }

    public int getShadowCaretPosition() {
        return this.i;
    }

    public void setTabSize(int n2) {
        SyntaxDocument syntaxDocument = this.getDocument();
        if (syntaxDocument != null) {
            int n3 = this.getTabSize();
            syntaxDocument.putProperty(o[1], n2);
            this.firePropertyChange(o[2], n3, n2);
        }
    }

    public int getTabSize() {
        Integer n2;
        int n3 = 8;
        SyntaxDocument syntaxDocument = this.getDocument();
        if (syntaxDocument != null && (n2 = (Integer)syntaxDocument.getProperty(o[0])) != null) {
            n3 = n2;
        }
        return n3;
    }

    @Override
    public void setDocument(Document document) {
        assert (TextComponentPopupMenu.DocumentFactory.isSupported(document, this));
        this.document = (SyntaxDocument)document;
        this.document.addDocumentListener(new i(this));
    }

    private void e() {
        block7: {
            block6: {
                int n2;
                block5: {
                    block4: {
                        n2 = n;
                        if (!this.c()) break block4;
                        this.vertical.setVisible(true);
                        if (n2 == 0) break block5;
                    }
                    this.vertical.setVisible(false);
                }
                if (!this.b()) break block6;
                this.horizontal.setVisible(true);
                if (n2 == 0) break block7;
            }
            this.horizontal.setVisible(false);
        }
        this.revalidate();
        this.repaint();
    }

    private void f() {
        int n2 = n;
        Font font = this.getFont();
        if (font != null) {
            for (int i2 = 0; i2 < this.getLineCount(); ++i2) {
                FontMetrics fontMetrics = this.getFontMetrics(font);
                int n3 = StringUtil.getMultiLineStringWidth(fontMetrics, this.getLineText(i2));
                if (this.c.b == i2) {
                    this.c.a = n3;
                    if (n2 == 0) continue;
                }
                if (this.c.a >= n3) continue;
                this.c.a = n3;
                this.c.b = i2;
                if (n2 == 0) continue;
            }
        }
    }

    static /* synthetic */ void access$100(JEditTextArea jEditTextArea) {
        jEditTextArea.f();
    }

    static /* synthetic */ void access$200(JEditTextArea jEditTextArea, int n2, int n3) {
        jEditTextArea.a(n2, n3);
    }

    static /* synthetic */ boolean access$300(JEditTextArea jEditTextArea) {
        return jEditTextArea.e;
    }

    static /* synthetic */ boolean access$400(JEditTextArea jEditTextArea) {
        return jEditTextArea.g;
    }

    static /* synthetic */ boolean access$502(JEditTextArea jEditTextArea, boolean bl2) {
        jEditTextArea.f = bl2;
        return jEditTextArea.f;
    }

    static /* synthetic */ boolean access$402(JEditTextArea jEditTextArea, boolean bl2) {
        jEditTextArea.g = bl2;
        return jEditTextArea.g;
    }

    static /* synthetic */ boolean access$500(JEditTextArea jEditTextArea) {
        return jEditTextArea.f;
    }

    static /* synthetic */ int access$600(JEditTextArea jEditTextArea) {
        return jEditTextArea.d;
    }

    static /* synthetic */ boolean access$302(JEditTextArea jEditTextArea, boolean bl2) {
        jEditTextArea.e = bl2;
        return jEditTextArea.e;
    }

    static /* synthetic */ JPopupMenu access$700(JEditTextArea jEditTextArea) {
        return jEditTextArea.j;
    }

    static /* synthetic */ int access$602(JEditTextArea jEditTextArea, int n2) {
        jEditTextArea.d = n2;
        return jEditTextArea.d;
    }

    static /* synthetic */ Logger access$800() {
        return l;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        int n2;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n3 = 0;
        String string2 = "z^~Q\btZ";
        int n4 = -1;
        block24: while (true) {
            char[] cArray;
            block33: {
                int n5;
                int n6;
                char[] cArray2;
                block32: {
                    char[] cArray3 = string2.toCharArray();
                    n2 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n6 = n7;
                    if (n7 <= 1) break block32;
                    cArray = cArray2;
                    n5 = n6;
                    if (n6 <= n2) break block33;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n2;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n2 % 5) {
                            case 0: {
                                n9 = 14;
                                break;
                            }
                            case 1: {
                                n9 = 63;
                                break;
                            }
                            case 2: {
                                n9 = 28;
                                break;
                            }
                            case 3: {
                                n9 = 2;
                                break;
                            }
                            default: {
                                n9 = 97;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n2;
                        cArray2 = cArray5;
                        n6 = n6;
                        if (n6 != 0) break;
                        cArray5 = cArray2;
                        n5 = n6;
                        n8 = n6;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n5 = n6;
                } while (n6 > n2);
            }
            string = new String(cArray);
            switch (n4) {
                default: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 1;
                    string2 = "z^~Q\btZ";
                    n4 = 0;
                    continue block24;
                }
                case 0: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 2;
                    string2 = "z^~Q\btZ";
                    n4 = 1;
                    continue block24;
                }
                case 1: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 3;
                    string2 = "ZZdvAmPqr\u000e`ZrvA|Z}fAaQp{";
                    n4 = 2;
                    continue block24;
                }
                case 2: {
                    stringArray2[n3] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 4;
                    string2 = "M^rl\u000ez\u001fng\u0011b^\u007fgA}Zpg\u0002zVsl";
                    n4 = 3;
                    continue block24;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n3] = string.intern();
        o = stringArray3;
        String string3 = "bPo";
        int n10 = -1;
        block27: while (true) {
            char[] cArray;
            block35: {
                int n11;
                int n12;
                char[] cArray6;
                block34: {
                    char[] cArray7 = string3.toCharArray();
                    n2 = 0;
                    int n13 = cArray7.length;
                    cArray6 = cArray7;
                    n12 = n13;
                    if (n13 <= 1) break block34;
                    cArray = cArray6;
                    n11 = n12;
                    if (n12 <= n2) break block35;
                }
                do {
                    char[] cArray8 = cArray6;
                    char[] cArray9 = cArray6;
                    int n14 = n2;
                    while (true) {
                        int n15;
                        char c3 = cArray8[n14];
                        switch (n2 % 5) {
                            case 0: {
                                n15 = 14;
                                break;
                            }
                            case 1: {
                                n15 = 63;
                                break;
                            }
                            case 2: {
                                n15 = 28;
                                break;
                            }
                            case 3: {
                                n15 = 2;
                                break;
                            }
                            default: {
                                n15 = 97;
                            }
                        }
                        cArray8[n14] = (char)(c3 ^ n15);
                        ++n2;
                        cArray6 = cArray9;
                        n12 = n12;
                        if (n12 != 0) break;
                        cArray9 = cArray6;
                        n11 = n12;
                        n14 = n12;
                        cArray8 = cArray6;
                    }
                    cArray = cArray6;
                    n11 = n12;
                } while (n12 > n2);
            }
            switch (n10) {
                default: {
                    LEFT_OF_SCROLLBAR = new String(cArray).intern();
                    string3 = "mZrv\u0004|";
                    n10 = 0;
                    continue block27;
                }
                case 0: {
                    CENTER = LEFT_OF_SCROLLBAR;
                    string3 = "|V{j\u0015";
                    n10 = 1;
                    continue block27;
                }
                case 1: {
                    RIGHT = LEFT_OF_SCROLLBAR;
                    string3 = "bZzv";
                    n10 = 2;
                    continue block27;
                }
                case 2: {
                    LEFT = LEFT_OF_SCROLLBAR;
                    string3 = "lPhv\u000ec";
                    n10 = 3;
                    continue block27;
                }
                case 3: 
            }
            break;
        }
        BOTTOM = LEFT_OF_SCROLLBAR;
        caretTimer = new Timer(500, new l());
        caretTimer.setInitialDelay(500);
        caretTimer.start();
        l = LoggerFactory.getLogger(JEditTextArea.class);
        SYNTAX_DOCUMENT_FACTORY = new e();
    }
}

