/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.textarea;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import org.jedit.syntax.SyntaxStyle;
import org.jedit.syntax.SyntaxUtilities;
import org.jedit.syntax.Token;
import org.jedit.syntax.TokenMarker;
import org.jedit.textarea.JEditTextArea;
import org.jedit.textarea.TextAreaDefaults;
import org.jedit.textarea.TextAreaHighlight;
import org.jedit.textarea.TextUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextAreaPainter
extends JComponent
implements TabExpander {
    private static final Logger a;
    public static RenderingHints ANTI_ALIASED_RENDERING;
    public static RenderingHints DEFAULT_RENDERING;
    private boolean b = false;
    private boolean c;
    private Color d;
    private int e;
    private boolean f;
    private Color g;
    private int h;
    protected JEditTextArea textArea;
    protected SyntaxStyle[] styles;
    protected Color caretColor;
    protected Color selectionColor;
    protected Color lineHighlightColor;
    protected Color highlightColor;
    protected Color bracketHighlightColor;
    protected Color eolMarkerColor;
    protected boolean blockCaret;
    protected boolean lineHighlight;
    protected boolean bracketHighlight;
    protected boolean paintInvalid;
    protected boolean eolMarkers;
    protected int cols;
    protected int rows;
    protected int tabSize;
    protected FontMetrics fm;
    protected TextAreaHighlight highlights;
    protected TextAreaHighlight firstPriorityHighlights;
    private static final String[] i;

    public TextAreaPainter(JEditTextArea jEditTextArea, TextAreaDefaults textAreaDefaults) {
        TextAreaPainter.a();
        this.textArea = jEditTextArea;
        this.setAutoscrolls(true);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.setFont(new Font(i[4], 0, 12));
        this.setForeground(Color.black);
        this.setBackground(textAreaDefaults.background);
        this.blockCaret = textAreaDefaults.blockCaret;
        this.styles = textAreaDefaults.styles;
        this.cols = textAreaDefaults.cols;
        this.rows = textAreaDefaults.rows;
        this.caretColor = textAreaDefaults.caretColor;
        this.selectionColor = textAreaDefaults.selectionColor;
        this.lineHighlightColor = textAreaDefaults.lineHighlightColor;
        this.lineHighlight = textAreaDefaults.lineHighlight;
        this.bracketHighlightColor = textAreaDefaults.bracketHighlightColor;
        this.bracketHighlight = textAreaDefaults.bracketHighlight;
        this.paintInvalid = textAreaDefaults.paintInvalid;
        this.eolMarkerColor = textAreaDefaults.eolMarkerColor;
        this.eolMarkers = textAreaDefaults.eolMarkers;
        this.c = textAreaDefaults.wrapGuide;
        this.d = textAreaDefaults.wrapGuideColor;
        this.e = textAreaDefaults.wrapGuideOffset;
        this.f = textAreaDefaults.linesIntervalHighlight;
        this.g = textAreaDefaults.linesIntervalColor;
        this.h = textAreaDefaults.linesInterval;
    }

    private static void a() {
        if (ANTI_ALIASED_RENDERING == null) {
            ANTI_ALIASED_RENDERING = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ANTI_ALIASED_RENDERING.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ANTI_ALIASED_RENDERING.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            ANTI_ALIASED_RENDERING.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        if (DEFAULT_RENDERING == null) {
            DEFAULT_RENDERING = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public boolean isAntiAliasingEnabled() {
        return this.b;
    }

    public void setAntiAliasingEnabled(boolean bl2) {
        this.b = bl2;
        this.b = false;
    }

    public void setWrapGuideEnabled(boolean bl2) {
        this.c = bl2;
    }

    public void setWrapGuideOffset(int n2) {
        this.e = n2;
    }

    public void setWrapGuideColor(Color color) {
        this.d = color;
    }

    public void setLinesIntervalHighlightEnabled(boolean bl2) {
        this.f = bl2;
    }

    public void setLinesInterval(int n2) {
        this.h = n2;
    }

    public void setLinesIntervalHighlightColor(Color color) {
        this.g = color;
    }

    @Override
    public final boolean isManagingFocus() {
        return false;
    }

    public final SyntaxStyle[] getStyles() {
        return this.styles;
    }

    public final void setStyles(SyntaxStyle[] syntaxStyleArray) {
        this.styles = syntaxStyleArray;
        this.repaint();
    }

    public final Color getCaretColor() {
        return this.caretColor;
    }

    public final void setCaretColor(Color color) {
        this.caretColor = color;
        this.invalidateSelectedLines();
    }

    public final Color getSelectionColor() {
        return this.selectionColor;
    }

    public final void setSelectionColor(Color color) {
        this.selectionColor = color;
        this.invalidateSelectedLines();
    }

    public final Color getHighlightColor() {
        return this.lineHighlightColor;
    }

    public final void setHighlightColor(Color color) {
        this.highlightColor = color;
        this.repaint();
    }

    public final Color getLineHighlightColor() {
        return this.lineHighlightColor;
    }

    public final void setLineHighlightColor(Color color) {
        this.lineHighlightColor = color;
        this.invalidateSelectedLines();
    }

    public final boolean isLineHighlightEnabled() {
        return this.lineHighlight;
    }

    public final void setLineHighlightEnabled(boolean bl2) {
        this.lineHighlight = bl2;
        this.invalidateSelectedLines();
    }

    public final Color getBracketHighlightColor() {
        return this.bracketHighlightColor;
    }

    public final void setBracketHighlightColor(Color color) {
        this.bracketHighlightColor = color;
        this.invalidateLine(this.textArea.getBracketLine());
    }

    public final boolean isBracketHighlightEnabled() {
        return this.bracketHighlight;
    }

    public final void setBracketHighlightEnabled(boolean bl2) {
        this.bracketHighlight = bl2;
        this.invalidateLine(this.textArea.getBracketLine());
    }

    public final boolean isBlockCaretEnabled() {
        return this.blockCaret;
    }

    public final void setBlockCaretEnabled(boolean bl2) {
        this.blockCaret = bl2;
        this.invalidateSelectedLines();
    }

    public final Color getEOLMarkerColor() {
        return this.eolMarkerColor;
    }

    public final void setEOLMarkerColor(Color color) {
        this.eolMarkerColor = color;
        this.repaint();
    }

    public final boolean getEOLMarkersPainted() {
        return this.eolMarkers;
    }

    public final void setEOLMarkersPainted(boolean bl2) {
        this.eolMarkers = bl2;
        this.repaint();
    }

    public boolean getInvalidLinesPainted() {
        return this.paintInvalid;
    }

    public void setInvalidLinesPainted(boolean bl2) {
        this.paintInvalid = bl2;
    }

    public void addCustomHighlight(TextAreaHighlight textAreaHighlight) {
        textAreaHighlight.init(this.textArea, this.highlights);
        this.highlights = textAreaHighlight;
    }

    public void addCustomFirstPriorityHighlight(TextAreaHighlight textAreaHighlight) {
        textAreaHighlight.init(this.textArea, this.firstPriorityHighlights);
        this.firstPriorityHighlights = textAreaHighlight;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.highlights != null) {
            return this.highlights.getToolTipText(mouseEvent);
        }
        return null;
    }

    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.textArea.recalculateVisibleLines();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void paint(Graphics graphics) {
        int n2 = JEditTextArea.n;
        this.tabSize = this.fm.charWidth(' ') * (Integer)this.textArea.getDocument().getProperty(i[1]);
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n3 = this.fm.getHeight();
        int n4 = this.textArea.getFirstLine();
        int n5 = n4 + rectangle.y / n3;
        int n6 = n4 + (rectangle.y + rectangle.height - 1) / n3;
        int n7 = this.textArea.getHorizontalOffset();
        int n8 = this.textArea.getLineCount();
        try {
            int n9;
            TokenMarker tokenMarker = this.textArea.getDocument().getTokenMarker();
            int n10 = this.textArea.maxHorizontalScrollWidth;
            boolean bl2 = false;
            for (n9 = n5; n9 <= n6; ++n9) {
                boolean bl4 = n9 >= 0 && n9 < n8;
                int n11 = this.paintLine(graphics, tokenMarker, bl4, n9, n7) - n7 + 5;
                if (!bl4) continue;
                tokenMarker.setLineWidth(n9, n11);
                if (n11 <= n10) continue;
                bl2 = true;
                if (n2 == 0) continue;
            }
            if (tokenMarker.isNextLineRequested()) {
                n9 = rectangle.y + rectangle.height;
                this.repaint(0, n9, this.getWidth(), this.getHeight() - n9);
            }
            if (!bl2) return;
            this.textArea.d();
            return;
        }
        catch (Exception exception) {
            a.error(i[0] + n5 + "," + n6 + i[2]);
            a.error("", (Throwable)exception);
        }
    }

    public final void invalidateLine(int n2) {
        this.repaint(0, this.textArea.lineToY(n2) + this.fm.getMaxDescent() + this.fm.getLeading(), this.getWidth(), this.fm.getHeight());
    }

    public final void invalidateLineRange(int n2, int n3) {
        this.repaint(0, this.textArea.lineToY(n2) + this.fm.getMaxDescent() + this.fm.getLeading(), this.getWidth(), (n3 - n2 + 1) * this.fm.getHeight());
    }

    public final void invalidateSelectedLines() {
        this.invalidateLineRange(this.textArea.getSelectionStartLine(), this.textArea.getSelectionEndLine());
    }

    @Override
    public float nextTabStop(float f2, int n2) {
        if (this.tabSize == 0) {
            this.tabSize = this.fm.charWidth(' ') * (Integer)this.textArea.getDocument().getProperty(i[3]);
        }
        int n3 = this.textArea.getHorizontalOffset();
        int n4 = ((int)f2 - n3) / this.tabSize;
        return (n4 + 1) * this.tabSize + n3;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        dimension.width = this.fm.charWidth('w') * this.cols;
        dimension.height = this.fm.getHeight() * this.rows;
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected int paintLine(Graphics graphics, TokenMarker tokenMarker, boolean bl2, int n2, int n3) {
        block3: {
            int n4;
            Color color;
            Font font;
            block2: {
                font = this.getFont();
                color = this.getForeground();
                n4 = this.textArea.lineToY(n2);
                if (bl2) break block2;
                if (!this.paintInvalid) break block3;
                this.paintHighlight(graphics, n2, n4);
                this.styles[10].setGraphicsFlags(graphics, font);
                graphics.drawString("~", 0, n4 + this.fm.getHeight());
                if (JEditTextArea.n == 0) break block3;
            }
            n3 = this.paintSyntaxLine(graphics, tokenMarker, n2, font, color, n3, n4);
        }
        return n3;
    }

    protected int paintSyntaxLine(Graphics graphics, TokenMarker tokenMarker, int n2, Font font, Color color, int n3, int n4) {
        Token token;
        int n5 = JEditTextArea.n;
        if (this.firstPriorityHighlights != null) {
            this.firstPriorityHighlights.paintHighlight(graphics, n2, n4);
        }
        Segment segment = this.textArea.b;
        this.textArea.getLineText(n2, this.textArea.b);
        Token token2 = token = tokenMarker.markTokens(this.textArea.b, n2);
        int n6 = n4 + this.fm.getLeading() + this.fm.getMaxDescent();
        int n7 = this.fm.getHeight();
        int n8 = this.fm.charWidth('w');
        int n9 = n3;
        int n10 = 0;
        String string = this.textArea.b.toString();
        while (token.id != 127) {
            int n11 = n8 * TextUtilities.getRealLength(string.substring(n10, n10 + token.length), this.tabSize);
            n10 += token.length;
            if (token.highlightBackground) {
                graphics.setColor(this.highlightColor);
                graphics.fillRect(n9, n6, n11, n7);
            }
            n9 += n11;
            token = token.next;
            if (n5 == 0) continue;
        }
        this.textArea.b = segment;
        this.paintHighlight(graphics, n2, n4);
        this.textArea.getLineText(n2, this.textArea.b);
        graphics.setFont(font);
        graphics.setColor(color);
        n3 = SyntaxUtilities.paintSyntaxLine(this.textArea.b, token2, this.styles, this, graphics, n3, n4 += this.fm.getHeight());
        if (this.eolMarkers) {
            graphics.setColor(this.eolMarkerColor);
            graphics.drawString(".", n3, n4);
        }
        return n3;
    }

    protected void paintHighlight(Graphics graphics, int n2, int n3) {
        if (n2 >= this.textArea.getSelectionStartLine() && n2 <= this.textArea.getSelectionEndLine()) {
            this.paintLineHighlight(graphics, n2, n3);
        }
        if (this.f && this.h > 0) {
            this.paintLinesInterval(graphics, n2, n3);
        }
        if (this.c && this.e > 0) {
            this.paintWrapGuide(graphics, n2, n3);
        }
        if (this.highlights != null) {
            this.highlights.paintHighlight(graphics, n2, n3);
        }
        if (this.bracketHighlight && n2 == this.textArea.getBracketLine()) {
            this.paintBracketHighlight(graphics, n2, n3);
        }
        if (n2 == this.textArea.getCaretLine()) {
            this.paintCaret(graphics, n2, n3);
        }
        if (n2 == this.textArea.getShadowCaretLine()) {
            this.paintShadowCaret(graphics, n2, n3);
        }
    }

    protected void paintWrapGuide(Graphics graphics, int n2, int n3) {
        graphics.setColor(this.d);
        int n4 = n3 + (this.fm.getLeading() + this.fm.getMaxDescent());
        int n5 = n2 > 0 ? n4 : 0;
        int n6 = n2 != this.textArea.getLineCount() - 1 ? n4 + this.fm.getHeight() : this.textArea.getHeight();
        int n7 = this.fm.charWidth('m');
        int n8 = this.textArea.getHorizontalOffset();
        int n9 = this.textArea.getWidth();
        int n10 = this.e * n7 + n8;
        if (n10 >= 0 && n10 < n9) {
            graphics.drawLine(n10, n5, n10, n6);
        }
    }

    protected void paintLinesInterval(Graphics graphics, int n2, int n3) {
        block4: {
            int n4;
            int n5;
            int n6;
            int n7;
            block6: {
                block9: {
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    block8: {
                        int n12;
                        int n13;
                        block7: {
                            block5: {
                                n11 = JEditTextArea.n;
                                if ((n2 + 1) % this.h != 0) break block4;
                                n7 = this.fm.getHeight();
                                n6 = n3 + this.fm.getLeading() + this.fm.getMaxDescent();
                                n13 = this.textArea.getSelectionStart();
                                n10 = this.textArea.getSelectionEnd();
                                graphics.setColor(this.g);
                                graphics.fillRect(0, n6, this.getWidth(), n7);
                                graphics.setColor(this.selectionColor);
                                n12 = this.textArea.getSelectionStartLine();
                                n9 = this.textArea.getSelectionEndLine();
                                n8 = this.textArea.getLineStartOffset(n2);
                                if (!this.textArea.isSelectionRectangular()) break block5;
                                int n14 = this.textArea.getLineLength(n2);
                                n5 = this.textArea.offsetToX(n2, Math.min(n14, n13 - this.textArea.getLineStartOffset(n12)));
                                if (n5 == (n4 = this.textArea.offsetToX(n2, Math.min(n14, n10 - this.textArea.getLineStartOffset(n9))))) {
                                    ++n4;
                                }
                                if (n11 == 0) break block6;
                            }
                            if (n12 != n9) break block7;
                            n5 = this.textArea.offsetToX(n2, n13 - n8);
                            n4 = this.textArea.offsetToX(n2, n10 - n8);
                            if (n11 == 0) break block6;
                        }
                        if (n2 != n12) break block8;
                        n5 = this.textArea.offsetToX(n2, n13 - n8);
                        n4 = this.textArea.offsetToX(n2, this.textArea.getLineLength(n2));
                        if (n11 == 0) break block6;
                    }
                    if (n2 != n9) break block9;
                    n5 = 0;
                    n4 = this.textArea.offsetToX(n2, n10 - n8);
                    if (n11 == 0) break block6;
                }
                n5 = 0;
                n4 = this.textArea.offsetToX(n2, this.textArea.getLineLength(n2));
            }
            graphics.fillRect(n5 > n4 ? n4 : n5, n6, n5 > n4 ? n5 - n4 : n4 - n5, n7);
        }
    }

    protected void paintLineHighlight(Graphics graphics, int n2, int n3) {
        block6: {
            int n4;
            int n5;
            int n6;
            int n7;
            block8: {
                block11: {
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    block10: {
                        int n12;
                        int n13;
                        block9: {
                            block7: {
                                block5: {
                                    n11 = JEditTextArea.n;
                                    n7 = this.fm.getHeight();
                                    n3 += this.fm.getLeading() + this.fm.getMaxDescent();
                                    n13 = this.textArea.getSelectionStart();
                                    if (n13 != (n10 = this.textArea.getSelectionEnd())) break block5;
                                    if (!this.lineHighlight) break block6;
                                    graphics.setColor(this.lineHighlightColor);
                                    graphics.fillRect(0, n3, this.getWidth(), n7);
                                    if (n11 == 0) break block6;
                                }
                                graphics.setColor(this.selectionColor);
                                n12 = this.textArea.getSelectionStartLine();
                                n9 = this.textArea.getSelectionEndLine();
                                n8 = this.textArea.getLineStartOffset(n2);
                                if (!this.textArea.isSelectionRectangular()) break block7;
                                n6 = this.textArea.getLineLength(n2);
                                n5 = this.textArea.offsetToX(n2, Math.min(n6, n13 - this.textArea.getLineStartOffset(n12)));
                                if (n5 == (n4 = this.textArea.offsetToX(n2, Math.min(n6, n10 - this.textArea.getLineStartOffset(n9))))) {
                                    ++n4;
                                }
                                if (n11 == 0) break block8;
                            }
                            if (n12 != n9) break block9;
                            n5 = this.textArea.offsetToX(n2, n13 - n8);
                            n4 = this.textArea.offsetToX(n2, n10 - n8);
                            if (n11 == 0) break block8;
                        }
                        if (n2 != n12) break block10;
                        n5 = this.textArea.offsetToX(n2, n13 - n8);
                        n4 = this.textArea.offsetToX(n2, this.textArea.getLineLength(n2));
                        if (n11 == 0) break block8;
                    }
                    if (n2 != n9) break block11;
                    n5 = 0;
                    n4 = this.textArea.offsetToX(n2, n10 - n8);
                    if (n11 == 0) break block8;
                }
                n5 = 0;
                n4 = this.textArea.offsetToX(n2, this.textArea.getLineLength(n2));
            }
            int n14 = n6 = n5 > n4 ? n5 - n4 : n4 - n5;
            if (n6 == 0) {
                n6 = 4;
            }
            graphics.fillRect(n5 > n4 ? n4 : n5, n3, n6, n7);
        }
    }

    protected void paintBracketHighlight(Graphics graphics, int n2, int n3) {
        int n4 = this.textArea.getBracketPosition();
        if (n4 == -1) {
            return;
        }
        int n5 = this.textArea.offsetToX(n2, n4);
        graphics.setColor(this.bracketHighlightColor);
        graphics.fillRect(n5, n3 += this.fm.getLeading() + this.fm.getMaxDescent(), this.fm.charWidth('(') - 1, this.fm.getHeight() - 1);
    }

    protected void paintCaret(Graphics graphics, int n2, int n3) {
        block2: {
            int n4;
            int n5;
            block4: {
                int n6;
                int n7;
                block3: {
                    n7 = JEditTextArea.n;
                    if (!this.textArea.isCaretVisible()) break block2;
                    int n8 = this.textArea.getCaretPosition() - this.textArea.getLineStartOffset(n2);
                    n5 = this.textArea.offsetToX(n2, n8);
                    n6 = this.blockCaret || this.textArea.isOverwriteEnabled() ? this.fm.charWidth('w') : 1;
                    n3 += this.fm.getLeading() + this.fm.getMaxDescent();
                    n4 = this.fm.getHeight();
                    graphics.setColor(this.caretColor);
                    if (!this.textArea.isOverwriteEnabled()) break block3;
                    graphics.fillRect(n5, n3 + n4 - 1, n6, 1);
                    if (n7 == 0) break block2;
                }
                if (n6 <= 1) break block4;
                graphics.drawRect(n5, n3, n6 - 1, n4 - 1);
                if (n7 == 0) break block2;
            }
            graphics.drawLine(n5, n3, n5, n3 + n4 - 1);
        }
    }

    protected void paintShadowCaret(Graphics graphics, int n2, int n3) {
        int n4 = JEditTextArea.n;
        int n5 = this.textArea.getShadowCaretPosition() - this.textArea.getLineStartOffset(n2);
        int n6 = this.textArea.offsetToX(n2, n5);
        n3 += this.fm.getLeading() + this.fm.getMaxDescent();
        int n7 = this.fm.getHeight();
        graphics.setColor(this.caretColor.darker());
        for (int i2 = 0; i2 < n7; i2 += 3) {
            graphics.drawLine(n6, n3 + i2, n6, n3 + i2 + 1);
            if (n4 == 0) continue;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "1\u001eL\u0017yT\u001e[\bj\u001d\u0002J\u0011e\u0013LR\u0011e\u0011LL\u0019e\u0013\t\u001e\u0003";
        int n3 = -1;
        block12: while (true) {
            char[] cArray;
            block17: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block16: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block16;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block17;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 116;
                                break;
                            }
                            case 1: {
                                n9 = 108;
                                break;
                            }
                            case 2: {
                                n9 = 62;
                                break;
                            }
                            case 3: {
                                n9 = 120;
                                break;
                            }
                            default: {
                                n9 = 11;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0000\r\\+b\u000e\t";
                    n3 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\tV";
                    n3 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0000\r\\+b\u000e\t";
                    n3 = 2;
                    continue block12;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "0\u0005_\u0014d\u0013";
                    n3 = 3;
                    continue block12;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        i = stringArray3;
        a = LoggerFactory.getLogger(TextAreaPainter.class);
        ANTI_ALIASED_RENDERING = null;
        DEFAULT_RENDERING = null;
    }
}

