/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.textarea;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import org.jedit.syntax.SyntaxDocument;
import org.jedit.syntax.Token;
import org.jedit.syntax.TokenMarker;
import org.jedit.textarea.JEditTextArea;

public class TextUtilities {
    public static final String BRACKETS;
    public static final int FORWARD = 1;
    public static final int BACKWARD = -1;
    private static final String[] a;

    private TextUtilities() {
    }

    public static ArrayList<Token> getTokenList(Token token, int n2) {
        int n3 = JEditTextArea.n;
        ArrayList<Token> arrayList = new ArrayList<Token>();
        while (true) {
            block3: {
                if (token == null) break;
                if (token.id != 127) break block3;
                token = null;
                continue;
            }
            arrayList.add(Math.max(0, arrayList.size() * n2), token);
            token = token.next;
            if (n3 != 0) break;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int findMatchingBracket(SyntaxDocument syntaxDocument, int n2) throws BadLocationException {
        char c2;
        int n3 = JEditTextArea.n;
        if (syntaxDocument.getLength() == 0) {
            return -1;
        }
        Element element = syntaxDocument.getDefaultRootElement();
        Element element2 = syntaxDocument.getParagraphElement(n2);
        Segment segment = new Segment();
        int n4 = element2.getStartOffset();
        int n5 = element2.getEndOffset() - n4 - 1;
        int n6 = element.getElementIndex(n4);
        syntaxDocument.getText(n4, n5, segment);
        n2 -= n4;
        try {
            c2 = segment.array[segment.offset + n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            c2 = '\u0000';
        }
        int n7 = a[1].indexOf(c2);
        if (n7 == -1) {
            return n7;
        }
        char c3 = a[3].charAt(a[0].length() - 1 - n7);
        int n8 = n7 < a[2].length() / 2 ? 1 : -1;
        TokenMarker tokenMarker = syntaxDocument.getTokenMarker();
        if (tokenMarker == null) {
            return -1;
        }
        ArrayList<Token> arrayList = TextUtilities.getTokenList(tokenMarker.markTokens(segment, n6), n8);
        byte by2 = 10;
        int n9 = 0;
        int n10 = n8 == 1 ? 0 : arrayList.size() - 1;
        boolean bl2 = false;
        do {
            Token token;
            try {
                token = arrayList.get(n10);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return -1;
            }
            if ((n9 += token.length) > n2) {
                by2 = token.id;
                if (n8 == 1) {
                    n9 -= token.length;
                }
                bl2 = true;
                if (n3 == 0) continue;
            }
            n10 += n8;
        } while (!bl2);
        if (by2 == 10) {
            return -1;
        }
        int n11 = 0;
        int n12 = n8 == 1 ? element.getElementCount() - n6 : n6 + 1;
        for (int i2 = 0; i2 < n12; ++i2) {
            int n13;
            block35: {
                block33: {
                    block34: {
                        int n14 = n6 + i2 * n8;
                        element2 = element.getElement(n14);
                        n4 = element2.getStartOffset();
                        n5 = element2.getEndOffset() - n4 - 1;
                        syntaxDocument.getText(n4, n5, segment);
                        if (n14 == n6) break block33;
                        arrayList = TextUtilities.getTokenList(tokenMarker.markTokens(segment, n6), n8);
                        n10 = 0;
                        if (n8 != 1) break block34;
                        n9 = 0;
                        n13 = 0;
                        if (n3 == 0) break block35;
                    }
                    n9 = n5;
                    n13 = n9 - 1;
                    if (n3 == 0) break block35;
                }
                n13 = n2;
            }
            while (n10 < arrayList.size()) {
                Token token = arrayList.get(n10);
                byte by3 = token.id;
                int n15 = token.length;
                if (by3 == by2) {
                    char[] cArray = new char[n15];
                    int n16 = n9 + (n8 == 1 ? 0 : n8 * cArray.length);
                    System.arraycopy(segment.array, segment.offset + n16, cArray, 0, cArray.length);
                    int n17 = n8 == 1 ? 0 : cArray.length - 1;
                    int n18 = n13 - n16 - n8;
                    do {
                        char c4;
                        if ((c4 = cArray[n18 += n8]) == c2) {
                            ++n11;
                            if (n3 == 0) continue;
                        }
                        if (c4 != c3 || --n11 != 0) continue;
                        return n4 + n16 + n18;
                    } while (n18 + n17 + 1 != cArray.length);
                }
                n13 = n9 += n15 * n8;
                if (n8 == -1) {
                    --n13;
                }
                ++n10;
                if (n3 == 0) continue;
            }
            if (n3 == 0) continue;
        }
        return -1;
    }

    public static int findWordStart(String string, int n2, String string2) {
        boolean bl2;
        char c2;
        int n3;
        block13: {
            block12: {
                n3 = JEditTextArea.n;
                c2 = string.charAt(n2);
                if (string2 == null) {
                    string2 = "";
                }
                if (Character.isLetterOrDigit(c2) || string2.indexOf(c2) != -1) break block12;
                bl2 = true;
                break block13;
            }
            bl2 = false;
        }
        boolean bl3 = bl2;
        int n4 = 0;
        for (int i2 = n2; i2 >= 0; --i2) {
            boolean bl4;
            boolean bl5;
            block15: {
                block14: {
                    c2 = string.charAt(i2);
                    bl5 = bl3;
                    if (Character.isLetterOrDigit(c2) || string2.indexOf(c2) != -1) break block14;
                    bl4 = true;
                    break block15;
                }
                bl4 = false;
            }
            if (!(bl5 ^ bl4)) continue;
            n4 = i2 + 1;
            if (n3 == 0) break;
            if (n3 == 0) continue;
            break;
        }
        return n4;
    }

    public static int findWordEnd(String string, int n2, String string2) {
        boolean bl2;
        char c2;
        int n3;
        block16: {
            block15: {
                n3 = JEditTextArea.n;
                if (n2 != 0) {
                    --n2;
                }
                c2 = string.charAt(n2);
                if (string2 == null) {
                    string2 = "";
                }
                if (Character.isLetterOrDigit(c2) || string2.indexOf(c2) != -1) break block15;
                bl2 = true;
                break block16;
            }
            bl2 = false;
        }
        boolean bl3 = bl2;
        int n4 = string.length();
        for (int i2 = n2; i2 < string.length(); ++i2) {
            boolean bl4;
            boolean bl5;
            block18: {
                block17: {
                    c2 = string.charAt(i2);
                    bl5 = bl3;
                    if (Character.isLetterOrDigit(c2) || string2.indexOf(c2) != -1) break block17;
                    bl4 = true;
                    break block18;
                }
                bl4 = false;
            }
            if (!(bl5 ^ bl4)) continue;
            n4 = i2;
            if (n3 == 0) break;
            if (n3 == 0) continue;
            break;
        }
        return n4;
    }

    public static int findTypeChange(String string, int n2, int n3) {
        int n4 = Character.getType(string.charAt(n2));
        int n5 = n2 + n3;
        while (true) {
            try {
                if (Character.getType(string.charAt(n5)) != n4) {
                    return n5;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return n5 - n3;
            }
            n5 += n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getRealLength(String string, int n2) {
        int n3 = JEditTextArea.n;
        int n4 = 0;
        block4: for (int i2 = 0; i2 < string.length(); ++i2) {
            switch (string.charAt(i2)) {
                case '\t': {
                    n4 += n2;
                    if (n3 == 0) continue block4;
                }
                default: {
                    ++n4;
                    continue block4;
                }
            }
        }
        return n4;
    }

    public static int getLeadingWhiteSpace(String string) {
        int n2;
        int n3 = JEditTextArea.n;
        block5: for (n2 = 0; n2 < string.length(); ++n2) {
            switch (string.charAt(n2)) {
                case '\t': 
                case ' ': {
                    if (n3 == 0) continue block5;
                    break block5;
                }
                default: {
                    break block5;
                }
            }
        }
        return n2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0005T\\.F\u0004";
        int n3 = 3;
        block12: while (true) {
            char[] cArray;
            block17: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block16: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block16;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block17;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 45;
                                break;
                            }
                            case 1: {
                                n9 = 15;
                                break;
                            }
                            case 2: {
                                n9 = 39;
                                break;
                            }
                            case 3: {
                                n9 = 83;
                                break;
                            }
                            default: {
                                n9 = 27;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 3: {
                    BRACKETS = string.intern();
                    string2 = "\u0005T\\.F\u0004";
                    n3 = -1;
                    continue block12;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0005T\\.F\u0004";
                    n3 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0005T\\.F\u0004";
                    n3 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0005T\\.F\u0004";
                    n3 = 2;
                    continue block12;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        a = stringArray3;
    }
}

