/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.ranktracker.data;

import com.agilemind.commons.data.field.Age;
import com.agilemind.commons.io.searchengine.analyzers.data.AlexaPopularityResult;
import com.agilemind.commons.io.searchengine.analyzers.data.IMozAuthorityResult;
import com.agilemind.commons.io.searchengine.analyzers.parsers.IFactorParser;
import com.agilemind.ranktracker.data.PageDifficultyData;
import com.agilemind.ranktracker.data.RankTrackerProject;
import java.util.Arrays;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeywordDifficultyUtils {
    private static final int[] a = new int[]{0, 10, 25, 40, 55, 70, 80, 90, 95, 97, 100};
    private static final int[] b = new int[]{0, 50, 1000, 5000, 10000, 20000};
    private static final int[] c = new int[]{0, 10, 40, 70, 90, 100};
    private static final int[] d = new int[]{0, 20, 40, 70, 100};
    private static final int[] e = new int[]{0, 20, 50, 90, 100};
    private static final int[] f = new int[]{1, 1000, 10000, 100000, 500000};
    private static final int[] g = new int[]{100, 90, 60, 30, 0};
    private static final long[] h = new long[]{0L, 50L, 1000L, 5000L, 10000L, 20000L};
    private static final int[] i = new int[]{0, 10, 40, 70, 90, 100};
    private static final int[] j = new int[]{0, 12, 36, 60, 120};
    private static final int[] k = new int[]{0, 30, 70, 90, 100};
    private static final Logger l = LoggerFactory.getLogger(KeywordDifficultyUtils.class);

    public static double calculatePageDifficultyScore(PageDifficultyData pageDifficultyData, boolean bl2) {
        double d2 = 0.0;
        try {
            d2 += KeywordDifficultyUtils.a(pageDifficultyData, bl2);
            d2 += KeywordDifficultyUtils.b(pageDifficultyData, bl2);
            d2 += KeywordDifficultyUtils.a(pageDifficultyData);
            d2 += KeywordDifficultyUtils.b(pageDifficultyData);
            d2 += KeywordDifficultyUtils.c(pageDifficultyData);
            d2 += KeywordDifficultyUtils.d(pageDifficultyData);
            d2 += KeywordDifficultyUtils.e(pageDifficultyData);
            d2 += KeywordDifficultyUtils.f(pageDifficultyData);
        }
        catch (Throwable throwable) {
            l.error("", throwable);
        }
        return d2;
    }

    private static double a(PageDifficultyData pageDifficultyData, boolean bl2) {
        Integer n2;
        block5: {
            block4: {
                if (!bl2) break block4;
                IMozAuthorityResult iMozAuthorityResult = pageDifficultyData.getMozAuthorityResult();
                n2 = iMozAuthorityResult != null ? (int)Math.round(iMozAuthorityResult.getPageAuthority() / 10.0) : -1;
                if (RankTrackerProject.u == 0) break block5;
            }
            n2 = pageDifficultyData.getPagePR();
        }
        if (n2 == null) {
            return 0.0;
        }
        return KeywordDifficultyUtils.a(n2, 100);
    }

    private static double b(PageDifficultyData pageDifficultyData, boolean bl2) {
        Integer n2;
        block5: {
            block4: {
                if (!bl2) break block4;
                IMozAuthorityResult iMozAuthorityResult = pageDifficultyData.getMozAuthorityResult();
                n2 = iMozAuthorityResult != null ? (int)Math.round(iMozAuthorityResult.getDomainAuthority() / 10.0) : -1;
                if (RankTrackerProject.u == 0) break block5;
            }
            n2 = pageDifficultyData.getDomainPR();
        }
        if (n2 == null) {
            return 0.0;
        }
        return KeywordDifficultyUtils.a(n2, 30);
    }

    private static double a(int n2, int n3) {
        int n4;
        block3: {
            block2: {
                if (n2 >= 0) break block2;
                n4 = 0;
                if (RankTrackerProject.u == 0) break block3;
            }
            n4 = a[n2];
        }
        return (double)(n4 * n3) / 300.0;
    }

    private static double a(PageDifficultyData pageDifficultyData) {
        if (pageDifficultyData.getPageReferencesSites() == null) {
            return 0.0;
        }
        int n2 = pageDifficultyData.getPageReferencesSites();
        double d2 = KeywordDifficultyUtils.a(n2, b, c);
        return d2 * 30.0 / 300.0;
    }

    private static double b(PageDifficultyData pageDifficultyData) {
        if (pageDifficultyData.getDomainReferencesSites() == null) {
            return 0.0;
        }
        int n2 = pageDifficultyData.getDomainReferencesSites();
        double d2 = KeywordDifficultyUtils.a(n2, b, c);
        return d2 * 20.0 / 300.0;
    }

    private static double c(PageDifficultyData pageDifficultyData) {
        assert (pageDifficultyData != null);
        if (pageDifficultyData.getOptimizationRate() == null) {
            return 0.0;
        }
        double d2 = pageDifficultyData.getOptimizationRate();
        double d3 = KeywordDifficultyUtils.a((int)Math.round(d2), d, e);
        return d3 * 50.0 / 300.0;
    }

    private static double d(PageDifficultyData pageDifficultyData) {
        AlexaPopularityResult alexaPopularityResult = pageDifficultyData.getAlexaPopularity();
        if (alexaPopularityResult == null) {
            return 0.0;
        }
        int n2 = alexaPopularityResult.getGlobalRank();
        if (n2 < 1 || n2 == Integer.MAX_VALUE) {
            return 0.0;
        }
        double d2 = KeywordDifficultyUtils.a(n2, f, g);
        return d2 * 40.0 / 300.0;
    }

    private static double e(PageDifficultyData pageDifficultyData) {
        double d2;
        block5: {
            Long l2;
            block4: {
                l2 = pageDifficultyData.getSocialSignals();
                if (l2 == null) {
                    return 0.0;
                }
                if (l2 <= Integer.MAX_VALUE) break block4;
                d2 = 100.0;
                if (RankTrackerProject.u == 0) break block5;
            }
            d2 = KeywordDifficultyUtils.a(l2, h, i);
        }
        return d2 * 20.0 / 300.0;
    }

    private static double f(PageDifficultyData pageDifficultyData) {
        assert (pageDifficultyData != null);
        Date date = pageDifficultyData.getDomainAge();
        if (date == null || date.equals(IFactorParser.NA_DATE)) {
            return 0.0;
        }
        Age age = new Age(date);
        int n2 = age.getMonths();
        double d2 = KeywordDifficultyUtils.a(n2 += age.getYears() * 12, j, k);
        return d2 * 10.0 / 300.0;
    }

    private static double a(long l2, long[] lArray, int[] nArray) {
        int n2 = Arrays.binarySearch(lArray, l2);
        if (n2 < 0) {
            if ((n2 = -n2 - 1) == lArray.length) {
                return nArray[n2 - 1];
            }
            if (n2 == 0) {
                return nArray[0];
            }
            return KeywordDifficultyUtils.a(l2, lArray[n2 - 1], lArray[n2], nArray[n2 - 1], nArray[n2]);
        }
        return lArray[n2];
    }

    private static double a(long l2, long l3, long l4, int n2, int n3) {
        assert (l4 > l3);
        return (double)n2 + (double)((l2 - l3) * (long)(n3 - n2)) / (double)(l4 - l3);
    }

    private static double a(int n2, int[] nArray, int[] nArray2) {
        int n3 = Arrays.binarySearch(nArray, n2);
        if (n3 < 0) {
            if ((n3 = -n3 - 1) == nArray.length) {
                return nArray2[n3 - 1];
            }
            if (n3 == 0) {
                return nArray2[0];
            }
            return KeywordDifficultyUtils.a(n2, nArray[n3 - 1], nArray[n3], nArray2[n3 - 1], nArray2[n3]);
        }
        return nArray[n3];
    }

    private static double a(int n2, int n3, int n4, int n5, int n6) {
        assert (n4 > n3);
        return (double)n5 + (double)((n2 - n3) * (n6 - n5)) / (double)(n4 - n3);
    }
}

