/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.ranktracker.data;

import com.agilemind.commons.application.modules.export.data.ExportData;
import com.agilemind.commons.application.modules.io.searchengine.controllers.SelectSearchEnginesPanelController;
import com.agilemind.commons.application.modules.io.searchengine.controllers.UseSearchEngineListInfoProvider;
import com.agilemind.commons.application.modules.io.searchengine.data.UseSearchEngineList;
import com.agilemind.commons.data.RecordList;
import com.agilemind.commons.io.searchengine.analyzers.analytics.GoogleAnalyticsChecker;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngineAcceptor;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngineList;
import com.agilemind.commons.io.searchengine.searchengines.data.SearchEngineType;
import com.agilemind.commons.mvc.controllers.ProviderFinder;
import com.agilemind.commons.util.DateUtil;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.ranktracker.data.Competitor;
import com.agilemind.ranktracker.data.Keyword;
import com.agilemind.ranktracker.data.KeywordDifficultyService;
import com.agilemind.ranktracker.data.KeywordPosition;
import com.agilemind.ranktracker.data.KeywordPositionsList;
import com.agilemind.ranktracker.data.RankTrackerProject;
import com.agilemind.ranktracker.gui.CompetitionTableCellRenderer;
import com.agilemind.ranktracker.gui.ExpectedClicksTableCellRenderer;
import com.agilemind.ranktracker.gui.KEITableCellRenderer;
import com.agilemind.ranktracker.views.ReachTableCellRenderer;
import com.agilemind.ranktracker.views.table.columns.KeywordDifficultyTableCellRenderer;
import com.agilemind.ranktracker.views.table.columns.SearchNumberColumnRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class RankTrackerExportReportData
extends ExportData<Keyword> {
    private Collection<SearchEngineType> a;

    public List<Keyword> getKeywords() {
        return super.getRecords();
    }

    public void setSearchEngines(Collection<SearchEngineType> collection) {
        this.a = collection;
    }

    public Collection<SearchEngineType> getSearchEngines() {
        return this.a;
    }

    public String formatSearchNum(long l2) {
        return SearchNumberColumnRenderer.getStr(l2, false);
    }

    public String formatCompetition(double d2) {
        return CompetitionTableCellRenderer.getCompetitionStr(d2);
    }

    public String formatKEI(double d2) {
        return KEITableCellRenderer.formatKEI(d2);
    }

    public String formatExpectedVisits(int n2) {
        return ExpectedClicksTableCellRenderer.format(n2);
    }

    public String formatReach(double d2) {
        return ReachTableCellRenderer.formatReach(d2);
    }

    public String formatVisits(int n2) {
        String string;
        block3: {
            block2: {
                if (n2 != GoogleAnalyticsChecker.NOT_YET_CHECKED) break block2;
                string = "";
                if (RankTrackerProject.u == 0) break block3;
            }
            string = String.valueOf(n2);
        }
        return string;
    }

    public String formatBounceRate(double d2) {
        String string;
        block3: {
            block2: {
                if (d2 != (double)GoogleAnalyticsChecker.NOT_YET_CHECKED.intValue()) break block2;
                string = "";
                if (RankTrackerProject.u == 0) break block3;
            }
            string = StringUtil.NUMBER_PERCENT_0_OPTIONAL_FORMAT.format(d2);
        }
        return string;
    }

    public String getPosition(KeywordPosition keywordPosition) {
        return keywordPosition != null ? KeywordPosition.getPositionDescription(keywordPosition.getPosition(), keywordPosition.getSubPosition(), keywordPosition.getUniversalSearchType()) : null;
    }

    public String getPositionWithoutSubPosition(KeywordPosition keywordPosition) {
        return keywordPosition != null ? KeywordPosition.getPositionDescription(keywordPosition.getPosition(), 0, keywordPosition.getUniversalSearchType()) : null;
    }

    public int getSubPosition(KeywordPosition keywordPosition) {
        return keywordPosition != null ? keywordPosition.getSubPosition() : -1;
    }

    public boolean isPositionNotFound(KeywordPosition keywordPosition) {
        return keywordPosition != null && KeywordPosition.isPositionNotFound(keywordPosition.getPosition());
    }

    public Double getKeywordDifficulty(Keyword keyword, SearchEngineType searchEngineType) {
        return KeywordDifficultyService.getKeywordDifficulty(keyword, searchEngineType);
    }

    public String formatKeywordDifficulty(Double d2) {
        if (d2 == null) {
            return "";
        }
        return KeywordDifficultyTableCellRenderer.format(d2);
    }

    public void reset(ProviderFinder providerFinder) {
        List<Object> list;
        block3: {
            block2: {
                UseSearchEngineListInfoProvider useSearchEngineListInfoProvider = (UseSearchEngineListInfoProvider)providerFinder.getProvider(UseSearchEngineListInfoProvider.class);
                if (useSearchEngineListInfoProvider == null) break block2;
                UseSearchEngineList useSearchEngineList = useSearchEngineListInfoProvider.getUseSearchEngineList();
                SearchEngineAcceptor searchEngineAcceptor = useSearchEngineListInfoProvider.getSearchEngineAcceptor();
                SelectSearchEnginesPanelController.SelectSearchEngineAcceptor selectSearchEngineAcceptor = new SelectSearchEnginesPanelController.SelectSearchEngineAcceptor(searchEngineAcceptor, useSearchEngineList.getList(), false);
                SearchEngineList searchEngineList = SearchEngineList.getInstance();
                list = searchEngineList.getAcceptedSearchEngineTypes(new SearchEngineAcceptor[]{selectSearchEngineAcceptor});
                if (RankTrackerProject.u == 0) break block3;
            }
            list = new ArrayList<SearchEngineType>(1);
            list.add(SearchEngineList.GOOGLE);
        }
        this.setSearchEngines(list);
    }

    public <T> Collection<T> reverse(RecordList<?, T> recordList) {
        ArrayList arrayList = new ArrayList(recordList.getList());
        Collections.reverse(arrayList);
        return arrayList;
    }

    public Collection<Competitor> getCompetitors() {
        int n2 = RankTrackerProject.u;
        ArrayList<Competitor> arrayList = new ArrayList<Competitor>();
        Iterator iterator = ((RankTrackerProject)this.getProject()).getCompetitorsList().iterator();
        while (iterator.hasNext()) {
            Competitor competitor = (Competitor)iterator.next();
            if (competitor.isIncludeInReport().booleanValue() && competitor.isEnable().booleanValue()) {
                arrayList.add(competitor);
            }
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    public KeywordPosition getKeywordPosition(Competitor competitor, Keyword keyword, SearchEngineType searchEngineType, KeywordPosition keywordPosition) {
        int n2 = RankTrackerProject.u;
        KeywordPositionsList keywordPositionsList = keyword.getHistory(searchEngineType, competitor);
        if (keywordPositionsList != null) {
            Date date = DateUtil.getStartDay((Date)keywordPosition.getCheckDate());
            Iterator iterator = keywordPositionsList.iterator();
            while (iterator.hasNext()) {
                KeywordPosition keywordPosition2 = (KeywordPosition)iterator.next();
                if (DateUtil.getStartDay((Date)keywordPosition2.getCheckDate()).equals(date)) {
                    return keywordPosition2;
                }
                if (n2 == 0) continue;
            }
        }
        return null;
    }
}

