/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.ranktracker.report.data.widget.data.project;

import com.agilemind.commons.application.modules.factors.data.DomainStrengthUtil;
import com.agilemind.commons.application.modules.io.searchengine.data.PopularityHistoryMap;
import com.agilemind.commons.application.modules.io.searchengine.data.UseSearchEngineFactorList;
import com.agilemind.commons.application.modules.widget.service.project.ExternalDomainFactorsProjectService;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.commons.io.searchengine.analyzers.data.AlexaPopularityResult;
import com.agilemind.commons.io.searchengine.analyzers.data.IMozAuthorityResult;
import com.agilemind.commons.io.searchengine.analyzers.data.IPopularityMap;
import com.agilemind.commons.io.searchengine.searchengines.data.mozapi.IMozApiKeysSettings;
import com.agilemind.commons.util.Precondition;
import com.agilemind.commons.util.Util;
import com.agilemind.ranktracker.data.Competitor;
import com.agilemind.ranktracker.data.RankTrackerProject;
import com.agilemind.ranktracker.report.data.widget.data.CompetitorsExternalDomainFactorsService;
import com.agilemind.ranktracker.report.data.widget.data.project.d;
import java.util.List;

public class CompetitorsExternalDomainFactorsProjectService
extends ExternalDomainFactorsProjectService
implements CompetitorsExternalDomainFactorsService<Competitor> {
    private RankTrackerProject a;

    public CompetitorsExternalDomainFactorsProjectService(RankTrackerProject rankTrackerProject, IMozApiKeysSettings iMozApiKeysSettings, PopularityHistoryMap popularityHistoryMap, UseSearchEngineFactorList useSearchEngineFactorList) {
        super(popularityHistoryMap, useSearchEngineFactorList, iMozApiKeysSettings);
        this.a = rankTrackerProject;
    }

    @Override
    public Double getDomainStrength(Competitor competitor) {
        return DomainStrengthUtil.getStrength((IPopularityMap)competitor.getPopularityMap(), (boolean)this.getMozApiKeysSettings().isUseInsteadPR());
    }

    @Override
    public Integer getGooglePR(Competitor competitor) {
        return (Integer)this.getUsedFactorValue((IPopularityMap)competitor.getPopularityMap(), SearchEngineFactorsList.DOMAIN_GOOGLE_PR);
    }

    @Override
    public Double getDomainAuthority(Competitor competitor) {
        IMozAuthorityResult iMozAuthorityResult = (IMozAuthorityResult)this.getUsedFactorValue((IPopularityMap)competitor.getPopularityMap(), SearchEngineFactorsList.MOZ_AUTHORITY_FACTOR_TYPE);
        if (iMozAuthorityResult == null) {
            return null;
        }
        return iMozAuthorityResult.getDomainAuthority();
    }

    @Override
    public AlexaPopularityResult getAlexaPopularityResult(Competitor competitor) {
        return (AlexaPopularityResult)this.getUsedFactorValue((IPopularityMap)competitor.getPopularityMap(), SearchEngineFactorsList.ALEXA);
    }

    @Override
    public Long getCompeteRank(Competitor competitor) {
        return (Long)this.getUsedFactorValue((IPopularityMap)competitor.getPopularityMap(), SearchEngineFactorsList.SITEANALYTICS_COMPETE_FACTOR_TYPE);
    }

    @Override
    public Long getCompeteTraffic(Competitor competitor) {
        return (Long)this.getUsedFactorValue((IPopularityMap)competitor.getPopularityMap(), SearchEngineFactorsList.SITEANALYTICS_TRAFFIC_FACTOR_TYPE);
    }

    @Override
    public Long getGooglePopularity(Competitor competitor) {
        return (Long)this.getUsedFactorValue((IPopularityMap)competitor.getPopularityMap(), SearchEngineFactorsList.GOOGLE);
    }

    @Override
    public Integer getYandexCY(Competitor competitor) {
        return (Integer)this.getUsedFactorValue((IPopularityMap)competitor.getPopularityMap(), SearchEngineFactorsList.YANDEX_CY);
    }

    @Override
    public List<Competitor> getCompetitors() {
        return Util.filter((Iterable)this.a.getCompetitorsList().getList(), (Precondition[])new Precondition[]{new d(this)});
    }
}

