/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.writer.writebehind;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.PersistenceConfiguration;
import net.sf.ehcache.writer.CacheWriter;
import net.sf.ehcache.writer.CacheWriterManager;
import net.sf.ehcache.writer.writebehind.CoalesceKeysFilter;
import net.sf.ehcache.writer.writebehind.WriteBehind;
import net.sf.ehcache.writer.writebehind.WriteBehindQueueManager;

public class WriteBehindManager
implements CacheWriterManager {
    private final WriteBehind writeBehind;

    public WriteBehindManager(Cache cache) {
        this.writeBehind = cache.isTerracottaClustered() ? cache.getCacheManager().createTerracottaWriteBehind(cache) : (cache.getCacheConfiguration().getPersistenceConfiguration() != null && cache.getCacheConfiguration().getPersistenceConfiguration().getStrategy() == PersistenceConfiguration.Strategy.LOCALRESTARTABLE ? cache.getCacheManager().getFeaturesManager().createWriteBehind(cache) : new WriteBehindQueueManager(cache.getCacheConfiguration()));
    }

    public void init(Cache cache) throws CacheException {
        CacheWriter cacheWriter = cache.getRegisteredCacheWriter();
        if (null == cacheWriter) {
            throw new CacheException("No cache writer was registered for cache " + cache.getName());
        }
        if (cache.getCacheConfiguration().getCacheWriterConfiguration().getWriteCoalescing()) {
            this.writeBehind.setOperationsFilter(new CoalesceKeysFilter());
        }
        this.writeBehind.start(cacheWriter);
    }

    public void put(Element element) throws CacheException {
        this.writeBehind.write(element);
    }

    public void remove(CacheEntry entry) throws CacheException {
        this.writeBehind.delete(entry);
    }

    public void dispose() {
        if (this.writeBehind != null) {
            this.writeBehind.stop();
        }
    }

    public long getQueueSize() {
        return this.writeBehind.getQueueSize();
    }
}

