/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.htmlparser.data;

import com.agilemind.commons.util.StringUtil;
import com.agilemind.htmlparser.data.HTMLElementInfo;
import com.agilemind.htmlparser.data.HTMLTag;
import com.agilemind.htmlparser.data.IImportantKeyword;
import com.agilemind.htmlparser.data.IPage;
import com.agilemind.htmlparser.data.KeywordInfo;
import com.agilemind.htmlparser.data.PageData;
import java.util.List;
import org.htmlparser.util.ParserException;

public class PageOptimizationUtility {
    public static final HTMLTag[] DEFAULT_HTML_TAGS = new HTMLTag[]{HTMLTag.TITLE, HTMLTag.META_DESCRIPTION, HTMLTag.META_KEYWORDS, HTMLTag.H1, HTMLTag.H2H6, HTMLTag.BOLD, HTMLTag.ITALIC, HTMLTag.LINK, HTMLTag.IMAGE, HTMLTag.BODY};
    private final PageData a;
    private final List<? extends IImportantKeyword> b;

    public PageOptimizationUtility(PageData pageData, List<? extends IImportantKeyword> list) {
        this.a = pageData;
        this.b = list;
    }

    public List<? extends IImportantKeyword> getImportantKeywords() {
        return this.b;
    }

    public double getProminence(IImportantKeyword iImportantKeyword) {
        Object t = this.a.getHTMLElementInfo(HTMLTag.BODY);
        int n = ((HTMLElementInfo)t).getWordsCount();
        String string = iImportantKeyword.getQuery();
        int n2 = ((HTMLElementInfo)t).getKeywordCount(string);
        int n3 = ((HTMLElementInfo)t).getPositionSum(string);
        return n2 == 0 || n == 0 ? 0.0 : ((double)n - (double)(n3 - 1) / (double)n2) / (double)n * 100.0;
    }

    public double getOptimizationRate(IImportantKeyword iImportantKeyword, HTMLTag[] hTMLTagArray) throws ParserException {
        boolean bl = KeywordInfo.d;
        double d2 = 0.0;
        double d3 = 0.0;
        for (HTMLTag hTMLTag : hTMLTagArray) {
            int n = hTMLTag.getScoreWeight();
            d2 += this.getOptimizationRate(iImportantKeyword, iImportantKeyword.getQuery(), hTMLTag.getTagName()) * (double)n;
            d3 += (double)n;
            if (!bl) continue;
        }
        return d2 / d3;
    }

    public double getOptimizationRate(IImportantKeyword iImportantKeyword, HTMLTag hTMLTag) throws ParserException {
        return PageOptimizationUtility.a(iImportantKeyword, iImportantKeyword.getQuery(), hTMLTag, this.a);
    }

    public double getOptimizationRate(String string) throws ParserException {
        boolean bl = KeywordInfo.d;
        HTMLTag hTMLTag = HTMLTag.getTagType(string);
        double d2 = 0.0;
        for (IImportantKeyword iImportantKeyword : this.b) {
            d2 += PageOptimizationUtility.a(iImportantKeyword, iImportantKeyword.getQuery(), hTMLTag, this.a);
            if (!bl) continue;
        }
        return d2 / (double)this.b.size();
    }

    public static double getOptimizationRate(IImportantKeyword iImportantKeyword, HTMLTag hTMLTag, double d2, long l) throws ParserException {
        return PageOptimizationUtility.a(iImportantKeyword, iImportantKeyword.getQuery(), hTMLTag, d2, (double)StringUtil.getKeywords((String)iImportantKeyword.getQuery()).size() * (double)l * 100.0 / d2);
    }

    public double getOptimizationRate(IImportantKeyword iImportantKeyword, String string, String string2) throws ParserException {
        return PageOptimizationUtility.getOptimizationRate(iImportantKeyword, string, string2, this.a);
    }

    public static double getOptimizationRate(IImportantKeyword iImportantKeyword, String string, String string2, PageData pageData) throws ParserException {
        HTMLTag hTMLTag = HTMLTag.getTagType(string2);
        return PageOptimizationUtility.a(iImportantKeyword, string, hTMLTag, pageData);
    }

    private static double a(IImportantKeyword iImportantKeyword, String string, HTMLTag hTMLTag, PageData pageData) throws ParserException {
        Object t = pageData.getHTMLElementInfo(hTMLTag);
        return PageOptimizationUtility.a(iImportantKeyword, string, hTMLTag, (double)((HTMLElementInfo)t).getWordsCount(), ((HTMLElementInfo)t).getKeywordDensity(string));
    }

    private static double a(IImportantKeyword iImportantKeyword, String string, HTMLTag hTMLTag, double d2, double d3) throws ParserException {
        double d4;
        double d5;
        block16: {
            int n;
            int n2;
            double d6;
            double d7;
            block15: {
                block17: {
                    double d8;
                    double d9;
                    double d10;
                    double d11;
                    block14: {
                        boolean bl = KeywordInfo.d;
                        d11 = PageOptimizationUtility.getCompetitorsAvgTagKeywordDensity(hTMLTag, iImportantKeyword, string);
                        d10 = Double.MAX_VALUE;
                        d9 = 0.0;
                        d8 = PageOptimizationUtility.a(hTMLTag, iImportantKeyword, string, d11);
                        d7 = PageOptimizationUtility.getCompetitorsAvgTagWordsCountNotRound(hTMLTag, iImportantKeyword);
                        double d12 = PageOptimizationUtility.getCompetitorsAvgTagKeywordCount(hTMLTag, iImportantKeyword, iImportantKeyword.getQuery());
                        d6 = PageOptimizationUtility.a(hTMLTag, iImportantKeyword, d7);
                        n2 = Integer.MAX_VALUE;
                        n = 0;
                        for (IPage iPage : iImportantKeyword.getCompetitorsPages()) {
                            HTMLElementInfo<?> hTMLElementInfo = iPage.getTags(hTMLTag);
                            if (hTMLElementInfo != null) {
                                int n3;
                                double d13 = hTMLElementInfo.getKeywordDensity(iImportantKeyword.getQuery());
                                if (d13 < d10) {
                                    d10 = d13;
                                }
                                if (d13 > d9) {
                                    d9 = d13;
                                }
                                if ((n3 = hTMLElementInfo.getWordsCount()) < n2) {
                                    n2 = n3;
                                }
                                if (n3 > n) {
                                    n = n3;
                                }
                            }
                            if (!bl) continue;
                        }
                        if (d3 == 0.0) {
                            d5 = 0.0;
                        } else {
                            if (d11 != 0.0 && d12 != 0.0) break block14;
                            d5 = 99.0;
                        }
                        break block17;
                    }
                    d5 = PageOptimizationUtility.a(d3, d11, d8, d10, d9);
                }
                if (d2 != 0.0) break block15;
                d4 = 0.0;
                break block16;
            }
            d4 = d7 == 0.0 ? 99.0 : PageOptimizationUtility.a(d2, d7, d6, (double)n2, (double)n);
        }
        double d14 = d4;
        return d14 * 0.3 + d5 * 0.7;
    }

    private static double a(double d2, double d3, double d4, double d5, double d6) {
        double d7;
        block3: {
            double d8;
            block8: {
                boolean bl;
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    bl = KeywordInfo.d;
                                    d8 = Math.abs(d3 - d2);
                                    if (d4 != 0.0) break block2;
                                    double d9 = d7 = d2 < d5 || d2 > d6 ? 0.0 : d2 / d3 * 99.0;
                                    if (!bl) break block3;
                                }
                                if (!(d2 < d5) && !(d2 > d6)) break block4;
                                d7 = 0.0;
                                if (!bl) break block3;
                            }
                            if (!(d8 <= d4)) break block5;
                            d7 = 100.0 - 30.0 * d8 / d4;
                            if (!bl) break block3;
                        }
                        if (!(d8 <= 2.0 * d4)) break block6;
                        d7 = 70.0 - 20.0 * (d8 - d4) / d4;
                        if (!bl) break block3;
                    }
                    if (!(d8 <= 3.0 * d4)) break block7;
                    d7 = 50.0 - 20.0 * (d8 - 2.0 * d4) / d4;
                    if (!bl) break block3;
                }
                if (!(d2 < d3)) break block8;
                double d10 = d7 = d5 > 0.0 ? 30.0 - 20.0 * (d8 - 3.0 * d4) / (d3 - d5 - 3.0 * d4) : 30.0 - 30.0 * (d8 - 3.0 * d4) / (d3 - d5 - 3.0 * d4);
                if (!bl) break block3;
            }
            d7 = 30.0 - 20.0 * (d8 - 3.0 * d4) / (d6 - d3 - 3.0 * d4);
        }
        return d7;
    }

    public static double getCompetitorsAvgTagWordsCountNotRound(HTMLTag hTMLTag, IImportantKeyword iImportantKeyword) throws ParserException {
        boolean bl = KeywordInfo.d;
        int n = 0;
        Iterable<? extends IPage> iterable = iImportantKeyword.getCompetitorsPages();
        int n2 = 0;
        int n3 = 0;
        for (IPage iPage : iterable) {
            block6: {
                int n4;
                block5: {
                    ++n3;
                    HTMLElementInfo<?> hTMLElementInfo = iPage.getTags(hTMLTag);
                    n4 = hTMLElementInfo.getWordsCount();
                    if (n4 != 0) break block5;
                    ++n2;
                    if (!bl) break block6;
                }
                n += n4;
            }
            if (!bl) continue;
        }
        double d2 = n3 - n2;
        double d3 = d2 == 0.0 ? 0.0 : (double)n / d2;
        return d3;
    }

    public static double getCompetitorsAvgTagKeywordDensity(HTMLTag hTMLTag, IImportantKeyword iImportantKeyword, String string) throws ParserException {
        boolean bl = KeywordInfo.d;
        double d2 = 0.0;
        Iterable<? extends IPage> iterable = iImportantKeyword.getCompetitorsPages();
        int n = 0;
        int n2 = 0;
        for (IPage iPage : iterable) {
            block11: {
                Object obj;
                block10: {
                    block9: {
                        ++n2;
                        HTMLElementInfo<?> hTMLElementInfo = iPage.getTags(hTMLTag);
                        obj = hTMLElementInfo.getKeywordInfo(string);
                        if (obj == null || hTMLElementInfo.getWordsCount() == 0) break block9;
                        if (((KeywordInfo)obj).getDensity() != 0.0) break block10;
                    }
                    ++n;
                    if (!bl) break block11;
                }
                d2 += ((KeywordInfo)obj).getDensity().doubleValue();
            }
            if (!bl) continue;
        }
        double d3 = n2 - n;
        double d4 = d3 == 0.0 ? 0.0 : d2 / d3;
        return d4;
    }

    public static double getCompetitorsAvgTagKeywordCount(HTMLTag hTMLTag, IImportantKeyword iImportantKeyword, String string) throws ParserException {
        boolean bl = KeywordInfo.d;
        int n = 0;
        Iterable<? extends IPage> iterable = iImportantKeyword.getCompetitorsPages();
        int n2 = 0;
        int n3 = 0;
        for (IPage iPage : iterable) {
            block6: {
                HTMLElementInfo<?> hTMLElementInfo;
                block5: {
                    ++n3;
                    hTMLElementInfo = iPage.getTags(hTMLTag);
                    if (hTMLElementInfo.getKeywordCount(string) != 0) break block5;
                    ++n2;
                    if (!bl) break block6;
                }
                n += hTMLElementInfo.getKeywordCount(string);
            }
            if (!bl) continue;
        }
        double d2 = n3 - n2;
        double d3 = d2 == 0.0 ? 0.0 : (double)n / d2;
        return d3;
    }

    private static double a(HTMLTag hTMLTag, IImportantKeyword iImportantKeyword, double d2) throws ParserException {
        boolean bl = KeywordInfo.d;
        double d3 = 0.0;
        Iterable<? extends IPage> iterable = iImportantKeyword.getCompetitorsPages();
        int n = 0;
        int n2 = 0;
        for (IPage iPage : iterable) {
            block6: {
                double d4;
                block5: {
                    ++n2;
                    HTMLElementInfo<?> hTMLElementInfo = iPage.getTags(hTMLTag);
                    d4 = hTMLElementInfo.getWordsCount();
                    if (d4 != 0.0) break block5;
                    ++n;
                    if (!bl) break block6;
                }
                d3 += (d4 -= d2) * d4;
            }
            if (!bl) continue;
        }
        double d5 = n2 - n;
        double d4 = d5 == 0.0 ? 0.0 : Math.sqrt(d3 / d5);
        return d4;
    }

    private static double a(HTMLTag hTMLTag, IImportantKeyword iImportantKeyword, String string, double d2) throws ParserException {
        boolean bl = KeywordInfo.d;
        double d3 = 0.0;
        Iterable<? extends IPage> iterable = iImportantKeyword.getCompetitorsPages();
        int n = 0;
        int n2 = 0;
        for (IPage iPage : iterable) {
            block11: {
                Object obj;
                block10: {
                    block9: {
                        ++n2;
                        HTMLElementInfo<?> hTMLElementInfo = iPage.getTags(hTMLTag);
                        obj = hTMLElementInfo.getKeywordInfo(string);
                        if (obj == null || hTMLElementInfo.getWordsCount() == 0) break block9;
                        if (((KeywordInfo)obj).getDensity() != 0.0) break block10;
                    }
                    ++n;
                    if (!bl) break block11;
                }
                double d4 = ((KeywordInfo)obj).getDensity() - d2;
                d3 += d4 * d4;
            }
            if (!bl) continue;
        }
        double d5 = n2 - n;
        double d4 = d5 == 0.0 ? 0.0 : Math.sqrt(d3 / d5);
        return d4;
    }
}

