/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.ico;

import com.twelvemonkeys.image.InverseColorMapIndexColorModel;
import com.twelvemonkeys.imageio.plugins.ico.BitmapDescriptor;
import com.twelvemonkeys.imageio.plugins.ico.BitmapMask;
import com.twelvemonkeys.imageio.plugins.ico.DIBHeader;
import com.twelvemonkeys.imageio.plugins.ico.DirectoryEntry;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

class BitmapIndexed
extends BitmapDescriptor {
    protected final int[] mBits = new int[this.getWidth() * this.getHeight()];
    protected final int[] mColors = new int[this.getColorCount() + 1];
    private BitmapMask mMask;

    public BitmapIndexed(DirectoryEntry pEntry, DIBHeader pHeader) {
        super(pEntry, pHeader);
    }

    public BufferedImage createImageIndexed() {
        IndexColorModel icm = this.createColorModel();
        Hashtable<String, Point> properties = null;
        if (this.mEntry instanceof DirectoryEntry.CUREntry) {
            DirectoryEntry.CUREntry entry = (DirectoryEntry.CUREntry)this.mEntry;
            properties = new Hashtable<String, Point>(1);
            properties.put("cursor_hotspot", entry.getHotspot());
        }
        BufferedImage image = new BufferedImage(icm, icm.createCompatibleWritableRaster(this.getWidth(), this.getHeight()), icm.isAlphaPremultiplied(), properties);
        WritableRaster raster = image.getRaster();
        int trans = icm.getTransparentPixel();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (!this.mMask.isTransparent(x, y)) continue;
                this.mBits[x + this.getWidth() * y] = trans;
            }
        }
        raster.setSamples(0, 0, this.getWidth(), this.getHeight(), 0, this.mBits);
        return image;
    }

    IndexColorModel createColorModel() {
        int bits = this.getBitCount();
        int colors = this.mColors.length;
        int trans = -1;
        if (colors > 1 << this.getBitCount()) {
            int index = BitmapIndexed.findTransIndexMaybeRemap(this.mColors, this.mBits);
            if (index == -1) {
                ++bits;
                trans = this.mColors.length - 1;
            } else {
                trans = index;
                --colors;
            }
        }
        return new InverseColorMapIndexColorModel(bits, colors, this.mColors, 0, true, trans, bits <= 8 ? 0 : 1);
    }

    private static int findTransIndexMaybeRemap(int[] pColors, int[] pBits) {
        int i;
        boolean[] used = new boolean[pColors.length - 1];
        for (int pBit : pBits) {
            if (used[pBit]) continue;
            used[pBit] = true;
        }
        for (int i2 = 0; i2 < used.length; ++i2) {
            if (used[i2]) continue;
            return i2;
        }
        int trans = -1;
        int duplicate = -1;
        block2: for (i = 0; trans == -1 && i < pColors.length - 1; ++i) {
            for (int j = i + 1; j < pColors.length - 1; ++j) {
                if (pColors[i] != pColors[j]) continue;
                trans = j;
                duplicate = i;
                continue block2;
            }
        }
        if (trans != -1) {
            for (i = 0; i < pBits.length; ++i) {
                if (pBits[i] != trans) continue;
                pBits[i] = duplicate;
            }
        }
        return trans;
    }

    public BufferedImage getImage() {
        if (this.mImage == null) {
            this.mImage = this.createImageIndexed();
        }
        return this.mImage;
    }

    public void setMask(BitmapMask pMask) {
        this.mMask = pMask;
    }
}

