/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.ico;

import java.io.DataInput;
import java.io.IOException;
import javax.imageio.IIOException;

abstract class DIBHeader {
    protected int mSize;
    protected int mWidth;
    protected int mHeight;
    protected int mPlanes;
    protected int mBitCount;
    protected int mCompression;
    protected int mImageSize;
    protected int mXPixelsPerMeter;
    protected int mYPixelsPerMeter;
    protected int mColorsUsed;
    protected int mColorsImportant;

    protected DIBHeader() {
    }

    public static DIBHeader read(DataInput pStream) throws IOException {
        int size = pStream.readInt();
        DIBHeader header = DIBHeader.createHeader(size);
        header.read(size, pStream);
        return header;
    }

    private static DIBHeader createHeader(int pSize) throws IOException {
        switch (pSize) {
            case 12: 
            case 64: {
                throw new IIOException(String.format("OS/2 Bitmap Information Header (size: %s) not supported", pSize));
            }
            case 40: {
                return new WindowsV3DIBHeader();
            }
            case 108: 
            case 124: {
                throw new IIOException(String.format("Windows Bitmap Information Header (size: %s) not supported", pSize));
            }
        }
        throw new IIOException(String.format("Unknown Bitmap Information Header (size: %s)", pSize));
    }

    protected abstract void read(int var1, DataInput var2) throws IOException;

    public final int getSize() {
        return this.mSize;
    }

    public final int getWidth() {
        return this.mWidth;
    }

    public final int getHeight() {
        return this.mHeight;
    }

    public final int getPlanes() {
        return this.mPlanes;
    }

    public final int getBitCount() {
        return this.mBitCount;
    }

    public int getCompression() {
        return this.mCompression;
    }

    public int getImageSize() {
        return this.mImageSize;
    }

    public int getXPixelsPerMeter() {
        return this.mXPixelsPerMeter;
    }

    public int getYPixelsPerMeter() {
        return this.mYPixelsPerMeter;
    }

    public int getColorsUsed() {
        return this.mColorsUsed;
    }

    public int getColorsImportant() {
        return this.mColorsImportant;
    }

    public String toString() {
        return String.format("%s: size: %d bytes, width: %d, height: %d, planes: %d, bit count: %d, compression: %d, image size: %d%s, X pixels per m: %d, Y pixels per m: %d, colors used: %d, colors important: %d%s", this.getClass().getSimpleName(), this.getSize(), this.getWidth(), this.getHeight(), this.getPlanes(), this.getBitCount(), this.getCompression(), this.getImageSize(), this.getImageSize() == 0 ? " (unknown)" : "", this.getXPixelsPerMeter(), this.getYPixelsPerMeter(), this.getColorsUsed(), this.getColorsImportant(), this.getColorsImportant() == 0 ? " (all)" : "");
    }

    static final class WindowsV3DIBHeader
    extends DIBHeader {
        WindowsV3DIBHeader() {
        }

        protected void read(int pSize, DataInput pStream) throws IOException {
            if (pSize != 40) {
                throw new IIOException(String.format("Size: %s !=: %s", pSize, 40));
            }
            this.mSize = pSize;
            this.mWidth = pStream.readInt();
            this.mHeight = pStream.readInt();
            this.mPlanes = pStream.readUnsignedShort();
            this.mBitCount = pStream.readUnsignedShort();
            this.mCompression = pStream.readInt();
            this.mImageSize = pStream.readInt();
            this.mXPixelsPerMeter = pStream.readInt();
            this.mYPixelsPerMeter = pStream.readInt();
            this.mColorsUsed = pStream.readInt();
            this.mColorsImportant = pStream.readInt();
        }
    }
}

