/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.ico;

import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.ico.BitmapDescriptor;
import com.twelvemonkeys.imageio.plugins.ico.BitmapIndexed;
import com.twelvemonkeys.imageio.plugins.ico.BitmapMask;
import com.twelvemonkeys.imageio.plugins.ico.BitmapRGB;
import com.twelvemonkeys.imageio.plugins.ico.BitmapUnsupported;
import com.twelvemonkeys.imageio.plugins.ico.CURImageReaderSpi;
import com.twelvemonkeys.imageio.plugins.ico.DIBHeader;
import com.twelvemonkeys.imageio.plugins.ico.Directory;
import com.twelvemonkeys.imageio.plugins.ico.DirectoryEntry;
import com.twelvemonkeys.imageio.plugins.ico.ICOImageReaderSpi;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.imageio.util.IndexedImageTypeSpecifier;
import com.twelvemonkeys.util.WeakWeakMap;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.color.ColorSpace;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICOImageReader
extends ImageReaderBase {
    private Directory mDirectory;
    private Map<DirectoryEntry, DIBHeader> mHeaders = new WeakHashMap<DirectoryEntry, DIBHeader>();
    private Map<DirectoryEntry, BitmapDescriptor> mDescriptors = new WeakWeakMap();
    private ImageReader mPNGImageReader;

    public ICOImageReader() {
        this(1);
    }

    ICOImageReader(int pType) {
        this(ICOImageReader.createProviderForConstructor(pType));
    }

    protected ICOImageReader(ImageReaderSpi pProvider) {
        super(pProvider);
    }

    private static ImageReaderSpi createProviderForConstructor(int pType) {
        switch (pType) {
            case 1: {
                return new ICOImageReaderSpi();
            }
            case 2: {
                return new CURImageReaderSpi();
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported ICO/CUR type: %d", pType));
    }

    protected void resetMembers() {
        this.mDirectory = null;
        this.mHeaders.clear();
        this.mDescriptors.clear();
        if (this.mPNGImageReader != null) {
            this.mPNGImageReader.dispose();
            this.mPNGImageReader = null;
        }
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int pImageIndex) throws IOException {
        ImageTypeSpecifier specifier;
        DirectoryEntry entry = this.getEntry(pImageIndex);
        if (this.isPNG(entry)) {
            return this.getImageTypesPNG(entry);
        }
        ArrayList<ImageTypeSpecifier> types = new ArrayList<ImageTypeSpecifier>();
        DIBHeader header = this.getHeader(entry);
        switch (header.getBitCount()) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                int offset = entry.getOffset() + header.getSize();
                if ((long)offset != this.mImageInput.getStreamPosition()) {
                    this.mImageInput.seek(offset);
                }
                BitmapIndexed indexed = new BitmapIndexed(entry, header);
                this.readColorMap(indexed);
                specifier = IndexedImageTypeSpecifier.createFromIndexColorModel((IndexColorModel)indexed.createColorModel());
                break;
            }
            case 16: {
                specifier = ImageTypeSpecifier.createFromBufferedImageType(9);
                break;
            }
            case 24: {
                specifier = ImageTypeSpecifier.createFromBufferedImageType(5);
                break;
            }
            case 32: {
                specifier = ImageTypeSpecifier.createFromBufferedImageType(2);
                break;
            }
            default: {
                throw new IIOException(String.format("Unknown bit depth: %d", header.getBitCount()));
            }
        }
        types.add(specifier);
        return types.iterator();
    }

    public int getNumImages(boolean pAllowSearch) throws IOException {
        return this.getDirectory().count();
    }

    public int getWidth(int pImageIndex) throws IOException {
        return this.getEntry(pImageIndex).getWidth();
    }

    public int getHeight(int pImageIndex) throws IOException {
        return this.getEntry(pImageIndex).getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage read(int pImageIndex, ImageReadParam pParam) throws IOException {
        BufferedImage destination;
        this.checkBounds(pImageIndex);
        this.processImageStarted(pImageIndex);
        DirectoryEntry entry = this.getEntry(pImageIndex);
        if (this.isPNG(entry)) {
            destination = this.readPNG(entry, pParam);
        } else {
            destination = this.hasExplicitDestination(pParam) ? ICOImageReader.getDestination((ImageReadParam)pParam, this.getImageTypes(pImageIndex), (int)this.getWidth(pImageIndex), (int)this.getHeight(pImageIndex)) : null;
            BufferedImage image = this.readBitmap(entry);
            if (pParam != null) {
                image = ICOImageReader.fakeAOI((BufferedImage)image, (ImageReadParam)pParam);
                image = ImageUtil.toBuffered((Image)ICOImageReader.fakeSubsampling((Image)image, (ImageReadParam)pParam));
            }
            if (destination == null) {
                destination = image;
            } else {
                Graphics2D g = destination.createGraphics();
                try {
                    g.setComposite(AlphaComposite.Src);
                    g.drawImage((Image)image, 0, 0, null);
                }
                finally {
                    g.dispose();
                }
            }
        }
        this.processImageProgress(100.0f);
        this.processImageComplete();
        return destination;
    }

    private boolean hasExplicitDestination(ImageReadParam pParam) {
        return pParam != null && (pParam.getDestination() != null || pParam.getDestinationType() != null || pParam.getDestinationOffset() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPNG(DirectoryEntry pEntry) throws IOException {
        long magic;
        this.mImageInput.seek(pEntry.getOffset());
        this.mImageInput.setByteOrder(ByteOrder.BIG_ENDIAN);
        try {
            magic = this.mImageInput.readLong();
        }
        finally {
            this.mImageInput.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        }
        return magic == -8552249625308161526L;
    }

    private BufferedImage readPNG(DirectoryEntry pEntry, ImageReadParam pParam) throws IOException {
        return this.initPNGReader(pEntry).read(0, pParam);
    }

    private Iterator<ImageTypeSpecifier> getImageTypesPNG(DirectoryEntry pEntry) throws IOException {
        return this.initPNGReader(pEntry).getImageTypes(0);
    }

    private ImageReader initPNGReader(DirectoryEntry pEntry) throws IOException {
        ImageReader pngReader = this.getPNGReader();
        this.mImageInput.seek(pEntry.getOffset());
        InputStream inputStream = IIOUtil.createStreamAdapter((ImageInputStream)this.mImageInput, (long)pEntry.getSize());
        ImageInputStream stream = ImageIO.createImageInputStream(inputStream);
        pngReader.setInput(stream);
        return pngReader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ImageReader getPNGReader() throws IIOException {
        if (this.mPNGImageReader == null) {
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("PNG");
            if (!readers.hasNext()) throw new IIOException("No PNGImageReader found using ImageIO, can't read PNG encoded ICO format.");
            this.mPNGImageReader = readers.next();
            return this.mPNGImageReader;
        } else {
            this.mPNGImageReader.reset();
        }
        return this.mPNGImageReader;
    }

    private DIBHeader getHeader(DirectoryEntry pEntry) throws IOException {
        if (!this.mHeaders.containsKey(pEntry)) {
            this.mImageInput.seek(pEntry.getOffset());
            DIBHeader header = DIBHeader.read(this.mImageInput);
            this.mHeaders.put(pEntry, header);
        }
        return this.mHeaders.get(pEntry);
    }

    private BufferedImage readBitmap(DirectoryEntry pEntry) throws IOException {
        BitmapDescriptor descriptor = this.mDescriptors.get(pEntry);
        if (descriptor == null || !this.mDescriptors.containsKey(pEntry)) {
            DIBHeader header = this.getHeader(pEntry);
            int offset = pEntry.getOffset() + header.getSize();
            if ((long)offset != this.mImageInput.getStreamPosition()) {
                this.mImageInput.seek(offset);
            }
            if (header.getCompression() != 0) {
                descriptor = new BitmapUnsupported(pEntry, String.format("Unsupported compression: %d", header.getCompression()));
            } else {
                int bitCount = header.getBitCount();
                switch (bitCount) {
                    case 1: 
                    case 4: 
                    case 8: {
                        descriptor = new BitmapIndexed(pEntry, header);
                        this.readBitmapIndexed((BitmapIndexed)descriptor);
                        break;
                    }
                    case 16: {
                        descriptor = new BitmapRGB(pEntry, header);
                        this.readBitmap16(descriptor);
                        break;
                    }
                    case 24: {
                        descriptor = new BitmapRGB(pEntry, header);
                        this.readBitmap24(descriptor);
                        break;
                    }
                    case 32: {
                        descriptor = new BitmapRGB(pEntry, header);
                        this.readBitmap32(descriptor);
                        break;
                    }
                    default: {
                        descriptor = new BitmapUnsupported(pEntry, String.format("Unsupported bit count %d", bitCount));
                    }
                }
            }
            this.mDescriptors.put(pEntry, descriptor);
        }
        return descriptor.getImage();
    }

    private void readBitmapIndexed(BitmapIndexed pBitmap) throws IOException {
        this.readColorMap(pBitmap);
        switch (pBitmap.getBitCount()) {
            case 1: {
                this.readBitmapIndexed1(pBitmap, false);
                break;
            }
            case 4: {
                this.readBitmapIndexed4(pBitmap);
                break;
            }
            case 8: {
                this.readBitmapIndexed8(pBitmap);
            }
        }
        BitmapMask mask = new BitmapMask(pBitmap.mEntry, pBitmap.mHeader);
        this.readBitmapIndexed1(mask.mMask, true);
        pBitmap.setMask(mask);
    }

    private void readColorMap(BitmapIndexed pBitmap) throws IOException {
        int colorCount = pBitmap.getColorCount();
        for (int i = 0; i < colorCount; ++i) {
            pBitmap.mColors[i] = this.mImageInput.readInt() & 0xFFFFFF | 0xFF000000;
        }
    }

    private void readBitmapIndexed1(BitmapIndexed pBitmap, boolean pAsMask) throws IOException {
        int width = ICOImageReader.adjustToPadding(pBitmap.getWidth() >> 3);
        byte[] row = new byte[width];
        for (int y = 0; y < pBitmap.getHeight(); ++y) {
            this.mImageInput.readFully(row, 0, width);
            int rowPos = 0;
            int xOrVal = 128;
            int pos = (pBitmap.getHeight() - y - 1) * pBitmap.getWidth();
            for (int x = 0; x < pBitmap.getWidth(); ++x) {
                pBitmap.mBits[pos++] = (row[rowPos] & xOrVal) / xOrVal & 0xFF;
                if (xOrVal == 1) {
                    xOrVal = 128;
                    ++rowPos;
                    continue;
                }
                xOrVal >>= 1;
            }
            if (pAsMask) continue;
            if (this.abortRequested()) {
                this.processReadAborted();
                break;
            }
            this.processImageProgress((float)(100 * y) / (float)pBitmap.getHeight());
        }
    }

    private void readBitmapIndexed4(BitmapIndexed pBitmap) throws IOException {
        int width = ICOImageReader.adjustToPadding(pBitmap.getWidth() >> 1);
        byte[] row = new byte[width];
        for (int y = 0; y < pBitmap.getHeight(); ++y) {
            this.mImageInput.readFully(row, 0, width);
            int rowPos = 0;
            boolean high4 = true;
            int pos = (pBitmap.getHeight() - y - 1) * pBitmap.getWidth();
            for (int x = 0; x < pBitmap.getWidth(); ++x) {
                int value;
                if (high4) {
                    value = (row[rowPos] & 0xF0) >> 4;
                } else {
                    value = row[rowPos] & 0xF;
                    ++rowPos;
                }
                pBitmap.mBits[pos++] = value & 0xFF;
                high4 = !high4;
            }
            if (this.abortRequested()) {
                this.processReadAborted();
                break;
            }
            this.processImageProgress((float)(100 * y) / (float)pBitmap.getHeight());
        }
    }

    private void readBitmapIndexed8(BitmapIndexed pBitmap) throws IOException {
        int width = ICOImageReader.adjustToPadding(pBitmap.getWidth());
        byte[] row = new byte[width];
        for (int y = 0; y < pBitmap.getHeight(); ++y) {
            this.mImageInput.readFully(row, 0, width);
            int rowPos = 0;
            int pos = (pBitmap.getHeight() - y - 1) * pBitmap.getWidth();
            for (int x = 0; x < pBitmap.getWidth(); ++x) {
                pBitmap.mBits[pos++] = row[rowPos++] & 0xFF;
            }
            if (this.abortRequested()) {
                this.processReadAborted();
                break;
            }
            this.processImageProgress((float)(100 * y) / (float)pBitmap.getHeight());
        }
    }

    private static int adjustToPadding(int pWidth) {
        if ((pWidth & 3) != 0) {
            return (pWidth & 0xFFFFFFFC) + 4;
        }
        return pWidth;
    }

    private void readBitmap16(BitmapDescriptor pBitmap) throws IOException {
        short[] pixels = new short[pBitmap.getWidth() * pBitmap.getHeight()];
        DirectColorModel cm = new DirectColorModel(16, 31744, 992, 31);
        DataBufferShort buffer = new DataBufferShort(pixels, pixels.length);
        WritableRaster raster = Raster.createPackedRaster(buffer, pBitmap.getWidth(), pBitmap.getHeight(), pBitmap.getWidth(), cm.getMasks(), null);
        pBitmap.mImage = new BufferedImage(cm, raster, cm.isAlphaPremultiplied(), null);
        for (int y = 0; y < pBitmap.getHeight(); ++y) {
            int offset = (pBitmap.getHeight() - y - 1) * pBitmap.getWidth();
            this.mImageInput.readFully(pixels, offset, pBitmap.getWidth());
            if (pBitmap.getWidth() % 2 != 0) {
                this.mImageInput.readShort();
            }
            if (this.abortRequested()) {
                this.processReadAborted();
                break;
            }
            this.processImageProgress((float)(100 * y) / (float)pBitmap.getHeight());
        }
    }

    private void readBitmap24(BitmapDescriptor pBitmap) throws IOException {
        byte[] pixels = new byte[pBitmap.getWidth() * pBitmap.getHeight() * 3];
        DataBufferByte buffer = new DataBufferByte(pixels, pixels.length);
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] nBits = new int[]{8, 8, 8};
        int[] bOffs = new int[]{2, 1, 0};
        ComponentColorModel cm = new ComponentColorModel(cs, nBits, false, false, 1, 0);
        WritableRaster raster = Raster.createInterleavedRaster(buffer, pBitmap.getWidth(), pBitmap.getHeight(), pBitmap.getWidth(), 3, bOffs, null);
        pBitmap.mImage = new BufferedImage(cm, raster, cm.isAlphaPremultiplied(), null);
        for (int y = 0; y < pBitmap.getHeight(); ++y) {
            int offset = (pBitmap.getHeight() - y - 1) * pBitmap.getWidth();
            this.mImageInput.readFully(pixels, offset, pBitmap.getWidth() * 3);
            if (this.abortRequested()) {
                this.processReadAborted();
                break;
            }
            this.processImageProgress((float)(100 * y) / (float)pBitmap.getHeight());
        }
    }

    private void readBitmap32(BitmapDescriptor pBitmap) throws IOException {
        int[] pixels = new int[pBitmap.getWidth() * pBitmap.getHeight()];
        DirectColorModel cm = (DirectColorModel)ColorModel.getRGBdefault();
        DataBufferInt buffer = new DataBufferInt(pixels, pixels.length);
        WritableRaster raster = Raster.createPackedRaster(buffer, pBitmap.getWidth(), pBitmap.getHeight(), pBitmap.getWidth(), cm.getMasks(), null);
        pBitmap.mImage = new BufferedImage(cm, raster, cm.isAlphaPremultiplied(), null);
        for (int y = 0; y < pBitmap.getHeight(); ++y) {
            int offset = (pBitmap.getHeight() - y - 1) * pBitmap.getWidth();
            this.mImageInput.readFully(pixels, offset, pBitmap.getWidth());
            if (this.abortRequested()) {
                this.processReadAborted();
                break;
            }
            this.processImageProgress((float)(100 * y) / (float)pBitmap.getHeight());
        }
    }

    private Directory getDirectory() throws IOException {
        this.assertInput();
        if (this.mDirectory == null) {
            this.readFileHeader();
        }
        return this.mDirectory;
    }

    private void readFileHeader() throws IOException {
        this.mImageInput.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.mImageInput.readUnsignedShort();
        int type = this.mImageInput.readUnsignedShort();
        int imageCount = this.mImageInput.readUnsignedShort();
        this.mDirectory = Directory.read(type, imageCount, this.mImageInput);
    }

    final DirectoryEntry getEntry(int pImageIndex) throws IOException {
        Directory directory = this.getDirectory();
        if (pImageIndex < 0 || pImageIndex >= directory.count()) {
            throw new IndexOutOfBoundsException(String.format("Index: %d, ImageCount: %d", pImageIndex, directory.count()));
        }
        return directory.getEntry(pImageIndex);
    }

    public static void main(String[] pArgs) throws IOException {
        if (pArgs.length == 0) {
            System.err.println("Please specify the icon file name");
            System.exit(1);
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        String title = new File(pArgs[0]).getName();
        JFrame frame = ICOImageReader.createWindow(title);
        JPanel root = new JPanel(new FlowLayout());
        JScrollPane scroll = new JScrollPane(root, 22, 30);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        frame.setContentPane(scroll);
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("ico");
        if (!readers.hasNext()) {
            System.err.println("No reader for format 'ico' found");
            System.exit(1);
        }
        ImageReader reader = readers.next();
        for (String arg : pArgs) {
            JPanel panel = new JPanel(null);
            panel.setLayout(new BoxLayout(panel, 1));
            ICOImageReader.readImagesInFile(arg, reader, panel);
            root.add(panel);
        }
        frame.pack();
        frame.setVisible(true);
    }

    private static void readImagesInFile(String pFileName, ImageReader pReader, Container pContainer) throws IOException {
        File file = new File(pFileName);
        if (!file.isFile()) {
            System.err.println(pFileName + " not found, or is no file");
        }
        pReader.setInput(ImageIO.createImageInputStream(file));
        int imageCount = pReader.getNumImages(true);
        for (int i = 0; i < imageCount; ++i) {
            try {
                ICOImageReader.addImage(pContainer, pReader, i);
                continue;
            }
            catch (Exception e) {
                System.err.println("FileName: " + pFileName);
                System.err.println("Icon: " + i);
                e.printStackTrace();
            }
        }
    }

    private static JFrame createWindow(String pTitle) {
        JFrame frame = new JFrame(pTitle);
        frame.setDefaultCloseOperation(2);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                System.exit(0);
            }
        });
        return frame;
    }

    private static void addImage(Container pParent, ImageReader pReader, int pImageNo) throws IOException {
        JButton button = new JButton();
        BufferedImage image = pReader.read(pImageNo);
        button.setIcon(new ImageIcon(image){
            TexturePaint mTexture;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void createTexture(GraphicsConfiguration pGraphicsConfiguration) {
                BufferedImage pattern = pGraphicsConfiguration.createCompatibleImage(20, 20);
                Graphics2D g = pattern.createGraphics();
                try {
                    g.setColor(Color.LIGHT_GRAY);
                    g.fillRect(0, 0, pattern.getWidth(), pattern.getHeight());
                    g.setColor(Color.GRAY);
                    g.fillRect(0, 0, pattern.getWidth() / 2, pattern.getHeight() / 2);
                    g.fillRect(pattern.getWidth() / 2, pattern.getHeight() / 2, pattern.getWidth() / 2, pattern.getHeight() / 2);
                }
                finally {
                    g.dispose();
                }
                this.mTexture = new TexturePaint(pattern, new Rectangle(pattern.getWidth(), pattern.getHeight()));
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (this.mTexture == null) {
                    this.createTexture(c.getGraphicsConfiguration());
                }
                Graphics2D gr = (Graphics2D)g;
                gr.setPaint(this.mTexture);
                gr.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
                super.paintIcon(c, g, x, y);
            }
        });
        button.setText("" + image.getWidth() + "x" + image.getHeight() + ": " + (image.getColorModel() instanceof IndexColorModel ? "" + ((IndexColorModel)image.getColorModel()).getMapSize() : "TrueColor"));
        pParent.add(button);
    }
}

